/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * s7comx32 - s7comx32.h												*
 ********************************************************************/
#ifndef _INC_S7COM32
#define _INC_S7COM32

#include <s7com32res.h>

#ifndef INT8
typedef signed __int8			INT8, *LPINT8;
#endif
#ifndef INT16
typedef signed __int16			INT16, *LPINT16, BOOL16, *LPBOOL16;
#endif
#ifndef INT32
typedef signed __int32			INT32, *LPINT32;
#endif
#ifndef INT64
typedef signed __int64			INT64, *LPINT64;
#endif

#ifndef UINT8
typedef unsigned __int8			UINT8, *LPUINT8;
#endif
#ifndef UINT16
typedef unsigned __int16		UINT16, *LPUINT16;
#endif
#ifndef UINT32
typedef unsigned __int32		UINT32, *LPUINT32;
#endif
#ifndef UINT64
typedef unsigned __int64		UINT64, *LPUINT64;
#endif

#ifndef LPVOID
typedef void					*LPVOID;
#endif

#ifndef HANDLE
typedef LPVOID					HANDLE, *LPHANDLE;
#endif

#if defined(__cplusplus) && !defined(_DEF_EXTERNC)
#define _DEF_EXTERNC
#define _DEF_S7COM_EXTERNC
extern "C" {
#endif

#define MIN_S7PDUSIZE				128
#define DEF_S7PDUSIZE				240
#define MAX_S7PDUSIZE				512

// Area Type
#define S7AT_INPUT					0
#define S7AT_OUTPUT					1
#define S7AT_FLAG					2
#define S7AT_DB						3
#define S7AT_STDMAX					4
#define S7AT_TIMER					4
#define S7AT_COUNTER				5
#define S7AT_MAX					6

// Variable Type
#define S7VT_BIT					0
#define S7VT_BYTE					1
#define S7VT_SHORT					2
#define S7VT_CHAR					3
#define S7VT_WORD					4
#define S7VT_INT					5
#define S7VT_DWORD					6
#define S7VT_DINT					7
#define S7VT_TIME					8
#define S7VT_TOD					9
#define S7VT_S5TIME					10
#define S7VT_REAL					11
#define S7VT_DT						12
#define S7VT_DATE					13
#define S7VT_TIMER					14
#define S7VT_COUNTER				15
#define S7VT_MAX					16

#define IFM_UNKNOWN					-1
#define IFM_TCP						0
#define IFM_S7ONLINE				1
#define IFM_CP_L2_1					2
#define IFM_CP_L2_2					3
#define IFM_LAST					3
#define IFM_MAX						(IFM_LAST + 1)

#define S7_CPUUNKNOWN				0x00
#define S7_CPUSTOP					0x01
#define S7_CPURUN					0x02
#define S7_CPULAST					0x02

#define MAX_S7VARS					20

#define STATION_PASSIVE				0x00
#define STATION_NON_EXISTENT		0x10
#define STATION_ACTIVE_READY		0x20
#define STATION_ACTIVE				0x30

#define KBAUD_9_6					0x00
#define KBAUD_19_2					0x01
#define KBAUD_93_75					0x02
#define KBAUD_187_5					0x03
#define KBAUD_500					0x04
#define KBAUD_375					0x05
#define KBAUD_750					0x06
#define MBAUD_1_5					0x07
#define MBAUD_3						0x08
#define MBAUD_6						0x09
#define MBAUD_12					0x0a
#define BAUD_UNKNOWN				0x0b
#define KBAUD_45_45					0x0c
#define BAUD_LAST					0x0c

#define REDUNDANCY_NO				0x00
#define REDUNDANCY_BUS_A			0x01
#define REDUNDANCY_BUS_B			0x02
#define REDUNDANCY_ON				0x03

#define LAYER_RS485					0x00
#define LAYER_MODEM					0x01

#define S7MAX_NAMELEN				23
#define S7MAX_NAMESIZE				(S7MAX_NAMELEN + 1)


#pragma pack(push, 1)

typedef struct tagS7DATETIME {
	UINT8							bcdYear;
	UINT8							bcdMonth;
	UINT8							bcdDay;
	UINT8							bcdHour;
	UINT8							bcdMin;
	UINT8							bcdSec;
	UINT8							bcdMsec;
	UINT8							bcdDoW;
} S7DATETIME, *LPS7DATETIME;

typedef struct tagBUSPARBLK {
	UINT8							nHSA;							// highest station-address range of values:  2 ... 126
	UINT8							nTS;							// FDL-address of this station range of values:  0 ... 126
	UINT16							nType;							// active, passive
	UINT16							nBaud;							// transmission rate
	UINT16							nRedundant;						// availability of redundant media
	UINT16							nRetryCtr;						// retry-number of requestor, if no reaction of responder range of values:  1 ... 8
	UINT8							nDefaultSap;					// Default SAP if no address-extension is used range of values:  2 ... 62
	UINT8							nTotalSap;						// number of sap for network-connection (only for network-connections) range of values:  2 ... 62
	UINT16							nTsl;							// SLOT-time: range of values:  2 exp 0 ... (2 exp 16) - 1   BIT-times
	UINT16							nTqui;							// Transmitter-Fall-Time / Repeater-Switch-Time: range of values:  0 ... (2 exp 8) - 1 BIT-times
	UINT16							nTSet;							// setup-time range of values:  0 ... (2 exp 8) - 1 BIT-times
	UINT16							nMinTsdr;						// smallest STATION-DELAY-time: range of values:  2 exp 0 ... (2 exp 16) - 1   BIT-times
	UINT16							nMaxTsdr;						// largest STATION-DELAY-time: range of values:  2 exp 0 ... (2 exp 16) - 1   BIT-times
	UINT32							nTtr;							// TARGET-ROTATION-time: range of values:  2 exp 0 ... (2 exp 24) - 1   BIT-times
	UINT8							nGap;							// GAP-UPDATE-factor: in multiples of ttr range_of_values:  1 ... 100
	INT16							nInRing;						// request entrance into the token-ring
	INT16							nLayer;							// RS485, modem
	UINT8							nReserved[8];					// reserved for FDL !!!!!
	char							nIdent[202];
	UINT8							nResponseTelegramLength;		// reserved for FDL !!!!!
} BUSPARBLK, *LPBUSPARBLK;

#pragma pack(pop)

HANDLE __stdcall S7_Interface_Init(UINT32 nMode);
HANDLE __stdcall S7_Interface_Done(HANDLE hIF);
HANDLE __stdcall S7_Connection_Init(HANDLE hIF, LPSTR lpName, INT32 nTimeOut, INT32 nAddr, INT32 nRack, INT32 nSlot, INT32 nDefPduSize);
HANDLE __stdcall S7_Connection_Done(HANDLE hCon);
BOOL __stdcall S7_IsConnected(HANDLE hCon);
INT32 __stdcall S7_Connect(HANDLE hCon);
INT32 __stdcall S7_Disconnect(HANDLE hCon);
INT32 __stdcall S7_OnLine_Partners(HANDLE hIF, INT32 nTimeOut, INT32 nSize, LPSTR lpBuf, LPINT32 lpCount);
INT32 __stdcall S7_OnLine_BusPars(HANDLE hIF, INT32 nTimeOut, LPBUSPARBLK lpBus);
INT32 __stdcall S7_GetCpuClock(HANDLE hCon, LPSYSTEMTIME lpSt);
INT32 __stdcall S7_SetCpuClock(HANDLE hCon, LPSYSTEMTIME lpSt);
INT32 __stdcall S7_GetCpuState(HANDLE hCon, LPUINT32 lpState);
INT32 __stdcall S7_CpuStart(HANDLE hCon, BOOL bCold);
INT32 __stdcall S7_CpuStop(HANDLE hCon);
INT32 __stdcall S7_SimpleRead(HANDLE hCon, INT32 nVT, INT32 nArea, INT32 nDB, INT32 nAddr, INT32 nBit, INT32 nCount, BOOL bConvert, LPVOID lpData);
INT32 __stdcall S7_MultiRead_Init(HANDLE hCon);
INT32 __stdcall S7_MultiRead_Done(HANDLE hCon);
INT32 __stdcall S7_SimpleWrite(HANDLE hCon, INT32 nVT, INT32 nArea, INT32 nDB, INT32 nAddr, INT32 nBit, INT32 nCount, BOOL bConvert, LPVOID lpData);
INT32 __stdcall S7_MultiWrite_Init(HANDLE hCon);
INT32 __stdcall S7_MultiWrite_Done(HANDLE hCon);
INT32 __stdcall S7_AddItem(HANDLE hCon, UINT32 nVT, UINT32 nArea, INT32 nDB, UINT32 nAddr, UINT32 nBit, UINT32 nCount, BOOL bConvert, LPVOID lpData);
INT32 __stdcall S7_GetItemMaxCount(HANDLE hCon, BOOL bNew, UINT32 nVT, LPUINT32 lpCount);
INT32 __stdcall S7_SessionLogin(HANDLE hCon, LPSTR lpPwd);
INT32 __stdcall S7_SessionLogout(HANDLE hCon);
INT32 __stdcall S7_GetUserData(HANDLE hAny);
INT32 __stdcall S7_SetUserData(HANDLE hAny, INT32 nData);
LPVOID __stdcall S7_GetUserPtr(HANDLE hAny);
LPVOID __stdcall S7_SetUserPtr(HANDLE hAny, LPVOID lpPtr);
INT32 __stdcall S7_GetConName(HANDLE hCon, LPSTR lpName);
void __stdcall S7_SetConName(HANDLE hCon, LPSTR lpName);
INT32 __stdcall S7_GetMaxPduSize(HANDLE hCon);
INT32 __stdcall S7_GetRequestPduSize(HANDLE hCon);
INT32 __stdcall S7_GetReplyPduSize(HANDLE hCon);
INT32 __stdcall S7_GetInterfaceMode(HANDLE hIF);
INT32 __stdcall S7_GetLastError(LPINT32 lpSysErr);
INT32 __stdcall S7_IsReadWriteError(HANDLE hCon);
INT32 __stdcall S7_GetReadWriteError(HANDLE hCon, INT32 nIndex, LPINT32 lpIOErr);

BOOL __stdcall S7_GetBit(LPVOID lpBuf);
void __stdcall S7_SetBit(LPVOID lpBuf, BOOL bValue);
char __stdcall S7_GetChar(LPVOID lpBuf);
void __stdcall S7_SetChar(LPVOID lpBuf, char cValue);
INT32 __stdcall S7_GetShort(LPVOID lpBuf);
void __stdcall S7_SetShort(LPVOID lpBuf, INT8 nValue);
UINT32 __stdcall S7_GetByte(LPVOID lpBuf);
void __stdcall S7_SetByte(LPVOID lpBuf, UINT8 nValue);
INT32 __stdcall S7_GetInt(LPVOID lpBuf);
void __stdcall S7_SetInt(LPVOID lpBuf, INT16 nValue);
UINT32 __stdcall S7_GetWord(LPVOID lpBuf);
void __stdcall S7_SetWord(LPVOID lpBuf, UINT16 nValue);
UINT32 __stdcall S7_GetCounter(LPVOID lpBuf);
BOOL __stdcall S7_SetCounter(LPVOID lpBuf, UINT32 nValue);
//	S5TIME --> TIME
UINT32 __stdcall S7_GetS5Time(LPVOID lpBuf);
//	TIME --> S5TIME
BOOL __stdcall S7_SetS5Time(LPVOID lpBuf, UINT32 nTime);
INT32 __stdcall S7_GetDInt(LPVOID lpBuf);
void __stdcall S7_SetDInt(LPVOID lpBuf, INT32 nValue);
UINT32 __stdcall S7_GetDWord(LPVOID lpBuf);
void __stdcall S7_SetDWord(LPVOID lpBuf, UINT32 nValue);
UINT32 __stdcall S7_GetTime(LPVOID lpBuf);
void __stdcall S7_SetTime(LPVOID lpBuf, UINT32 nValue);
double __stdcall S7_GetReal(LPVOID lpBuf);
void __stdcall S7_SetReal(LPVOID lpBuf, double fValue);
BOOL __stdcall S7_GetDT(LPSYSTEMTIME lpSt, LPVOID lpBuf);
BOOL __stdcall S7_SetDT(LPVOID lpBuf, LPSYSTEMTIME lpSt);
void __stdcall S7_GetDate(LPSYSTEMTIME lpSt, LPVOID lpBuf);
void __stdcall S7_SetDate(LPVOID lpBuf, LPSYSTEMTIME lpSt);
void __stdcall S7_GetTOD(LPSYSTEMTIME lpSt, LPVOID lpBuf);
void __stdcall S7_SetTOD(LPVOID lpBuf, LPSYSTEMTIME lpSt);

#if defined(_DEF_S7COM_EXTERNC)
}
#undef _DEF_EXTERNC
#undef _DEF_S7COM_EXTERNC
#endif

#endif  // _INC_S7COM32
