/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * s7com32 - private.h												*
 ********************************************************************/
#pragma once
#ifndef _INC_PRIVATE
#define _INC_PRIVATE

#ifndef _INC_SKLIBUDP
#include <sklibudp.h>
#endif

#define STRUCTID_S7IF				'FI7S'
#define STRUCTID_S7CON				'NC7S'

#define MAX_ISOPAYLOADSIZE			512
#define MAX_TCLPAYLOADSIZE			520
#define MAX_IFMODE					4

//	PDU Type
#define PDUT_REQUEST				1								// request sent by the master (e.g. read/write memory, read/write blocks, start/stop device, setup communication)
#define PDUT_ACK					2								// simple acknowledgement sent by the slave with no data field
#define PDUT_RESPONSE				3								// acknowledgement with optional data field, contains the reply to a job request
#define PDUT_USERDATA				7								// an extension of the original protocol, the parameter field contains the request/response id,
																	// (used for programming/debugging, SZL reads, security functions, time setup, cyclic read..)

//	PDU Functions
#define PDUFN_RESPONSE				0x02							// Response (when error)
#define PDUFN_READ					0x04							// Read area
#define PDUFN_WRITE					0x05							// Write area
#define PDUFN_CPUSTART				0x28
#define PDUFN_CPUSTOP				0x29
#define PDUFN_NEGOTIATE				0xF0							// Negotiate PDU length

//	PDU SubFunctions
#define PDUSFN_GETCLOCK				0x01							// Read Clock (Date and Time)
#define PDUSFN_SETCLOCK				0x02							// Set Clock (Date and Time)
#define PDUSFN_READSZL				0x01
#define PDUSFN_COLDSTART			0x4320
#define PDUSFN_ENTERPWD				0x01
#define PDUSFN_CANCELPWD			0x02

#define TG_SZL						0x44
#define TG_SECURITY					0x45
#define TG_CLOCK					0x47

// Transport size
#define TS_BIT						0x03
#define TS_BYTE						0x04
#define TS_INT						0x05
#define TS_REAL						0x07
#define TS_OCTET					0x09

#define IORESULT_OK					0xFF

#define S7PDU_ID					0x32

// Area Type Code
#define S7ATC_INPUT					0x81
#define S7ATC_OUTPUT				0x82
#define S7ATC_FLAG					0x83
#define S7ATC_DB					0x84
#define S7ATC_COUNTER				0x1C
#define S7ATC_TIMER					0x1D

// Variable Type Code
#define S7VTC_BIT					0x01
#define S7VTC_BYTE					0x02
#define S7VTC_CHAR					0x03
#define S7VTC_WORD					0x04
#define S7VTC_INT					0x05
#define S7VTC_DWORD					0x06
#define S7VTC_DINT					0x07
#define S7VTC_REAL					0x08
#define S7VTC_DATE					0x09
#define S7VTC_TOD					0x0A
#define S7VTC_TIME					0x0B
#define S7VTC_S5TIME				0x0C
#define S7VTC_DT					0x0F
#define S7VTC_COUNTER				0x1C
#define S7VTC_TIMER					0x1D

#pragma pack(push, 1)

typedef struct tagREADDATAINFO {
	UINT8							nVT;
	UINT8							nCount;
	UINT8							nSize;
	UINT8							nCvt;
	ANYPOINTER						pData;
} READDATAINFO, *LPREADDATAINFO;

typedef struct tagS7PDU {
	INT32							nHdrLen;
	INT32							nParLen;
	INT32							nDatLen;
	INT32							nTotLen;
	LPSTR							pData;
} S7PDU, *LPS7PDU;

typedef struct tagS7INTERFACE		S7INTERFACE, *LPS7INTERFACE;
typedef struct tagS7CONNECTION		S7CONNECTION, *LPS7CONNECTION;

typedef struct tagS7COMMONIFCON {
	INT32							nReserved[3];
	INT32							nStructID;
	INT32							nUser;
	LPVOID							pUser;
} S7COMMONIFCON, *LPS7COMMONIFCON;

typedef struct tagS7INTERFACE {
	INT32							nMode;
	INT32							nOnlineID;
	LPS7CONNECTION					pConnection;
	INT32							nStructID;
	INT32							nUser;
	LPVOID							pUser;
	INT32							nNextID;
} S7INTERFACE, *LPS7INTERFACE;

typedef struct tagS7CONNECTION {
    LPS7CONNECTION					pNextCon;
	INT32							nConID;
    LPS7INTERFACE					pIF;
	INT32							nStructID;
	INT32							nUser;
	LPVOID							pUser;
	char							cName[S7MAX_NAMESIZE];
	UINT32							nTimeOut;						// Timeout in milliseconds used in transort.
    UINT32							nAddr;							// The PLC's address
    INT32							nRack;							// rack number for ISO over TCP
    INT32							nSlot;							// slot number for ISO over TCP
	NETINFO							NetInf;
	BOOL							bConnected;
	BOOL							bOpened;
	BOOL							bAddEnabled;
	INT32							nReference;
	INT32							nSequence;
	INT32							nReplyLen;
	INT32							nPDUSize;
    INT32							nTPDUSize; 						// size of TPDU for ISO over TCP
	LPSTR							pSndBuf;
	LPSTR							pRcvBuf;
	S7PDU							SndPdu;
	S7PDU							RcvPdu;
	READDATAINFO					RdInfo[MAX_S7VARS];
	INT32							nRWErrCnt;
	UINT8							nRWErrInfo[MAX_S7VARS];
} S7CONNECTION, *LPS7CONNECTION;

typedef struct tagS7PDUHEADER {
	UINT8							nID;							// Telegram ID, always 32
	UINT8							nType;							// Header type 1 or 7
	UINT16							nReserved;						// AB currently unknown, maybe it can be used for long numbers.
	UINT16							nSequence;						// Message ID. This can be used to make sure a received answer
	UINT16							nParLen;						// Length of parameters which follow this header
	UINT16							nDatLen;						// Length of data which follow the parameters
} S7PDUHEADER, *LPS7PDUHEADER;

typedef struct tagS7ERRPDUHEADER {
	UINT8							nID;							// Telegram ID, always 32
	UINT8							nType;							// Header type 1 or 7
	UINT16							nReserved;						// Currently unknown, maybe it can be used for long numbers.
	UINT16							nSequence;						// Message ID. This can be used to make sure a received answer
	UINT16							nParLen;						// Length of parameters which follow this header
	UINT16							nDatLen;						// Length of data which follow the parameters
	UINT16							nError;							// Error code
} S7ERRPDUHEADER, *LPS7ERRPDUHEADER;

typedef struct tagNEGOTIATE_PARS {
	UINT8							nFunc;
	UINT8							nReserved;
	UINT16							nParallelJobs1;
	UINT16							nParallelJobs2;
	UINT16							nPDUSize;
} NEGOTIATE_PARS, *LPNEGOTIATE_PARS;

typedef struct tagREQCTRL_PARS {
	UINT8							nFunc;
	UINT8							nReserved[5];
} REQCTRL_PARS, *LPREQCTRL_PARS;

typedef struct tagSTOP_PARS {
	REQCTRL_PARS					Cmn;
	UINT8							nLength;						// 9
	char							cCmd[9];						// "P_PROGRAM"
} STOP_PARS, *LPSTOP_PARS;

typedef struct tagHOTSTART_PARS {
	REQCTRL_PARS					Cmn;
	UINT8							nReserved[2];
	UINT16							nLength1;						// 0
	UINT8							nLength2;						// 9
	char							cCmd[9];						// "P_PROGRAM"
} HOTSTART_PARS, *LPHOTSTART_PARS;

typedef struct tagCOLDSTART_PARS {
	REQCTRL_PARS					Cmn;
	UINT8							nReserved[2];
	UINT16							nLength1;						// 2
	UINT16							nSubFn;							// 'C ' 0x4320
	UINT8							nLength2;						// 9
	char							cCmd[9];						// "P_PROGRAM"
} COLDSTART_PARS, *LPCOLDSTART_PARS;

typedef struct tagRESCTRL_PARS {
	UINT8							nFunc;
} RESCTRL_PARS, *LPRESCTRL_PARS;

typedef struct tagITEMINFO {
	UINT8							nHead[3];						// 0x12 0x0A 0x10
 	UINT8							nVT;							// Variable type
	UINT16							nCount;
	UINT16							nDB;
	union {
		struct {
	UINT8							nArea;
	UINT8							nBytes[3];
		};
	UINT32							nAddress;
	};
} ITEMINFO, *LPITEMINFO;

typedef struct tagRW_PAR_HDR {
	UINT8							nFunc;
	UINT8							nCount;
} RW_PAR_HDR, *LPRW_PAR_HDR;

typedef struct tagREQ_RW_PARS {
	RW_PAR_HDR						Hdr;
	ITEMINFO						Items[MAX_S7VARS];
} REQ_RW_PARS, *LPREQ_RW_PARS;

typedef struct tagRES_RW_PARS {
	RW_PAR_HDR						Hdr;
} RES_RW_PARS, *LPRES_RW_PARS;

typedef struct tagDATAHEADER {
	UINT8							nRetVal;						// return value
	UINT8							nTS;							// transport size
	UINT16							nLength;						// length
} DATAHEADER, *LPDATAHEADER;

typedef struct tagITEMDATA {
	DATAHEADER						Hdr;
	UINT8							nData;							// various length
} ITEMDATA, *LPITEMDATA;

typedef struct tagRES_WRITE_DATA {
	UINT8							Data[MAX_S7VARS];
} RES_WRITE_DATA, *LPRES_WRITE_DATA;

typedef struct tagREQUSERPARS {
	UINT8							nHead[3];						// 0x00 0x01 0x12
	UINT8							nParLen;						// par len 0x04
	UINT8							nReserved;						// unknown
	UINT8							nTG;							// type and group  (4 bits type and 4 bits group)
	UINT8							nSubFn;							// subfunction
	UINT8							nSequence;						// sequence
} REQUSERPARS, *LPREQUSERPARS;

typedef struct tagRESUSERPARS {
	UINT8							nHead[3];						// 0x00 0x01 0x12
	UINT8							nParLen;						// par len 0x04
	UINT8							nReserved1;						// unknown
	UINT8							nTG;							// type and group  (4 bits type and 4 bits group)
	UINT8							nSubFn;							// subfunction
	UINT8							nSequence;						// sequence
	UINT16							nReserved2;						// present if plen=0x08 (S7 manager online functions)
	UINT16							nError;							// present if plen=0x08 (S7 manager online functions)
} RESUSERPARS, *LPRESUSERPARS;

typedef struct tagCLOCKDATA {
	DATAHEADER						Hdr;
	UINT8							nReserved1;
	UINT8							nReserved2;						// 0x19
	S7DATETIME						Time;
} CLOCKDATA, *LPCLOCKDATA;

typedef struct tagPASSWORDDATA {
	DATAHEADER						Hdr;
	char							cPwd[8];
} PASSWORDDATA, *LPPASSWORDDATA;

typedef struct tagREQSZLDATA {
	DATAHEADER						Hdr;
	UINT16							nID;							// SZL-ID
	UINT16							nIndex;							// SZL-Index
} REQSZLDATA, *LPREQSZLDATA;

typedef struct tagCPUSTATEDATA {
	DATAHEADER						Hdr;
	UINT16							nID;							// SZL-ID
	UINT16							nIndex;							// SZL-Index
	UINT16							nListLen;
	UINT16							nListCount;						// Common SZL response
	UINT8							nReserved1[3];
	UINT8							nState;
	UINT8							nReserved2[16];
} CPUSTATEDATA, *LPCPUSTATEDATA;

typedef union tagS7ANYPARPTR {
	LPVOID							pVoid;
	LPSTR							pStr;
	LPNEGOTIATE_PARS				pNeg;
	LPREQ_RW_PARS					pReqRW;
	LPRES_RW_PARS					pResRW;
	LPREQUSERPARS					pReqUser;
	LPRESUSERPARS					pResUser;
	LPSTOP_PARS						pStop;
	LPHOTSTART_PARS					pHStart;
	LPCOLDSTART_PARS				pCStart;
	LPREQCTRL_PARS					pReqCtrl;
	LPRESCTRL_PARS					pResCtrl;
} S7ANYPARPTR, *LPS7ANYPARPTR;

typedef union tagS7ANYDATAPTR {
	LPVOID							pVoid;
	LPSTR							pStr;
	LPDATAHEADER					pDHdr;
	LPITEMDATA						pItem;
	LPCLOCKDATA						pClk;
	LPCPUSTATEDATA					pState;
	LPPASSWORDDATA					pPwd;
} S7ANYDATAPTR, *LPS7ANYDATAPTR;

#pragma pack(pop)

#ifdef __cplusplus	
extern "C" {
#endif

INT32 __stdcall pS7Online_Init(LPS7INTERFACE lpIF, LPINT32 lpSysErr);
void __stdcall pS7Online_Done(LPS7INTERFACE lpIF, BOOL bCloseLib);
INT32 __stdcall pS7Online_Connect(LPS7CONNECTION lpCon, LPINT32 lpSysErr);
INT32 __stdcall pS7Online_Disconnect(LPS7CONNECTION lpCon, LPINT32 lpSysErr);
INT32 __stdcall pS7Online_Exchange(LPS7CONNECTION lpCon, LPINT32 lpSysErr);

INT32 __stdcall pS7PDU_SndInit(LPS7CONNECTION lpCon, INT32 nType, INT32 nFunc, INT32 nMode, BOOL bConnected);
INT32 __stdcall pS7PDU_RcvInit(LPS7CONNECTION lpCon, LPINT32 lpSysErr);
INT32 __stdcall pS7PDU_SetPDUSize(LPS7CONNECTION lpCon);
void __stdcall pS7PDU_AddData(LPS7CONNECTION lpCon, LPVOID lpData, INT32 nSize);

INT32 __stdcall pS7IsoTcp_Connect(LPS7CONNECTION lpCon, LPINT32 lpSysErr);
INT32 __stdcall pS7IsoTcp_Disconnect(LPS7CONNECTION lpCon, LPINT32 lpSysErr);
INT32 __stdcall pS7IsoTcp_Exchange(LPS7CONNECTION lpCon, LPINT32 lpSysErr);
INT32 __stdcall pS7_Exchange(LPS7CONNECTION lpCon);
INT32 __stdcall pS7_TestConnection(LPS7CONNECTION lpCon, BOOL bConnected, BOOL bClrAddEn);
INT32 __stdcall pS7_TestInterface(LPS7INTERFACE lpIF);

#ifdef __cplusplus
}
#endif

#endif  // _INC_PRIVATE

