/****************************************************************
 * Copyright (c) 2021 by SK  karoly.saly@matrasoft.hu			*
 *																*
 * s7comtest - s7comtest.h										*
 ****************************************************************/
#ifndef _INC_S7COMTEST
#define _INC_S7COMTEST

// #define USE_DLL

#include <skclib32.h>
#ifdef USE_DLL
#include <s7comx32.h>
#else
#include <s7com32.h>
#endif
#include "s7ct_res.h"

#define MAX_FONT				3
#define SMALL_FONT				0
#define NORMAL_FONT				1
#define LARGE_FONT				2
#define SMALL_FONTSIZE			9
#define NORMAL_FONTSIZE			12
#define LARGE_FONTSIZE			15

#define MAX_EDITLINE			400

#define VM_DEFAULT				0
#define VM_BIN					1
#define VM_HEX					2
#define VM_DEC					3
#define VM_UDEC					4
#define VM_CHAR					5
#define VM_REAL					6
#define VM_TIME					7
#define VM_DT					8
#define VM_MAX					8

#define DEFAULT_MPI				2
#define DEFAULT_IP				0x0101A8C0
#define MAX_SIZENAME			5
#define MAX_DBNUM				32767
#define MAX_ADDRESS				32767
#define MAX_COUNT				512

#define STR_EXT_VAT				".vat"

#define MENU_SETOFF				0
#define MENU_SETON				1
#define MENU_UNCHANGED			2

#pragma pack(push, 1)

typedef struct tagVARINFO {
	UINT32						nVT;
	UINT32						nArea;
	UINT32						nDB;
	UINT32						nAddr;
	UINT32						nBit;
	UINT32						nCount;
	UINT32						nPlcVarSize;
	UINT32						nPCVarSize;
	UINT32						nAllocSize;
	LPSTR						pData;
	LPUINT8						pView;
	LPSTR						pName;
} VARINFO, *LPVARINFO;

typedef struct tagVATDATA {
	INT32						nIFMode;
	INT32						nAddr;
	INT32						nTimeOut;
	INT32						nRack;
	INT32						nSlot;
	INT32						nVarCnt;
	HANDLE						hIF;
	HANDLE						hCon;
	char						cPlcName[S7MAX_NAMESIZE];
	VARINFO						VarInfo[MAX_S7VARS];
} VATDATA, *LPVATDATA;

#pragma pack(pop)

extern HWND						g_hWndStatus;
extern INT32					g_nStatusHeight;
extern LPEDITWIN				g_pMainEdit;

extern INT32					g_nFont;
extern HFONT					g_hFont;
extern BOOL						g_bLoaded;
extern HFONT					g_hListFont;
extern INT32					g_nFontSize[MAX_FONT];
extern HBRUSH					g_hRedBrush;
extern VATDATA					g_VAT;
extern VARINFO					g_ActVar;
extern LPSTR					g_VarTypes[S7VT_MAX];
extern LPSTR					g_AreaTypes[S7AT_MAX];
extern char						g_cAreaName[S7AT_MAX];
extern char						g_cSizeName[MAX_SIZENAME];
extern char						g_cVatName[MAX_PATH];
extern LPSTR					g_pIFMode[IFM_MAX];

void __stdcall SetListFont(INT32 nFont);
void __stdcall WriteMsg(INT32 nFunc, INT32 nData, LPVOID lpData);
BOOL __cdecl OpenInterface();
BOOL __stdcall OpenConnection(BOOL bModify);
BOOL __cdecl DoCpuStart();
BOOL __cdecl DoSetClock();
BOOL __cdecl DoSessionLogin();
BOOL __cdecl DoRead();
BOOL __cdecl DoWrite();
BOOL __stdcall DoVarSelect(BOOL bNew, BOOL bWrite, HWND hWnd, LPVARINFO lpInfo);
void __stdcall PresetVarInfo(BOOL bClr, INT32 nVT, INT32 nArea, INT32 nCount, LPVARINFO lpInfo);
INT32 __stdcall GetVarName(BOOL bAddSpc, BOOL bCount, BOOL bType, INT32 nIndex, LPVARINFO lpInfo, LPSTR lpBuf, LPINT32 lpSize);
void __stdcall MultiReadWriteInit(BOOL bWrite);
void __stdcall GetViewValue(INT32 nIdx, LPVARINFO lpInfo, LPANYVALUE lpDst, LPSYSTEMTIME lpSt);
void __stdcall SetViewValue(INT32 nIdx, LPVARINFO lpInfo, LPANYVALUE lpSrc, LPSYSTEMTIME lpSt);
INT32 __stdcall GetValueStr(BOOL bAddSpc, BOOL bEdit, INT32 nIdx, LPVARINFO lpInfo, LPSTR lpBuf, LPBOOL lpErr);
BOOL __stdcall DoVarInput(BOOL bWrite, INT32 nIndex, HWND hWnd, LPVARINFO lpInfo);
INT32 __stdcall GetDefViewMode(LPVARINFO lpInfo);
INT32 __stdcall FillViewModeList(BOOL bAddDefault, BOOL bMenu, INT32 nIdx, LPVARINFO lpInfo, LPINT32 lpViewCnt, LPINT32 lpViewList);
void __stdcall DoView(BOOL bFromWrite, BOOL bUpdate);
LPVATDATA __stdcall VAT_Init(LPVATDATA lpVat);
LPVATDATA __stdcall VAT_Done(LPVATDATA lpVat, BOOL bCloseIF, BOOL bCloseCon, BOOL bLog, BOOL bFree);
BOOL __stdcall Read_VAT(LPSTR lpFileName, LPVATDATA lpVat);
BOOL __stdcall Load_VAT(LPSTR lpFileName, LPVATDATA lpVat);
BOOL __stdcall Save_VAT(LPSTR lpFileName, LPVATDATA lpVat);
void __stdcall SetWinTitle(HWND hWnd, INT32 nIDS);
void __stdcall EnableMenus(INT32 nIF, INT32 nCon, BOOL bSave);

#endif	// _INC_S7COMTEST
