/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_condlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
static BOOL		m_bInit					= FALSE;
static BOOL		m_bModify				= FALSE;
static INT32	m_nLastIP				= 0;
#define EDITBOX_ADDR					0
#define EDITBOX_RACK					1
#define EDITBOX_SLOT					2
#define EDITBOX_TOUT					3
#define MAX_EDITBOX						4
static BOOL		m_bEditErr[MAX_EDITBOX]	= {FALSE, FALSE, FALSE, FALSE};
static INT32	m_nEditVal[MAX_EDITBOX]	= {2, 0, 2, 1000};
static INT32	m_nEditMin[MAX_EDITBOX]	= {0, 0, 0, 100};
static INT32	m_nEditMax[MAX_EDITBOX]	= {127, 31, 18, 30000};
static INT32	m_nEditID[MAX_EDITBOX]	= {IDC_CON_MPI_VAL, IDC_CON_RACK_VAL, IDC_CON_SLOT_VAL, IDC_CON_TOUT_VAL};
static INT32	m_nUpDnID[MAX_EDITBOX]	= {IDC_CON_MPI_UD, IDC_CON_RACK_UD, IDC_CON_SLOT_UD, IDC_CON_TOUT_UD};
static char		m_cConName[S7MAX_NAMESIZE];
// **********************************************************************************
static INT32 __stdcall GetEditIdx(INT32 nID) {
INT32	i, nIdx;

	nIdx = -1;
	for (i = 0; i < MAX_EDITBOX; i++) {
		if (m_nEditID[i] == nID) {
			nIdx = i;
			break;
		}
	}
	return nIdx;
}
// **********************************************************************************
static void __stdcall SetEditStr(HWND hDlg, INT32 nIdx, INT32 nVal, BOOL bSel) {
char	cBuf[256];
INT32	nLen;
BOOL	bInit, bErr;

	bInit = m_bInit;
	m_bInit = TRUE;
	nLen = StrPrint(cBuf, "%d", nVal);
	SendDlgItemMessage(hDlg, m_nEditID[nIdx], WM_SETTEXT, 0, (LPARAM) cBuf);
	if (bSel) SendDlgItemMessage(hDlg, m_nEditID[nIdx], EM_SETSEL, 0, nLen);
	bErr = m_bEditErr[nIdx];
	m_bEditErr[nIdx] = FALSE;
	if (bErr) UpdateDlgWindow(hDlg, m_nEditID[nIdx], TRUE);
	m_bInit = bInit;
}
// **********************************************************************************
static void __stdcall EnableOK(HWND hDlg) {
INT32	i;
BOOL	bEn;

	bEn = (S7_GetInterfaceMode(g_VAT.hIF) == IFM_TCP) ? m_nLastIP != 0 : TRUE;
	for (i = 0; i < MAX_EDITBOX; i++) {
		if (m_bEditErr[i]) bEn = FALSE;
	}
	EnableWindow(GetDlgItem(hDlg, IDOK), bEn);
}
// **********************************************************************************
static void __stdcall InitControls(HWND hDlg) {
HWND	hEdit, hUpDown, hIP;
INT32	i, nIP;
BOOL	bEn, bAccel;
UDACCEL	Accel[2];

	bEn = S7_GetInterfaceMode(g_VAT.hIF) == IFM_TCP;
	nIP = ByteSwap32(m_nLastIP);
	SendDlgItemMessage(hDlg, IDC_CON_IP_VAL, IPM_SETADDRESS, 0, nIP);
	hIP = GetDlgItem(hDlg, IDC_CON_IP_VAL);
	EnableWindow(hIP, bEn);
	if (bEn) {
		SetFocus(hIP);
		EnableWindow(GetDlgItem(hDlg, IDC_CON_MPI_LBL), FALSE);
	}
	else {
		EnableWindow(GetDlgItem(hDlg, IDC_CON_IP_LBL), FALSE);
	}
	SendDlgItemMessage(hDlg, IDC_CON_NAME_VAL, WM_SETTEXT, 0, (LPARAM) m_cConName);
	SendDlgItemMessage(hDlg, IDC_CON_NAME_VAL, EM_SETLIMITTEXT, S7MAX_NAMELEN, 0);
	bEn = !bEn;
	for (i = 0; i < MAX_EDITBOX; i++) {
		hEdit = GetDlgItem(hDlg, m_nEditID[i]);
		hUpDown = GetDlgItem(hDlg, m_nUpDnID[i]);
		SendMessage(hUpDown, UDM_SETBUDDY, (WPARAM) hEdit, 0);
		SendMessage(hUpDown, UDM_SETRANGE, 0, MAKELPARAM(m_nEditMax[i], m_nEditMin[i]));
		SendMessage(hUpDown, UDM_SETPOS, 0, m_nEditVal[i]);
		bAccel = TRUE;
		if (i == EDITBOX_ADDR) {
			Accel[0].nSec = 0;
			Accel[0].nInc = 1;
			Accel[1].nSec = 2;
			Accel[1].nInc = 10;
		}
		else if (i == EDITBOX_TOUT) {
			Accel[0].nSec = 0;
			Accel[0].nInc = 50;
			Accel[1].nSec = 2;
			Accel[1].nInc = 200;
		}
		else {
			bAccel = FALSE;
		}
		if (bAccel) SendMessage(hUpDown, UDM_SETACCEL, 2, (LPARAM) &Accel);
		SetEditStr(hDlg, i, m_nEditVal[i], FALSE);
		EnableWindow(hEdit, bEn);
		EnableWindow(hUpDown, bEn);
		bEn = TRUE;
	}
}
// **********************************************************************************
static INT32 CALLBACK pCon_Open(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
LPNMUPDOWN			pUD;
INT32				i, nIdx, nCmd, nID, nLen, nScan, nPrev, nAct, nRet;
char				cBuf[256];
BOOL				bState, bOK;

	switch (uMsg) {
	case WM_INITDIALOG:
		m_bInit = TRUE;
		InitControls(hDlg);
		EnableOK(hDlg);
		CenterWindow(hDlg, GetParent(hDlg));
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		m_bInit = FALSE;
		return TRUE;
	case WM_CTLCOLOREDIT:
		nID = GetDlgCtrlID((HWND) lParam);
		nIdx = GetEditIdx(nID);
		if (nIdx >= 0) {
			bOK = !m_bEditErr[nIdx];
			if (bOK) {
				SetTextColor((HDC) wParam, GetSysColor(COLOR_WINDOWTEXT));
				SetBkColor((HDC) wParam, GetSysColor(COLOR_WINDOW));
				return (LRESULT) GetSysColorBrush(COLOR_WINDOW);
			}
			else {
				SetTextColor((HDC) wParam, RGB_BLACK);
				SetBkColor((HDC) wParam, RGB_LIGHTRED);
				return (LRESULT) g_hRedBrush;
			}
		}
		break;
	case WM_COMMAND:
		nRet = 0;
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDC_CON_MPI_VAL:
		case IDC_CON_RACK_VAL:
		case IDC_CON_SLOT_VAL:
			nIdx = GetEditIdx(nID);
			nPrev = (INT16) (SendDlgItemMessage(hDlg, nID, UDM_GETPOS, 0, 0) & 0xFFFF);
			switch (nCmd) {
			case EN_SETFOCUS:
				SendDlgItemMessage(hDlg, nID, EM_SETSEL, 0, 31);
				break;
			case EN_KILLFOCUS:
//				SetEditStr(nPage, nIdx, nPrev, FALSE);
				break;
			case EN_CHANGE:
				if (!m_bInit) {
					nLen = SendDlgItemMessage(hDlg, nID, WM_GETTEXT, sizeof(cBuf), (LPARAM) cBuf);
					nAct = (INT32) IntVal(cBuf, NF_DEC, 0, &nScan);
					bOK = (nLen > 0) && (nScan == nLen) && (nAct >= m_nEditMin[nIdx]) && (nAct <= m_nEditMax[nIdx]);
					if (bOK && (nAct != nPrev)) {
						SendDlgItemMessage(hDlg, m_nUpDnID[nIdx], UDM_SETPOS, 0, nAct);
					}
					bState = !m_bEditErr[nIdx];
					m_bEditErr[nIdx] = !bOK;
					if (bOK) {
						m_nEditVal[nIdx] = nAct;
					}
					EnableOK(hDlg);
					if (bOK != bState) UpdateDlgWindow(hDlg, nID, TRUE);
				}
				break;
			}
			break;
		case IDC_CON_NAME_VAL:
			if (nCmd == EN_CHANGE) {
				nLen = SendDlgItemMessage(hDlg, nID, WM_GETTEXT, sizeof(cBuf), (LPARAM) cBuf);
				TrimCpy(m_cConName, cBuf, TSM_BOTH);
			}
			break;
		case IDC_CON_IP_VAL:
			if ((nCmd == EN_CHANGE) || (nCmd == EN_KILLFOCUS)) {
				SendDlgItemMessage(hDlg, IDC_CON_IP_VAL, IPM_GETADDRESS, 0, (LPARAM) &m_nLastIP);
				m_nLastIP = ByteSwap32(m_nLastIP);
				EnableOK(hDlg);
			}
			break;
		case IDOK:
			nRet = IDOK;
		case IDCANCEL:
			EndDialog (hDlg, nRet);
		}
		return TRUE;
		break;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if ((wParam >= IDC_SEPARATOR) && (wParam <= IDC_SEPARATOR9)){
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_NOTIFY:
		pUD = (LPNMUPDOWN) lParam;
		nID = pUD->hdr.idFrom;
		nIdx = -1;
		for (i = 0; i < MAX_EDITBOX; i++) {
			if (m_nUpDnID[i] == nID) {
				nIdx = i;
				break;
			}
		}
		if ((nIdx >= 0) && (pUD->hdr.code == UDN_DELTAPOS)) {
			nPrev = (INT16) (SendDlgItemMessage(hDlg, nID, UDM_GETPOS, 0, 0) & 0xFFFF);
			nAct = pUD->iDelta + pUD->iPos;
			if (nAct > m_nEditMax[nIdx]) nAct = m_nEditMax[nIdx];
			if (nAct < m_nEditMin[nIdx]) nAct = m_nEditMin[nIdx];
			if (nAct != nPrev) {
				m_nEditVal[nIdx] = nAct;
				SetEditStr(hDlg, nIdx, nAct, TRUE);
			}
			return TRUE;
		}
		break;
	}
	return FALSE;
}
// **********************************************************************************
BOOL __stdcall OpenConnection(BOOL bModify) {
INT32	i, nDlg;
BOOL	bRet;

	bRet = FALSE;
	for (i = 0; i < MAX_EDITBOX; i++) {
		m_bEditErr[i]	= FALSE;
	}
	StrCpy(m_cConName, g_VAT.cPlcName);
	if (g_VAT.nIFMode == IFM_TCP) {
		m_nLastIP = g_VAT.nAddr;
	}
	else {
		m_nEditVal[EDITBOX_ADDR] = g_VAT.nAddr;
	}
	m_nEditVal[EDITBOX_RACK] = g_VAT.nRack;
	m_nEditVal[EDITBOX_SLOT] = g_VAT.nSlot;
	m_nEditVal[EDITBOX_TOUT] = g_VAT.nTimeOut;
	nDlg = DialogBox(g_hInstance, RESSTR(IDD_OPENCON), g_hWndMain, pCon_Open);
	if (nDlg == IDOK) {
		if (bModify && g_VAT.hCon) {
			g_VAT.hCon = S7_Connection_Done(g_VAT.hCon);
			WriteMsg(IDS_CON_DONE, 0, NULL);
		}
		StrCpy(g_VAT.cPlcName, m_cConName);
		g_VAT.nAddr = g_VAT.nIFMode == IFM_TCP ? m_nLastIP : m_nEditVal[EDITBOX_ADDR];
		g_VAT.nRack = m_nEditVal[EDITBOX_RACK];
		g_VAT.nSlot = m_nEditVal[EDITBOX_SLOT];
		g_VAT.nTimeOut = m_nEditVal[EDITBOX_TOUT];
		g_VAT.hCon = S7_Connection_Init(g_VAT.hIF, g_VAT.cPlcName, g_VAT.nTimeOut, g_VAT.nAddr, g_VAT.nRack, g_VAT.nSlot, DEF_S7PDUSIZE);
		WriteMsg(IDS_CON_INIT, 0, NULL);
		bRet = TRUE;
	}
	return bRet;
}
