/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_seldlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
static BOOL		m_bInit					= FALSE;
static INT32	m_nType					= S7VT_WORD;
static INT32	m_nArea					= S7AT_FLAG;
#define EDITBOX_DB						0
#define EDITBOX_ADDR					1
#define EDITBOX_BIT						2
#define EDITBOX_COUNT					3
#define MAX_EDITBOX						4
static BOOL		m_bEditErr[MAX_EDITBOX]	= {FALSE, FALSE, FALSE, FALSE};
static INT32	m_nEditVal[MAX_EDITBOX]	= {0, 0, 0, 1};
static INT32	m_nEditMin[MAX_EDITBOX]	= {0, 0, 0, 1};
static INT32	m_nEditMax[MAX_EDITBOX]	= {MAX_DBNUM, MAX_ADDRESS, 7, MAX_COUNT};
static INT32	m_nEditID[MAX_EDITBOX]	= {IDC_RW_DBNUM_VAL, IDC_RW_ADDRESS_VAL, IDC_RW_BIT_VAL, IDC_RW_COUNT_VAL};
static INT32	m_nUpDnID[MAX_EDITBOX]	= {IDC_RW_DBNUM_UD, IDC_RW_ADDRESS_UD, IDC_RW_BIT_UD, IDC_RW_COUNT_UD};
// **********************************************************************************
static INT32 __stdcall GetEditIdx(INT32 nID) {
INT32	i, nIdx;

	nIdx = -1;
	for (i = 0; i < MAX_EDITBOX; i++) {
		if (m_nEditID[i] == nID) {
			nIdx = i;
			break;
		}
	}
	return nIdx;
}
// **********************************************************************************
static void __stdcall SetEditStr(HWND hDlg, INT32 nIdx, INT32 nVal, BOOL bSel) {
char	cBuf[256];
INT32	nLen;
BOOL	bInit, bErr;

	bInit = m_bInit;
	m_bInit = TRUE;
	nLen = StrPrint(cBuf, "%d", nVal);
	SendDlgItemMessage(hDlg, m_nEditID[nIdx], WM_SETTEXT, 0, (LPARAM) cBuf);
	if (bSel) SendDlgItemMessage(hDlg, m_nEditID[nIdx], EM_SETSEL, 0, nLen);
	bErr = m_bEditErr[nIdx];
	m_bEditErr[nIdx] = FALSE;
	if (bErr) UpdateDlgWindow(hDlg, m_nEditID[nIdx], TRUE);
	m_bInit = bInit;
}
// **********************************************************************************
static void __stdcall EnableOK(HWND hDlg) {
INT32	i;
BOOL	bEn;

	bEn = TRUE;
	for (i = 0; i < MAX_EDITBOX; i++) {
		if (m_bEditErr[i]) bEn = FALSE;
	}
	if (m_nType == S7VT_BIT) {
		if (m_nEditVal[EDITBOX_COUNT] > 1)  {
			if (m_nEditVal[EDITBOX_BIT] || (m_nEditVal[EDITBOX_COUNT] & 7)) bEn = FALSE;
		}
	}
	EnableWindow(GetDlgItem(hDlg, IDOK), bEn);
}
// **********************************************************************************
static void __stdcall InitControls(HWND hDlg, BOOL bFirst) {
HWND	hEdit, hUpDown;
INT32	i, nRes;
UINT32	nMax;
BOOL	bAccel, bBit, bDB, bEn, bCount;
UDACCEL	Accel[2];

	FillComboFromStr(hDlg, IDC_RW_TYPE, g_VarTypes, S7VT_MAX, m_nType, TRUE);
	switch (m_nType) {
	case S7VT_TIMER:
		FillComboFromStr(hDlg, IDC_RW_AREA, &g_AreaTypes[S7AT_TIMER], 1, 0, TRUE);
		m_nArea = S7AT_TIMER;
		break;
	case S7VT_COUNTER:
		FillComboFromStr(hDlg, IDC_RW_AREA, &g_AreaTypes[S7AT_COUNTER], 1, 0, TRUE);
		m_nArea = S7AT_COUNTER;
		break;
	default:
		if (m_nArea >= S7AT_STDMAX) m_nArea = S7AT_FLAG;
		FillComboFromStr(hDlg, IDC_RW_AREA, g_AreaTypes, S7AT_STDMAX, m_nArea, TRUE);
	}
	bCount = TRUE;
	bBit = m_nType == S7VT_BIT ? TRUE : FALSE;
	if (m_nArea == S7AT_DB) {
		bDB = TRUE;
		if (m_nEditVal[EDITBOX_DB] == 0) m_nEditVal[EDITBOX_DB] = 1;
		m_nEditMin[EDITBOX_DB] = 1;
	}
	else {
		bDB = FALSE;
		m_nEditVal[EDITBOX_DB] = 0;
		m_nEditMin[EDITBOX_DB] = 0;
	}
	nRes = S7_GetItemMaxCount(g_VAT.hCon, TRUE, m_nType, &nMax);
	if (nMax) {
		m_nEditMin[EDITBOX_COUNT] = 1;
		if (m_nType == S7VT_BIT) nMax <<=  3;
		m_nEditMax[EDITBOX_COUNT] = nMax;
		if (!m_nEditVal[EDITBOX_COUNT]) m_nEditVal[EDITBOX_COUNT] = 1;
		if (m_nEditVal[EDITBOX_COUNT] > (INT32) nMax) m_nEditVal[EDITBOX_COUNT] = nMax;
	}
	else {
		m_nEditVal[EDITBOX_COUNT] = 0;
		m_nEditMin[EDITBOX_COUNT] = 0;
		m_nEditMax[EDITBOX_COUNT] = 0;
		bCount = FALSE;
	}

	for (i = 0; i < MAX_EDITBOX; i++) {
		hEdit = GetDlgItem(hDlg, m_nEditID[i]);
		hUpDown = GetDlgItem(hDlg, m_nUpDnID[i]);
		if (bFirst) SendMessage(hUpDown, UDM_SETBUDDY, (WPARAM) hEdit, 0);
		SendMessage(hUpDown, UDM_SETRANGE, 0, MAKELPARAM(m_nEditMax[i], m_nEditMin[i]));
		SendMessage(hUpDown, UDM_SETPOS, 0, m_nEditVal[i]);
		bAccel = bFirst;
		Accel[0].nSec = 0;
		Accel[0].nInc = 1;
		Accel[1].nSec = 2;
		bEn = TRUE;
		switch (i) {
		case EDITBOX_DB:
			bEn = bDB;
		case EDITBOX_ADDR:
			Accel[1].nInc = 100;
			break;
		case EDITBOX_COUNT:
			bEn = bCount;
			Accel[1].nInc = 10;
			break;
		case EDITBOX_BIT:
			bEn = bBit;
			bAccel = FALSE;
		}
		if (bAccel) SendMessage(hUpDown, UDM_SETACCEL, 2, (LPARAM) &Accel);
		SetEditStr(hDlg, i, m_nEditVal[i], FALSE);
		EnableWindow(hEdit, bEn);
		EnableWindow(hUpDown, bEn);
	}
}
// **********************************************************************************
static INT32 CALLBACK pVarSelect(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
LPNMUPDOWN			pUD;
INT32				i, nIdx, nCmd, nID, nLen, nScan, nPrev, nAct, nRet;
char				cBuf[256];
BOOL				bState, bOK;

	switch (uMsg) {
	case WM_INITDIALOG:
		m_bInit = TRUE;
		InitControls(hDlg, TRUE);
		EnableOK(hDlg);
		CenterWindow(hDlg, GetParent(hDlg));
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		m_bInit = FALSE;
		return TRUE;
	case WM_CTLCOLOREDIT:
		nID = GetDlgCtrlID((HWND) lParam);
		nIdx = GetEditIdx(nID);
		if (nIdx >= 0) {
			bOK = !m_bEditErr[nIdx];
			if (bOK) {
				SetTextColor((HDC) wParam, GetSysColor(COLOR_WINDOWTEXT));
				SetBkColor((HDC) wParam, GetSysColor(COLOR_WINDOW));
				return (LRESULT) GetSysColorBrush(COLOR_WINDOW);
			}
			else {
				SetTextColor((HDC) wParam, RGB_BLACK);
				SetBkColor((HDC) wParam, RGB_LIGHTRED);
				return (LRESULT) g_hRedBrush;
			}
		}
		break;
	case WM_COMMAND:
		nRet = 0;
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDC_RW_DBNUM_VAL:
		case IDC_RW_ADDRESS_VAL:
		case IDC_RW_BIT_VAL:
		case IDC_RW_COUNT_VAL:
			nIdx = GetEditIdx(nID);
			nPrev = (INT16) (SendDlgItemMessage(hDlg, nID, UDM_GETPOS, 0, 0) & 0xFFFF);
			switch (nCmd) {
			case EN_SETFOCUS:
				SendDlgItemMessage(hDlg, nID, EM_SETSEL, 0, 31);
				break;
			case EN_KILLFOCUS:
//				SetEditStr(nPage, nIdx, nPrev, FALSE);
				break;
			case EN_CHANGE:
				if (!m_bInit) {
					nLen = SendDlgItemMessage(hDlg, nID, WM_GETTEXT, sizeof(cBuf), (LPARAM) cBuf);
					nAct = (INT32) IntVal(cBuf, NF_DEC, 0, &nScan);
					bOK = (nLen > 0) && (nScan == nLen) && (nAct >= m_nEditMin[nIdx]) && (nAct <= m_nEditMax[nIdx]);
					if (bOK && (nAct != nPrev)) {
						SendDlgItemMessage(hDlg, m_nUpDnID[nIdx], UDM_SETPOS, 0, nAct);
					}
					bState = !m_bEditErr[nIdx];
					m_bEditErr[nIdx] = !bOK;
					if (bOK) {
						m_nEditVal[nIdx] = nAct;
					}
					EnableOK(hDlg);
					if (bOK != bState) UpdateDlgWindow(hDlg, nID, TRUE);
				}
				break;
			}
			break;
		case IDC_RW_TYPE:
		case IDC_RW_AREA:
			if (nCmd == CBN_SELCHANGE) {
				i = SendDlgItemMessage(hDlg, nID, CB_GETCURSEL, 0, 0);
				if (nID == IDC_RW_TYPE) {
					m_nType = i;
					if (m_nType != S7VT_BIT) m_nEditVal[EDITBOX_BIT] = 0;
				}
				else {
					m_nArea = i;
				}
				InitControls(hDlg, FALSE);
				EnableOK(hDlg);
			}
			break;
		case IDOK:
			nRet = IDOK;
		case IDCANCEL:
			EndDialog (hDlg, nRet);
		}
		return TRUE;
		break;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if ((wParam >= IDC_SEPARATOR) && (wParam <= IDC_SEPARATOR9)){
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_NOTIFY:
		pUD = (LPNMUPDOWN) lParam;
		nID = pUD->hdr.idFrom;
		nIdx = -1;
		for (i = 0; i < MAX_EDITBOX; i++) {
			if (m_nUpDnID[i] == nID) {
				nIdx = i;
				break;
			}
		}
		if ((nIdx >= 0) && (pUD->hdr.code == UDN_DELTAPOS)) {
			nPrev = (INT16) (SendDlgItemMessage(hDlg, nID, UDM_GETPOS, 0, 0) & 0xFFFF);
			nAct = pUD->iDelta + pUD->iPos;
			if (nAct > m_nEditMax[nIdx]) nAct = m_nEditMax[nIdx];
			if (nAct < m_nEditMin[nIdx]) nAct = m_nEditMin[nIdx];
			if (nAct != nPrev) {
				m_nEditVal[nIdx] = nAct;
				SetEditStr(hDlg, nIdx, nAct, TRUE);
				EnableOK(hDlg);
			}
			return TRUE;
		}
		break;
	}
	return FALSE;
}
// **********************************************************************************
BOOL __stdcall DoVarSelect(BOOL bNew, BOOL bWrite, HWND hWnd, LPVARINFO lpInfo) {
SYSTEMTIME	st;
INT32		nDlg;
UINT32		i, nCount, nMin, nDB, nAddr, nBit;
BOOL		bRet, bChk;
VARINFO		VI;
ANYPOINTER	pAny;
UINT64		nDate;
LPUINT8		pView;
LPSTR		pName;

	bRet = FALSE;
	if (bNew) {
		PresetVarInfo(TRUE, m_nType, m_nArea, m_nEditVal[EDITBOX_COUNT], &g_ActVar);
	}
	else {
		m_nType = lpInfo->nVT;
		m_nArea = lpInfo->nArea;
		m_nEditVal[EDITBOX_DB] = lpInfo->nDB;
		m_nEditVal[EDITBOX_ADDR] = lpInfo->nAddr;
		m_nEditVal[EDITBOX_BIT] = lpInfo->nBit;
		m_nEditVal[EDITBOX_COUNT] = lpInfo->nCount;
	}
	for (i = 0; i < MAX_EDITBOX; i++) {
		m_bEditErr[i]	= FALSE;
	}
	MultiReadWriteInit(bWrite);
	nDlg = DialogBox(g_hInstance, RESSTR(IDD_RW_VARSEL), hWnd, pVarSelect);
	if (nDlg == IDOK) {
		nDB = m_nEditVal[EDITBOX_DB];
		nAddr = m_nEditVal[EDITBOX_ADDR];
		nBit = m_nEditVal[EDITBOX_BIT];
		nCount = m_nEditVal[EDITBOX_COUNT];
		PresetVarInfo(TRUE, m_nType, m_nArea, nCount, &VI);
		bRet = bNew || (VI.nVT != lpInfo->nVT) || (VI.nArea != lpInfo->nArea) || (nDB != lpInfo->nDB) || (nAddr != lpInfo->nAddr) || (nBit != lpInfo->nBit) || (nCount != lpInfo->nCount);
		bChk = FALSE;
		if (lpInfo->pData) {
			if (m_nType != lpInfo->nVT) {
				FreeMem(lpInfo->pData);
				lpInfo->pData = NULL;
			}
			else if (lpInfo->nCount != nCount) {
				pAny.pVoid = GetMem(GMM_CLEAR, nCount * (1 + S7MAX_NAMESIZE) + (VI.nAllocSize << 1));
				nMin = min(lpInfo->nCount, nCount);
				MemCpy(pAny.pVoid, lpInfo->pData, nMin * lpInfo->nPCVarSize);
				pView = pAny.pStr + (VI.nAllocSize << 1);
				pName = pView + nCount;
				MemCpy(pAny.pVoid, lpInfo->pData, nMin * lpInfo->nPCVarSize);
				MemCpy(pView, lpInfo->pView, nMin);
				MemCpy(pName, lpInfo->pName, nMin * S7MAX_NAMESIZE);
				FreeMem(lpInfo->pData);
				lpInfo->pData = pAny.pVoid;
				lpInfo->pView = pView;
				lpInfo->pName = pName;
				bChk = TRUE;
			}
		}
		PresetVarInfo(FALSE, m_nType, m_nArea, nCount, lpInfo);
		if (!lpInfo->pData) {
			lpInfo->pData = GetMem(GMM_CLEAR, nCount * (1 + S7MAX_NAMESIZE) + (lpInfo->nAllocSize << 1));
			lpInfo->pView = lpInfo->pData + (VI.nAllocSize << 1);
			lpInfo->pName = lpInfo->pView + nCount;
			nMin = 0;
			bChk = TRUE;
		}
		if ((bChk) && (lpInfo->nVT == S7VT_DT)) {
			pAny.pVoid = lpInfo->pData;
			MemClr(&st, sizeof(SYSTEMTIME));
			DayToDate(0, 1990, &st);
			S7_SetDT(&nDate, &st);
			pAny.pU64 += nMin;
			for (i = nMin; i < nCount; i++) {
				*pAny.pU64++ = nDate;
			}
		}
		lpInfo->nDB = nDB;
		lpInfo->nAddr = nAddr;
		lpInfo->nBit = nBit;
	}
	return bRet;
}
