/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_clkdlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
static INT32	m_nColdStrt		= 0;
// **********************************************************************************
static INT32 CALLBACK pStartDlg(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
INT32				nID, nCmd;

	switch (uMsg) {
	case WM_INITDIALOG:
		CheckDlgButton(hDlg, IDC_WARMSTART + m_nColdStrt, BST_CHECKED);
		CenterWindow(hDlg, g_hWndMain);
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		return TRUE;
	case WM_COMMAND:
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDOK:
			EndDialog (hDlg, IDOK);
			return TRUE ;
		case IDCANCEL:
			EndDialog (hDlg, 0);
			return TRUE ;
		case IDC_WARMSTART:
		case IDC_COLDSTART:
			switch (nCmd) {
			case BN_CLICKED:
				m_nColdStrt = nID - IDC_WARMSTART;
				break;
			}
			return TRUE;
		} // end switch
		return TRUE ;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if (wParam == IDC_SEPARATOR) {
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		return TRUE ;
	} // end switch
	return FALSE ;
}
// **********************************************************************************
BOOL __cdecl DoCpuStart() {
INT32			nDlg, nRes;
BOOL			bRet;

	bRet = FALSE;
	nDlg = DialogBox(g_hInstance, RESSTR(IDD_CPUSTART), g_hWndMain, pStartDlg);
	if (nDlg == IDOK) {
		nRes = S7_CpuStart(g_VAT.hCon, m_nColdStrt);
		WriteMsg(IDS_CPUSTART, 0, NULL);
		bRet = TRUE;
	}
	return bRet;
}
