/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_viewdlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
static HWND		m_hStatus				= NULL;
static HANDLE	m_hThread				= NULL;
static BOOL		m_bUpdate				= FALSE;
static UINT32	m_nUpdate				= 1000;
static BOOL		m_bHidden				= FALSE;
static BOOL		m_bFromWrite			= FALSE;
static UINT32	m_nTimer				= 0;
static INT32	m_nSelelectedValue		= -1;
static INT32	m_nStatusHeight			= 0;
static INT32	m_nLeft					= 0;
static INT32	m_nTop					= 0;
static INT32	m_nListBtm				= 0;
static INT32	m_nLineTop				= 0;
static INT32	m_nBtnTop				= 0;
static INT32	m_nBtnWidth				= 0;
static INT32	m_nChkTop				= 0;
static INT32	m_nMinWidth				= 0;
static INT32	m_nMinHeight			= 0;
static INT32	m_nVarLen;
static INT32	m_nNameLen;
#define MAX_UPDATE						6
static INT32	m_nUpdList[MAX_UPDATE]	= {100, 250, 500, 1000, 2000, 5000};
#ifdef LANGUAGE_ENGLISH
static LPSTR	m_pUpdList[MAX_UPDATE]	= {"100 ms", "250 ms", "500 ms" , "1 s", "2 s", "5 s"};
#endif
#ifdef LANGUAGE_HUNGARIAN
static LPSTR	m_pUpdList[MAX_UPDATE]	= {"100 ms", "250 ms", "500 ms" , "1 mp", "2 mp", "5 mp"};
#endif
// **********************************************************************************
static void __stdcall FillViewList(HWND hDlg, BOOL bFirst, BOOL bForce) {
char	cBuf[256];
HWND	hList;
UINT32	j;
INT32	i, k, nAct, nTop, nWidth, nLen;
LPSTR	pSrc, pDst, pName;
BOOL	bActChg, bAnyChg;

	bAnyChg = FALSE;
	hList = GetDlgItem(hDlg, IDC_RW_VIEWLIST);
	if (bFirst) {
		m_nVarLen = m_nNameLen = 0;
		for (i = 0; i < g_VAT.nVarCnt; i++) {
			GetVarName(TRUE, FALSE, FALSE, g_VAT.VarInfo[i].nCount - 1, &g_VAT.VarInfo[i], cBuf, &m_nVarLen);
			pName = g_VAT.VarInfo[i].pName;
			for (j = 0; j < g_VAT.VarInfo[i].nCount; j++) {
				nLen = StrLen(pName);
				if (nLen > m_nNameLen) m_nNameLen = nLen;
				pName += S7MAX_NAMESIZE;
			}
		}
		m_nSelelectedValue = -1;
	}
	nTop = bFirst ? 0 : SendMessage(hList, LB_GETTOPINDEX, 0, 0);
	k = nWidth = 0;
	for (i = 0; i < g_VAT.nVarCnt; i++) {
		pSrc = pDst = g_VAT.VarInfo[i].pData;
		pDst += g_VAT.VarInfo[i].nAllocSize;
		pName = g_VAT.VarInfo[i].pName;
		for (j = 0; j < g_VAT.VarInfo[i].nCount; j++) {
			bActChg = bFirst || (bForce && (k == m_nSelelectedValue)) || MemCmp(pDst, pSrc, g_VAT.VarInfo[i].nPCVarSize);
			nAct = GetVarName(TRUE, FALSE, FALSE, j, &g_VAT.VarInfo[i], cBuf, NULL);
			nAct += StrPrint(&cBuf[nAct], "%*c= ", m_nVarLen - nAct + 1, ' ');
			if (m_nNameLen) {
				nLen = StrLen(pName);
				nAct -= 2;
				nAct += StrPrint(&cBuf[nAct], ": %s%*c= ", pName, m_nNameLen - nLen + 1, ' ');
			}
			nAct += GetValueStr(TRUE, FALSE, j, &g_VAT.VarInfo[i], &cBuf[nAct], NULL);
			if (bActChg) {
				bAnyChg = TRUE;
				SendMessage(hList, LB_INSERTSTRING, k, (LPARAM) cBuf);
				if (!bFirst) SendMessage(hList, LB_DELETESTRING, k + 1, 0);
				MemCpy(pDst, pSrc, g_VAT.VarInfo[i].nPCVarSize);
			}
			nAct = MeasureText(NULL, hDlg, g_hListFont, cBuf, NULL, FALSE);
			if (nAct > nWidth) nWidth = nAct;
			pDst += g_VAT.VarInfo[i].nPCVarSize;
			pSrc += g_VAT.VarInfo[i].nPCVarSize;
			pName += S7MAX_NAMESIZE;
			k++;
		}
	}
	k = SendMessage(hList, LB_GETHORIZONTALEXTENT, 0, 0);
	if (k != nWidth) SendMessage(hList, LB_SETHORIZONTALEXTENT, nWidth, 0);
	if (bAnyChg) {
		SendMessage(hList, LB_SETCURSEL, m_nSelelectedValue, 0);
		SendMessage(hList, LB_SETTOPINDEX, nTop, 0);
	}
}
// **********************************************************************************
static INT32 __stdcall pDoRead(HWND hDlg) {
INT32		nRes, nMode;

	if (g_VAT.nVarCnt == 1) {
		nRes = S7_SimpleRead(g_VAT.hCon, g_VAT.VarInfo[0].nVT, g_VAT.VarInfo[0].nArea, g_VAT.VarInfo[0].nDB, g_VAT.VarInfo[0].nAddr, g_VAT.VarInfo[0].nBit, g_VAT.VarInfo[0].nCount, TRUE, g_VAT.VarInfo[0].pData);
		nMode = IDS_SIMPLEREAD;
	}
	else {
		MultiReadWriteInit(FALSE);
		nRes = S7_MultiRead_Done(g_VAT.hCon);
		nMode = IDS_MULTIREAD;
	}
	if (nRes) {
		WriteMsg(nMode, 0, NULL);
		CheckDlgButton(hDlg, IDC_RW_UPDATE, BST_UNCHECKED);
		EnableWindow(GetDlgItem(hDlg, IDC_RW_UPDATE), FALSE);
		EnableWindow(GetDlgItem(hDlg, IDC_RW_UPDCYCLE), FALSE);
		m_bUpdate = FALSE;
	}
	return nRes;
}
// **********************************************************************************
static void __stdcall DlgTimerProc(HWND hDlg, UINT32 uMsg, UINT32 idEvent, ULONG dwTime) {
static	INT32	nPrevSec = -1;
INT32			nRes;
UINT32			nAct, nDlt;

	nAct = GetTickCount();
	nDlt = nAct - m_nTimer;
	if (nDlt >= m_nUpdate) {
		m_nTimer += m_nUpdate;
		DisplayTime(m_hStatus, FALSE, &nPrevSec, NULL, NULL);
		if (m_bUpdate) {
			nRes = pDoRead(hDlg);
			if (!nRes) FillViewList(hDlg, FALSE, FALSE);
		}
	}
}
// **********************************************************************************
static INT32 __stdcall FindVarIdx(LPINT32 lpVar) {
INT32	i, k, nIdx, nVar;

	nVar = -1;
	k = 0;
	for (i = 0; (i < g_VAT.nVarCnt) && (nVar < 0); i++) {
		if (m_nSelelectedValue < k + (INT32) g_VAT.VarInfo[i].nCount) {
			nVar = i;
			nIdx = m_nSelelectedValue - k;
		}
		k += g_VAT.VarInfo[i].nCount;
	}
	*lpVar = nVar;
	return nIdx;
}
// **********************************************************************************
static INT32 CALLBACK pViewDlg(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
POINT				pt;
INT32				i, w, nCmd, nID, nRet, nFromPt, nVar, nIdx, nMode, nSel, nView, nWidth, nHeight, nViewModeCnt;
INT32				nViewModeList[VM_MAX], paParts[2];
HWND				hBox, hItem;
WINDOWINFO			wiDlg;
RECT				rClient, rc;

	switch (uMsg) {
	case WM_INITDIALOG:
		nSel = 3;
		for (i = 0; i < MAX_UPDATE; i++) {
			if (m_nUpdate == m_nUpdList[i]) {
				nSel = i;
				break;
			}
		}
		FillComboFromStr(hDlg, IDC_RW_UPDCYCLE, m_pUpdList, MAX_UPDATE, nSel, TRUE);
		m_bHidden = FALSE;
		if (m_bUpdate) CheckDlgButton(hDlg, IDC_RW_UPDATE, BST_CHECKED);
		EnableWindow(GetDlgItem(hDlg, IDC_RW_UPDCYCLE), m_bUpdate);
		m_hStatus = GetDlgItem(hDlg, IDC_STATUSBAR);
		paParts[0] = GetTimeStrWidth(m_hStatus, TRUE, 0, 2);
		paParts[1] = -1;
		SendMessage(m_hStatus, SB_SETPARTS, (WPARAM) 2, (LPARAM) paParts);
		m_nStatusHeight = GetWindowHeight(hDlg, IDC_STATUSBAR);
		SendDlgItemMessage(hDlg, IDC_RW_VIEWLIST, WM_SETFONT, (WPARAM) g_hListFont, TRUE);
		FillViewList(hDlg, TRUE, FALSE);
		if (m_bFromWrite) {
			nRet = pDoRead(hDlg);
			if (!nRet) FillViewList(hDlg, FALSE, FALSE);
		}
		LB_UnSelect_Init(hDlg, IDC_RW_VIEWLIST);
		CenterWindow(hDlg, GetParent(hDlg));
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		m_nTimer = GetTickCount() - m_nUpdate;
		SetTimer(hDlg, IDC_TIMER, 50, DlgTimerProc);
		wiDlg.cbSize = sizeof(WINDOWINFO);
		GetWindowInfo(hDlg, &wiDlg);
		GetWindowRect(GetDlgItem(hDlg, IDC_RW_VIEWLIST), &rc);
		m_nLeft = rc.left - wiDlg.rcClient.left;
		m_nTop = rc.top - wiDlg.rcClient.top;
		m_nListBtm = wiDlg.rcClient.bottom - rc.bottom;
		nHeight = rc.bottom - rc.top;
		GetWindowRect(GetDlgItem(hDlg, IDC_SEPARATOR), &rc);
		m_nLineTop = wiDlg.rcClient.bottom - rc.top;
		GetWindowRect(GetDlgItem(hDlg, IDCANCEL), &rc);
		m_nBtnWidth = rc.right - rc.left;
		m_nBtnTop = wiDlg.rcClient.bottom - rc.top;
		GetWindowRect(GetDlgItem(hDlg, IDC_RW_UPDATE), &rc);
		m_nChkTop = wiDlg.rcClient.bottom - rc.top;
		m_nMinWidth = rc.right - rc.left;
		GetWindowRect(GetDlgItem(hDlg, IDC_RW_UPDCYCLE), &rc);
		m_nMinWidth += rc.right - rc.left;
		GetWindowRect(GetDlgItem(hDlg, IDC_RW_HIDEPARENT), &rc);
		m_nMinWidth += rc.right - rc.left;
		m_nMinWidth += 3 * m_nLeft;
		m_nMinHeight = (nHeight >> 1) + 2 * m_nTop + m_nChkTop;
		SetWinTitle(hDlg, IDS_VIEWTITLE);
		return TRUE;
	case WM_CLOSE:
		wParam = IDCANCEL;
	case WM_COMMAND:
		nRet = 0;
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDM_VM_DEF:
		case IDM_VM_BIN:
		case IDM_VM_HEX:
		case IDM_VM_DEC:
		case IDM_VM_UDEC:
		case IDM_VM_CHAR:
		case IDM_VM_REAL:
		case IDM_VM_TIME:
		case IDM_VM_DT:
			nIdx = FindVarIdx(&nVar);
			nView = nID - IDM_VM_FIRST;
			if (g_VAT.VarInfo[nVar].pView[nIdx] != nView) {
				g_VAT.VarInfo[nVar].pView[nIdx] = nView;
				FillViewList(hDlg, FALSE, TRUE);
			}
			break;
		case IDC_RW_VIEWLIST:
			return TRUE;
		case IDC_RW_UPDCYCLE:
			if (nCmd == CBN_SELCHANGE) {
				nSel = SendDlgItemMessage(hDlg, nID, CB_GETCURSEL, 0, 0);
				m_nUpdate = m_nUpdList[nSel];
			}
			break;
		case IDC_RW_UPDATE:
		case IDC_RW_HIDEPARENT:
			switch (nCmd) {
			case BN_CLICKED:
				if (nID == IDC_RW_UPDATE) {
					m_nTimer = GetTickCount() - m_nUpdate;
					m_bUpdate = !m_bUpdate;
					EnableWindow(GetDlgItem(hDlg, IDC_RW_UPDCYCLE), m_bUpdate);
				}
				else {
					m_bHidden = !m_bHidden;
					ShowWindow(g_hWndMain, m_bHidden ? SW_HIDE : SW_SHOWNORMAL);
				}
				break;
			}
			return TRUE;
		case IDCANCEL:
			DestroyWindow(hDlg);
		}
		return TRUE;
		break;
	case WM_SK_LISTSEL:
		m_nSelelectedValue = lParam;
		return TRUE;
	case WM_GETMINMAXINFO:
		SetMinMaxInfo(hDlg, m_nMinWidth, m_nMinHeight, 0, 0, NULL, NULL, (LPMINMAXINFO) lParam);
		break;
	case WM_SIZE:
		SendMessage(GetDlgItem(hDlg, IDC_STATUSBAR), WM_SIZE, wParam, lParam);
		GetClientRect(hDlg, &rClient);
		nWidth = rClient.right - rClient.left;
		nHeight = rClient.bottom - rClient.top;
		MoveWindow(GetDlgItem(hDlg, IDC_RW_VIEWLIST), m_nLeft, m_nTop, nWidth - 2 * m_nLeft, nHeight - m_nListBtm - m_nTop, FALSE);
		hItem = GetDlgItem(hDlg, IDC_RW_UPDATE);
		GetWindowSize(hItem, &rc);
		MoveWindow(hItem, m_nLeft, nHeight - m_nChkTop, rc.right, rc.bottom, FALSE);
		w = rc.right;
		hItem = GetDlgItem(hDlg, IDC_RW_UPDCYCLE);
		GetWindowSize(hItem, &rc);
		MoveWindow(hItem, m_nLeft + w, nHeight - m_nChkTop, rc.right, rc.bottom, FALSE);
		hItem = GetDlgItem(hDlg, IDC_RW_HIDEPARENT);
		GetWindowSize(hItem, &rc);
		MoveWindow(hItem, nWidth - m_nLeft - rc.right, nHeight - m_nChkTop, rc.right, rc.bottom, FALSE);
		hItem = GetDlgItem(hDlg, IDC_SEPARATOR);
		GetWindowSize(hItem, &rc);
		MoveWindow(hItem, m_nLeft, rClient.bottom - m_nLineTop, nWidth - 2 * m_nTop, rc.bottom, FALSE);
		hItem = GetDlgItem(hDlg, IDCANCEL);
		GetWindowSize(hItem, &rc);
		MoveWindow(hItem, (nWidth - rc.right) >> 1, nHeight - m_nBtnTop, rc.right, rc.bottom, FALSE);
		InvalidateRect(hDlg, &rClient, TRUE);
		break;
	case WM_CONTEXTMENU:
		if (wParam ==  (WPARAM) GetDlgItem(hDlg, IDC_RW_VIEWLIST)) {
			if (lParam == -1) lParam = GetMessagePos();
			SplitInt32((INT32) lParam, &pt.x, &pt.y);
			hBox = GetDlgItem(hDlg, IDC_RW_VIEWLIST);
			nFromPt = LBItemFromPt(hBox, pt, FALSE);
			if (nFromPt >= 0) {
				if (m_nSelelectedValue != nFromPt) {
					m_nSelelectedValue = nFromPt;
					SendDlgItemMessage(hDlg, IDC_RW_VIEWLIST, LB_SETCURSEL, nFromPt, 0);
				}
				nIdx = FindVarIdx(&nVar);
				nSel = FillViewModeList(TRUE, TRUE, nIdx, &g_VAT.VarInfo[nVar], &nViewModeCnt, nViewModeList);
				for (i = 0; i < nViewModeCnt; i++) {
					nMode = (nViewModeList[i] == 0 ? MF_SEPARATOR : 0) | MF_OWNERDRAW;
					if (i == nSel) nMode |= MF_CHECKED;
					nViewModeList[i] |= nMode << 16;
				}
				ShowPopupMenu(hDlg, pt.x, pt.y, NULL, nViewModeCnt, 0, nViewModeList);
			}
		}
		break;
	case WM_MEASUREITEM:
		PopupMenu_Measure(hDlg, lParam);
		break;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if ((wParam >= IDC_SEPARATOR) && (wParam <= IDC_SEPARATOR9)){
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		else {
			PopupMenu_Draw(hDlg, lParam);
		}
		break;
	case WM_DESTROY:
		KillTimer(hDlg, IDC_TIMER);
		LB_UnSelect_Done(hDlg, IDC_RW_VIEWLIST);
		PostQuitMessage(0);
		return TRUE;
	}
	return FALSE;
}
// **********************************************************************************
static UINT32 WINAPI ThreadProc(LPVOID lpVoid) {
LPTIDDATA	pTid;
HWND		hDlg;
BOOL		bErr;
INT32		nRet;

	pTid = _getptd();
#ifdef _DEBUG
	DbgStrPrint("View dialog thread(0x%x) started.\r\n", pTid->nThreadID);
#endif	//	_DEBUG
	hDlg = CreateDialog(g_hInstance, MAKEINTRESOURCE(IDD_VIEWDLG), g_hWndMain, pViewDlg);
	if (hDlg) {
		EnableWindow(g_hWndMain, FALSE);
		pTid->hWnd = hDlg;
		nRet = MessageLoop(&bErr);
		EnableWindow(g_hWndMain, TRUE);
		if (m_bHidden) {
			ShowWindow(g_hWndMain, SW_SHOWNORMAL);
		}
		SetForegroundWindow(g_hWndMain);
	}
	else nRet = -1;
	m_hThread = NULL;
#ifdef _DEBUG
	DbgStrPrint("View dialog thread ended.\r\n");
#endif	//	_DEBUG
	return nRet;
}
// **********************************************************************************
void __stdcall DoView(BOOL bFromWrite, BOOL bUpdate) {

	m_bFromWrite = bFromWrite;
	m_bUpdate = bUpdate;
	m_hThread = SimpleThread(ThreadProc, NULL);
}
