;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* libcmt - _pow_.asm												*
;********************************************************************
.586
.MODEL FLAT, c
option casemap :none
option scoped

include crtplus.inc

extern c	_fltused : dword

.CODE

OPTION PROLOGUE: NONE
OPTION EPILOGUE: NONE

	pow				proc
					fld		qword ptr [esp + 4]				; base
					fld		qword ptr [esp + 12]			; exp
	pow				endp

; st = exp
; st1 = base
	_CIpow			proc
					xor		ecx, ecx
					xor		eax, eax
					call	asmChkTOS
					mov		dx, ax							; dh.0 = sign
					cmp		dl, FXAM_NORM
					jne		@@02
					fld		st
					frndint
					fcom	st(1)
					fnstsw	ax
					test	ah, FPU_AH_ZF
					jz		@@01
					or		dh, 2							; exp is integer
					fidiv	g_nTwo
					fld		st
					frndint
					fcomp
					fnstsw	ax
					test	ah, FPU_AH_ZF
					jnz		@@01
					or		dh, 4							; exp is odd
			@@01:	fstp	st
					jmp		@@03
			@@02:	cmp		dl, FXAM_NAN
					je		@@12
			@@03:	fxch	st(1)
					xor		eax, eax
					call	asmChkTOS
					cmp		al, FXAM_NORM
					jne		@@06
					cmp		dl, FXAM_ZERO
					je		@@10
					cmp		ah, 0
					je		@@04
					test	dh, 2
					jz		@@12
					fchs
					test	dh, 4
					jz		@@04
					inc		cl
			@@04:	cmp		dl, FXAM_NORM
					jne		@@05		
					fyl2x
					jmp		asmExpCommon
			@@05:	test	dh, 1							; neg
					jz		@@11
					jmp		@@09
			@@06:	cmp		al, FXAM_ZERO
					jne		@@07
					cmp		dl, FXAM_ZERO
					je		@@10
					test	dh, 1
					jnz		@@11							; infinity
					jmp		@@09							; 0
			@@07:	cmp		al, FXAM_INF
					jne		@@12
					cmp		dl, FXAM_ZERO					; exp = 0
					je		@@10
					cmp		ah, 0
					je		@@08
					test	dh, 2
					jz		@@12
					test	dh, 4
					jz		@@08
					fchs
			@@08:	test	dh, 1
					jz 		@@14
			@@09:	fldz
					jmp		@@13
			@@10:	fld1
					jmp		@@13
			@@11:	fld		g_fdInfinity
					jmp		@@13
			@@12:	fld		g_fdIndefinite
			@@13:	fstp	st(1)
			@@14:	fstp	st(1)
					ret
	_CIpow			endp

END
