;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* libcmt - _trigh_.asm												*
;********************************************************************
.586
.MODEL FLAT, c
option casemap :none
option scoped

include crtplus.inc

extern c	_fltused : dword

.CODE

OPTION PROLOGUE: NONE
OPTION EPILOGUE: NONE

	sinh			proc
					fld		qword ptr [esp + 4]
	sinh			endp

	_CIsinh			proc
					call	__ExpH
					call	__ExpHCopyInv
					fsubp	st(1), st
					jmp		__ShChRet
	_CIsinh			endp

	cosh			proc
					fld		qword ptr [esp + 4]
	cosh			endp

	_CIcosh			proc
					call	__ExpH
					call	__ExpHSum
					jmp		__ShChRet
	_CIcosh			endp

	tanh			proc
					fld		qword ptr [esp + 4]
	tanh			endp

	_CItanh			proc
					call	__ExpH
					fld		st
					call	__ExpHSum
					fxch	st(1)
					call	__ExpHCopyInv
					fsubp	st(1), st
					fdivrp	st(1), st
					ret
	_CItanh			endp

	__ShChRet		proc	private
					fld1
					fchs
					fxch	st(1)
					fscale
					fstp	st(1)
					ret
	__ShChRet		endp

	__ExpH			proc	private
					fldl2e
					fmulp	st(1), st
					call	asmExpM1
					xor		edx, edx
					test	ah, 1
					jz		@@1
					call	__ExpHCopyInv
					fxch	st(1)
					fstp	st
			@@1:	test	al, 40h
					jnz		@@2
					not		dh
					fld1
					faddp	st(1), st
					fscale
			@@2:	fstp	st(1)
					ret
	__ExpH			endp

	__ExpHSum		proc	private
					call	__ExpHCopyInv
					faddp	st(1), st
					or		dh, dh
					jnz		@@1
					fld1
					fadd	st(1), st
					faddp	st(1), st
			@@1:	ret
	__ExpHSum		endp


	__ExpHCopyInv	proc	private
					fld		st
					fld1
					or		dh, dh
					jnz		@@1
					fadd	st, st(1)
					fchs
					fxch	st(1)
			@@1:	fdivrp	st(1), st
					ret
	__ExpHCopyInv	endp

END
