;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* libcmt - chandler4.asm											*
;********************************************************************
.586
.MODEL FLAT, C
option casemap :none
option scoped

include crtplus.inc

	EXTERNDEF C		g_nException : DWORD
	EXTERNDEF C		g_nExceptIP : DWORD
	EXTERNDEF C		g_hInstance : DWORD

;OPTION PROLOGUE: PrologueDef 
;OPTION EPILOGUE: EpilogueDef 
OPTION PROLOGUE: NONE
OPTION EPILOGUE: NONE

EXCEPTION_EXECUTE_HANDLER            equ 1
EXCEPTION_CONTINUE_SEARCH            equ 0
EXCEPTION_CONTINUE_EXECUTION         equ -1

MAXIMUM_SUPPORTED_EXTENSION          equ 512
EXCEPTION_MAXIMUM_PARAMETERS         equ 15
SIZE_OF_80387_REGISTERS   equ 80

	EXCEPTION_RECORD			STRUCT
		ExceptionCode			DD		?
		ExceptionFlags			DD		?
		pExceptionRecord		DD		?
		ExceptionAddress		DD		?
		NumberParameters		DD		?
		ExceptionInformation	DD		EXCEPTION_MAXIMUM_PARAMETERS dup(?)
	EXCEPTION_RECORD			ENDS

	FLOATING_SAVE_AREA			STRUCT
		ControlWord				DD		?
		StatusWord				DD		?
		TagWord					DD		?
		ErrorOffset				DD		?
		ErrorSelector			DD		?
		DataOffset				DD		?
		DataSelector			DD		?
		RegisterArea			DB		SIZE_OF_80387_REGISTERS dup(?)
		Cr0NpxState				DD		?
	FLOATING_SAVE_AREA			ENDS

	CONTEXT						STRUCT
		ContextFlags			DD		?
		iDr0					DD		?
		iDr1					DD		?
		iDr2					DD		?
		iDr3					DD		?
		iDr6					DD		?
		iDr7					DD		?
		FloatSave				FLOATING_SAVE_AREA <>
		regGs					DD		?
		regFs					DD		?
		regEs					DD		?
		regDs					DD		?
		regEdi					DD		?
		regEsi					DD		?
		regEbx					DD		?
		regEdx					DD		?
		regEcx					DD		?
		regEax					DD		?
		regEbp					DD		?
		regEip					DD		?
		regCs					DD		?
		regFlag					DD		?
		regEsp					DD		?
		regSs					DD		?
		ExtendedRegisters		DB		MAXIMUM_SUPPORTED_EXTENSION dup(?)
	CONTEXT						ENDS

.DATA
	comm	_pDestructExceptionObject	: DWORD

.CODE

;*********************************************************************
; __fastcall _EH4_TransferToHandler(x, x)
	asmEH4_TransferToHandler	PROC	PRIVATE
								mov		ebp, edx
								mov		esi, ecx
								mov		eax, ecx
								push	1
								call	_NLG_Notify
								xor		eax, eax
								xor		ebx, ebx
								xor		ecx, ecx
								xor		edx, edx
								xor		edi, edi
								jmp		esi
	asmEH4_TransferToHandler	ENDP
;*********************************************************************
; __fastcall _EH4_LocalUnwind(x, x, x, x)
	asmEH4_LocalUnwind			PROC	PRIVATE Param1:DWORD, Param2:DWORD
								push	ebp
		_pushlen				=		4
								mov		ebp, [esp + _pushlen + 4]		; Param1
								push	edx
								push	ecx
		_pushlen				=		12
								push	[esp + _pushlen + 8]			; Param2
								call	_local_unwind4
								add		esp, 12
								pop		ebp
								ret		8
	asmEH4_LocalUnwind			ENDP
;*********************************************************************
; __fastcall _EH4_GlobalUnwind2(x, x)
	asmEH4_GlobalUnwind2		PROC	PRIVATE
								push	ebx
								push	esi
								push	edi
								push	ebp
								push	0
								push	edx
								push	offset @@1
								push	ecx
								call	RtlUnwind
				@@1:			pop		ebp
								pop		edi
								pop		esi
								pop		ebx
								ret
	asmEH4_GlobalUnwind2		ENDP
;*********************************************************************
; __fastcall _EH4_CallFilterFunc(x, x)
	asmEH4_CallFilterFunc		PROC	PRIVATE
								push	ebp
								push	esi
								push	edi
								push	ebx
								mov		ebp, edx
								xor		eax, eax
								xor		ebx, ebx
								xor		edx, edx
								xor		esi, esi
								xor		edi, edi
								call	ecx
								pop		ebx
								pop		edi
								pop		esi
								pop		ebp
								ret
	asmEH4_CallFilterFunc		ENDP
;*********************************************************************
	_ValidateLocalCookies		PROC	PRIVATE
								mov		eax, [edi]
								cmp		eax, -2
								jz		@@1
								mov		ecx, [edi + 4]
								add		ecx, esi
								xor		ecx, [eax + esi]
								call	asmSecCheckCookie
				@@1:			mov		ecx, [edi + 12]
								mov		eax, [edi + 8]
								add		ecx, esi
								xor		ecx, [eax+esi]
								jmp		asmSecCheckCookie
	_ValidateLocalCookies		ENDP
;*********************************************************************
OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
	_except_handler4			PROC	USES EBX ESI EDI, lpException: DWORD, Param2: DWORD,  lpContext: DWORD
	LOCAL Loc01 : BYTE
	LOCAL Loc02 : BYTE
	LOCAL Loc03 : BYTE
	LOCAL Loc04 : BYTE
	LOCAL Loc08 : DWORD
	LOCAL Loc0C : DWORD
	LOCAL Loc10 : DWORD
	LOCAL Loc14 : DWORD
	LOCAL Loc18 : DWORD
								mov		ebx, Param2
								mov		esi, [ebx + 8]
								xor		esi, __security_cookie
								mov		eax, [esi]
								mov		Loc01, 0
								mov		Loc0C, 1
								lea		edi, [ebx + 16]
								cmp		eax, -2
								jz		@@01
								mov		ecx, [esi + 4]
								add		ecx, edi
								xor		ecx, [eax + edi]
								call	asmSecCheckCookie
					@@01:		mov		ecx, [esi + 12]
								mov		eax, [esi + 8]
								add		ecx, edi
								xor		ecx, [eax + edi]
								call	asmSecCheckCookie
								mov		eax, lpException
								test	byte ptr [eax + 4], 066h
								jnz		@@07
								mov		edx, [eax].	EXCEPTION_RECORD.ExceptionCode
								mov		g_nException, edx
								mov		ecx, lpContext
								mov		edx, [ecx].	CONTEXT.regEip
								sub		edx, g_hInstance
								mov		g_nExceptIP, edx
								lea		edx, Loc18
								mov		[ebx - 4], edx
								mov		ebx, [ebx + 12]
								mov		Loc18, eax
								mov		Loc14, ecx
								cmp		ebx, -2
								jz		@@12
								lea		ecx, [ecx + 0]
					@@02:		lea		eax, [ebx + ebx * 2]
								mov		ecx, [esi + eax * 4 + 20]
								lea		eax, [esi + eax * 4 + 16]
								mov		Loc10, eax
								mov		eax, [eax]
								mov		Loc08, eax
								test	ecx, ecx
								jz		@@09
								mov		edx, edi
								call	asmEH4_CallFilterFunc
								mov		Loc01, 1
								test	eax, eax
								jg		@@03
								jns		@@08
								mov		Loc0C, 0
								jmp		@@10
					@@03:		mov		ecx, lpException
								cmp		dword ptr [ecx], 0E06D7363h
								jnz		@@04
								cmp		_pDestructExceptionObject, 0
								jz		@@04
								invoke	_IsNonwritableInCurrentImage, offset _pDestructExceptionObject
								test	eax, eax
								jz		@@04
								mov		edx, lpException
								push	1
								push	edx
								call	_pDestructExceptionObject
								add		esp, 8
					@@04:		mov		ecx, Param2
								mov		edx, lpException
								call	asmEH4_GlobalUnwind2
								mov		eax, Param2
								cmp		[eax + 12], ebx
								jz		@@05
								push	offset __security_cookie
								push	edi
								mov		edx, ebx
								mov		ecx, eax
								call	asmEH4_LocalUnwind
								mov		eax, Param2
					@@05:		mov		ecx, Loc08
								mov		[eax + 12], ecx
								mov		eax, [esi]
								cmp		eax, -2
								jz		@@06
								mov		ecx, [esi + 4]
								add		ecx, edi
								xor		ecx, [eax + edi]
								call	asmSecCheckCookie
					@@06:		mov		ecx, [esi + 12]
								mov		edx, [esi + 8]
								add		ecx, edi
								xor		ecx, [edx + edi]
								call	asmSecCheckCookie
								mov		eax, Loc10
								mov		ecx, [eax + 8]
								mov		edx, edi
								call	asmEH4_TransferToHandler
					@@07:		mov		edx, -2
								cmp		[ebx + 12], edx
								jz		@@12
								push	offset __security_cookie
								push	edi
								mov		ecx, ebx
								call	asmEH4_LocalUnwind
								jmp		@@10
					@@08:		mov		eax, Loc08
					@@09:		mov		ebx, eax
								cmp		eax, -2
								jnz		@@02
								cmp		Loc01, 0
								jz		@@12
					@@10:		mov		eax, [esi]
								cmp		eax, -2
								jz		@@11
								mov		ecx, [esi + 4]
								add		ecx, edi
								xor		ecx, [eax + edi]
								call	asmSecCheckCookie
					@@11:		mov		ecx, [esi + 12]
								mov		edx, [esi + 8]
								add		ecx, edi
								xor		ecx, [edx + edi]
								call	asmSecCheckCookie
					@@12:		mov		eax, Loc0C
								ret
	_except_handler4			ENDP

END
