;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* libcmt - cpufeatures.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

include crtplus.inc

IsProcessorFeaturePresent	PROTO STDCALL, :DWORD

PF_MMX_INSTRUCTIONS_AVAILABLE		equ		3
PF_XMMI_INSTRUCTIONS_AVAILABLE		equ		6					; SSE
PF_AMD3D_INSTRUCTIONS_AVAILABLE		equ		7
PF_XMMI64_INSTRUCTIONS_AVAILABLE	equ		10					; SSE2
PF_SSE3_INSTRUCTIONS_AVAILABLE		equ		13

.CODE
OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE
; EDX of CPUID AX=00000001
	CPUID_FPU			equ		000000001h
	CPUID_TSC			equ		000000010h
	CPUID_CX8			equ		000000100h
	CPUID_CMOV			equ		000008000h
	CPUID_MMX			equ		000800000h
	CPUID_FXSR			equ		001000000h
	CPUID_SSE			equ		002000000h
	CPUID_SSE2			equ		004000000h
; ECX of CPUID AX=00000001
	CPUID_SSE3			equ		000000001h
	CPUID_SSSE3			equ		000000200h
; EDX of CPUID AX=80000001
	CPUID_AMD_3DNOW		equ		080000000h
	CPUID_AMD_3DNOWEXT	equ		040000000h
	CPUID_AMD_MMXEXT	equ		000400000h

;*********************************************************************
;UINT32 __stdcall GetCpuFeatures(BOOL bSystem);
	GetCpuFeatures		PROC	Par1: DWORD
	_arglen				=		4
	_pushlen			=		0
	@@bSystem			equ		dword ptr [esp + _pushlen + 4]
						push	ebx
						push	esi
						push	edi
						xor		esi, esi
						pushfd
						pop		eax
						mov		ecx, eax
						xor		eax, 0200000h
						push	eax
						popfd
						pushfd
						pop		eax
						cmp		eax, ecx
						jz		@@14						; no CPUID --> no MMX
						or		esi, CPUFEAT_CPUID
						mov		eax, 1
						cpuid
						test	edx, CPUID_FPU
						jz		@@01
						or		esi, CPUFEAT_FPU
			@@01:		test	edx, CPUID_TSC
						jz		@@02
						or		esi, CPUFEAT_TSC
			@@02:		test	edx, CPUID_CX8
						jz		@@03
						or		esi, CPUFEAT_CX8
			@@03:		test	edx, CPUID_CMOV
						jz		@@04
						or		esi, CPUFEAT_CMOV
			@@04:		test	edx, CPUID_MMX
						jz		@@05
						or		esi, CPUFEAT_MMX
			@@05:		test	edx, CPUID_FXSR
						jz		@@06
						or		esi, CPUFEAT_FXSR
			@@06:		test	edx, CPUID_SSE
						jz		@@07
						or		esi, CPUFEAT_SSE
			@@07:		test	edx, CPUID_SSE2
						jz		@@08
						or		esi, CPUFEAT_SSE2
			@@08:		test	ecx, CPUID_SSE3
						jz		@@09
						or		esi, CPUFEAT_SSE3
			@@09:		test	ecx, CPUID_SSSE3
						jz		@@10
						or		esi, CPUFEAT_SSSE3
			@@10:		xor		eax, eax
						cpuid
						cmp		ecx, 0444d4163h
						jne		@@14
						or		esi, CPUFEAT_AMD
						mov		eax, 080000000h
						cpuid
						cmp		eax, 080000000h
						jbe		@@14
						mov		eax, 080000001h
						cpuid
			@@11:		test	edx, CPUID_AMD_3DNOW
						jz		@@12
						or		esi, CPUFEAT_3DNOW
			@@12:		test	edx, CPUID_AMD_3DNOWEXT
						jz		@@13
						or		esi, CPUFEAT_3DNOWEXT
			@@13:		test	edx, CPUID_AMD_MMXEXT
						jz		@@14
						or		esi, CPUFEAT_MMXEXT
			@@14:		cmp		@@bSystem, 0
						je		@@17
						lea		ebx, @@OSTable
			@@15:		mov		edi, [ebx]
						test	edi, edi
						jz		@@17
						test	esi, edi
						jz		@@16
						mov		eax, [ebx + 4]
						invoke	IsProcessorFeaturePresent, eax
						and		eax, eax
						jnz		@@16
						not		edi
						and		esi, edi
			@@16:		add		ebx, 8
						jmp		@@15
			@@17:		mov		eax, esi
						pop		edi
						pop		esi
						pop		ebx
						ret		_arglen
			@@OSTable	dd		CPUFEAT_MMX, PF_MMX_INSTRUCTIONS_AVAILABLE
						dd		CPUFEAT_SSE, PF_XMMI_INSTRUCTIONS_AVAILABLE
						dd		CPUFEAT_SSE2, PF_XMMI64_INSTRUCTIONS_AVAILABLE
						dd		CPUFEAT_SSE3 + CPUFEAT_SSSE3, PF_SSE3_INSTRUCTIONS_AVAILABLE
						dd		CPUFEAT_3DNOW + CPUFEAT_3DNOWEXT + CPUFEAT_MMXEXT, PF_AMD3D_INSTRUCTIONS_AVAILABLE
						dd		0
	GetCpuFeatures		ENDP

END
