;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* libcmt - secchk.asm												*
;********************************************************************
.586
.MODEL FLAT, C
option casemap :none
option scoped

include crtplus.inc

;*********************************************************************
.DATA

	__pInconsistency			dd		offset terminate

;*********************************************************************
.xdata$x						SEGMENT	readonly public 'DATA'
	__sehtable_terminate		dd		-2, 0, -40, 0, -2
								dd		offset term_exc1
								dd		offset term_exc2
	__sehtable_inconsistency	dd		-2, 0, -40, 0, -2
								dd		offset _incon_exc1
								dd		offset _incon_exc2
.xdata$x	ends

;*********************************************************************
.CODE

OPTION PROLOGUE: NONE
OPTION EPILOGUE: NONE

;*********************************************************************
;void __cdecl terminate(void);
	terminate			PROC
	_msexc				equ		-24
						push	8
						push	offset __sehtable_terminate
						call	_SEH_prolog4
						call	_getptd
						mov		eax, [eax].TIDDATA.tid_terminate
						test	eax, eax
						jz		@@2
						and		[ebp + _msexc].CPPEH_RECORD.disabled, 0
						call	eax
						jmp		@@1

		term_exc1		LABEL	NEAR
						xor		eax, eax
						inc		eax
						ret

		term_exc2		LABEL	NEAR
						mov		esp, [ebp + _msexc].CPPEH_RECORD.old_esp

		@@1:			mov		[ebp + _msexc].CPPEH_RECORD.disabled, 0FFFFFFFEh
		@@2:			call	abort
						call	_SEH_epilog4
						ret
	terminate			ENDP
;*********************************************************************
; void __cdecl unexpected(void)
	unexpected			PROC
						call	_getptd
						mov		eax, [eax].TIDDATA.tid_unexpected
						test	eax, eax
						jz		@@1
						call	eax
		@@1:			jmp		terminate
	unexpected			ENDP
;*********************************************************************
; void __cdecl _inconsistency(void)
	_inconsistency		PROC
	_msexc				equ		-24
						push	8
						push	offset __sehtable_inconsistency
						call	_SEH_prolog4
						mov		eax, __pInconsistency
						test	eax, eax
						jz		@@2
						and		[ebp + _msexc].CPPEH_RECORD.disabled, 0
						call	eax
						jmp		@@1

		_incon_exc1		LABEL	NEAR
						xor		eax, eax
						inc		eax
						ret

		_incon_exc2		LABEL	NEAR
						mov		esp,  [ebp + _msexc].CPPEH_RECORD.old_esp
		@@1:			mov		[ebp + _msexc].CPPEH_RECORD.disabled, 0FFFFFFFEh
		@@2:			jmp		terminate
	_inconsistency		ENDP

END
