;********************************************************************
;* Copyright (c) 2011-13 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* libcmt - lock.asm												*
;********************************************************************
.586
.MODEL FLAT, C
;option casemap :none   ; set code to case sensitive

include skglobals.inc

EnterCriticalSection	PROTO	STDCALL :DWORD
TryEnterCriticalSection	PROTO	STDCALL :DWORD
LeaveCriticalSection	PROTO	STDCALL :DWORD

.DATA

	RTL_CRITICAL_SECTION		STRUCT
		DebugInfo				DD			?
		LockCount				DD			?
		RecursionCount			DD			?
		OwningThread			DD			?
		LockSemaphore			DD			?
		SpinCount				DD			?
	RTL_CRITICAL_SECTION		ENDS

	_TOTAL_LOCKS				equ			20

	EXTERNDEF C		m_LockTable : RTL_CRITICAL_SECTION

.CODE
OPTION PROLOGUE: NONE
OPTION EPILOGUE: NONE

;*********************************************************************
;void __cdecl _lock(INT32 LockNum);
	LockThread			PROC	nPar1 :DWORD
	LockThread			ENDP
	_lock				PROC	nPar1 :DWORD
	_arglen				=		4
	@@Lock				equ		dword ptr [esp + 4]

						mov		eax, @@Lock
						cmp		eax, _TOTAL_LOCKS
						jae		@@1
						imul	eax, eax, SIZEOF RTL_CRITICAL_SECTION
						lea		eax, m_LockTable[eax]
						invoke	EnterCriticalSection, eax
			@@1:		ret
	_lock				ENDP
;*********************************************************************
;BOOL __cdecl TryLockThread(INT32 LockNum);
	TryLockThread		PROC	nPar1 :DWORD
	_arglen				=		4
	@@Lock				equ		dword ptr [esp + 4]

						mov		eax, @@Lock
						cmp		eax, _TOTAL_LOCKS
						jb		@@1
						xor		eax, eax
						jmp		@@2
			@@1:		imul	eax, eax, SIZEOF RTL_CRITICAL_SECTION
						lea		eax, m_LockTable[eax]
						invoke	TryEnterCriticalSection, eax
						test	eax, eax
						jz		@@2
						mov		eax, TRUE
			@@2:		ret
	TryLockThread		ENDP
;*********************************************************************
;void __cdecl _unlock(INT32 LockNum);
	UnLockThread		PROC	nPar1 :DWORD
	UnLockThread		ENDP
	_unlock				PROC	nPar1 :DWORD
	_arglen				=		4
	@@Lock				equ		dword ptr [esp + 4]

						mov		eax, @@Lock
						cmp		eax, _TOTAL_LOCKS
						jae		@@1
						imul	eax, eax, SIZEOF RTL_CRITICAL_SECTION
						lea		eax, m_LockTable[eax]
						invoke	LeaveCriticalSection, eax
			@@1:		ret
	_unlock				ENDP
;*********************************************************************
;LPCRITICAL_SECTION __cdecl GetCriticalSection(INT32 nLockID);
	GetCriticalSection	PROC	nPar1 :DWORD
	_arglen				=		4
	@@Lock				equ		dword ptr [esp + 4]

						xor		eax, eax
						mov		edx, @@Lock
						cmp		edx, _TOTAL_LOCKS
						jae		@@1
						imul	eax, edx, SIZEOF RTL_CRITICAL_SECTION
						lea		eax, m_LockTable[eax]
			@@1:		ret
	GetCriticalSection	ENDP

END
