;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* libcmt - memmove.asm												*
;********************************************************************
.586
.MODEL FLAT, C
option casemap :none
option scoped

.CODE

OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

;*********************************************************************
	memmove			PROC	USES esi edi, lpDst:DWORD, lpSrc:DWORD, nSize:DWORD
	memmove			ENDP
;*********************************************************************
;void __cdecl MemMove(LPVOID lpDst, LPVOID lpSrc, INT32 nSize);
	MemMove			PROC	USES esi edi, lpDst:DWORD, lpSrc:DWORD, nSize:DWORD
	_pushlen		equ		8
					push	esi
					push	edi
					mov		ecx, [esp + _pushlen + 12]			; nSize
					mov		eax, ecx
					mov		edi, [esp + _pushlen + 4]			; lpDst
					and		edi, edi
					jz		@@3
					mov		esi, [esp + _pushlen + 8]			; lpSrc
					and		esi, esi
					jz		@@3
					cmp		esi, edi
					jae		@@2
					add		esi, ecx
					cmp		esi, edi
					ja		@@1
					sub		esi, ecx
					jmp		@@2
		@@1:		add		edi, ecx
					std
					dec		esi
					dec		edi
					and		ecx, 3
					rep		movsb
					mov		ecx, eax
					sub		esi, 3
					sub		edi, 3
					shr		ecx, 2
					rep		movsd
					cld
					jmp		@@3
		@@2:		shr		ecx, 2
					rep		movsd
					mov		ecx, eax
					and		ecx, 3
					rep		movsb
		@@3:		mov		eax, [esp + _pushlen + 4]			; lpDst
					pop		edi
					pop		esi
					ret
	MemMove			ENDP

END
