/* ymath.h internal header */
#pragma once
#ifndef _YMATH
#define _YMATH
#ifndef RC_INVOKED
#include "yvals.h"
_C_STD_BEGIN
_C_LIB_DECL

#pragma pack(push, _CRT_PACKING)

		/* MACROS FOR _Dtest RETURN (0 => ZERO) */
#define _DENORM		(-2)	/* C9X only */
#define _FINITE		(-1)
#define _INFCODE	1
#define _NANCODE	2

		/* MACROS FOR _Feraise ARGUMENT */
#define _FE_DIVBYZERO	0x04
#define _FE_INEXACT	0x20
#define _FE_INVALID	0x01
#define _FE_OVERFLOW	0x08
#define _FE_UNDERFLOW	0x10

		/* TYPE DEFINITIONS */
typedef union
	{	/* pun float types as integer array */
	unsigned short _Word[8];
	float _Float;
	double _Double;
	long double _Long_double;
	} _Dconst;

		/* ERROR REPORTING */
void __cdecl _Feraise(int);

		/* double DECLARATIONS */
double __cdecl _Cosh(double, double);
short __cdecl _Dtest(double *);
short __cdecl _Exp(double *, double, short);
double __cdecl _Sinh(double, double);
extern /* const */ _Dconst _Denorm, _Hugeval, _Inf,
	_Nan, _Snan;

		/* float DECLARATIONS */
float __cdecl _FCosh(float, float);
short __cdecl _FDtest(float *);
short __cdecl _FExp(float *, float, short);
float __cdecl _FSinh(float, float);
extern /* const */ _Dconst _FDenorm, _FInf, _FNan, _FSnan;

		/* long double DECLARATIONS */
long double __cdecl _LCosh(long double, long double);
short __cdecl _LDtest(long double *);
short __cdecl _LExp(long double *, long double, short);
long double __cdecl _LSinh(long double, long double);
extern /* const */ _Dconst _LDenorm, _LInf, _LNan, _LSnan;

_END_C_LIB_DECL

#pragma pack(pop)
_C_STD_END
#endif /* RC_INVOKED */
#endif /* _YMATH */

/*
 * Copyright (c) 1992-2009 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V5.20:0009 */
