/***
*cruntime.h - definitions specific to the target operating system and hardware
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       This header file contains widely used definitions specific to the
*       host operating system and hardware. It is included by every C source
*       and most every other header file.
*
*       [Internal]
*
****/

#pragma once

#ifndef _INC_CRUNTIME
#define _INC_CRUNTIME

#ifndef _CRTBLD
/*
 * This is an internal C runtime header file. It is used when building
 * the C runtimes only. It is not to be used as a public header file.
 */
#error ERROR: Use of C runtime library internal header file.
#endif  /* _CRTBLD */

#if !defined (UNALIGNED)
#define UNALIGNED
#endif  /* !defined (UNALIGNED) */

#define REG1    register
#define REG2    register
#define REG3    register
#define REG4
#define REG5
#define REG6
#define REG7
#define REG8
#define REG9

/*
 * Are the macro definitions below still needed in this file?
 */

#endif  /* _INC_CRUNTIME */
