/***
*eh.h - User include file for exception handling.
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       User include file for exception handling.
*
*       [Public]
*
****/

#pragma once

#ifndef _INC_EH
#define _INC_EH
#ifndef RC_INVOKED
#ifndef _CRTBLD
/* This version of the header files is NOT for user programs.
 * It is intended for use when building the C runtimes ONLY.
 * The version intended for public use will not have this message.
 */
#error ERROR: Use of C runtime library internal header file.
#endif  /* _CRTBLD */

/* Currently, all MS C compilers for Win32 platforms default to 8 byte
 * alignment.
 */
#pragma pack(push,_CRT_PACKING)

#ifndef __cplusplus
#error "eh.h is only for C++!"
#endif  /* __cplusplus */

/* terminate_handler is the standard name; terminate_function is supported for historical reasons */
typedef void (__cdecl *terminate_function)();
typedef void (__cdecl *terminate_handler)();
typedef void (__cdecl *unexpected_function)();
typedef void (__cdecl *unexpected_handler)();

struct _EXCEPTION_POINTERS;
typedef void (__cdecl *_se_translator_function)(unsigned int, struct _EXCEPTION_POINTERS*);

__declspec(noreturn) void __cdecl terminate(void);
void __cdecl unexpected(void);

int __cdecl _is_exception_typeof(_In_ const type_info &_Type, _In_ struct _EXCEPTION_POINTERS * _ExceptionPtr);

/* only __clrcall versions provided by the MRT exist in pure */
terminate_function __cdecl set_terminate(_In_opt_ terminate_function _NewPtFunc);
extern "C" terminate_function __cdecl _get_terminate(void);
unexpected_function __cdecl set_unexpected(_In_opt_ unexpected_function _NewPtFunc);
extern "C" unexpected_function __cdecl _get_unexpected(void);

_se_translator_function __cdecl _set_se_translator(_In_opt_ _se_translator_function _NewPtFunc);
bool __cdecl __uncaught_exception();

#pragma pack(pop)
#endif  /* RC_INVOKED */
#endif  /* _INC_EH */
