#ifndef _INC_LIBCMT
#define _INC_LIBCMT

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

//	Define the number of supported handles and streams. The definitions
//	here must exactly match those in internal.h (for _NHANDLE_) and stdio.h (for _NSTREAM_).

#define _IOB_ENTRIES		3

//	Lock symbols

#define _EXIT_LOCK			0											// lock for exit code
#define _IOB_SCAN_LOCK		1											// _iob[] table lock
#define _CONIO_LOCK			2											// lock for conio routines
#define _UNDNAME_LOCK		3											// lock for unDName() routine
#define _TIME_LOCK			4											// lock for time functions
#define _ENV_LOCK			5											// lock for environment variables
#define _LOCKTAB_LOCK		6											// lock to protect semaphore lock table
#define _OSFHND_LOCK		7											// lock to protect _osfhnd array
#define _SETLOCALE_LOCK		8											// lock for locale handles, etc.
#define _TYPEINFO_LOCK		9											// lock for type_info access
#define _DEBUG_LOCK			10											// lock for debug global structs
//#define _IO_LOCK			11
//#define _COM_LOCK			12
//#define _SKDP_LOCK		13
//#define _USER_LOCK		14
//#define _USER_LOCK0		(_USER_LOCK + 0)
//#define _USER_LOCK1		(_USER_LOCK + 1)
//#define _USER_LOCK2		(_USER_LOCK + 2)
//#define _FILE_LOCK		17
//#define _FILE_LOCK0		(_FILE_LOCK + 0)
//#define _FILE_LOCK1		(_FILE_LOCK + 1)
//#define _FILE_LOCK2		(_FILE_LOCK + 2)
#define _STREAM_LOCKS		17											// Table of stream locks
#define _LAST_STREAM_LOCK	(_STREAM_LOCKS + _IOB_ENTRIES - 1)			// Last stream lock

#define _TOTAL_LOCKS        (_LAST_STREAM_LOCK + 1)

#define _lock_fh(fh)            __lock_fhandle(fh)
#define _lock_str(s)            _lock_file(s)
#define _lock_str2(i,s)         _lock_file2(i,s)
#define _unlock_fh(fh)          _unlock_fhandle(fh)
#define _unlock_str(s)          _unlock_file(s)
#define _unlock_str2(i,s)       _unlock_file2(i,s)

void __cdecl _lock(_In_ int _File);
void __cdecl _lock_file2(_In_ int _Index, _Inout_ void * _File);
void __cdecl _unlock(_Inout_ int _File);
void __cdecl _unlock_file2(_In_ int _Index, _Inout_ void * _File);

void __cdecl _freeptd(_Inout_opt_ LPTIDDATA _Ptd);			// free up a per-thread CRT data block

// Define function types used in several startup sources

typedef void (__cdecl *_PVFV)(void);
typedef int  (__cdecl *_PIFV)(void);
typedef void (__cdecl *_PVFI)(int);
typedef _PVFV		*LP_PVFV;

extern UINT32		g_nTlsIndex;

int __cdecl _InitTerm_I(_PIFV *pfbegin, _PIFV *pfend);
void __cdecl _InitTerm_V(_PVFV *pfbegin, _PVFV *pfend);

void __cdecl _crtInitProgNameA();
void __cdecl _crtInitProgNameW();
LPSTR __cdecl _crtGetCmdLineA();
LPWSTR __cdecl _crtGetCmdLineW();
void __cdecl _crtExeInit();
int __cdecl _crtCommonInit(int nAppType);
int __cdecl _crtCommonTerm(BOOL bTermProcess);
LONG WINAPI _crtUnhandledExceptionFilter(PEXCEPTION_POINTERS ExceptionInfo);
int __cdecl __crtInitCritSect(PCRITICAL_SECTION lpCriticalSection);

// Security check initialization and failure reporting used by /GS security checks.
void __cdecl __security_init_cookie(void);
__declspec(noreturn) void __cdecl __report_gsfailure(void);
extern uintptr_t __security_cookie;
void __cdecl _call_reportfault(int nDbgHookCode, DWORD dwExceptionCode, DWORD dwExceptionFlags);

#ifdef __cplusplus
}
#endif	// __cplusplus

#endif	// _INC_LIBCMT
