/***
*malloc.h - declarations and definitions for memory allocation functions
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       Contains the function declarations for memory allocation functions;
*       also defines manifest constants and types used by the heap routines.
*       [System V]
*
*       [Public]
*
****/

#pragma once

#ifndef _INC_MALLOC
#define _INC_MALLOC

//	Currently, all MS C compilers for Win32 platforms default to 8 byte alignment.
#pragma pack(push,_CRT_PACKING)

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* Maximum heap request the heap manager will attempt */

#define _HEAP_MAXREQ    0xFFFFFFE0

/* _STATIC_ASSERT is for enforcing boolean/integral conditions at compile time. */

#ifndef _STATIC_ASSERT
#define _STATIC_ASSERT(expr) typedef char __static_assert_t[ (expr) ]
#endif  /* _STATIC_ASSERT */

// Function prototypes

#ifndef _CRT_ALLOCATION_DEFINED
#define _CRT_ALLOCATION_DEFINED
_Check_return_ _Ret_opt_bytecap_x_(_Count*_Size) _CRT_JIT_INTRINSIC _CRTNOALIAS _CRTRESTRICT    void * __cdecl calloc(_In_ size_t _Count, _In_ size_t _Size);
_CRTNOALIAS                                                                             void   __cdecl free(_Post_ptr_invalid_ void * _Memory);
_Check_return_ _Ret_opt_bytecap_(_Size) _CRT_JIT_INTRINSIC _CRTNOALIAS _CRTRESTRICT                              void * __cdecl malloc(_In_ size_t _Size);
_Success_(return!=0)
_Check_return_ _Ret_opt_bytecap_(_NewSize) _CRTNOALIAS _CRTRESTRICT                           void * __cdecl realloc(_Post_ptr_invalid_ void * _Memory, _In_ size_t _NewSize);
_Success_(return!=0)
_Check_return_ _Ret_opt_bytecap_x_(_Count*_Size) _CRTNOALIAS _CRTRESTRICT                       void * __cdecl _recalloc(_Post_ptr_invalid_ void * _Memory, _In_ size_t _Count, _In_ size_t _Size);
#endif  /* _CRT_ALLOCATION_DEFINED */

int     __cdecl _resetstkoflw (void);

_Check_return_ _Ret_opt_bytecap_(_NewSize) void *  __cdecl _expand(_Pre_notnull_ void * _Memory, _In_ size_t _NewSize);
_Check_return_ size_t  __cdecl _msize(_Pre_notnull_ void * _Memory);

_Ret_bytecap_(_Size) void *          __cdecl _alloca(_In_ size_t _Size);

#define _ALLOCA_S_HEAP_MARKER   0xDDDD

#define _ALLOCA_S_MARKER_SIZE   8

_STATIC_ASSERT(sizeof(unsigned int) <= _ALLOCA_S_MARKER_SIZE);

#if !__STDC__
/* Non-ANSI names for compatibility */
#define alloca  _alloca
#endif  /* !__STDC__ */




#ifdef __cplusplus
}
#endif  /* __cplusplus */

#pragma pack(pop)

#endif  /* _INC_MALLOC */
