
/***
*new.h - declarations and definitions for C++ memory allocation functions
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       Contains the declarations for C++ memory allocation functions.
*
*       [Public]
*
****/

#pragma once

#ifndef _INC_NEW
#define _INC_NEW

#ifdef __cplusplus

#ifndef _MSC_EXTENSIONS
#include "new"
#endif  /* _MSC_EXTENSIONS */

/* Protect against #define of new */
#pragma push_macro("new")
#undef  new

#ifndef __NOTHROW_T_DEFINED
#define __NOTHROW_T_DEFINED
namespace std {
        /* placement new tag type to suppress exceptions */
        struct nothrow_t {};

        /* constant for placement new tag */
        extern const nothrow_t nothrow;
};

_Ret_opt_bytecap_(_Size) void *__cdecl operator new(size_t _Size, const std::nothrow_t&) throw();
_Ret_opt_bytecap_(_Size) void *__cdecl operator new[](size_t _Size, const std::nothrow_t&) throw();
void __cdecl operator delete(void *, const std::nothrow_t&) throw();
void __cdecl operator delete[](void *, const std::nothrow_t&) throw();
#endif  /* __NOTHROW_T_DEFINED */

#ifndef __PLACEMENT_NEW_INLINE
#define __PLACEMENT_NEW_INLINE
inline void *__cdecl operator new(size_t, void *_Where)
        {return (_Where); }
inline void __cdecl operator delete(void *, void *)
        {return; }
#endif  /* __PLACEMENT_NEW_INLINE */


/*
 * Microsoft extension:
 *
 * _NO_ANSI_NEW_HANDLER de-activates the ANSI new_handler. Use this special value
 * to support old style (_set_new_handler) behavior.
 */

#pragma pop_macro("new")

#endif  /* __cplusplus */

#endif  /* _INC_NEW */
