/***
*time.h - definitions/declarations for time routines
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       This file has declarations of time routines and defines
*       the structure returned by the localtime and gmtime routines and
*       used by asctime.
*       [ANSI/System V]
*
*       [Public]
*
****/

#pragma once

#ifndef _INC_TIME
#define _INC_TIME

#if !defined (_WIN32)
#error ERROR: Only Win32 target supported!
#endif  /* !defined (_WIN32) */

#ifndef _CRTBLD
/* This version of the header files is NOT for user programs.
 * It is intended for use when building the C runtimes ONLY.
 * The version intended for public use will not have this message.
 */
#error ERROR: Use of C runtime library internal header file.
#endif  /* _CRTBLD */

/*
 * Currently, all MS C compilers for Win32 platforms default to 8 byte
 * alignment.
 */
#pragma pack(push,_CRT_PACKING)

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#ifndef _INTERNAL_IFSTRIP_
#include "cruntime.h"
#endif  /* _INTERNAL_IFSTRIP_ */

/* Define _CRTIMP */

#ifndef _CRTIMP
#define _CRTIMP
#endif  /* _CRTIMP */

#ifndef _WCHAR_T_DEFINED
typedef unsigned short wchar_t;
#define _WCHAR_T_DEFINED
#endif  /* _WCHAR_T_DEFINED */

#ifndef _TIME32_T_DEFINED
typedef long __time32_t;   /* 32-bit time value */
#define _TIME32_T_DEFINED
#endif  /* _TIME32_T_DEFINED */

#ifndef _TIME64_T_DEFINED
typedef __int64 __time64_t;     /* 64-bit time value */
#define _TIME64_T_DEFINED
#endif  /* _TIME64_T_DEFINED */

#ifndef _TIME_T_DEFINED
#ifdef _USE_32BIT_TIME_T
typedef __time32_t time_t;      /* time value */
#else  /* _USE_32BIT_TIME_T */
typedef __time64_t time_t;      /* time value */
#endif  /* _USE_32BIT_TIME_T */
#define _TIME_T_DEFINED         /* avoid multiple def's of time_t */
#endif  /* _TIME_T_DEFINED */

#ifndef _CLOCK_T_DEFINED
typedef long clock_t;
#define _CLOCK_T_DEFINED
#endif  /* _CLOCK_T_DEFINED */

#ifndef _SIZE_T_DEFINED
typedef unsigned int   size_t;
#define _SIZE_T_DEFINED
#endif  /* _SIZE_T_DEFINED */

/* Define NULL pointer value */
#ifndef NULL
#ifdef __cplusplus
#define NULL    0
#else  /* __cplusplus */
#define NULL    ((void *)0)
#endif  /* __cplusplus */
#endif  /* NULL */


#ifndef _TM_DEFINED
struct tm {
        int tm_sec;     /* seconds after the minute - [0,59] */
        int tm_min;     /* minutes after the hour - [0,59] */
        int tm_hour;    /* hours since midnight - [0,23] */
        int tm_mday;    /* day of the month - [1,31] */
        int tm_mon;     /* months since January - [0,11] */
        int tm_year;    /* years since 1900 */
        int tm_wday;    /* days since Sunday - [0,6] */
        int tm_yday;    /* days since January 1 - [0,365] */
        int tm_isdst;   /* daylight savings time flag */
        };
#define _TM_DEFINED
#endif  /* _TM_DEFINED */


/* Clock ticks macro - ANSI version */

#define CLOCKS_PER_SEC  1000


/* Extern declarations for the global variables used by the ctime family of
 * routines.
 */

/* non-zero if daylight savings time is used */
_Check_return_ _CRT_INSECURE_DEPRECATE_GLOBALS(_get_daylight) int* __cdecl __daylight(void);
#define _daylight (*__daylight())

/* offset for Daylight Saving Time */
_Check_return_ _CRT_INSECURE_DEPRECATE_GLOBALS(_get_dstbias) long* __cdecl __dstbias(void);
#define _dstbias (*__dstbias())

/* difference in seconds between GMT and local time */
_Check_return_ _CRT_INSECURE_DEPRECATE_GLOBALS(_get_timezone) long* __cdecl __timezone(void);
#define _timezone (*__timezone())

/* standard/daylight savings time zone names */
_Check_return_ _Deref_ret_z_ _CRT_INSECURE_DEPRECATE_GLOBALS(_get_tzname) char ** __cdecl __tzname(void);
#define _tzname (__tzname())

errno_t __cdecl _get_daylight(_Out_ int * _Daylight);
errno_t __cdecl _get_dstbias(_Out_ long * _Daylight_savings_bias);
errno_t __cdecl _get_timezone(_Out_ long * _Timezone);
errno_t __cdecl _get_tzname(_Out_ size_t *_ReturnValue, _Out_z_cap_(_SizeInBytes) char *_Buffer, _In_ size_t _SizeInBytes, _In_ int _Index);

#ifndef _INTERNAL_IFSTRIP_

_DEFINE_SET_FUNCTION(_set_daylight, int, _daylight)
_DEFINE_SET_FUNCTION(_set_dstbias, long, _dstbias)
_DEFINE_SET_FUNCTION(_set_timezone, long, _timezone)

#endif  /* _INTERNAL_IFSTRIP_ */

/* Function prototypes */

_Check_return_ clock_t __cdecl clock(void);
double __cdecl _difftime32(_In_ __time32_t _Time1, _In_ __time32_t _Time2);


size_t __cdecl strftime(_Out_z_cap_(_SizeInBytes) char * _Buf, _In_ size_t _SizeInBytes, _In_z_ _Printf_format_string_ const char * _Format, _In_ const struct tm * _Tm);
size_t __cdecl _strftime_l(_Pre_notnull_ _Post_z_ char *_Buf, _In_ size_t _Max_size, _In_z_ _Printf_format_string_ const char * _Format, _In_ const struct tm *_Tm, _In_opt_ _locale_t _Locale);

_Check_return_wat_ errno_t __cdecl _strdate_s(_Out_cap_(_SizeInBytes) _Post_count_c_(9) char *_Buf, _In_ size_t _SizeInBytes);
__DEFINE_CPP_OVERLOAD_SECURE_FUNC_0_0(errno_t, _strdate_s, _Deref_post_count_c_(9) char, _Buffer)
__DEFINE_CPP_OVERLOAD_STANDARD_FUNC_0_0(char *, __RETURN_POLICY_DST, _CRTIMP, _strdate, _Out_z_cap_c_(9), char, _Buffer)

_Check_return_wat_ errno_t __cdecl _strtime_s(_Out_cap_(_SizeInBytes) _Post_count_c_(9) char *_Buf , _In_ size_t _SizeInBytes);
__DEFINE_CPP_OVERLOAD_SECURE_FUNC_0_0(errno_t, _strtime_s, _Deref_post_count_c_(9) char, _Buffer)
__DEFINE_CPP_OVERLOAD_STANDARD_FUNC_0_0(char *, __RETURN_POLICY_DST, _CRTIMP, _strtime, _Out_z_cap_c_(9), char, _Buffer)

__time32_t __cdecl _time32(_Out_opt_ __time32_t * _Time);

void __cdecl _tzset(void);

_Check_return_ double __cdecl _difftime64(_In_ __time64_t _Time1, _In_ __time64_t _Time2);

__time64_t __cdecl _time64(_Out_opt_ __time64_t * _Time);

#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif  /* _SIZE_T_DEFINED */

#ifndef _WTIME_DEFINED

/* wide function prototypes, also declared in wchar.h */

size_t __cdecl wcsftime(_Out_z_cap_(_SizeInWords) wchar_t * _Buf, _In_ size_t _SizeInWords, _In_z_ _Printf_format_string_ const wchar_t * _Format,  _In_ const struct tm * _Tm);
size_t __cdecl _wcsftime_l(_Out_z_cap_(_SizeInWords) wchar_t * _Buf, _In_ size_t _SizeInWords, _In_z_ _Printf_format_string_ const wchar_t *_Format, _In_ const struct tm *_Tm, _In_opt_ _locale_t _Locale);

errno_t __cdecl _wstrdate_s(_Out_cap_(_SizeInWords) _Post_count_c_(9) wchar_t * _Buf, _In_ size_t _SizeInWords);
__DEFINE_CPP_OVERLOAD_SECURE_FUNC_0_0(errno_t, _wstrdate_s, _Deref_post_count_c_(9) wchar_t, _Buffer)
__DEFINE_CPP_OVERLOAD_STANDARD_FUNC_0_0(wchar_t *, __RETURN_POLICY_DST, _CRTIMP, _wstrdate, _Out_z_cap_c_(9), wchar_t, _Buffer)

errno_t __cdecl _wstrtime_s(_Out_cap_(_SizeInWords) _Post_count_c_(9) wchar_t * _Buf, _In_ size_t _SizeInWords);
__DEFINE_CPP_OVERLOAD_SECURE_FUNC_0_0(errno_t, _wstrtime_s, _Deref_post_count_c_(9) wchar_t, _Buffer)
__DEFINE_CPP_OVERLOAD_STANDARD_FUNC_0_0(wchar_t *, __RETURN_POLICY_DST, _CRTIMP, _wstrtime, _Out_z_cap_c_(9), wchar_t, _Buffer)

#define _WTIME_DEFINED
#endif  /* _WTIME_DEFINED */

#if !defined (RC_INVOKED) && !defined (__midl)
#ifdef _USE_32BIT_TIME_T
static __inline double __cdecl difftime(time_t _Time1, time_t _Time2)
{
    return _difftime32(_Time1,_Time2);
}
static __inline time_t __cdecl time(time_t * _Time)
{
    return _time32(_Time);
}
#else  /* _USE_32BIT_TIME_T */
static __inline double __cdecl difftime(time_t _Time1, time_t _Time2)
{
    return _difftime64(_Time1,_Time2);
}
static __inline time_t __cdecl time(time_t * _Time)
{
    return _time64(_Time);
}
#endif  /* _USE_32BIT_TIME_T */
#endif  /* !defined (RC_INVOKED) && !defined (__midl) */

#if !__STDC__

/* Non-ANSI names for compatibility */

#define CLK_TCK  CLOCKS_PER_SEC

/*
daylight, timezone, and tzname are not available under /clr:pure.
Please use _daylight, _timezone, and _tzname or
_get_daylight, _get_timezone, and _get_tzname instead.
*/
_CRT_INSECURE_DEPRECATE_GLOBALS(_get_daylight) extern int daylight;
_CRT_INSECURE_DEPRECATE_GLOBALS(_get_timezone) extern long timezone;
_CRT_INSECURE_DEPRECATE_GLOBALS(_get_tzname) extern char * tzname[2];

_CRT_NONSTDC_DEPRECATE(_tzset) void __cdecl tzset(void);

#endif  /* !__STDC__ */


#ifdef __cplusplus
}
#endif  /* __cplusplus */

#pragma pack(pop)

#endif  /* _INC_TIME */
