/* _Stod function */
#include "crtdefs.h"
#define ENABLE_STDLIB_H
#include "crtplus.h"
#include "xmath.h"

_C_STD_BEGIN

#if defined(__cplusplus)
extern "C"
#endif

double __cdecl _Stodx(const char *s, char **endptr, long pten, int *perr)
	{	/* convert string to double */
	int err = errno;
	double x = g_fdZero;

	errno = 0;
	x = strtod(s, endptr);
	*perr = errno;
	errno = err;

	for (; 0 < pten; --pten)
		x *= 10.0;
	for (; pten < 0; ++pten)
		x /= 10.0;
	return (x);
	}

double __cdecl _Stod(const char *s, char **endptr, long pten)
	{	/* convert string, discard error code */
	int err = 0;
	return _Stodx(s, endptr, pten, &err);
	}

_C_STD_END

/*
 * Copyright (c) 1992-2007 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
 V5.03:0009 */
