/***
*_freebuf.c - release a buffer from a stream
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       defines _freebuf() - release a buffer from a stream
*
*******************************************************************************/

#include "crtdefs.h"
#define ENABLE_STDLIB_H
#include "crtplus.h"
#include "libcmt.h"
#include "cruntime.h"
#include "stdio.h"
#include "file2.h"
#include "dbgint.h"
#include "internal.h"

/***
*void _freebuf(stream) - release a buffer from a stream
*
*Purpose:
*       free a buffer if at all possible. free() the space if malloc'd by me.
*       forget about trying to free a user's buffer for him; it may be static
*       memory (not from malloc), so he has to take care of it. this function
*       is not intended for use outside the library.
*
*       Multi-thread notes:
*       _freebuf() does NOT get the stream lock; it is assumed that the
*       caller has already done this.
*
*Entry:
*       FILE *stream - stream to free bufer on
*
*Exit:
*       Buffer may be freed.
*       No return value.
*
*Exceptions:
*
*******************************************************************************/

void __cdecl _freebuf (
        REG1 FILE *stream
        )
{
        _ASSERTE(stream != NULL);

        if (inuse(stream) && mbuf(stream))
        {
                free(stream->_base);

                stream->_flag &= ~(_IOMYBUF | _IOSETVBUF);
                stream->_base = stream->_ptr = NULL;
                stream->_cnt = 0;
        }
}
