/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - crt0.c													*
 * startup routine for control apps (ANSI)							*
 ********************************************************************/
#undef _UNICODE
#undef UNICODE

#include "crtdefs.h"
#define ENABLE_STDLIB_H
#include "crtplus.h"
#include "libcmt.h"

int __cdecl main(int _Argc, char ** _Argv);

// These routines do the C runtime initialization, call the appropriate user entry function, and handle termination cleanup.
// For a managed app, they then return the exit code back to the calling routine, which is the managed startup code.
// For an unmanaged app, they call exit and never return.
// User entry called: main

static int __mainCRTStartup(void);

int mainCRTStartup(void) {
// The /GS security cookie must be initialized before any exception handling targetting the current image is registered.
// No function using exception handling can be called in the current image until after __security_init_cookie has been called.

	__security_init_cookie();
	return __mainCRTStartup();
}

__declspec(noinline) int __mainCRTStartup(void) {
int		nRet;

	g_nCpuFeatures = GetCpuFeatures(TRUE);
	GetWinVersion(&g_sWinVersion);
	_crtInitProgNameA();
	_crtExeInit();
	nRet =_crtCommonInit(APP_CONSOLE);
	if (nRet == 0) {
		__try {
			nRet = main(__argc, __argv);
        }
		__except(EXCEPTION_EXECUTE_HANDLER) {
			nRet = GetExceptionCode();					// Should never reach here
		} // end of try - except
	}
	exit(nRet);
	return nRet;
}
