/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - crt0cmn.c												*
 * common initialize routines										*
 ********************************************************************/
#include "crtdefs.h"
#include "crtplus.h"
#include "libcmt.h"
#include "cruntime.h"
#include "rtcapi.h"
#include "internal.h"
#include "dbgint.h"
#include "sect_attribs.h"

#define FPUROUND_MASK		0x0C00
#define FPUROUND_TRUNC		0x0C00
#define FPUROUND_FLOOR		0x0400
#define FPUROUND_CEIL		0x0800
#define FPUROUND_NEAR		0x0000
#define FPU_EXCEPTMASK		0x007F
#define FPU_PRECISION24		0x0000
#define FPU_PRECISION53		0x0200
#define FPU_PRECISION64		0x0300


_CRTALLOC(".CRT$XIA") _PIFV __xi_a[] = { NULL };
_CRTALLOC(".CRT$XIZ") _PIFV __xi_z[] = { NULL };
_CRTALLOC(".CRT$XCA") _PVFV __xc_a[] = { NULL };
_CRTALLOC(".CRT$XCZ") _PVFV __xc_z[] = { NULL };
_CRTALLOC(".CRT$XPA") _PVFV __xp_a[] = { NULL };
_CRTALLOC(".CRT$XPZ") _PVFV __xp_z[] = { NULL };
_CRTALLOC(".CRT$XTA") _PVFV __xt_a[] = { NULL };
_CRTALLOC(".CRT$XTZ") _PVFV __xt_z[] = { NULL };

_CRTALLOC(".rtc$IAA") _PVFV __rtc_iaa[] = { NULL };
_CRTALLOC(".rtc$IZZ") _PVFV __rtc_izz[] = { NULL };
_CRTALLOC(".rtc$TAA") _PVFV __rtc_taa[] = { NULL };
_CRTALLOC(".rtc$TZZ") _PVFV __rtc_tzz[] = { NULL };

#pragma comment(linker, "/merge:.CRT=.rdata")
#pragma comment(linker, "/defaultlib:kernel32.lib")
#pragma comment(linker, "/disallowlib:msvcrt.lib")
#pragma comment(linker, "/disallowlib:msvcrtd.lib")

#if defined (_DEBUG)
#pragma comment(linker, "/disallowlib:libcmt.lib")
#else 
#pragma comment(linker, "/disallowlib:libcmtd.lib")
#endif	// defined (_DEBUG)

INT32 __stdcall PreMain(INT32 nRTErr);
//*********************************************************************
static void __stdcall DefaultMsgProc(__int32 nCode) {
}

UINT32			g_nAppType			= APP_UNKNOWN;
UINT32			g_nErrorMode		= SEM_FAILCRITICALERRORS | SEM_NOGPFAULTERRORBOX | SEM_NOOPENFILEERRORBOX;
UINT32			g_nCpuFeatures		= 0;
WINVERSION		g_sWinVersion		= {0};
INT32			g_nException		= 0;
INT32			g_nExceptIP			= 0;
HANDLE			g_hCrtHeap			= NULL;
LOCALINFO		g_LocInfo			= {'.', ' ', DF_YMD, 0};
UINT8			g_nNumSepTab[4]		= { 3,  4, 3, 8};
UINT8			g_nBaseNum[4]		= {10, 16, 8, 2};

EXITMSGPROC		g_pExitMsgProc		= DefaultMsgProc;
INT32			_umaskval			= 0;				//	define umask

UINT32			m_bInitialized		= FALSE;
UINT16			g_nDefaultFpuCW		= FPUROUND_NEAR + FPU_PRECISION53 + FPU_EXCEPTMASK;
UINT16			g_nFloorFpuCW		= FPUROUND_FLOOR + FPU_PRECISION53 + FPU_EXCEPTMASK;
UINT16			g_nCeilFpuCW		= FPUROUND_CEIL + FPU_PRECISION53 + FPU_EXCEPTMASK;
UINT16			g_nTruncFpuCW		= FPUROUND_TRUNC + FPU_PRECISION53 + FPU_EXCEPTMASK;

/* argument vector and environment */

/*
 * Pointer to callback function to initialize any dynamically initialized
 * __declspec(thread) variables.  This relies on a subtle aspect of C.
 * The pointer is defined here uninitialized.  It is defined initialized in
 * tlsdyn.c.  If user code uses dynamically initialized __declspec(thread)
 * variables, then compiler-injected dependencies cause tlsdyn.obj to be
 * linked.  In that case, the non-zero definition of __dyn_tls_init_callback
 * in tlsdyn.obj will take precedence, and the startup code will execute the
 * callback.  This use of multiple definitions is only legal in C, not C++.
 */

const PIMAGE_TLS_CALLBACK __dyn_tls_init_callback;

//*********************************************************************
//	If we have any dynamically initialized __declspec(thread) variables, then invoke their initialization for the thread on
//	which the DLL is being loaded, by calling __dyn_tls_init through a callback defined in tlsdyn.obj.  We can't rely on the OS
//	calling __dyn_tls_init with DLL_PROCESS_ATTACH because, on Win2K3 and before, that call happens before the CRT isinitialized.
int __cdecl _crtCommonInit(int nAppType) {
int		nRet;

	g_nAppType = nAppType;
#ifdef _DEBUG
	g_bUseStdIO = TRUE;
#endif	// _DEBUG
	nRet = 0;
	__try {
// initialize heap
		g_hCrtHeap = HeapCreate(0, 4096, 0);
		if (g_hCrtHeap) {
			nRet = _mtinit();
			if (!nRet) {
				m_bInitialized = TRUE;
				_InitTerm_V(__rtc_iaa, __rtc_izz);
				nRet = _InitTerm_I(__xi_a, __xi_z);			// C inicializations
				if (!nRet) {
					_InitTerm_V(__xc_a, __xc_z);			// C++ initializations
					if (__dyn_tls_init_callback && _IsNonwritableInCurrentImage((PBYTE)&__dyn_tls_init_callback)) {
						__dyn_tls_init_callback(NULL, DLL_THREAD_ATTACH, NULL);
					}
				}
			}
		}
		else nRet = _RTERR_HEAPINIT;
	}
    __except (EXCEPTION_EXECUTE_HANDLER) {
		nRet = GetExceptionCode();							// Should never reach here
	} // end of try - except
	nRet = PreMain(nRet);
	return nRet;
}
//*********************************************************************
int __cdecl _crtCommonTerm(BOOL bDestroy) {
int		nRet;

	nRet = 0;
	if (m_bInitialized) {
		_lock(_EXIT_LOCK);					// assure only 1 thread in exit path
		if (!m_bInitialized) return 0;			// another thead called
		__try {
            _InitTerm_V(__xp_a, __xp_z);		//	do pre-terminators
			_InitTerm_V(__xt_a, __xt_z);		//	do terminators
			_InitTerm_V(__rtc_taa, __rtc_tzz);
		}
		__except (EXCEPTION_EXECUTE_HANDLER) {
			nRet = GetExceptionCode();			// Should never reach here
		} // end of try - except
		m_bInitialized = FALSE;
		_unlock(_EXIT_LOCK);					// unlock the exit code path
	}
	if (g_hCrtHeap && bDestroy) {
		_mtterm();
		HeapDestroy(g_hCrtHeap);
		g_hCrtHeap = NULL;
	}
	return nRet;
}
//*********************************************************************
void __cdecl exit(__int32 nCode) {

	g_pExitMsgProc(nCode);
	_crtCommonTerm(TRUE);
	ExitProcess(nCode);
}
