/***
*dbghook.c - Debug CRT Hook Functions
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       Allow users to override default alloc hook at link time.
*
*******************************************************************************/

#include "crtdefs.h"
#include "dbgint.h"

int _debugger_hook_dummy;

__declspec(noinline) void __cdecl _crt_debugger_hook(int _Reserved) {
    /* assign 0 to _debugger_hook_dummy so that the function is not folded in retail */
    (_Reserved);
    _debugger_hook_dummy = 0;
}
