/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - dllcrt0.c												*
 * dll crt initialization											*
 ********************************************************************/
#include "crtdefs.h"
#include "crtplus.h"
#include "libcmt.h"

//	User routine DllMain is called on all notifications
extern BOOL WINAPI DllMain(HANDLE hDllHandle, DWORD dwReason, LPVOID lpreserved);

static BOOL __cdecl _DllStartup(HANDLE hDllHandle, DWORD dwReason, LPVOID lpreserved);

//*********************************************************************
//	C Run-Time initialization for a DLL linked with a C run-time library.
BOOL WINAPI _DllMainCRTStartup(HANDLE  hDllHandle, DWORD dwReason, LPVOID lpreserved) {

	if (dwReason == DLL_PROCESS_ATTACH) __security_init_cookie();
	return _DllStartup(hDllHandle, dwReason, lpreserved);
}
//*********************************************************************
__declspec(noinline) BOOL __cdecl _DllStartup(HANDLE hDllHandle, DWORD dwReason, LPVOID lpreserved) {
LPTIDDATA	ptd;
BOOL		bRet;

	bRet = FALSE;
	if (dwReason == DLL_PROCESS_ATTACH) {
		g_hInstance = g_hResource = (HINSTANCE) hDllHandle;
		g_nCpuFeatures = GetCpuFeatures(TRUE);
		GetWinVersion(&g_sWinVersion);
		if (_crtCommonInit(APP_DLL) == 0) bRet = TRUE;
	}
	else if (dwReason == DLL_THREAD_ATTACH) {
		ptd = GetMem(GMM_CLEAR, sizeof(TIDDATA));
		if (ptd) {
			if (TlsSetValue(g_nTlsIndex, (LPVOID)ptd)) {
				ptd->nThreadID = GetCurrentThreadId();
				ptd->hThread = INVALID_HANDLE_VALUE;
				ptd->LocInfo.nInfo = g_LocInfo.nInfo;
				bRet = TRUE;
			}
			else FreeMem(ptd);
		}
	}
	else  bRet = TRUE;
	if (bRet) bRet = DllMain(hDllHandle, dwReason, lpreserved);
	if (dwReason == DLL_PROCESS_DETACH) {
		_crtCommonTerm(lpreserved == NULL);
	}
	else if (dwReason == DLL_THREAD_DETACH) {
		_freeptd(NULL);						// free up per-thread CRT data
    }
	return bRet;
}
