/***
*invarg.c - stub for invalid argument handler
*
*   Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines _invalidarg() and _set_invalid_parameter_handler()
*
*******************************************************************************/

#include "crtdefs.h"
#include <ntstatus.h>
#define ENABLE_STRING_H
#define ENABLE_STDLIB_H
#define WIN32_NO_STATUS // so it won't fire duplicate macro definition in winnt.h
#include "crtplus.h"
#include "libcmt.h"
#include "cruntime.h"
#include "sect_attribs.h"
#include "internal.h"
#include "dbgint.h"

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

void * _ReturnAddress(void);
#pragma intrinsic(_ReturnAddress)

#if defined (_X86_)
void * _AddressOfReturnAddress(void);
#pragma intrinsic(_AddressOfReturnAddress)
#endif  // defined (_X86_)

// global variable which stores the user handler

static _invalid_parameter_handler __pInvalidArgHandler = NULL;

//	Called when an invalid argument is passed into a CRT function
void __cdecl _invalid_parameter(
    const wchar_t *pszExpression,
    const wchar_t *pszFunction,
    const wchar_t *pszFile,
    unsigned int nLine,
    uintptr_t pReserved
    )
{
    pszExpression;
    pszFunction;
    pszFile;

    if (__pInvalidArgHandler) {
        __pInvalidArgHandler(pszExpression, pszFunction, pszFile, nLine, pReserved);
        return;
    }

    _invoke_watson(pszExpression, pszFunction, pszFile, nLine, pReserved);
}

//***SK #ifndef _DEBUG

//	wrapper which passes no debug info; not available in debug;
//	we don't pass the null params, so we gain some speed and space in code generation
void __cdecl _invalid_parameter_noinfo(void)
{
    _invalid_parameter(NULL, NULL, NULL, 0, 0);
}

//	wrapper which passes no debug info; not available in debug;
//	we don't pass the null params, so we gain some speed and space in code generation; also, we make sure we never return;
//	this is used only in inline code (mainly in the Standard C++ Library and
//	in the SafeInt Library); with __declspec(noreturn) the compiler BE can optimized the codegen even better
__declspec(noreturn) void __cdecl _invalid_parameter_noinfo_noreturn(void)
{
    _invalid_parameter(NULL, NULL, NULL, 0, 0);
    _invoke_watson(NULL, NULL, NULL, 0, 0);
}

//***SK #endif  // _DEBUG

__declspec(noreturn) void __cdecl _invoke_watson(
    const wchar_t *pszExpression,
    const wchar_t *pszFunction,
    const wchar_t *pszFile,
    unsigned int nLine,
    uintptr_t pReserved
    )
{
    (pszExpression);
    (pszFunction);
    (pszFile);
    (nLine);
    (pReserved);

    _call_reportfault(_CRT_DEBUGGER_INVALIDPARAMETER,
                      STATUS_INVALID_CRUNTIME_PARAMETER,
                      EXCEPTION_NONCONTINUABLE);
    TerminateProcess(GetCurrentProcess(), STATUS_INVALID_CRUNTIME_PARAMETER);
}

void __cdecl _call_reportfault(
    int nDbgHookCode,
    DWORD dwExceptionCode,
    DWORD dwExceptionFlags
    )
{
EXCEPTION_RECORD	ExceptionRecord;
CONTEXT				ContextRecord;

    // Notify the debugger if attached.
    if (nDbgHookCode != _CRT_DEBUGGER_IGNORE)
        _crt_debugger_hook(nDbgHookCode);

//	Fake an exception to call reportfault.
    MemClr(&ExceptionRecord, sizeof(EXCEPTION_RECORD));
    EXCEPTION_POINTERS ExceptionPointers = {&ExceptionRecord, &ContextRecord};
    BOOL wasDebuggerPresent = FALSE;
    DWORD ret = 0;

    __asm {
        mov dword ptr [ContextRecord.Eax], eax
        mov dword ptr [ContextRecord.Ecx], ecx
        mov dword ptr [ContextRecord.Edx], edx
        mov dword ptr [ContextRecord.Ebx], ebx
        mov dword ptr [ContextRecord.Esi], esi
        mov dword ptr [ContextRecord.Edi], edi
        mov word ptr [ContextRecord.SegSs], ss
        mov word ptr [ContextRecord.SegCs], cs
        mov word ptr [ContextRecord.SegDs], ds
        mov word ptr [ContextRecord.SegEs], es
        mov word ptr [ContextRecord.SegFs], fs
        mov word ptr [ContextRecord.SegGs], gs
        pushfd
        pop [ContextRecord.EFlags]
    }

    ContextRecord.ContextFlags = CONTEXT_CONTROL;
#pragma warning(push)
#pragma warning(disable:4311)
    ContextRecord.Eip = (ULONG)_ReturnAddress();
    ContextRecord.Esp = (ULONG)_AddressOfReturnAddress();
#pragma warning(pop)
    ContextRecord.Ebp = *((ULONG *)_AddressOfReturnAddress()-1);


    ExceptionRecord.ExceptionCode = dwExceptionCode;
    ExceptionRecord.ExceptionFlags    = dwExceptionFlags;
    ExceptionRecord.ExceptionAddress = _ReturnAddress();


    wasDebuggerPresent = IsDebuggerPresent();

//	Make sure any filter already in place is deleted.
    SetUnhandledExceptionFilter(NULL);

    ret = UnhandledExceptionFilter(&ExceptionPointers);

    // if no handler found and no debugger previously attached
    // the execution must stop into the debugger hook.
    if (ret == EXCEPTION_CONTINUE_SEARCH && !wasDebuggerPresent && nDbgHookCode != _CRT_DEBUGGER_IGNORE) {
        _crt_debugger_hook(nDbgHookCode);
    }
}

//	Establish a handler to be called when a CRT detects a invalid parameter
_invalid_parameter_handler __cdecl _set_invalid_parameter_handler( _invalid_parameter_handler pNew )
{
    _invalid_parameter_handler pOld;

    pOld = __pInvalidArgHandler;

    __pInvalidArgHandler = pNew;

    return pOld;
}

_invalid_parameter_handler __cdecl
_get_invalid_parameter_handler( )
{
    return __pInvalidArgHandler;
}

#ifdef __cplusplus
}
#endif	// __cplusplus
