/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - pesect.c												*
 * query info from a PE image header								*
 ********************************************************************/
#include "crtdefs.h"
#include "crtplus.h"

extern IMAGE_DOS_HEADER __ImageBase;

//********************************************************************
BOOL __cdecl _ValidateImageBase(PBYTE pImageBase) {
PIMAGE_DOS_HEADER		pDOSHeader;
PIMAGE_NT_HEADERS		pNTHeader;

	pDOSHeader = (PIMAGE_DOS_HEADER)pImageBase;
    if (pDOSHeader->e_magic != IMAGE_DOS_SIGNATURE) return FALSE;
    pNTHeader = (PIMAGE_NT_HEADERS) ((PBYTE) pDOSHeader + pDOSHeader->e_lfanew);
    if (pNTHeader->Signature != IMAGE_NT_SIGNATURE) return FALSE;
    return pNTHeader->OptionalHeader.Magic == IMAGE_NT_OPTIONAL_HDR_MAGIC;
}
//********************************************************************
//	Given an RVA (Relative Virtual Address, the offset from the Image Base
//	for a PE image), determine which PE section, if any, includes that RVA.
PIMAGE_SECTION_HEADER __cdecl _FindPESection(PBYTE pImageBase, DWORD_PTR rva) {
PIMAGE_NT_HEADERS		pNTHeader;
PIMAGE_SECTION_HEADER	pSection;
unsigned int			nSection, nMaxSect;

    pNTHeader = (PIMAGE_NT_HEADERS) (pImageBase + ((PIMAGE_DOS_HEADER)pImageBase)->e_lfanew);
	pSection = (PIMAGE_SECTION_HEADER) ((PBYTE)&pNTHeader->OptionalHeader + pNTHeader->FileHeader.SizeOfOptionalHeader);
	nMaxSect = pNTHeader->FileHeader.NumberOfSections;
	for (nSection = 0; nSection < nMaxSect; nSection++, pSection++) {
        if ((rva >= pSection->VirtualAddress) && (rva <  pSection->VirtualAddress + pSection->Misc.VirtualSize)) return pSection;
	}
	return NULL;
}
//********************************************************************
//	Check if an address is located within the current PE image (the one starting at __ImageBase),
//	that it is in a proper section of the image, and that section is not marked writable.
BOOL __cdecl _IsNonwritableInCurrentImage(PBYTE pTarget) {
PBYTE					pImageBase;
DWORD_PTR				rvaTarget;
PIMAGE_SECTION_HEADER	pSection;

	pImageBase = (PBYTE) &__ImageBase;
	if (!_ValidateImageBase(pImageBase)) return FALSE;
	rvaTarget = pTarget - pImageBase;
	pSection = _FindPESection(pImageBase, rvaTarget);
    if (pSection) return (pSection->Characteristics & IMAGE_SCN_MEM_WRITE) == 0;
	else return FALSE;
}
