/***
*putch.c - contains the _putch() routine
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       The routine "_putch()" writes a single character to the console.
*
*       NOTE: In real-mode MS-DOS the character is actually written to standard
*       output, and is therefore redirected when standard output is redirected.
*       However, under Win32 console mode, the character is ALWAYS written
*       to the console, even when standard output has been redirected.
*
*******************************************************************************/

#include "crtdefs.h"
#define ENABLE_STDLIB_H
#include "crtplus.h"
#include "libcmt.h"
#include "internal.h"
#include "cruntime.h"
#include "oscalls.h"
#include "conio.h"
#include "stdio.h"
#include "limits.h"

/*
 * declaration for console handle
 */
extern intptr_t _confh;

/***
*int _putch(c) - write a character to the console
*
*Purpose:
*       Calls WriteConsole to output the character
*       Note: in Win32 console mode always writes to console even
*       when stdout redirected
*
*Entry:
*       c - Character to be output
*
*Exit:
*       If an error is returned from WriteConsole
*           Then returns EOF
*       Otherwise
*           returns character that was output
*
*Exceptions:
*
*******************************************************************************/

/* normal version lock and unlock the console, and then call the _lk version
   which directly accesses the console without locking. */

int __cdecl _putch (
        int c
        )
{
        int ch;

        _lock(_CONIO_LOCK);            /* secure the console lock */
		__try {
            ch = _putch_nolock(c);              /* output the character */
		}
		__finally {
            _unlock(_CONIO_LOCK);          /* release the console lock */
		}

        return ch;
}

/* define version which accesses the console directly - normal version in
   non-_MT situations, special _lk version in _MT */

int __cdecl _putch_nolock(int c) {
// can't use ch directly unless sure we have a big-endian machine
unsigned char ch = (unsigned char)c;
DWORD num_written;

//	_confh, the handle to the console output, is created the first time that either _putch() or _cputs() is called.

	if (_confh == -2) __initconout();
	if (_confh == -1) return EOF;
// write character to console file handle

	if (!WriteConsole((HANDLE) _confh, (LPVOID) &c, 1, &num_written, NULL)) return EOF;		// return error indicator
	return ch;
}
