/***
*rand_s.c - random number generator
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       defines rand_s() - random number generator
*
*******************************************************************************/

#include "crtdefs.h"
#include "crtplus.h"
#include "libcmt.h"
#include "cruntime.h"
#include "stddef.h"
#include "internal.h"

/***
*errno_t rand_s(unsigned int *_RandomValue) - returns a random number
*
*Purpose:
*       returns a random number.
*
*Entry:
*       Non NULL out parameter.
*
*Exit:
*   errno_t - 0 if sucessful
*             error value on failure
*
*       Out parameter -
*             set to random value on success
*             set to 0 on error
*
*Exceptions:
*   Works only in Win2k and above. Will call invalid parameter if RtlGenRandom is not
*   available.
*
*******************************************************************************/

/* Review : Remove following after the define is added to SDK header */
#ifndef RtlGenRandom
#define RtlGenRandom    SystemFunction036
#else  /* RtlGenRandom */
#pragma message ( __FILE__ " : Review comments in this file" )
#endif  /* RtlGenRandom */

#define __TO_STR(x) #x
#define _TO_STR(x)  __TO_STR(x)



typedef BOOL (APIENTRY *PGENRANDOM)( PVOID, ULONG );

static PGENRANDOM g_pfnRtlGenRandom	= NULL;

errno_t __cdecl rand_s(unsigned int *_RandomValue) {
HMODULE		hAdvApi32;


	if (!_RandomValue) return EINVAL;
	*_RandomValue = 0;					// Review : better value to initialize it to?
	if (g_pfnRtlGenRandom == NULL) {
		hAdvApi32 = LoadLibraryW(L"ADVAPI32.DLL");
		if (hAdvApi32) g_pfnRtlGenRandom = (PGENRANDOM) GetProcAddress(hAdvApi32, _TO_STR( RtlGenRandom ));
	}

    if (!(*g_pfnRtlGenRandom)(_RandomValue, sizeof(unsigned int))) return ENOMEM;
    return 0;
}
