/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - stdenvp.c												*
 * common initialize routines										*
 ********************************************************************/
#include "crtdefs.h"
#define ENABLE_STRING_H
#define ENABLE_STDLIB_H
#include "crtplus.h"
#include "libcmt.h"
#include "cruntime.h"
#include "internal.h"
#include "oscalls.h"
#include "tchar.h"
#include "dbgint.h"
#include "sect_attribs.h"

char		**_environ = NULL;

static int __cdecl __EnvInit(void);
#ifdef _DEBUG
static void __cdecl __EnvTerm(void);
#endif	// _DEBUG

_CRTALLOC(".CRT$XIC") static _PIFV _pInit = __EnvInit;
#ifdef _DEBUG
_CRTALLOC(".CRT$XTC") static _PVFV _pTerm = __EnvTerm;
#endif	// _DEBUG

/***
*_setenvp - set up "envp" for C programs
*
*Purpose:
*       Reads the environment and build the envp array for C programs.
*
*Entry:
*       The environment strings occur at _aenvptr.
*       The list of environment strings is terminated by an extra null
*       byte.  Thus two null bytes in a row indicate the end of the
*       last environment string and the end of the environment, resp.
*
*Exit:
*       "environ" points to a null-terminated list of pointers to ASCIZ
*       strings, each of which is of the form "VAR=VALUE".  The strings
*       are copied from the environment area. This array of pointers will
*       be malloc'ed.  The block pointed to by _aenvptr is deallocated.
*
*Uses:
*       Allocates space on the heap for the environment pointers.
*
*Exceptions:
*       If space cannot be allocated, program is terminated.
*
*******************************************************************************/
//*********************************************************************
static int __cdecl __EnvInit(void) {
LPSTR	p, envptr;				// points to environment block
char	**env;				// _environ ptr traversal pointer
int		numstrings;			// number of environment strings
int		i, cchars, nRet;

	nRet = numstrings = 0;
	p = envptr = GetEnvironmentStrings();				// get environ info
//	We called __crtGetEnvironmentStrings[AW] just before this,
//	so if _[aw]envptr is NULL, we failed to get the environment. Return an error.
	if (p == NULL) return _RTERR_SPACEENV;
//	NOTE: starting with single null indicates no environ.
//	Count the number of strings. Skip drive letter settings
//	("=C:=C:\foo" type) by skipping all environment variables that begin with '=' character.

	while (*p != '\0') {
//	don't count "=..." type
		if (*p != '=') ++numstrings;
		p += StrLen(p) + 1;
	}
// need pointer for each string, plus one null ptr at end
	if (_environ = env = GetMem(GMM_CLEAR, (numstrings + 1) * sizeof(LPSTR))) {
//	copy strings to allocated memory and save pointers in _environ
		for (p = envptr; *p != '\0' ; p += cchars) {
			cchars = StrLen(p) + 1;
// don't copy "=..." type
			if (*p != '=') {
				if ((*env = GetMem(GMM_CLEAR, cchars)) == NULL)	{
					nRet = _RTERR_SPACEENV;
					break;
				}
				StrCpy(*env, p);
				env++;
			}
		}
	}
	else nRet = _RTERR_SPACEENV;
	if (nRet && _environ) {
		env = _environ;
		for (i = 0; i < numstrings; i++) {
			FreeMem(*env);
			env++;
		}
		FreeMem(_environ);
		_environ = NULL;
	}
// and a final NULL pointer
	*env = NULL;
	return nRet;
}
//*********************************************************************
#ifdef _DEBUG
static void __cdecl __EnvTerm() {
LPSTR	*pptr;

	if (_environ) {
		for (pptr = _environ; *pptr != NULL; ++pptr) {
			free(*pptr);
		}
		FreeMemEx(&(LPVOID) _environ);
	}
}
#endif	// _DEBUG
