/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - thread.c												*
 ********************************************************************/
#include "crtdefs.h"
#include "crtplus.h"
#include "libcmt.h"

static INT32 m_nThreadCounter		= 0;

static UINT32 WINAPI __ThreadStart(LPTIDDATA ptd);

//*********************************************************************
HANDLE __stdcall ThreadStart(LPTHREAD_START_ROUTINE lpInitCode, LPVOID lpArg, UINT32 nStack, BOOL bSuspended, LPUINT32 lpID) {
LPTIDDATA	ptd;		// pointer to per-thread data
HANDLE		hThread;	// thread handle
UINT32		nID, nFlags, nOwnID, nStart, nDelta;

	ptd = hThread = NULL;
	LockThread(_TIME_LOCK);
	nOwnID = ++m_nThreadCounter;
	UnLockThread(_TIME_LOCK);
	if (g_hWndMain) PostMessage(g_hWndMain, WM_SK_THREADSTART, 0, nOwnID);
	if (lpInitCode) {
		if (ptd = GetMem(GMM_CLEAR, sizeof(TIDDATA))) {
			ptd->nOwnThreadID = nOwnID;
			ptd->_initaddr = lpInitCode;
			ptd->_initarg = lpArg;
			ptd->hThread = INVALID_HANDLE_VALUE;
			ptd->LocInfo.nInfo = g_LocInfo.nInfo;
			if (!lpID) lpID = &nID;
			nFlags = bSuspended ? CREATE_SUSPENDED : 0;
			hThread = CreateThread(NULL, nStack, __ThreadStart, ptd, nFlags, lpID);
		}
	}
	if (hThread) {
		ptd->hThread = hThread;
		if (!bSuspended) {
			nStart = GetTickCount();
			do {
				Sleep(0);
				nDelta = GetTickCount() - nStart;
			} while (!ptd->nThreadID && (nDelta < 200));
		}
	}
	else {
		FreeMem(ptd);
		if (g_hWndMain) PostMessage(g_hWndMain, WM_SK_THREADEXIT, -1, nOwnID);
	}
	return hThread;
}
//*********************************************************************
HANDLE __stdcall SimpleThread(LPTHREAD_START_ROUTINE lpInitCode, LPVOID lpArg) {
UINT32		nID;

	return ThreadStart(lpInitCode, lpArg, 0, FALSE, &nID);
}
//*********************************************************************
static UINT32 WINAPI __ThreadStart(LPTIDDATA ptd) {
INT32		nCode, nOwnID;

	nOwnID = ptd->nOwnThreadID;
	if (TlsSetValue(g_nTlsIndex, ptd)) {
		InitFpu();
		ptd->nThreadID = GetCurrentThreadId();
		__try {
			nCode = ptd->_initaddr(ptd->_initarg);
		}
		__except(EXCEPTION_EXECUTE_HANDLER) {
			nCode = GetExceptionCode();
		}
		_freeptd(ptd);
	}
	else {
		nCode = -(INT32) GetLastError();
		FreeMem(ptd);
	}
	if (g_hWndMain) PostMessage(g_hWndMain, WM_SK_THREADEXIT, nCode, nOwnID);
	ExitThread(nCode);
	return 0;				// Never returns
}
