/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - tidtable.c												*
 ********************************************************************/
#include "crtdefs.h"
#include "crtplus.h"
#include "libcmt.h"
#include <shlobj.h>

#define _CRT_SPINCOUNT				4000

//*********************************************************************
//	Lock Table
CRITICAL_SECTION				m_LockTable[_TOTAL_LOCKS];
//*********************************************************************
UINT32			g_nTlsIndex		= TLS_OUT_OF_INDEXES;
INT32 volatile	g_nCoInitMode	= COINIT_APARTMENTTHREADED;
LPTIDDATA		m_MainPtd		= NULL;
//*********************************************************************
int __cdecl __crtInitCritSect(PCRITICAL_SECTION lpCriticalSection) {
int		nRet;

	if ((g_sWinVersion.Build > 0) && (g_sWinVersion.Major >= 4)) {
		nRet = InitializeCriticalSectionAndSpinCount(lpCriticalSection, _CRT_SPINCOUNT);
	}
	else {
		InitializeCriticalSection(lpCriticalSection);
		nRet = 1;
	}
    return nRet;
}
//*********************************************************************
int __cdecl _mtinit(void) {
INT32		i;

	for (i = 0; i < _TOTAL_LOCKS; i++) {
		if (!__crtInitCritSect(&m_LockTable[i])) return _RTERR_THREAD;
	}
	g_nTlsIndex = TlsAlloc();
	if (g_nTlsIndex == TLS_OUT_OF_INDEXES) return _RTERR_THREAD;
	m_MainPtd = GetMem(GMM_CLEAR, sizeof(TIDDATA));
	if (!m_MainPtd) return _RTERR_THREAD;
	if (!TlsSetValue(g_nTlsIndex, m_MainPtd)) {
		FreeMem(m_MainPtd);
		return _RTERR_THREAD;
	}
	m_MainPtd->nThreadID = GetCurrentProcessId();
	m_MainPtd->hThread = GetCurrentProcess();
	m_MainPtd->LocInfo.nInfo = g_LocInfo.nInfo;
	return 0;
}
//*********************************************************************
void __cdecl _mtterm(void) {
INT32	i;

	if (g_nTlsIndex != TLS_OUT_OF_INDEXES) {
		_freeptd(NULL);
		TlsFree(g_nTlsIndex);
		g_nTlsIndex = TLS_OUT_OF_INDEXES;
	}
	for (i = 0; i < _TOTAL_LOCKS; i++) {
		DeleteCriticalSection(&m_LockTable[i]);
	}
}
//*********************************************************************
LPTIDDATA __cdecl _getptd(void) {
LPTIDDATA	ptd;
UINT32		nLastError;

	nLastError = GetLastError();
	ptd = TlsGetValue(g_nTlsIndex);
	SetLastError(nLastError);
	if (!ptd) {
		if (g_nAppType == APP_DLL) ptd = m_MainPtd;
		else exit(_RTERR_THREAD);							// must exist
	}
	return ptd;
}
//*********************************************************************
void __cdecl _freeptd(LPTIDDATA ptd) {

	if (g_nTlsIndex != TLS_OUT_OF_INDEXES) {
		if (!ptd) ptd = TlsGetValue(g_nTlsIndex);		// if parameter "ptd" is NULL, get the per-thread data pointer
		if (ptd) {
			FreeMem(ptd->_cvtbuf);
			FreeMem(ptd);
		}
		TlsSetValue(g_nTlsIndex, NULL);
	}
}
