/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - wcrt0.c													*
 * startup routine for console apps (UNICODE)						*
 ********************************************************************/
#undef _UNICODE
#undef UNICODE

#define _UNICODE 1
#define UNICODE 1

#include "crtdefs.h"
#define ENABLE_STDLIB_H
#include "crtplus.h"
#include "libcmt.h"

int __cdecl wmain(int _Argc, wchar_t ** _Argv);

// These routines do the C runtime initialization, call the appropriate user entry function, and handle termination cleanup.
// For a managed app, they then return the exit code back to the calling routine, which is the managed startup code.
// For an unmanaged app, they call exit and never return.
// User entry called: wmain

static int __wmainCRTStartup(void);

int wmainCRTStartup(void) {
// The /GS security cookie must be initialized before any exception handling targetting the current image is registered.
// No function using exception handling can be called in the current image until after __security_init_cookie has been called.

	__security_init_cookie();
	return __wmainCRTStartup();
}

__declspec(noinline) int __wmainCRTStartup(void) {
int		nRet;

	g_nCpuFeatures = GetCpuFeatures(TRUE);
	GetWinVersion(&g_sWinVersion);
	_crtInitProgNameW();
	_crtExeInit();
	nRet = _crtCommonInit(APP_CONSOLE);
	if (nRet == 0) {
		__try {
			nRet = wmain(__argc, __wargv);
		}
		__except(EXCEPTION_EXECUTE_HANDLER) {
			nRet = GetExceptionCode();					// Should never reach here
		} // end of try - except
	}
	exit(nRet);
	return nRet;
}
