/********************************************************************
 * Copyright (C) Microsoft Corporation.								*
 * libcmt rewritten by SK											*
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * libcmt - wincrt0.c												*
 * startup routine for Windows apps (ANSI)							*
 ********************************************************************/
#undef _UNICODE
#undef UNICODE

#include "crtdefs.h"
#include "crtplus.h"
#include "libcmt.h"

INT32 __stdcall WinMainX(LPSTR lpCmdLine, INT32 nCmdShow);

extern IMAGE_DOS_HEADER		__ImageBase;

// These routines do the C runtime initialization, call the appropriate user entry function, and handle termination cleanup.
// For a managed app, they then return the exit code back to the calling routine, which is the managed startup code.
// For an unmanaged app, they call exit and never return.
// User entry called: WinMain

static int __WinMainCRTStartup(void);

int WinMainCRTStartup(void) {
// The /GS security cookie must be initialized before any exception handling targetting the current image is registered.
// No function using exception handling can be called in the current image until after __security_init_cookie has been called.

	__security_init_cookie();
	return __WinMainCRTStartup();
}

#ifdef _DEBUG
INT32 ExceptFilter(PEXCEPTION_POINTERS lpExcept) {

	return EXCEPTION_EXECUTE_HANDLER;
}
#endif	// _DEBUG

__declspec(noinline) int __WinMainCRTStartup(void) {
STARTUPINFOW	StartupInfo;
LPSTR			pCmdLine;
int				nRet;

	g_hInstance = g_hResource = (HINSTANCE) &__ImageBase;
	g_nCpuFeatures = GetCpuFeatures(TRUE);
	GetWinVersion(&g_sWinVersion);
	_crtInitProgNameA();
	_crtExeInit();
	nRet = _crtCommonInit(APP_GUI);
	if (nRet == 0) {
		__try {
			GetStartupInfoW(&StartupInfo);
			pCmdLine = _crtGetCmdLineA();
			nRet = WinMainX(pCmdLine, StartupInfo.dwFlags & STARTF_USESHOWWINDOW ? StartupInfo.wShowWindow : SW_SHOWDEFAULT);
		}
#ifdef _DEBUG
		__except(ExceptFilter(GetExceptionInformation())) {
#else	// _DEBUG
		__except(EXCEPTION_EXECUTE_HANDLER) {
#endif	// _DEBUG
			nRet = GetExceptionCode();					// Should never reach here
		} // end of try - except
	}
	exit(nRet);
	return nRet;
}
