####
# makefile.inc - Included makefile for VCRT build process
#
#   Copyright (c) Microsoft Corporation. All rights reserved.
#
#
###############################################################################

# Here is the target for building LIBC{,D} / LIBCMT{,D}.LIB
!if "$(BLD_CPP)"=="YES"
all: \
        $(OBJDIR)\stdcpp.lib
!else
all: \
        $(OBJDIR)\convert.lib \
        $(OBJDIR)\direct.lib \
        $(OBJDIR)\dos.lib \
        $(OBJDIR)\eh.lib \
        $(OBJDIR)\heap.lib \
        $(OBJDIR)\helper.lib \
        $(OBJDIR)\lowio.lib \
        $(OBJDIR)\crtplus.lib \
        $(OBJDIR)\misc.lib \
        $(OBJDIR)\rtc.lib \
        $(OBJDIR)\startup.lib \
        $(OBJDIR)\stdio.lib \
        $(OBJDIR)\string.lib \
        $(OBJDIR)\time.lib \
        $(OBJDIR)\conv.lib \
        $(OBJDIR)\tran.lib
!endif

# Here is the target for building LIBCP{,D} / LIBCPMT{,D}.LIB

CONV_OBJECTS = \
        $(OBJDIR)\_cfin_.obj \
        $(OBJDIR)\_cfout_.obj \
        $(OBJDIR)\_constpow_.obj \
        $(OBJDIR)\_intrncvt_.obj \
        $(OBJDIR)\_mantold_.obj \
        $(OBJDIR)\_strgtold_.obj \
        $(OBJDIR)\_wcfin_.obj \
        $(OBJDIR)\_wstrgtold_.obj \
        $(OBJDIR)\_x10fout_.obj \
        $(OBJDIR)\cvt.obj

EH_OBJECTS = \
        $(OBJDIR)\__CxxExceptionFilter.obj \
		$(OBJDIR)\__CxxFrameHandler.obj \
        $(OBJDIR)\_trnsctrl_.obj \
        $(OBJDIR)\bad_exception.obj \
        $(OBJDIR)\ehprolg2.obj \
        $(OBJDIR)\ehprolg3.obj \
        $(OBJDIR)\ehprolg3a.obj \
        $(OBJDIR)\ehprolog.obj \
        $(OBJDIR)\ehvccctr.obj \
        $(OBJDIR)\ehvcccvb.obj \
        $(OBJDIR)\ehvecctr.obj \
        $(OBJDIR)\ehveccvb.obj \
        $(OBJDIR)\ehvecdtr.obj \
        $(OBJDIR)\ehstrs.obj \
        $(OBJDIR)\frame.obj \
        $(OBJDIR)\hooks.obj \
        $(OBJDIR)\lowhelpr.obj \
        $(OBJDIR)\rtti.obj \
        $(OBJDIR)\stdexcpt.obj \
        $(OBJDIR)\throw.obj \
        $(OBJDIR)\tncleanup.obj \
        $(OBJDIR)\typinfo.obj \
        $(OBJDIR)\typname.obj \
        $(OBJDIR)\undname.obj \
        $(OBJDIR)\unhandld.obj \
        $(OBJDIR)\user.obj \
        $(OBJDIR)\validate.obj

RTC_OBJECTS = \
        $(OBJDIR)\_convert_.obj \
        $(OBJDIR)\_error_.obj \
        $(OBJDIR)\_init_.obj \
        $(OBJDIR)\_initterm_.obj \
        $(OBJDIR)\_pdblkup_.obj \
        $(OBJDIR)\_stack_.obj \
        $(OBJDIR)\_userapi_.obj

TRAN_OBJECTS = \
        $(OBJDIR)\_acos_.obj \
        $(OBJDIR)\_asin_.obj \
        $(OBJDIR)\_atan_.obj \
        $(OBJDIR)\_atan2_.obj \
        $(OBJDIR)\_ceil_.obj \
        $(OBJDIR)\_checkTOS_.obj \
        $(OBJDIR)\_cos_.obj \
        $(OBJDIR)\_exp_.obj \
        $(OBJDIR)\_exp10_.obj \
        $(OBJDIR)\_exp2_.obj \
        $(OBJDIR)\_expm1_.obj \
        $(OBJDIR)\_fabs_.obj \
        $(OBJDIR)\_floor_.obj \
        $(OBJDIR)\_fltxam_.obj \
        $(OBJDIR)\_fmod_.obj \
        $(OBJDIR)\_fpuinit_.obj \
        $(OBJDIR)\_fpupreset_.obj \
        $(OBJDIR)\_fpustate_.obj \
        $(OBJDIR)\_frexp_.obj \
        $(OBJDIR)\_frnd_.obj \
        $(OBJDIR)\_ftol_.obj \
        $(OBJDIR)\_ftrunc_.obj \
        $(OBJDIR)\_ldexp_.obj \
        $(OBJDIR)\_log_.obj \
        $(OBJDIR)\_log10_.obj \
        $(OBJDIR)\_log2_.obj \
        $(OBJDIR)\_modf_.obj \
        $(OBJDIR)\_pow_.obj \
        $(OBJDIR)\_sin_.obj \
        $(OBJDIR)\_sqrt_.obj \
        $(OBJDIR)\_tan_.obj \
        $(OBJDIR)\_trigh_.obj \
        $(OBJDIR)\_xto2_.obj \
        $(OBJDIR)\_xto3_.obj \
        $(OBJDIR)\_xto4_.obj \
        $(OBJDIR)\_xtoy_.obj

CONVERT_OBJECTS = \
        $(OBJDIR)\_fptostr.obj 		\
        $(OBJDIR)\atox.obj     		\
        $(OBJDIR)\swab.obj     		\
        $(OBJDIR)\wchtodig.obj 		\
        $(OBJDIR)\wtox.obj     		\
        $(OBJDIR)\xtoa.obj     		\
        $(OBJDIR)\xtoas.obj    		\
        $(OBJDIR)\xtow.obj     		\
        $(OBJDIR)\xtows.obj    		\
        $(OBJDIR)\_ctype.obj	\
        $(OBJDIR)\_wctype.obj  	\
        $(OBJDIR)\atodbl.obj   	\
        $(OBJDIR)\atof.obj     	\
        $(OBJDIR)\fcvt.obj     	\
        $(OBJDIR)\gcvt.obj     	\
        $(OBJDIR)\iswctype.obj 	\
        $(OBJDIR)\isctype.obj  	\
        $(OBJDIR)\mbstowcs.obj 	\
        $(OBJDIR)\mbtowc.obj   	\
        $(OBJDIR)\mbrtowc.obj  	\
        $(OBJDIR)\strtod.obj   	\
        $(OBJDIR)\strtol.obj   	\
        $(OBJDIR)\strtoq.obj   	\
        $(OBJDIR)\tolower.obj  	\
        $(OBJDIR)\toupper.obj  	\
        $(OBJDIR)\towlower.obj 	\
        $(OBJDIR)\towupper.obj 	\
        $(OBJDIR)\wcrtomb.obj  	\
        $(OBJDIR)\wcstod.obj   	\
        $(OBJDIR)\wcstol.obj   	\
        $(OBJDIR)\wcstoq.obj   	\
        $(OBJDIR)\wcstombs.obj 	\
        $(OBJDIR)\wctomb.obj	\
        $(OBJDIR)\wtof.obj

CRTPLUS_OBJECTS = \
        $(OBJDIR)\cmath_fd1ByPi.obj \
        $(OBJDIR)\cmath_fd1BySqrt2.obj \
        $(OBJDIR)\cmath_fd2ByPi.obj \
        $(OBJDIR)\cmath_fd2BySqrtPi.obj \
        $(OBJDIR)\cmath_fdDblMin.obj \
        $(OBJDIR)\cmath_fdDblMax.obj \
        $(OBJDIR)\cmath_fdE.obj \
        $(OBJDIR)\cmath_fdLdE.obj \
        $(OBJDIR)\cmath_fdIndefinite.obj \
        $(OBJDIR)\cmath_fdInfinity.obj \
        $(OBJDIR)\cmath_fdInfinityM.obj \
        $(OBJDIR)\cmath_fdLn10.obj \
        $(OBJDIR)\cmath_fdLn2.obj \
        $(OBJDIR)\cmath_fdLogE.obj \
        $(OBJDIR)\cmath_fdPi.obj \
        $(OBJDIR)\cmath_fdPiBy2.obj \
        $(OBJDIR)\cmath_fdPiBy4.obj \
        $(OBJDIR)\cmath_fdSqrt2.obj \
        $(OBJDIR)\cmath_fHalf.obj \
        $(OBJDIR)\cmath_fOne.obj \
		$(OBJDIR)\cmath_fxPiBy2To61.obj \
        $(OBJDIR)\cmath_nOne.obj \
        $(OBJDIR)\cmath_nOneM.obj \
        $(OBJDIR)\cmath_nEiht \
        $(OBJDIR)\cmath_nFive \
        $(OBJDIR)\cmath_nFour.obj \
        $(OBJDIR)\cmath_nHundred \
        $(OBJDIR)\cmath_nMillion.obj \
        $(OBJDIR)\cmath_nNine \
        $(OBJDIR)\cmath_nSeven \
        $(OBJDIR)\cmath_nSix \
        $(OBJDIR)\cmath_nTen.obj \
        $(OBJDIR)\cmath_nTenThousand.obj \
        $(OBJDIR)\cmath_nThousand \
        $(OBJDIR)\cmath_nThree.obj \
        $(OBJDIR)\cmath_nTwo.obj \
        $(OBJDIR)\cmath_Zero.obj \
        $(OBJDIR)\cpufeatures.obj \
        $(OBJDIR)\errorflags.obj \
        $(OBJDIR)\memclr.obj \
        $(OBJDIR)\memcpy.obj \
        $(OBJDIR)\memfill8.obj \
        $(OBJDIR)\memmove.obj \
        $(OBJDIR)\memsize.obj \
        $(OBJDIR)\wstrlen.obj \
        $(OBJDIR)\xstrcmp.obj \
        $(OBJDIR)\xstrcpy.obj \
        $(OBJDIR)\xstrcpyn.obj \
        $(OBJDIR)\xstrlen.obj

DIRECT_OBJECTS = \
        $(OBJDIR)\drivemap.obj \
        $(OBJDIR)\drivfree.obj \
        $(OBJDIR)\findfile.obj \
        $(OBJDIR)\findf64.obj  \
        $(OBJDIR)\findfi32.obj \
        $(OBJDIR)\findfi64.obj \
        $(OBJDIR)\enable.obj   \
        $(OBJDIR)\wfindfil.obj \
        $(OBJDIR)\wfndf64.obj  \
        $(OBJDIR)\wfndfi32.obj \
        $(OBJDIR)\wfndfi64.obj

DOS_OBJECTS = \
        $(OBJDIR)\_doserrno.obj \
        $(OBJDIR)\_errno.obj \
        $(OBJDIR)\access.obj   \
        $(OBJDIR)\chmod.obj    \
        $(OBJDIR)\chdir.obj    \
        $(OBJDIR)\dosmap.obj   \
        $(OBJDIR)\drive.obj    \
        $(OBJDIR)\fullpath.obj \
        $(OBJDIR)\getcwd.obj   \
        $(OBJDIR)\mkdir.obj    \
        $(OBJDIR)\rename.obj   \
        $(OBJDIR)\rmdir.obj    \
        $(OBJDIR)\stat.obj     \
        $(OBJDIR)\stat64.obj   \
        $(OBJDIR)\stati32.obj  \
        $(OBJDIR)\stati64.obj  \
        $(OBJDIR)\unlink.obj   \
        $(OBJDIR)\waccess.obj  \
        $(OBJDIR)\wchdir.obj   \
        $(OBJDIR)\wchmod.obj   \
        $(OBJDIR)\wfullpat.obj \
        $(OBJDIR)\wgetcwd.obj  \
        $(OBJDIR)\wmkdir.obj   \
        $(OBJDIR)\wrename.obj  \
        $(OBJDIR)\wrmdir.obj   \
        $(OBJDIR)\wstat.obj    \
        $(OBJDIR)\wstat64.obj  \
        $(OBJDIR)\wstati32.obj \
        $(OBJDIR)\wstati64.obj \
        $(OBJDIR)\wunlink.obj

HEAP_OBJECTS = \
        $(OBJDIR)\_msize.obj \
		$(OBJDIR)\allocatedmemsize \
        $(OBJDIR)\resetstk.obj  \
        $(OBJDIR)\calloc.obj   \
        $(OBJDIR)\malloc.obj   \
        $(OBJDIR)\memalloc.obj \
        $(OBJDIR)\memfree.obj \
        $(OBJDIR)\memfreeex.obj \
        $(OBJDIR)\memmodify.obj \
        $(OBJDIR)\realloc.obj  \
        $(OBJDIR)\nothrow0.obj \
        $(OBJDIR)\delete.obj   \
        $(OBJDIR)\delete2.obj  \
        $(OBJDIR)\new.obj      \
        $(OBJDIR)\nomemoryh.obj \
        $(OBJDIR)\new2.obj     \
        $(OBJDIR)\delaopnt.obj \
        $(OBJDIR)\delopnt.obj  \
        $(OBJDIR)\newaopnt.obj \
        $(OBJDIR)\newopnt.obj

HELPER_OBJECTS = \
        $(OBJDIR)\lldiv.obj    \
        $(OBJDIR)\lldvrm.obj   \
        $(OBJDIR)\llmul.obj    \
        $(OBJDIR)\llrem.obj    \
        $(OBJDIR)\llshl.obj    \
        $(OBJDIR)\llshr.obj    \
        $(OBJDIR)\ulldiv.obj   \
        $(OBJDIR)\ulldvrm.obj  \
        $(OBJDIR)\ullrem.obj   \
        $(OBJDIR)\ullshr.obj   \

LOWIO_OBJECTS = \
        $(OBJDIR)\chsize.obj   \
        $(OBJDIR)\close.obj    \
        $(OBJDIR)\commit.obj   \
        $(OBJDIR)\creat.obj    \
        $(OBJDIR)\dup.obj      \
        $(OBJDIR)\dup2.obj     \
        $(OBJDIR)\eof.obj      \
        $(OBJDIR)\flength.obj  \
        $(OBJDIR)\fleni64.obj  \
        $(OBJDIR)\fstat.obj    \
        $(OBJDIR)\fstat64.obj  \
        $(OBJDIR)\fstati32.obj \
        $(OBJDIR)\fstati64.obj \
        $(OBJDIR)\initcon.obj  \
        $(OBJDIR)\ioinit.obj   \
        $(OBJDIR)\isatty.obj   \
        $(OBJDIR)\locking.obj  \
        $(OBJDIR)\lseek.obj    \
        $(OBJDIR)\lseeki64.obj \
        $(OBJDIR)\mktemp.obj   \
        $(OBJDIR)\open.obj     \
        $(OBJDIR)\openo.obj    \
        $(OBJDIR)\osfinfo.obj  \
        $(OBJDIR)\pipe.obj     \
        $(OBJDIR)\read.obj     \
        $(OBJDIR)\setmode.obj  \
        $(OBJDIR)\tell.obj     \
        $(OBJDIR)\telli64.obj  \
        $(OBJDIR)\txtmode.obj  \
        $(OBJDIR)\write.obj    \
        $(OBJDIR)\cgets.obj    \
        $(OBJDIR)\cgetws.obj   \
        $(OBJDIR)\cputs.obj    \
        $(OBJDIR)\getch.obj    \
        $(OBJDIR)\getwch.obj   \
        $(OBJDIR)\putch.obj    \
        $(OBJDIR)\putwch.obj   \
        $(OBJDIR)\wcreat.obj   \
        $(OBJDIR)\wmktemp.obj  \
        $(OBJDIR)\inp.obj      \
        $(OBJDIR)\outp.obj     \
        $(OBJDIR)\wopen.obj

MISC_OBJECTS = \
        $(OBJDIR)\callcounter.obj\
        $(OBJDIR)\chandler4.obj\
        $(OBJDIR)\chkesp.obj   \
        $(OBJDIR)\eh3valid.obj \
        $(OBJDIR)\exsup.obj    \
        $(OBJDIR)\exsup2.obj   \
        $(OBJDIR)\exsup3.obj   \
        $(OBJDIR)\exsup4.obj   \
        $(OBJDIR)\loadcfg.obj  \
        $(OBJDIR)\longjmp.obj  \
        $(OBJDIR)\longjmpuw4.obj  \
        $(OBJDIR)\nlg.obj  \
        $(OBJDIR)\secchk.obj   \
        $(OBJDIR)\sehprolg.obj \
        $(OBJDIR)\sehprolg4.obj \
        $(OBJDIR)\sehprolg4gs.obj \
        $(OBJDIR)\sehsupp.obj  \
        $(OBJDIR)\calldtor.obj \
        $(OBJDIR)\setjmp.obj   \
        $(OBJDIR)\setjmp3.obj  \
        $(OBJDIR)\setjmpex.obj \
        $(OBJDIR)\a_cmp.obj    \
        $(OBJDIR)\a_loc.obj    \
        $(OBJDIR)\a_map.obj    \
        $(OBJDIR)\a_str.obj    \
        $(OBJDIR)\abort.obj    \
        $(OBJDIR)\abs.obj      \
        $(OBJDIR)\assert.obj   \
        $(OBJDIR)\aw_com.obj   \
        $(OBJDIR)\bsearch.obj  \
        $(OBJDIR)\bsearch_s.obj \
        $(OBJDIR)\bswap.obj    \
        $(OBJDIR)\charmax.obj  \
        $(OBJDIR)\ctype.obj    \
        $(OBJDIR)\div.obj      \
        $(OBJDIR)\dbghook.obj  \
        $(OBJDIR)\dbgrpt.obj   \
        $(OBJDIR)\dbgrptt.obj  \
        $(OBJDIR)\dbgrptw.obj  \
        $(OBJDIR)\getenv.obj   \
        $(OBJDIR)\getpath.obj  \
        $(OBJDIR)\getqloc.obj  \
        $(OBJDIR)\glstatus.obj \
        $(OBJDIR)\gs_cookie.obj \
        $(OBJDIR)\gs_report.obj \
        $(OBJDIR)\initcoll.obj \
        $(OBJDIR)\initctyp.obj \
        $(OBJDIR)\inithelp.obj \
        $(OBJDIR)\initmon.obj  \
        $(OBJDIR)\initnum.obj  \
        $(OBJDIR)\inittime.obj \
        $(OBJDIR)\invarg.obj   \
        $(OBJDIR)\labs.obj     \
        $(OBJDIR)\lcnvinit.obj \
        $(OBJDIR)\lconv.obj    \
        $(OBJDIR)\ldiv.obj     \
        $(OBJDIR)\lfind.obj    \
        $(OBJDIR)\lfind_s.obj  \
        $(OBJDIR)\localref.obj \
        $(OBJDIR)\lsearch.obj  \
        $(OBJDIR)\lsearch_s.obj \
        $(OBJDIR)\makepath.obj \
        $(OBJDIR)\makepath_s.obj \
        $(OBJDIR)\onexit.obj   \
        $(OBJDIR)\nlsdata1.obj \
        $(OBJDIR)\nlsdata2.obj \
        $(OBJDIR)\nlsdata3.obj \
        $(OBJDIR)\perror.obj   \
        $(OBJDIR)\purevirt.obj \
        $(OBJDIR)\putenv.obj   \
        $(OBJDIR)\qsort.obj    \
        $(OBJDIR)\qsort_s.obj  \
        $(OBJDIR)\rand.obj     \
        $(OBJDIR)\rand_s.obj   \
        $(OBJDIR)\rotl.obj     \
        $(OBJDIR)\rotr.obj     \
        $(OBJDIR)\searchen.obj \
        $(OBJDIR)\setenv.obj   \
        $(OBJDIR)\setlocal.obj \
        $(OBJDIR)\splitpat.obj \
        $(OBJDIR)\splitpath_s.obj \
        $(OBJDIR)\syserr.obj   \
        $(OBJDIR)\convrtcp.obj \
        $(OBJDIR)\umask.obj    \
        $(OBJDIR)\w_cmp.obj    \
        $(OBJDIR)\w_loc.obj    \
        $(OBJDIR)\w_map.obj    \
        $(OBJDIR)\w_str.obj    \
        $(OBJDIR)\wassert.obj  \
        $(OBJDIR)\wgetenv.obj  \
        $(OBJDIR)\wgetpath.obj \
        $(OBJDIR)\wmakepat.obj \
        $(OBJDIR)\wmakepath_s.obj \
        $(OBJDIR)\wperror.obj  \
        $(OBJDIR)\wputenv.obj  \
        $(OBJDIR)\wsearche.obj \
        $(OBJDIR)\wsetenv.obj  \
        $(OBJDIR)\wsetloca.obj \
        $(OBJDIR)\wsplitpa.obj \
        $(OBJDIR)\wsplitpath_s.obj \
        $(OBJDIR)\wrt2err.obj

STARTUP_OBJECTS = \
        $(OBJDIR)\_cmovused.obj \
        $(OBJDIR)\_fltused.obj \
        $(OBJDIR)\_mmxused.obj \
        $(OBJDIR)\_sseused.obj \
        $(OBJDIR)\_sse2used.obj \
        $(OBJDIR)\chkstk.obj \
        $(OBJDIR)\crt0.obj \
        $(OBJDIR)\crt0cmn.obj \
        $(OBJDIR)\crt0cmnw.obj \
        $(OBJDIR)\crt0dat.obj \
        $(OBJDIR)\crt0exe.obj \
        $(OBJDIR)\crt0gui.obj \
        $(OBJDIR)\crtcmdlinea.obj \
        $(OBJDIR)\crtcmdlinew.obj \
        $(OBJDIR)\crtprognamea.obj \
        $(OBJDIR)\crtprognamew.obj \
        $(OBJDIR)\dllcrt0.obj \
        $(OBJDIR)\dllmain.obj \
        $(OBJDIR)\pesect.obj \
        $(OBJDIR)\stdargv.obj \
        $(OBJDIR)\stdenvp.obj \
        $(OBJDIR)\thread.obj \
        $(OBJDIR)\tidtable.obj \
        $(OBJDIR)\tlsdtor.obj \
        $(OBJDIR)\tlsdyn.obj \
        $(OBJDIR)\tlssup.obj \
        $(OBJDIR)\wcrt0.obj \
        $(OBJDIR)\wincrt0.obj \
        $(OBJDIR)\wstdargv.obj \
        $(OBJDIR)\wstdenvp.obj \
        $(OBJDIR)\wwincrt0.obj

STDCPP_OBJECTS = \
        $(OBJDIR)\cerr.obj      \
        $(OBJDIR)\cin.obj       \
        $(OBJDIR)\clog.obj      \
        $(OBJDIR)\cout.obj      \
        $(OBJDIR)\fiopen.obj    \
        $(OBJDIR)\iomanip.obj   \
        $(OBJDIR)\ios.obj       \
        $(OBJDIR)\iosptrs.obj   \
        $(OBJDIR)\iostream.obj  \
        $(OBJDIR)\locale.obj    \
        $(OBJDIR)\locale0.obj   \
        $(OBJDIR)\newaop.obj    \
        $(OBJDIR)\nomemory.obj  \
        $(OBJDIR)\nothrow.obj   \
        $(OBJDIR)\raisehan.obj  \
        $(OBJDIR)\stdthrow.obj  \
        $(OBJDIR)\ushcerr.obj   \
        $(OBJDIR)\ushcout.obj   \
        $(OBJDIR)\ushcin.obj    \
        $(OBJDIR)\ushclog.obj   \
        $(OBJDIR)\ushiostr.obj  \
        $(OBJDIR)\uncaught.obj  \
        $(OBJDIR)\wcerr.obj     \
        $(OBJDIR)\wcin.obj      \
        $(OBJDIR)\wclog.obj     \
        $(OBJDIR)\wcout.obj     \
        $(OBJDIR)\wctrans.obj   \
        $(OBJDIR)\wctype.obj    \
        $(OBJDIR)\wiostrea.obj  \
        $(OBJDIR)\wlocale.obj   \
        $(OBJDIR)\xcosh.obj     \
        $(OBJDIR)\xdateord.obj  \
        $(OBJDIR)\xdebug.obj    \
        $(OBJDIR)\xdnorm.obj    \
        $(OBJDIR)\xdscale.obj   \
        $(OBJDIR)\xdtest.obj    \
        $(OBJDIR)\xexp.obj      \
        $(OBJDIR)\xfcosh.obj    \
        $(OBJDIR)\xfdnorm.obj   \
        $(OBJDIR)\xfdscale.obj  \
        $(OBJDIR)\xfdtest.obj   \
        $(OBJDIR)\xferaise.obj  \
        $(OBJDIR)\xfexp.obj     \
        $(OBJDIR)\xfsinh.obj    \
        $(OBJDIR)\xfvalues.obj  \
        $(OBJDIR)\xgetwctype.obj\
        $(OBJDIR)\xlcosh.obj    \
        $(OBJDIR)\xldnorm.obj   \
        $(OBJDIR)\xldscale.obj  \
        $(OBJDIR)\xldtest.obj   \
        $(OBJDIR)\xlexp.obj     \
        $(OBJDIR)\xlocale.obj   \
        $(OBJDIR)\xlock.obj     \
        $(OBJDIR)\xlpoly.obj    \
        $(OBJDIR)\xlsinh.obj    \
        $(OBJDIR)\xlvalues.obj  \
        $(OBJDIR)\xmbtowc.obj   \
        $(OBJDIR)\xmtx.obj      \
        $(OBJDIR)\xmutex.obj    \
        $(OBJDIR)\xpoly.obj     \
        $(OBJDIR)\xsinh.obj     \
        $(OBJDIR)\xstod.obj     \
        $(OBJDIR)\xstof.obj     \
        $(OBJDIR)\xstol.obj     \
        $(OBJDIR)\xstold.obj    \
        $(OBJDIR)\xstoll.obj    \
        $(OBJDIR)\xstoul.obj    \
        $(OBJDIR)\xstoull.obj   \
        $(OBJDIR)\xstrcoll.obj  \
        $(OBJDIR)\xstrxfrm.obj  \
        $(OBJDIR)\xtowlower.obj \
        $(OBJDIR)\xtowupper.obj \
        $(OBJDIR)\xvalues.obj   \
        $(OBJDIR)\xwcscoll.obj  \
        $(OBJDIR)\xwcsxfrm.obj  \
        $(OBJDIR)\xwctomb.obj   \
        $(OBJDIR)\_tolower.obj  \
        $(OBJDIR)\_toupper.obj


STDIO_OBJECTS = \
        $(OBJDIR)\feoferr.obj  \
        $(OBJDIR)\fgetc.obj    \
        $(OBJDIR)\fgetchar.obj \
        $(OBJDIR)\fgets.obj    \
        $(OBJDIR)\fgetwc.obj   \
        $(OBJDIR)\fgetws.obj   \
        $(OBJDIR)\fgetwchr.obj \
        $(OBJDIR)\fileno.obj   \
        $(OBJDIR)\fputc.obj    \
        $(OBJDIR)\fputs.obj    \
        $(OBJDIR)\fputchar.obj \
        $(OBJDIR)\fputwc.obj   \
        $(OBJDIR)\fputws.obj   \
        $(OBJDIR)\fputwchr.obj \
        $(OBJDIR)\_filbuf.obj  \
        $(OBJDIR)\_filwbuf.obj \
        $(OBJDIR)\_file.obj    \
        $(OBJDIR)\_flsbuf.obj  \
        $(OBJDIR)\_flswbuf.obj \
        $(OBJDIR)\_freebuf.obj \
        $(OBJDIR)\_getbuf.obj  \
        $(OBJDIR)\_open.obj    \
        $(OBJDIR)\_sftbuf.obj  \
        $(OBJDIR)\clearerr.obj \
        $(OBJDIR)\closeall.obj \
        $(OBJDIR)\fclose.obj   \
        $(OBJDIR)\fdopen.obj   \
        $(OBJDIR)\fflush.obj   \
        $(OBJDIR)\fgetpos.obj  \
        $(OBJDIR)\fopen.obj    \
        $(OBJDIR)\fprintf.obj  \
        $(OBJDIR)\fread.obj    \
        $(OBJDIR)\freopen.obj  \
        $(OBJDIR)\fscanf.obj   \
        $(OBJDIR)\fseek.obj    \
        $(OBJDIR)\fseeki64.obj \
        $(OBJDIR)\fsetpos.obj  \
        $(OBJDIR)\ftell.obj    \
        $(OBJDIR)\ftelli64.obj \
        $(OBJDIR)\fwprintf.obj \
        $(OBJDIR)\fwrite.obj   \
        $(OBJDIR)\fwscanf.obj  \
        $(OBJDIR)\gets.obj     \
        $(OBJDIR)\getw.obj     \
        $(OBJDIR)\getws.obj    \
        $(OBJDIR)\outputformat.obj \
        $(OBJDIR)\printf.obj   \
        $(OBJDIR)\puts.obj     \
        $(OBJDIR)\putw.obj     \
        $(OBJDIR)\putws.obj    \
        $(OBJDIR)\rewind.obj   \
        $(OBJDIR)\rmtmp.obj    \
        $(OBJDIR)\scanf.obj    \
        $(OBJDIR)\setmaxf.obj  \
        $(OBJDIR)\setbuf.obj   \
        $(OBJDIR)\setvbuf.obj  \
        $(OBJDIR)\snprintf.obj \
        $(OBJDIR)\snprnc.obj   \
        $(OBJDIR)\snscanf.obj  \
        $(OBJDIR)\snwprint.obj \
        $(OBJDIR)\snwscanf.obj \
        $(OBJDIR)\sprintf.obj  \
        $(OBJDIR)\sscanf.obj   \
        $(OBJDIR)\stream.obj   \
        $(OBJDIR)\swprintf.obj \
        $(OBJDIR)\swprintn.obj \
        $(OBJDIR)\swprnc.obj   \
        $(OBJDIR)\swscanf.obj  \
        $(OBJDIR)\ungetc.obj   \
        $(OBJDIR)\ungetwc.obj  \
        $(OBJDIR)\vprintf.obj  \
        $(OBJDIR)\vfprintf.obj \
        $(OBJDIR)\vfwprint.obj \
        $(OBJDIR)\vsprintf.obj \
        $(OBJDIR)\vsnprint.obj \
        $(OBJDIR)\vsnprnc.obj  \
        $(OBJDIR)\vsnwprnt.obj \
        $(OBJDIR)\vswprint.obj \
        $(OBJDIR)\vswprinn.obj \
        $(OBJDIR)\vswprnc.obj  \
        $(OBJDIR)\vwprintf.obj \
        $(OBJDIR)\wfdopen.obj  \
        $(OBJDIR)\wfopen.obj   \
        $(OBJDIR)\wfreopen.obj \
        $(OBJDIR)\_wopen.obj   \
        $(OBJDIR)\wprintf.obj  \
        $(OBJDIR)\wscanf.obj   \
        $(OBJDIR)\ncommode.obj \
        $(OBJDIR)\cscanf.obj   \
        $(OBJDIR)\cscanfs.obj  \
        $(OBJDIR)\cwscanf.obj  \
        $(OBJDIR)\cwscanfs.obj \
        $(OBJDIR)\cprintf.obj  \
        $(OBJDIR)\cprintfp.obj \
        $(OBJDIR)\cprintfs.obj \
        $(OBJDIR)\cwprintf.obj \
        $(OBJDIR)\cwprntfp.obj \
        $(OBJDIR)\cwprntfs.obj \
        $(OBJDIR)\input.obj    \
        $(OBJDIR)\inputs.obj   \
        $(OBJDIR)\output.obj   \
        $(OBJDIR)\outputp.obj  \
        $(OBJDIR)\outputs.obj  \
        $(OBJDIR)\winput.obj   \
        $(OBJDIR)\winputs.obj  \
        $(OBJDIR)\woutput.obj  \
        $(OBJDIR)\woutputp.obj \
        $(OBJDIR)\woutputs.obj

STRING_OBJECTS = \
        $(OBJDIR)\memcpy_s.obj \
        $(OBJDIR)\memchr.obj   \
        $(OBJDIR)\memcmp.obj   \
        $(OBJDIR)\memccpy.obj  \
        $(OBJDIR)\_memicmp.obj \
        $(OBJDIR)\memmove_s.obj \
        $(OBJDIR)\strcat.obj   \
        $(OBJDIR)\strchr.obj   \
        $(OBJDIR)\strcspn.obj  \
        $(OBJDIR)\strdup.obj   \
        $(OBJDIR)\strncat.obj  \
        $(OBJDIR)\strncmp.obj  \
        $(OBJDIR)\strncpy.obj  \
        $(OBJDIR)\_strnicm.obj \
        $(OBJDIR)\strnset.obj  \
        $(OBJDIR)\strpbrk.obj  \
        $(OBJDIR)\strrchr.obj  \
        $(OBJDIR)\strrev.obj   \
        $(OBJDIR)\strset.obj   \
        $(OBJDIR)\strspn.obj   \
        $(OBJDIR)\strstr.obj   \
        $(OBJDIR)\strlen_s.obj \
        $(OBJDIR)\strcat_s.obj \
        $(OBJDIR)\strncat_s.obj \
        $(OBJDIR)\strcpy_s.obj \
        $(OBJDIR)\strncpy_s.obj \
        $(OBJDIR)\strncnt.obj  \
        $(OBJDIR)\strset_s.obj \
        $(OBJDIR)\strnset_s.obj \
        $(OBJDIR)\strtok.obj   \
        $(OBJDIR)\strtok_s.obj \
        $(OBJDIR)\wcscat.obj   \
        $(OBJDIR)\wcscat_s.obj \
        $(OBJDIR)\wcschr.obj   \
        $(OBJDIR)\wcscmp.obj   \
        $(OBJDIR)\wcscpy_s.obj \
        $(OBJDIR)\wcscspn.obj  \
        $(OBJDIR)\wcsdup.obj   \
        $(OBJDIR)\wcslen_s.obj \
        $(OBJDIR)\wcsncat.obj  \
        $(OBJDIR)\wcsncat_s.obj \
        $(OBJDIR)\wcsncmp.obj  \
        $(OBJDIR)\wcsncnt.obj  \
        $(OBJDIR)\wcsncpy.obj  \
        $(OBJDIR)\wcsncpy_s.obj  \
        $(OBJDIR)\wcsnset.obj  \
        $(OBJDIR)\wcsnset_s.obj  \
        $(OBJDIR)\wcspbrk.obj  \
        $(OBJDIR)\wcsrchr.obj  \
        $(OBJDIR)\wcsrev.obj   \
        $(OBJDIR)\wcsset.obj   \
        $(OBJDIR)\wcsset_s.obj \
        $(OBJDIR)\wcsspn.obj   \
        $(OBJDIR)\wcsstr.obj   \
        $(OBJDIR)\wcstok.obj   \
        $(OBJDIR)\wcstok_s.obj \
        $(OBJDIR)\memicmp.obj  \
        $(OBJDIR)\strcoll.obj  \
        $(OBJDIR)\stricmp.obj  \
        $(OBJDIR)\stricoll.obj \
        $(OBJDIR)\strlwr.obj   \
        $(OBJDIR)\strncoll.obj \
        $(OBJDIR)\strnicmp.obj \
        $(OBJDIR)\strnicol.obj \
        $(OBJDIR)\strupr.obj   \
        $(OBJDIR)\strxfrm.obj  \
        $(OBJDIR)\wcscoll.obj  \
        $(OBJDIR)\wcsicmp.obj  \
        $(OBJDIR)\wcsicoll.obj \
        $(OBJDIR)\wcslwr.obj   \
        $(OBJDIR)\wcsncoll.obj \
        $(OBJDIR)\wcsnicmp.obj \
        $(OBJDIR)\wcsnicol.obj \
        $(OBJDIR)\wcsupr.obj   \
        $(OBJDIR)\wcsxfrm.obj 

TIME_OBJECTS = \
        $(OBJDIR)\clock.obj    \
        $(OBJDIR)\days.obj     \
        $(OBJDIR)\difftime.obj \
        $(OBJDIR)\difftm64.obj \
        $(OBJDIR)\dtoxtime.obj \
        $(OBJDIR)\ftime.obj    \
        $(OBJDIR)\strftime.obj \
        $(OBJDIR)\strdate.obj  \
        $(OBJDIR)\strtime.obj  \
        $(OBJDIR)\time.obj     \
        $(OBJDIR)\timeset.obj  \
        $(OBJDIR)\tzset.obj    \
        $(OBJDIR)\dtoxtm64.obj \
        $(OBJDIR)\ftime64.obj  \
        $(OBJDIR)\time64.obj   \
        $(OBJDIR)\wcsftime.obj \
        $(OBJDIR)\wstrdate.obj \
        $(OBJDIR)\wstrtime.obj

$(OBJDIR)\convert.lib: $(CONVERT_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(CONVERT_OBJECTS: =^
)
<<keep


$(OBJDIR)\direct.lib: $(DIRECT_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(DIRECT_OBJECTS: =^
)
<<keep


$(OBJDIR)\dos.lib: $(DOS_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(DOS_OBJECTS: =^
)
<<keep


$(OBJDIR)\heap.lib: $(HEAP_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(HEAP_OBJECTS: =^
)
<<keep


$(OBJDIR)\helper.lib: $(HELPER_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(HELPER_OBJECTS: =^
)
<<keep

$(OBJDIR)\lowio.lib: $(LOWIO_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(LOWIO_OBJECTS: =^
)
<<keep


$(OBJDIR)\crtplus.lib: $(CRTPLUS_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(CRTPLUS_OBJECTS: =^
)
<<keep


$(OBJDIR)\misc.lib: $(MISC_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(MISC_OBJECTS: =^
)
<<keep


$(OBJDIR)\startup.lib: $(STARTUP_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(STARTUP_OBJECTS: =^
)
<<keep


$(OBJDIR)\stdcpp.lib: $(STDCPP_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(STDCPP_OBJECTS: =^
)
<<keep


$(OBJDIR)\stdio.lib: $(STDIO_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(STDIO_OBJECTS: =^
)
<<keep


$(OBJDIR)\string.lib: $(STRING_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(STRING_OBJECTS: =^
)
<<keep


$(OBJDIR)\time.lib: $(TIME_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(TIME_OBJECTS: =^
)
<<keep

$(OBJDIR)\eh.lib: $(EH_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(EH_OBJECTS: =^
)
<<keep

$(OBJDIR)\conv.lib: $(CONV_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(CONV_OBJECTS: =^
)
<<keep

$(OBJDIR)\rtc.lib: $(RTC_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(RTC_OBJECTS: =^
)
<<keep

$(OBJDIR)\tran.lib: $(TRAN_OBJECTS)
    $(LIB) -out:$@ @<<$*.rsp
$(TRAN_OBJECTS: =^
)
<<keep
