#pragma once
#ifndef _INC_CRTPLUS
#define _INC_CRTPLUS

#if defined(__cplusplus) && !defined(_DEF_EXTERNC)
#define _DEF_EXTERNC
#define _DEF_CRTPLUS_EXTERNC
extern "C" {
#endif

#define _X86_

#define CALLBACK				__stdcall

typedef signed __int8			INT8, *LPINT8;
typedef signed __int16			INT16, *LPINT16, BOOL16, *LPBOOL16;
typedef signed __int32			INT32, *LPINT32;
typedef signed __int64			INT64, *LPINT64;

typedef unsigned __int8			UINT8, *LPUINT8;
typedef unsigned __int16		UINT16, *LPUINT16;
typedef unsigned __int32		UINT32, *LPUINT32;
typedef unsigned __int64		UINT64, *LPUINT64;

typedef unsigned __int8			BYTE, *LPBYTE;
typedef unsigned __int16		WORD, *LPWORD;
typedef unsigned long			DWORD, *LPDWORD, ULONG, *LPULONG;
typedef signed long				LONG, *LPLONG;
typedef signed __int32			BOOL, *LPBOOL;

typedef char					CHAR, *LPCHAR, *LPSTR;
typedef unsigned char			UCHAR, *LPUCHAR, *LPUSTR;
typedef const char				*LPCSTR;

typedef float					FLOAT, *LPFLOAT;
typedef double					DOUBLE, *LPDOUBLE;

typedef void					*LPVOID;
typedef const void				*LPCVOID;

typedef LPVOID					HANDLE, *LPHANDLE;

#ifndef _WCHAR_T_DEFINED
#define _WCHAR_T_DEFINED
typedef unsigned short			wchar_t;
#endif	// _WCHAR_T_DEFINED

typedef wchar_t					WCHAR, *LPWSTR;

#ifdef ENABLE_STRING_H
#ifdef _CRTBLD
#include "string.h"
#else	// _CRTBLD
#include <string.h>
#endif	// _CRTBLD
#else
#define _INC_STRING				// disable including string.h
LPVOID __cdecl memcpy(LPVOID lpDst, LPCVOID lpSrc, UINT32 nSize);
#endif	// ENABLE_STRING_H

#ifdef ENABLE_STDLIB_H
#ifdef _CRTBLD
#include "stdlib.h"
#else	// _CRTBLD
#include <stdlib.h>
#endif	// _CRTBLD
#else
#define _INC_STDLIB				// disable including stdlib.h
LPVOID __cdecl memset(LPVOID lpDst, INT32 nVal, UINT32 nSize);
void __cdecl srand(UINT32 nSeed);
INT32 __cdecl rand();
INT32 __cdecl abs(INT32 nNumber);
void __cdecl qsort(LPVOID lpBase, UINT32 num, UINT32 width, INT32 (__cdecl *comp)(const void *, const void *));
#endif	//  ENABLE_STDLIB_H

#ifdef NO_INC_WINDOWS
#define WM_APP					0x8000

typedef LPVOID					HWND;
typedef LPVOID					HFONT;
typedef LPVOID					HDC;
typedef LPVOID					HINSTANCE;
typedef LPVOID					HCURSOR;
typedef LPVOID					LPMSG;
typedef LPVOID					LPMINMAXINFO;
typedef LPVOID					LPTPMPARAMS;
typedef LPVOID					HACCEL;
typedef LPVOID					HBITMAP;
typedef LPVOID					LPLVITEM;
typedef UINT32					COLORREF;
typedef LPVOID					WNDPROC;
typedef LPSTR					va_list;
typedef DWORD					LCID;         
typedef LPVOID					LPCRITICAL_SECTION;
typedef DWORD (__stdcall *LPTHREAD_START_ROUTINE)(LPVOID lpThreadParameter);
typedef struct tagOVERLAPPED {
	DWORD						Internal;
	DWORD						InternalHigh;
	union{
		struct {
			DWORD				Offset;
			DWORD				OffsetHigh;
		};
		LPVOID					Pointer;
	};
	HANDLE						hEvent;
} OVERLAPPED, *LPOVERLAPPED;
typedef struct tagSYSTEMTIME {
	WORD						wYear;
	WORD						wMonth;
	WORD						wDayOfWeek;
	WORD						wDay;
	WORD						wHour;
	WORD						wMinute;
	WORD						wSecond;
	WORD						wMilliseconds;
} SYSTEMTIME, *LPSYSTEMTIME;
typedef struct tagRECT {
	UINT32						left;
	UINT32						top;
	UINT32						right;
	UINT32						bottom;
} RECT, *LPRECT;

#else // NO_INC_WINDOWS
#define _INC_WINDOWS
#define _WINDOWS_

//	If defined, the following flags inhibit definition of the indicated items.
//	NOGDICAPMASKS     - CC_*, LC_*, PC_*, CP_*, TC_*, RC_
//	NOVIRTUALKEYCODES - VK_*
//	NOWINMESSAGES     - WM_*, EM_*, LB_*, CB_*
//	NOWINSTYLES       - WS_*, CS_*, ES_*, LBS_*, SBS_*, CBS_*
//	NOSYSMETRICS      - SM_*
//	NOMENUS           - MF_*
//	NOICONS           - IDI_*
//	NOKEYSTATES       - MK_*
//	NOSYSCOMMANDS     - SC_*
//	NORASTEROPS       - Binary and Tertiary raster ops
//	NOSHOWWINDOW      - SW_*
//	OEMRESOURCE       - OEM Resource values
//	NOATOM            - Atom Manager routines
//	NOCLIPBOARD       - Clipboard routines
//	NOCOLOR           - Screen colors
//	NOCTLMGR          - Control and Dialog routines
//	NODRAWTEXT        - DrawText() and DT_*
//	NOGDI             - All GDI defines and routines
//	NOKERNEL          - All KERNEL defines and routines
//	NOUSER            - All USER defines and routines
//	NONLS             - All NLS defines and routines
//	NOMB              - MB_* and MessageBox()
//	NOMEMMGR          - GMEM_*, LMEM_*, GHND, LHND, associated routines
//	NOMETAFILE        - typedef METAFILEPICT
//	NOMINMAX          - Macros min(a,b) and max(a,b)
//	NOMSG             - typedef MSG and associated routines
//	NOOPENFILE        - OpenFile(), OemToAnsi, AnsiToOem, and OF_*
//	NOSCROLL          - SB_* and scrolling routines
//	NOSERVICE         - All Service Controller routines, SERVICE_ equates, etc.
//	NOSOUND           - Sound driver routines
//	NOTEXTMETRIC      - typedef TEXTMETRIC and associated routines
//	NOWH              - SetWindowsHook and WH_*
//	NOWINOFFSETS      - GWL_*, GCL_*, associated routines
//	NOCOMM            - COMM driver routines
//	NOKANJI           - Kanji support stuff.
//	NOHELP            - Help engine interface.
//	NOPROFILER        - Profiler interface.
//	NODEFERWINDOWPOS  - DeferWindowPos routines
//	NOMCX             - Modem Configuration Extensions

#include <windef.h>
#include <winbase.h>
#include <wingdi.h>
#include <winuser.h>
#include <winnls.h>
#include <wincon.h>
#include <winver.h>
#include <winreg.h>
#include <winnetwk.h>

#ifndef WIN32_LEAN_AND_MEAN
#include <cderr.h>
#include <dde.h>
#include <ddeml.h>
#include <dlgs.h>
#include <lzexpand.h>
#include <mmsystem.h>
#include <nb30.h>
#include <rpc.h>
#include <shellapi.h>
#include <winperf.h>
#ifndef NO_INC_WINSOCK
#include <winsock.h>
#endif
#ifndef NOCRYPT
#include <wincrypt.h>
#include <winefs.h>
#include <winscard.h>
#endif

#ifndef NOGDI
#include <winspool.h>
#ifndef NOOLE
#ifdef INC_OLE1
#include <ole.h>
#else
#include <ole2.h>
#endif	// !INC_OLE1
#endif	// NOOLE
#include <commdlg.h>
#endif	// !NOGDI
#ifndef NOSERVICE
#include <winsvc.h>
#endif
#if(WINVER >= 0x0400)
#ifndef NOMCX
#include <mcx.h>
#endif	// NOMCX
#ifndef NOIME
#include <imm.h>
#endif
#endif	// WINVER >= 0x0400
#endif	// WIN32_LEAN_AND_MEAN

typedef RTL_CRITICAL_SECTION	*LPCRITICAL_SECTION;
#endif // NO_INC_WINDOWS

#pragma pack(push, 1)

typedef union tagLOCALINFO {
	struct {
	char						cDecPoint;
	char						cSeparator;
	UINT8						nDateFormat;
	UINT8						nReserved;
	};
	UINT32						nInfo;
} LOCALINFO, *LPLOCALINFO;

typedef struct tagWINVERSION {
	UINT8						Minor;
	UINT8						Major;
	INT16						Build;
} WINVERSION, *LPWINVERSION;

#ifndef MB_LEN_MAX
#define MB_LEN_MAX    5								// max. bytes in multibyte char
#endif	// MB_LEN_MAX

typedef struct tagTIDDATA {
	UINT32	volatile			nThreadID;						// thread ID
	HANDLE						hThread;						// thread handle
	INT32						nOwnThreadID;					// own thread ID. Main = 0. +1 on any 
	BOOL	volatile			bThreadActive;					// Thread active
	LOCALINFO					LocInfo;
	HWND						hWnd;
	HACCEL						hAccel;
	HWND						hDlg;
	INT32						nErrFlags;						// Memory allocation/ File IO error
	BOOL						bInDoEvents;
	INT32						nErrNo;							// for errors
	INT32						nSysErrNo;						// for syserrors
	INT32						nUser;
	LPVOID						pUser;
	INT32						_terrno;						// errno value
	UINT32						_tdoserrno;						// _doserrno value
	UINT32						_holdrand;						// rand() seed value
	LPSTR						_token;							// ptr to strtok() token
	LPWSTR						_wtoken;						// ptr to wcstok() token
	LPSTR						_cvtbuf;						// ptr to ecvt()/fcvt buffer
	LPTHREAD_START_ROUTINE		_initaddr;						// initial user thread address
	LPVOID						_initarg;						// initial user thread argument
	LPVOID						ptmbcinfo;
	LPVOID						ptlocinfo;						// pointer to the copy of the locale informaton used by the thead
	INT32						_ownlocale;						// if 1, this thread owns its own locale
	LPVOID						_terminate;						// terminate() routine
	LPVOID						_unexpected;					// unexpected() routine
	LPVOID						_translator;					// S.E. translator */
	LPVOID						_purecall;						// called when pure virtual happens
	LPVOID						_curexception;					// current exception
	LPVOID						_curcontext;					// current exception context
	INT32						_ProcessingThrow;				// for uncaught_exception
	LPVOID						_curexcspec;					// for handling exceptions thrown from std::unexpected
	LPVOID						_pFrameInfoChain;
	LPVOID						_psetloc_data;					// _psetloc_struct
	INT32						_cxxReThrow;					// Set to True if it's a rethrown C++ Exception
} TIDDATA, *LPTIDDATA;

#pragma pack(pop)

//	Own windows messages
#define WM_SK_QUIT				(WM_APP + 1)
#define WM_SK_QUIT_LP_QUIT		0
#define WM_SK_QUIT_LP_RESTART	1
#define WM_SK_QUIT_LP_REBOOT	2
#define WM_SK_CLOSE				(WM_APP + 2)
#define WM_SK_THREADSTART		(WM_APP + 3)
#define WM_SK_THREADEXIT		(WM_APP + 4)
#define WM_SK_PAINT				(WM_APP + 5)					// dialog update wParam = dialog item or 0 for dialog
#define WM_SK_SPECIAL			(WM_APP + 6)
#define WM_SK_LOG				(WM_APP + 7)
#define WM_SK_SHOW				(WM_APP + 8)
#define WM_SK_TIMER				(WM_APP + 9)
#define WM_SK_TIMEOUT			(WM_APP + 10)
#define WM_SK_LISTSEL			(WM_APP + 11)

#define TRUE					1
#define FALSE					0

#define MAX_PATH				260

#define MAX_UNSIGNED64			0xFFFFFFFFFFFFFFFF
#define MAX_SIGNED64			0x7FFFFFFFFFFFFFFF
#define MIN_SIGNED64			0x8000000000000000
#define MAX_UNSIGNED32			0xFFFFFFFF
#define MAX_SIGNED32			0x7FFFFFFF
#define MIN_SIGNED32			0x80000000
#define MAX_UNSIGNED16			65535
#define MAX_SIGNED16			32767
#define MIN_SIGNED16			-32768
#define MAX_UNSIGNED8			255
#define MAX_SIGNED8				127
#define MIN_SIGNED8				-128

#define BIT8_MASK				0x000000FF
#define BIT16_MASK				0x0000FFFF
#define BIT24_MASK				0x00FFFFFF

#define GMM_DEFAULT				0
#define GMM_CLEAR				1
#define GMM_ALWAYS				2

// GetCpuFeatures
#define CPUFEAT_CPUID			0x00000001
#define CPUFEAT_AMD				0x00000002
#define CPUFEAT_FPU				0x00000004
#define CPUFEAT_TSC				0x00000008
#define CPUFEAT_CX8				0x00000010
#define CPUFEAT_CMOV			0x00000020
#define CPUFEAT_MMX				0x00000040
#define CPUFEAT_MMXEXT			0x00000080
#define CPUFEAT_FXSR			0x00000100
#define CPUFEAT_SSE				0x00000200
#define CPUFEAT_SSE2			0x00000400
#define CPUFEAT_SSE3			0x00000800
#define CPUFEAT_SSSE3			0x00001000
#define CPUFEAT_3DNOW			0x00002000
#define CPUFEAT_3DNOWEXT		0x00004000

#define FXAM_ZERO						1
#define FXAM_DENORM						2
#define FXAM_NORM						3
#define FXAM_INF						4
#define FXAM_NAN						5
#define FXAM_UNSUP						6
#define FXAM_EMPTY						7

//	g_nAppType values
#define APP_UNKNOWN						0
#define APP_CONSOLE						1
#define APP_GUI							2
#define APP_DLL							3

//	Error flags
#define ERRF_MEMORY						0x01000000
#define ERRF_FILE						0x02000000
#define ERRF_BCD						0x04000000
#define ERRF_CODEMASK					0x00FFFFFF

//	Date format
#define DF_YMD							0
#define DF_MDY							1
#define DF_DMY							2

#define _RTERR_FIRST					1				// first runtime error
#define _RTERR_HEAPINIT					1				// heap failed to initialize
#define _RTERR_SPACEARG					2				// not enough space for arguments
#define _RTERR_SPACEENV					3				// not enough space for environment
#define _RTERR_ABORT					4				// abnormal program termination
#define _RTERR_THREAD					5				// not enough space for thread data
#define _RTERR_ONEXIT					6				// insufficient heap to allocate initial table of funct. ptrs
#define _RTERR_STDIOINIT				7				// not enough space for stdio initialization
#define _RTERR_LOWIOINIT				8				// not enough space for lowio initialization
#define _RTERR_PURECALL					9
#define _RTERR_LOCALE					10				// lack of space for locale/
#define _RTERR_FPU						11				// fpu not detected
#define _RTERR_CMOV						12				// cmov not detected
#define _RTERR_MMX						13				// mmx not detected
#define _RTERR_SSE						14				// sse not detected
#define _RTERR_SSE2						15				// sse2 not detected
#define _RTERR_LAST						100				// last runtime error

//	g_nAppState values
#define APST_WINREADY					0x00000001
#define APST_SAVESETTINGS				0x00000080
#define APST_UDPREADY					0x00000100
#define APST_COM1READY					0x00000200
#define APST_COM2READY					0x00000400
#define APST_COM3READY					0x00000800
#define APST_COM4READY					0x00001000

extern const float		g_fZero;
extern const INT32		g_nZero;
extern const double		g_fdZero;
extern const INT64		g_ndZero;
extern const float		g_fOne;
extern const INT32		g_nOne;
extern const INT32		g_nOneM;
extern const INT32		g_nTwo;
extern const INT32		g_nThree;
extern const INT32		g_nFour;
extern const INT32		g_nFive;
extern const INT32		g_nSix;
extern const INT32		g_nSeven;
extern const INT32		g_nEiht;
extern const INT32		g_nNine;
extern const INT32		g_nTen;
extern const INT32		g_nHundred;
extern const INT32		g_nThousand;
extern const INT32		g_nMillion;

extern const double		g_fdE;				// 2.71828182845904523536
extern const double		g_fdLdE;			// 1.44269504088896340736
extern const double		g_fdLogE;			// 0.434294481903251827651
extern const double		g_fdLn2;			// 0.693147180559945309417
extern const double		g_fdLn10;			// 2.30258509299404568402
extern const double		g_fdPi;				// 3.14159265358979323846
extern const double		g_fdPiBy2;			// 1.57079632679489661923
extern const double		g_fdPiBy4;			// 0.785398163397448309616
extern const double		g_fd1ByPi;			// 0.318309886183790671538
extern const double		g_fd2ByPi;			// 0.636619772367581343076
extern const double		g_fd2BySqrtPi;		// 1.12837916709551257390
extern const double		g_fdSqrt2;			// 1.41421356237309504880
extern const double		g_fd1BySqrt2;		// 0.707106781186547524401

extern const double		g_fdIndefinite;
extern const double		g_fdInfinity;
extern const double		g_fdInfinityM;

extern UINT16			g_nDefaultFpuCW;
extern UINT16			g_nFloorFpuCW;
extern UINT16			g_nCeilFpuCW;
extern UINT16			g_nTruncFpuCW;

extern UINT32			g_nCpuFeatures;
extern HANDLE			g_hCrtHeap;
extern UINT32			g_nAppType;
extern UINT32			g_nErrorMode;
extern BOOL				g_bUseStdIO;
extern UINT32			g_nAppState;
extern HWND				g_hWndMain;
extern HINSTANCE		g_hInstance;
extern HINSTANCE		g_hResource;
extern INT32 volatile	g_nCoInitMode;
extern INT32			g_nException;
extern INT32			g_nExceptIP;
extern WINVERSION		g_sWinVersion;

extern UINT32			g_nCallCounter;

#ifndef MAX_PATH
#define					MAX_PATH	260
#endif // MAX_PATH

extern char				g_cProgName[MAX_PATH];
extern WCHAR			g_wcProgName[MAX_PATH];

extern LOCALINFO		g_LocInfo;

typedef void (__stdcall * EXITMSGPROC)(INT32 nCode);

extern EXITMSGPROC		g_pExitMsgProc;

double __cdecl fround(double fVal);
double __cdecl ftrunc(double fVal);
double __cdecl log2(double fVal);
double __cdecl exp10(double fVal);
double __cdecl exp2(double fVal);
double __cdecl xtoy(double x, double y);
double __cdecl xton(double x, INT32 n);
double __cdecl xto2(double x);
double __cdecl xto3(double x);
double __cdecl xto4(double x);
INT32 __stdcall FltXam(double fVal, BOOL bFull);

void __cdecl _lock(INT32 nLockID);
void __cdecl _unlock(INT32 nLockID);
void __cdecl LockThread(INT32 nLockID);
BOOL __cdecl TryLockThread(INT32 nLockID);
void __cdecl UnLockThread(INT32 nLockID);
LPCRITICAL_SECTION __cdecl GetCriticalSection(INT32 nLockID);
#define _TIME_LOCK			4								// defined in libcmt.h
#define _IO_LOCK			11
#define _COM_LOCK			12
#define _SKDP_LOCK			13
#define _USER_LOCK			14
#define _USER_LOCK0			(_USER_LOCK + 0)
#define _USER_LOCK1			(_USER_LOCK + 1)
#define _USER_LOCK2			(_USER_LOCK + 2)
#define _FILE_LOCK			17
#define _FILE_LOCK0			(_FILE_LOCK + 0)
#define _FILE_LOCK1			(_FILE_LOCK + 1)
#define _FILE_LOCK2			(_FILE_LOCK + 2)

void __stdcall SetErrorFlags(INT32 nMask);
INT32 __cdecl GetErrorFlags();
LPVOID __stdcall GetMem(INT32 nMode, UINT32 dwBytes);
LPVOID __stdcall ModifyMem(LPVOID lpMem, INT32 nMode, DWORD dwBytes);
BOOL __stdcall ModifyMemEx(LPVOID *lpMem, INT32 nMode, UINT32 dwBytes);
BOOL __cdecl FreeMem(LPVOID lpMem);
BOOL __cdecl FreeStr(LPSTR lpStr);
BOOL __stdcall FreeMemEx(LPVOID *lpMem);
UINT32 __stdcall MemSize(LPVOID lpMem);
void __stdcall MemClr(LPVOID lpMem, INT32 nSize);
LPVOID __cdecl MemFill8(LPVOID lpMem, char nFill, INT32 nSize);
void __cdecl MemCpy(LPVOID lpDst, LPVOID lpSrc, INT32 nSize);
void __cdecl MemMove(LPVOID lpDst, LPVOID lpSrc, INT32 nSize);
INT64 __stdcall AllocatedMemSize(HANDLE hHeap);
INT32 __cdecl StrLen(LPSTR lpStr);
INT32 __stdcall StrCpy(LPSTR lpDst, LPSTR lpSrc);
INT32 __stdcall StrCpyN(LPSTR lpDst, LPSTR lpSrc, INT32 nDstSize);

INT32 __cdecl WStrLen(LPWSTR lpwStr);

void __stdcall InitFpu();
//	Set only the Fpu variables - don't call the InitFpu
void __stdcall SetFpuPrecision(BOOL bExtended);
//	for DLL functions: set default FPU control word
int __stdcall FpuPreset();
//	for DLL functions: restore saved FPU control word
void __stdcall FpuSetCW(int nSavedCW);
INT32 __stdcall GetFpuState();
UINT32 __stdcall GetCpuFeatures(BOOL bSystem);
INT32 __stdcall GetWinVersion(LPWINVERSION lpVersion);
HANDLE __stdcall ThreadStart(LPTHREAD_START_ROUTINE lpInitCode, LPVOID lpArg, UINT32 nStack, BOOL bSuspended, LPUINT32 lpID);
HANDLE __stdcall SimpleThread(LPTHREAD_START_ROUTINE lpInitCode, LPVOID lpArg);
LPTIDDATA __cdecl _getptd(void);							// return address of per-thread CRT data

#ifndef _EXIT_DEFINED
#define _EXIT_DEFINED
__declspec(noreturn) void __cdecl exit(INT32 nCode);
#endif  // _EXIT_DEFINED

#ifndef _ABORT_DEFINED
#define _ABORT_DEFINED
void __cdecl abort(void);
#endif  // _ABORT_DEFINED

#if defined(_DEF_CRTPLUS_EXTERNC)
}
#undef _DEF_EXTERNC
#undef _DEF_CRTPLUS_EXTERNC
#endif

#endif  // _INC_CRTPLUS
