#pragma once
#ifndef _INC_SKCLIB32
#define _INC_SKCLIB32

#include <crtplus.h>

#ifndef NO_INC_WINDOWS
#ifndef NO_INC_COMMCTRL
#include <commctrl.h>
#endif // NO_INC_COMMCTRL
#endif // NO_INC_WINDOWS
#include <skclibres.h>

#if defined(__cplusplus) && !defined(_DEF_EXTERNC)
#define _DEF_EXTERNC
#define _DEF_SKCLIB_EXTERNC
extern "C" {
#endif

// LisdtView CheckBox uNewState, uOldState flags
#define LVIS_UNCHECKED			0x1000
#define LVIS_CHECKED			0x2000
#define LVIS_CHECKMASK			0x3000

#define STR_TSZO_FOLDER			"TSZO"
#define STR_VTSZO				"VTSZO"
#define STR_RESTART				"ReStart"
#define STR_VERSION				"Version"
#define STR_PROGRAM				"Program"
#define STR_SKUPDATE			"SKUpdate"
#define STR_DEFAULT				"Default"

#define STR_KOZOS				"Kozos"
#define STR_UTVONAL				"Utvonal"
#define STR_ADAT				"Adat"
#define STR_CFA					"CFA"
#define STR_PATH				"Path"
#define STR_SERVER				"Server"
#define STR_LOCAL				"Local"
#define STR_USERS				"Users"
#define STR_MAXUSER				"MaxUser"
#define STR_USER				"User"
#define STR_USERLIST			"UserList"
#define STR_SYSLOG				"SysLog"
#define STR_RSTCHECK			"RstCheck"
#define STR_FONTS				"Fonts"
#define STR_FONT				"Font"
#define STR_NAME				"Name"
#define STR_TIME				"Time"
#define STR_SIZE				"Size"
#define STR_FILES				"Files"
#define STR_FILE				"File"
#define STR_DIR					"Dir"
#define STR_ROOT				"Root"
#define STR_SORT				"Sort"
#define STR_HOST				"Host"
#define STR_DAY					"Day"
#define STR_CURDAY				"CurDay"
#define STR_BLOKK				"Blokk"

#define STR_UDP					"UDP"
#define STR_CONNECTION			"Connection"
#define STR_MAXCONNECTION		"MaxConnection"
#define STR_MAXJOB				"MaxJob"
#define STR_PORT				"Port"
#define STR_PC					"PC"
#define STR_IP					"IP"
#define STR_RIGHTS				"Rights"
#define STR_TIMEOUT				"TimeOut"
#define STR_SEND				"Send"
#define STR_RCV					"Rcv"
#define STR_STD					"Std"
#define STR_RESEND				"ReSend"
#define STR_IO					"IO"
#define STR_FIND				"Find"
#define STR_REQ					"Req"
#define STR_RETRY				"Retry"
#define STR_SHARE				"Share"
#define STR_MAXFOLDER			"MaxFolder"
#define STR_FOLDER				"Folder"
#define STR_COMMON				"Common"
#define STR_MODE				"Mode"
#define STR_THREADERROR			"ThreadError"
#define STR_PROGERROR			"ProgError"
#define STR_WAITSEC				"WaitSec"

#define CMDSTR_RESTART			"/RST"
#define UPDATE_PARAM_CLASS		"/C:"
#define UPDATE_PARAM_SRC		"/S:"
#define UPDATE_PARAM_DST		"/D:"

#define CHR_NUL					0
#define CHR_STX					2
#define CHR_ETX					3
#define CHR_ACK					6
#define CHR_BEL					7
#define CHR_BS					8
#define CHR_HT					9
#define CHR_LF					10
#define CHR_FF					12
#define CHR_CR					13
#define CHR_DLE					16
#define CHR_XON					17
#define CHR_XOFF				19
#define CHR_NAK					21
#define CHR_ESC					27
#define CHR_SPC					32

#define STR_EMPTY				""
#define STR_HUN					"hun"
#define STR_BACKSLASH			"\\"
#define STR_DBLBACKSLASH		"\\\\"
#define STR_SLASH				"/"
#define STR_COLON				":"
#define STR_HASHMARK			"#"
#define STR_STAR				"*"
#define STR_DOT					"."
#define STR_DOUBLEDOT			".."
#define STR_DOTBSLASH			".\\"
#define STR_DBLDOTBSLASH		"..\\"
#define STR_SPACE				" "
#define STR_PERCENT				" %"
#define STR_HT					"\t"
#define STR_CRLF				"\r\n"
#define STR_COLONSEP			" : "
#define STR_MINUSSEP			" - "
#define STR_POINTSEP			" ... "
#define STR_EXT_APE				".ape"
#define STR_EXT_BAK				".bak"
#define STR_EXT_BMP				".bmp"
#define STR_EXT_CFA				".cfa"
#define STR_EXT_CFG				".cfg"
#define STR_EXT_CSV				".csv"
#define STR_EXT_CUR				".cur"
#define STR_EXT_DAT				".dat"
#define STR_EXT_EMF				".emf"
#define STR_EXT_EXE				".exe"
#define STR_EXT_FLAC			".flac"
#define STR_EXT_ICO				".ico"
#define STR_EXT_INI				".ini"
#define STR_EXT_JPG				".jpg"
#define STR_EXT_LOG				".log"
#define STR_EXT_MAV				".mav"
#define STR_EXT_MP3				".mp3"
#define STR_EXT_OLD				".old"
#define STR_EXT_TMP				".tmp"
#define STR_EXT_TXT				".txt"
#define STR_EXT_XLS				".xls"
#define STR_EXT_WAV				".wav"
#define STR_EXT_WMF				".wmf"
#define STR_EXT_WV				".wv"
#define STR_ANYFILE				"*.*"
#define STR_CURRENTDIR			STR_DOT
#define STR_PARENTDIR			STR_DOUBLEDOT
#define LEN_STDEXT				4
#define STR_ARIAL				"Arial"
#define STR_ARIALNARROW			"Arial Narrow"
#define STR_COURIERNEW			"Courier New"
#define STR_TAHOMA				"Tahoma"

#define IS_RESSTR(s) ((((UINT32)(s)) >> 16) == 0)
#define RESSTR(i) ((LPSTR)((UINT32)((UINT16)(i))))
#define RESSTRW(i) ((LPWSTR)((UINT32)((UINT16)(i))))

#define STR_FORMAT_DEC			"%d"

#define STARTYEAR				2000

#define VK_PAGEUP				VK_PRIOR
#define VK_PAGEDOWN				VK_NEXT
#define TBSTATE_DISABLED		0x00
#define GKS_PRESSED				0x80

#define RGB_BLACK				0x00000000
#define RGB_LIGHTRED			0x000000FF
#define RGB_DARKRED				0x00000080
#define RGB_RED					0x000000C0
#define RGB_LIGHTGREEN			0x0000FF00
#define RGB_DARKGREEN			0x00008000
#define RGB_GREEN				0x0000C000
#define RGB_LIGHTBLUE			0x00FF0000
#define RGB_DARKBLUE			0x00800000
#define RGB_BLUE				0x00C00000
#define RGB_YELLOW				0x0000FFFF
#define RGB_PALEYELLOW			0x0080FFFF
#define RGB_LIGHTMAGENTA		0x00FF00FF
#define RGB_PALEMAGENTA			0x00FF80FF
#define RGB_MAGENTA				0x00C000C0
#define RGB_LIGTCYAN			0x00FFFF00
#define RGB_PALECYAN			0x00FFFF80
#define RGB_CYAN				0x00C0C000
#define RGB_WHITE				0x00FFFFFF
#define RGB_LIGHTGRAY			0x00C0C0C0
#define RGB_DARKGRAY			0x00808080
#define RGB_DARKORANGE			0x000060C0
#define RGB_ORANGE				0x000080FF
#define RGB_PINK				0x008080FF
#define RGB_PEACH				0x0080C0FF
#define RGB_GOLD				0x0000C0FF

#define SECONDSOFHOUR			3600
#define SECONDSOFDAY			86400
#define MILLISECONDSOFDAY		86400000

//	GetIniFileFolder flags
#define IFF_DEFAULT				0
#define IFF_ADDBSLASH			1
#define IFF_EXISTS				2
#define IFF_CREATE				4
#define IFF_ONERRDEF			8

#define CPR_INVALID				0
#define CPR_WILDCARD			1
#define CPR_COMPUTER			2
#define CPR_VALID				3
#define CPR_ROOT				4
#define CPR_NETROOT				5

#define PRS_STATUS				3
#define PRS_STATUSLEN			MAX_PATH
#define PRS_CANCELLEN			32
#define PRS_FONTLEN				64
#define PRS_TITLELEN			128

// Progress flags
#define	PRSF_DEFAULT			0
#define	PRSF_DRAWPERCENT		0x00000001
#define	PRSF_DBLPROGRESS		0x00000002
#define	PRSF_STATUS0_OFF		0x00000004
#define	PRSF_STATUS1			0x00000008
#define	PRSF_STATUS2			0x00000010
#define	PRSF_MINBOX				0x00000040
#define	PRSF_ENABLEOWNER		0x00000080
#define	PRSF_ALWAYSTOP			0x00000100
#define	PRSF_FLAGMASK			0x0000FFFF
#define	PRSF_CANCEL				0x00010000
#define	PRSF_MINIMIZED			0x00020000

// ProgressSetText Mode
#define	PSTM_LEFT				0
#define	PSTM_RIGHT				1
#define	PSTM_CENTER				2
#define	PSTM_PATH				4

#define	ICC_ANY_CLASSES			0x00001FFF

#pragma pack(push, 1)

typedef struct tagPROGRESSINFO {
	HWND volatile		hDlg;
		union {
	LPVOID volatile		pData;
	INT32 volatile		nData;
		};
	HWND				hOwner;
	INT32				nWidth;
	INT32				nFontSize;
	float				fValue[2];
	INT32				nValue[2];
	INT32				nRound[2];
	INT32				nFlags;
	INT32				nTick;
	INT32				nTickDelta;
	LPINT32				lpCancel;
	COLORREF			crBack;
	COLORREF			crText;
	COLORREF			crSelBack;
	COLORREF			crSelText;
	char				cStatus[2 * PRS_STATUS][PRS_STATUSLEN];
	INT32				nStatMode[PRS_STATUS];
	char				cCancel[PRS_CANCELLEN];
	char				cFontName[PRS_FONTLEN];
	char				cTitle[PRS_TITLELEN];
} PROGRESSINFO, *LPPROGRESSINFO;

#pragma pack(pop)


// Trim String Mode
#define TSM_LEFT				1
#define TSM_RIGHT				2
#define TSM_BOTH				3

#define MAX_WORKPATH			1024
// File open mode
#define FOM_READ				0x0000
#define FOM_WRITE				0x0001
#define FOM_REWRITE				0x0002
#define FOM_SHARE				0x0004
// File seek mode
#define FSM_BEGIN				FILE_BEGIN
#define FSM_CURRENT				FILE_CURRENT
#define FSM_END					FILE_END
#define FSM_TIME				3
// File callback mode
#define FCBM_OPEN				0
#define FCBM_READ				1
#define FCBM_WRITE				2
#define FCBM_CLOSE				3
typedef struct tagSORTINFO	SORTINFO, *LPSORTINFO;
typedef struct tagFILEIO	FILEIO, *LPFILEIO;
typedef void (CALLBACK* FILEIOPROC)(INT32 nMode, LPFILEIO lpFile, LPVOID lpBuffer, UINT32 nBytes);
typedef BOOL (CALLBACK* TESTEVENTPROC)(LPMSG lpMsg);
typedef BOOL (CALLBACK* TESTRESULTPROC)(HWND hWndOwner, LPSTR lpStr);
typedef INT32 (CALLBACK* SORTCMPPROC)(LPSORTINFO lpSort, LPSTR lpListStr, LPSTR lpFindStr, LPVOID lpInfo);
typedef BOOL (CALLBACK* PROGRESSPROC)(INT64 nTotal, INT64 nCurrent, LPVOID lpInfo);
typedef INT32 (CALLBACK* CUSTOMDRAWPROC)(LPVOID lpDraw);
typedef void (CALLBACK* FASTTIMERPROC)(LPVOID lpParam);
// ListView parancsok
#define LVCMD_DEFAULT			0x0000
#define LVCMD_ICONS				0x7029
#define LVCMD_LIST				0x702b
#define LVCMD_DETAILS			0x702c
#define LVCMD_THUMBS			0x702d
#define LVCMD_TILES				0x702e
// FileTime mdok
#define FT_CREATION				1 
#define FT_LASTACCESS			2
#define FT_LASTWRITE			4

// LoadTextFile mdok
#define LTF_STD					0
#define LTF_ADDCRLF				1
#define LTF_FROMEND				2
#define LTF_SKIPHT				4
#define LTF_SKIPSPC				8
#define LTF_EXTRABUF			0x10
#define ABSMAX_TEXTFILESIZE		100000000
#define ABSMAX_INIFILESIZE		131072

#ifdef NO_INC_WINDOWS
#define FA_READONLY				0x0001
#define FA_HIDDEN				0x0002
#define FA_SYSTEM				0x0004
#define FA_DIRECTORY			0x0010
#define FA_ARCHIVE				0x0020
#define FA_NORMAL				0x0080
#define FA_COMPRESSED			0x0800
#define LPWIN32_FIND_DATA		LPVOID
#else
#define FA_READONLY				FILE_ATTRIBUTE_READONLY
#define FA_HIDDEN				FILE_ATTRIBUTE_HIDDEN
#define FA_SYSTEM				FILE_ATTRIBUTE_SYSTEM
#define FA_DIRECTORY			FILE_ATTRIBUTE_DIRECTORY
#define FA_ARCHIVE				FILE_ATTRIBUTE_ARCHIVE
#define FA_NORMAL				FILE_ATTRIBUTE_NORMAL
#define FA_COMPRESSED			FILE_ATTRIBUTE_COMPRESSED
#define FA_SPECIAL				FILE_ATTRIBUTE_NOT_CONTENT_INDEXED
#endif // NO_INC_WINDOWS
#define FA_MASK					(FA_READONLY | FA_HIDDEN | FA_SYSTEM | FA_DIRECTORY | FA_ARCHIVE | FA_NORMAL | FA_COMPRESSED | FA_SPECIAL)
#define FA_UNKNOWN				~FA_MASK
#define FA_BIGFILE				0x8000


#define CRC16_POLYNOMIAL		0x8005
#define SFV_POLYNOMIAL			0xEDB88320

// WideCharToAnsi modes
#define WCTA_LE					0
#define WCTA_BE					1
#define WCTA_BOM				2
// Byte Order Mark
#define BOM_LE					0xFEFF
#define BOM_BE					0xFFFE

// Number format
#define NF_DEFAULT				0
#define NF_DEC					0
#define NF_HEX					1
#define NF_OCT					2
#define NF_BIN					3
#define NF_AUTO					4
#define NF_ZFILL				0x0004
#define NF_SINGLE				0x0008
#define NF_ZDEC					(NF_ZFILL + NF_DEC)
#define NF_ZHEX					(NF_ZFILL + NF_HEX)
#define NF_ZOCT					(NF_ZFILL + NF_OCT)
#define NF_ZBIN					(NF_ZFILL + NF_BIN)
#define NF_UNSIGNED				0x0010
#define NF_UDEC					(NF_UNSIGNED + NF_DEC)
#define NF_USINGLE				(NF_UNSIGNED + NF_SINGLE)
#define NF_SEP					0x0020
#define NF_CLRZDEC				0x0040
#define NF_ONEZDEC				0x0080
#define NF_UCASE				0x0100
#define NF_PLUSSIGN				0x0200
#define NF_SPCSIGN				0x0400
#define NF_FLOATING				0x0800
#define NF_INT8					0x1000
#define NF_INT16				0x2000
#define NF_INT32				0x4000
#define NF_NOSEPERR				0x8000
#define NF_NEGATIVE				0x80000000					// for internal use

#define PERFORMANCE_UFACTOR		1000000
#define PERFORMANCE_MFACTOR		1000

#pragma pack(push, 1)

typedef struct tagCHAIN	CHAIN, *LPCHAIN;
typedef struct tagCHAIN {
	LPCHAIN					pNext;
	UINT32					nID;
} CHAIN, *LPCHAIN;

typedef struct tagMD5INFOTABLE {
	INT32					nFlags;
	INT32					nInpBytes;
	INT64					nTotal;
	UINT32					nCRC[4];
	char					cInpBuf[128];
	UINT16					nRotate[64];
	UINT32					nPolynom[64];
} MD5INFOTABLE, *LPMD5INFOTABLE;

typedef struct tagSORTINFO {
	LPINT32					pOffset;
	LPSTR					pString;
	INT32					nMaxCnt;
	INT32					nCount;
	INT32					nMaxSize;
	INT32					nActSize;
	INT32					nInfoSize;
	INT32					nMode;
	union {
		INT32				nData;
		LPVOID				pData;
	};
	SORTCMPPROC				pCmpProc;
} SORTINFO, *LPSORTINFO;

typedef struct tagFILEIO {
	HANDLE					hFile;
	INT32					nErr;
	FILEIOPROC				pIOProc;
	union {
		LPVOID				pUser;
		UINT32				nUser;
	};
	union {
		struct {
			UINT32			nSizeLo;
			UINT32			nSizeHi;
		};
		UINT64				nSize;
	};
	union {
		struct {
			UINT32			nPosLo;
			UINT32			nPosHi;
		};
		UINT64				nPos;
	};
	char					cName[1];				// for terminating 0. variable length
} FILEIO, *LPFILEIO;

typedef struct tagFILEINFO {
	SYSTEMTIME				Time;
		union {
	INT64					nSize;
			struct {	
	INT32					nSizeLo;
	INT32					nSizeHi;
			};
		};
	INT32					nIOErr;
	INT32					nAttr;
	INT32					nType;
	INT32					nVersion;
	INT32					nState;
	INT32					nDirID;
	INT32					nImage;
	INT32					nFlags;
	INT32					nCount;
	INT32					nUser;
	LPVOID					pUser;
} FILEINFO, *LPFILEINFO;

typedef union tagANYPOINTER {
	LPVOID					pVoid;
	LPSTR					pStr;
	LPBOOL16				pBool16;
	LPBOOL					pBool;
	LPINT8					pI8;
	LPUINT8					pU8;
	LPINT16					pI16;
	LPUINT16				pU16;
	LPINT32					pI32;
	LPUINT32				pU32;
	LPINT64					pI64;
	LPUINT64				pU64;
	LPFLOAT					pFlt;
	LPDOUBLE				pDbl;
	LPSYSTEMTIME			pTime;
	LPRECT					pRect;
} ANYPOINTER, *LPANYPOINTER;

typedef union tagANYVALUE {
	INT8					aI8[8];
	UINT8					aU8[8];
	INT16					aI16[4];
	UINT16					aU16[4];
	INT32					aI32[2];
	UINT32					aU32[2];
	struct {
		INT8				i8lo;
		INT8				i8hi;
	};
	struct {
		UINT8				u8lo;
		UINT8				u8hi;
	};
	struct {
		INT16				i16lo;
		INT16				i16hi;
	};
	struct {
		UINT16				u16lo;
		UINT16				u16hi;
	};
	struct {
		INT32				i32lo;
		INT32				i32hi;
	};
	struct {
		UINT32				u32lo;
		UINT32				u32hi;
	};
	char					c;
	INT8					i8;
	UINT8					u8;
	INT16					i16;
	UINT16					u16;
	BOOL					b;
	INT32					i32;
	UINT32					u32;
	INT64					i64;
	UINT64					u64;
	LONG					l;
	float					f;
	double					d;
	ANYPOINTER				p;
} ANYVALUE, *LPANYVALUE;

typedef union tagLARGEINT {
	struct {
		INT32				i32lo;
		INT32				i32hi;
	};
	struct {
		UINT32				u32lo;
		UINT32				u32hi;
	};
	INT64					i64;
	UINT64					u64;
} LARGEINT, *LPLARGEINT;

typedef struct tagEDITWIN {
	HWND					hParent;
	HWND					hEdit;
	HANDLE					hThread;
	INT32					nMaxLen;
	INT32					nActLen;
	INT32					nChkLen;
	INT32					nMaxLine;
	INT32					nActLine;
	INT32					nChkLine;
	INT32					nIdx;
	INT32					nLineTbl[3];
	INT32					nSizeTbl[3];
} EDITWIN, *LPEDITWIN;

#define MAX_PCNAMESIZE		24
#define MAX_USERNAMESIZE	24
#define MAX_DOMAINNAMESIZE	16

typedef struct tagUSERINFO {
	char					cPCName[MAX_PCNAMESIZE];
	char					cUserName[MAX_USERNAMESIZE];
	char					cDomainName[MAX_DOMAINNAMESIZE];
} USERINFO, *LPUSERINFO;

typedef struct tagRINGBUFFER {
	INT32 volatile			nRdIdx;
	INT32 volatile			nWrIdx;
	INT32					nUnit;
	INT32					nMaxCnt;
	ANYPOINTER				pBuf;
} RINGBUFFER, *LPRINGBUFFER;

#pragma pack(pop)

#define xor(a, b)		(((a) && (!(b))) || ((!(a)) && (b)))
#define eqv(a, b)		(((a) && (b)) || ((!(a)) && (!(b))))

extern SYSTEMTIME			g_SysTime;

#define SLI_DECPOINT		1
#define SLI_SEPARATOR		2
#define SLI_DATEFORMAT		4
#define SLI_GLOBAL			0x80

UINT32 __cdecl SetLocInfo(INT32 nFlags, ...);
// **********************************************************************************
INT32 __stdcall IntStr(LPSTR lpResult, INT64 nVal, INT32 nMode, INT32 nDec, INT32 nLen);
INT32 __stdcall FltStr(LPSTR lpResult, double fVal, INT32 nMode, INT32 nDec, INT32 nLen);
INT32 __stdcall _StrPrint(LPSTR lpBuf, LPSTR lpFormat, va_list ArgPtr);
INT32 __cdecl StrPrint(LPSTR lpBuf, LPSTR lpFormat, ...);
INT32 __cdecl DbgStrPrint(LPSTR lpFormat, ...);
INT64 __stdcall IntVal(LPSTR lpString, INT32 nMode, INT32 nDec, LPINT32 lpScan);
double __stdcall FltVal(LPSTR lpString, INT32 nMode, LPINT32 lpScan);
double __stdcall FltRound(double fVal, INT32 nDec);
UINT32 __stdcall StrToIP(LPSTR lpStr, UINT32 nDef);
// **********************************************************************************
// *** align.asm
LPVOID __stdcall AlignPtr2(LPVOID lpIn);
INT32 __stdcall AlignLen2(INT32 nLen);
LPVOID __stdcall AlignPtr4(LPVOID lpIn);
INT32 __stdcall AlignLen4(INT32 nLen);
LPVOID __stdcall AlignPtr8(LPVOID lpIn);
INT32 __stdcall AlignLen8(INT32 nLen);
LPVOID __stdcall AlignPtr16(LPVOID lpIn);
INT32 __stdcall AlignLen16(INT32 nLen);
// **********************************************************************************
// simple math functions
INT32 __stdcall IntLog2(UINT32 nValue);
INT32 __stdcall IntPow(INT32 x, UINT32 y);
INT32 __stdcall IntMulDiv(INT32 nNumber, INT32 nMultiplier, INT32 nDivider);
INT32 __stdcall IntDivMul(INT32 nNumber, INT32 nDivider, INT32 nMultiplier);
INT32 __stdcall AbsInt32(INT32 nVal);
UINT32 __stdcall GCD(UINT32 numA, UINT32 numB);
double __stdcall AbsDbl(double fVal);
BOOL __stdcall QuasiEqual(double fValA, double fValB, double fRelDlt);
void __stdcall SplitInt32(INT32 iParam, LPINT32 lpLo, LPINT32 lpHi);
BOOL __stdcall GetBit(LPVOID lpBuf, INT32 nBit);
BOOL __stdcall SetBit(LPVOID lpBuf, INT32 nBit, INT32 nValue);
INT32 __stdcall ScanBits(LPVOID lpBuf, INT32 nDWCnt);
UINT32 __stdcall ByteSwap16(UINT32 nVal);
INT32 __stdcall SByteSwap16(UINT32 nVal);
UINT32 __stdcall ByteSwap32(UINT32 nVal);
UINT32 __stdcall ByteSwap32Ptr(LPVOID lpVal);
INT32 __stdcall ByteToBCD(INT32 nValue);
INT32 __stdcall BCDToByte(INT32 nValue);
// **********************************************************************************
// *** dlgfile.c
BOOL __stdcall SaveFileDlg(HWND hWndOwner, LPSTR lpTitle, LPSTR lpFileName, LPSTR lpInitDir,
							LPSTR lpFilter, LPSTR lpDefExt, UINT32 dwFlags, UINT32 dwLVCmd, TESTRESULTPROC TestResult);
BOOL __stdcall OpenFileDlg(HWND hWndOwner, LPSTR lpTitle, LPSTR lpFileName, LPSTR lpInitDir,
							LPSTR lpFilter, LPSTR lpDefExt, UINT32 dwFlags, UINT32 dwLVCmd, TESTRESULTPROC TestResult);
BOOL __stdcall MultiOpenDlg(HWND hWndOwner, LPSTR lpTitle, LPSTR lpFileList, INT32 nSize, LPSTR lpInitDir,
							LPSTR lpFilter, LPSTR lpDefExt, UINT32 dwFlags, UINT32 dwLVCmd, TESTRESULTPROC TestResult);
// **********************************************************************************
// *** dlgfolder.c
BOOL __stdcall BrowseFolderDlg(HWND hWndOwner, LPSTR lpTitle, LPSTR lpFolder,
						LPSTR lpRoot, BOOL bNewStyle, BOOL bEditBox);
// **********************************************************************************
INT32 __stdcall GetRootDir(LPSTR lpRoot, LPSTR lpPath);
BOOL __stdcall CreateFolder(LPSTR lpFolder, LPINT32 lpError);
INT32 __stdcall GetSpecialFolder(INT32 nFolder, LPSTR lpFolder);
BOOL __stdcall PathExists(LPSTR lpPath);
BOOL __stdcall PathExistsX(LPSTR lpPath);
INT32 __stdcall FormatFolder(LPSTR lpPath, BOOL bAddBackSlash);
INT32 __stdcall CheckFolderName(LPSTR lpPath);
INT32 __stdcall CheckFileName(LPSTR lpPath);
INT32 __stdcall FExpand(LPSTR lpDstName, LPSTR lpSrcName, LPSTR lpDefDir, BOOL bFromPC);
BOOL __stdcall FNameMask(LPSTR lpFileName, LPSTR lpMask);
INT32 __stdcall FNameCmp(LPSTR lpStr1, LPSTR lpStr2);
INT32 __stdcall TrueName(LPSTR lpTrueName, INT32 nSize, LPSTR lpShareName, BOOL bLocalOnly);
INT32 __stdcall ReplaceIpToServer(LPSTR lpPath, LPSTR lpServer, LPSTR lpIP);
// **********************************************************************************
// *** centerwindow.c
void __stdcall CenterWindow(HWND hWndChild, HWND hWndParent);
// **********************************************************************************
BOOL __stdcall LeapYear(INT32 nYear);
INT32 __stdcall GetDayOfWeek(UINT16 nYear, UINT8 nMonth, UINT8 nDay);
INT32 __stdcall GetDaysOfMonth(INT32 nYear, INT32 nMonth);
INT32 __stdcall DateToDay(INT32 nStrtYear, LPSYSTEMTIME lpDate);
void __stdcall DayToDate(INT32 nDay, INT32 nStrtYear, LPSYSTEMTIME lpDate);
INT32 __stdcall TimeToMilliSec(INT32 nDay, LPSYSTEMTIME lpSysTime);
void __stdcall MilliSecToTime(INT32 nMilliSec, LPSYSTEMTIME lpTime);
INT32 __stdcall TimeToSec(LPSYSTEMTIME lpTime);
void __stdcall SecToTime(INT32 nSec, LPSYSTEMTIME lpTime);
double __stdcall SysTimeToVBDate(LPSYSTEMTIME lpSysTime);
void __stdcall VBDateToSysTime(double vbDate, LPSYSTEMTIME lpSysTime);
BOOL __stdcall DateValid(LPSYSTEMTIME lpDate);
INT32 __stdcall GetLastSunday(INT32 nStrtYear, INT32 nActYear, INT32 nMonth);
void __stdcall NextDay(LPSYSTEMTIME lpSysTime);
void __stdcall PrevDay(LPSYSTEMTIME lpSysTime);
// **********************************************************************************
void __stdcall WaitForZero(LPVOID lpAnyInt, UINT32 nTimeOut);
BOOL __stdcall DoEvents(LPVOID lpAnyInt, UINT32 nTimeOut, TESTEVENTPROC TestEvent);
void __stdcall ProcessMessage(LPMSG lpMsg);
INT32 __stdcall MessageLoop(LPBOOL lpErr);
// **********************************************************************************
// *** files
UINT32 __stdcall GetFAttr(LPSTR lpFileName, LPINT32 lpError);
UINT32 __stdcall GetFAttrX(LPSTR lpFileName, LPINT32 lpError);
BOOL __stdcall FileExists(LPSTR lpFileName, BOOL bNonZero);
BOOL __stdcall FileExistsX(LPSTR lpFileName, BOOL bNonZero);
BOOL __stdcall FolderExists(LPSTR lpFolderName);
BOOL __stdcall FolderExistsX(LPSTR lpFolderName);
INT64 __stdcall GetFSize(LPSTR lpFileName, LPINT32 lpError);
INT32 __stdcall GetFTime(LPSTR lpFileName, INT32 nMode, LPSYSTEMTIME lpFileTime);
INT32 __stdcall GetFInfo(LPSTR lpFileName, LPFILEINFO lpFileInfo);
INT32 __stdcall GetFInfoX(LPSTR lpFileName, LPFILEINFO lpFileInfo);
INT32 __stdcall FDelete(LPSTR lpFileName, BOOL bAlways);
INT32 __stdcall FDeleteX(LPSTR lpFileName, BOOL bAlways);
INT32 __stdcall FRename(LPSTR lpSrcFile, LPSTR lpDstFile, BOOL bAlways);
INT32 __stdcall FRenameX(LPSTR lpSrcFile, LPSTR lpDstFile, BOOL bAlways);
LPFILEIO __stdcall FOpen(LPSTR lpFileName, INT32 nMode, FILEIOPROC FileIOProc);
LPFILEIO __stdcall FOpenX(LPSTR lpFileName, INT32 nMode, FILEIOPROC FileIOProc);
INT32 __stdcall FClose(LPFILEIO lpFile);
INT32 __stdcall FCloseEx(LPFILEIO *lpFile);
UINT32 __stdcall FRead(LPFILEIO lpFile, LPVOID lpBuffer, UINT32 nNumberOfBytesToRead);
char __stdcall FGetCh(LPFILEIO lpFile);
UINT32 __stdcall FSkip(LPFILEIO lpFile, UINT32 nNumberOfBytesToSkip);
UINT32 __stdcall FWrite(LPFILEIO lpFile, LPVOID lpBuffer, UINT32 nNumberOfBytesToWrite);
UINT64 __stdcall FSize(LPFILEIO lpFile);
UINT64 __stdcall FSeek(LPFILEIO lpFile, INT64 nMove, UINT32 nMode);
INT32 __stdcall FGetTime(LPFILEIO lpFile, INT32 nMode, LPSYSTEMTIME lpFileTime);
INT32 __stdcall FSetTime(LPFILEIO lpFile, INT32 nMode, LPSYSTEMTIME lpFileTime);
INT32 __stdcall FTruncate(LPFILEIO lpFile);
INT32 __stdcall FCopy(LPSTR lpDstName, LPSTR lpSrcName, LPSYSTEMTIME lpTime, LPVOID lpInfo, PROGRESSPROC lpProgress, LPINT32 lpErr);
LPSTR __stdcall LoadTextFile(LPSTR lpFileName, INT32 nFlags, INT32 nMaxLen, LPINT32 lpRdLen);
INT32 __stdcall SaveTextFile(LPSTR lpFileName, LPSTR lpBuf, INT32 nSize, LPSYSTEMTIME lpFTime);
INT32 __stdcall FAppendText(LPSTR lpFileName, LPSTR lpBuf, INT32 nSize);
INT32 __stdcall LoadBinFile(LPSTR lpFileName, INT32 nMinSize, INT32 nMaxSize, BOOL bAlloc, LPVOID *lpBuf, LPINT32 lpError);
INT32 __stdcall GetShortPathNameX(LPSTR lpLongName, LPSTR lpShortName, INT32 nMaxLen);
HANDLE __stdcall FindFirstFileX(LPSTR lpFolder, LPSTR lpMask, LPWIN32_FIND_DATA lpFD);
LPSTR __stdcall GetFindFileName(LPSTR lpFolder, LPWIN32_FIND_DATA lpFD);
// **********************************************************************************
// *** inifiles
INT32 __stdcall StrToInt(LPSTR lpStr, INT32 nMin, INT32 nMax, INT32 nDef);
double __stdcall StrToFlt(LPSTR lpStr, double fMin, double fMax, double fDef);
void __stdcall GetIniFile(LPSTR lpIniFile);
void __stdcall GetIniFiles(LPSTR lpGlobalIni, LPSTR lpLocalFolder, LPSTR lpLocalIni);
INT32 __stdcall GetIniFileStr(LPSTR lpFile, LPSTR lpSect, LPSTR lpKey, LPSTR lpResult, INT32 nSize, LPSTR lpDefault);
INT32 __stdcall GetIniFileInt(LPSTR lpFile, LPSTR lpSect, LPSTR lpKey, INT32 nMin, INT32 nMax, INT32 nDef);
float __stdcall GetIniFileFlt(LPSTR lpFile, LPSTR lpSect, LPSTR lpKey, float fMin, float fMax, float fDef);
INT32 __stdcall GetIniFileFolder(LPSTR lpFile, LPSTR lpSect, LPSTR lpKey, LPSTR lpResult, INT32 nSize, LPSTR lpDefault, INT32 nFlags);
INT32 __stdcall GetIniFileSection(LPSTR lpFile, LPSTR lpSect, LPSTR lpResult, INT32 nSize);
INT32 __stdcall GetIniBufStr(LPSTR lpIniBuf, LPSTR lpSect, LPSTR lpKey, LPSTR lpResult, INT32 nSize, LPSTR lpDefault);
INT32 __stdcall GetIniBufInt(LPSTR lpIniBuf, LPSTR lpSect, LPSTR lpKey, INT32 nMin, INT32 nMax, INT32 nDef);
UINT32 __stdcall GetIniBufIP(LPSTR lpIniBuf, LPSTR lpSect, LPSTR lpKey, UINT32 nDef);
float __stdcall GetIniBufFlt(LPSTR lpIniBuf, LPSTR lpSect, LPSTR lpKey, float fMin, float fMax, float fDef);
INT32 __stdcall GetIniBufFolder(LPSTR lpIniBuf, LPSTR lpSect, LPSTR lpKey, LPSTR lpResult, INT32 nSize, LPSTR lpDefault, INT32 nFlags);
INT32 __stdcall GetIniBufSection(LPSTR lpIniBuf, LPSTR lpSect, LPSTR lpResult, INT32 nSize);
void __stdcall SetIniFileStr(LPSTR lpFile, LPSTR lpSect, LPSTR lpKey, LPSTR lpValue);
void __stdcall SetIniFileInt(LPSTR lpFile, LPSTR lpSect, LPSTR lpKey, INT32 nValue);
void __stdcall SetIniFileFlt(LPSTR lpFile, LPSTR lpSect, LPSTR lpKey, float fValue, INT32 nDec);
INT32 __stdcall SetIniBufStr(LPSTR *lpIniBuf, LPSTR lpSect, LPSTR lpKey, LPSTR lpValue);
INT32 __stdcall SetIniBufInt(LPSTR *lpIniBuf, LPSTR lpSect, LPSTR lpKey, INT32 nValue);
INT32 __stdcall SetIniBufFlt(LPSTR *lpIniBuf, LPSTR lpSect, LPSTR lpKey, float fValue, INT32 nDec);
INT32 __stdcall SetIniBufComment(LPSTR *lpIniBuf, LPSTR lpSect, LPSTR lpKey, LPSTR lpComment);
// **********************************************************************************
// *** measuretext.c
INT32 __stdcall MeasureText(HDC hDC, HWND hWnd, HFONT hFont, LPSTR lpStr, LPRECT lpRect, BOOL bPrefix);
// **********************************************************************************
// *** memory
INT32 __stdcall MemCmp(LPVOID lpMem1, LPVOID lpMem2, INT32 nSize);
LPSTR __stdcall NewStr(LPSTR lpStr, INT32 nLen);
BOOL __stdcall GrowMem(LPVOID *lpBuf, LPINT32 lpMaxSize, INT32 nCurSize, INT32 nReqSize);
void __stdcall MemFill32(LPVOID lpMem, INT32 nFill, INT32 nCount);
// **********************************************************************************
// *** performace.asm
void __stdcall PerformanceStart(LPINT64 lpStart);
INT64 __stdcall PerformanceStop(LPINT64 lpStart, BOOL bMilliSec);
// **********************************************************************************
// *** md5.asm
void __stdcall MD5_Init(LPMD5INFOTABLE lpMD5Table);
// MD5 calculation with mmx only
void __stdcall MD5_Calc(LPMD5INFOTABLE lpMD5Table, void *lpBuffer, INT32 ByteCnt);
void __stdcall MD5_Done(LPMD5INFOTABLE lpMD5Table, LPVOID lpCRC, BOOL bHex);
// MD5 calculation without mmx
void __stdcall MD5_Calc_Any(LPMD5INFOTABLE lpMD5Table, void *lpBuffer, INT32 ByteCnt);
void __stdcall MD5_Done_Any(LPMD5INFOTABLE lpMD5Table, LPVOID lpCRC, BOOL bHex);
// **********************************************************************************
// *** sfv.asm
void __stdcall Sfv_Init(INT32 nMagic, LPUINT32 lpTable);
void __stdcall Sfv_Calc(LPVOID lpBuffer, INT32 ByteCnt, LPUINT32 lpCRC);
UINT32 __stdcall Sfv_Done(LPUINT32 lpCRC, LPSTR lpCRCStr);
void __stdcall Crc_Init(LPVOID lpCrcTable, INT32 nBits, BOOL bReflect, UINT32 nMagic);
void __stdcall Crc8_Calc(LPUINT8 lpCrc, LPUINT8 lpCrcTable, void *lpBuffer, INT32 nByteCnt);
void __stdcall Crc16_CalcStd(LPUINT16 lpCrc, LPUINT16 lpCrcTable, void *lpBuffer, INT32 nByteCnt);
void __stdcall Crc16_CalcRev(LPUINT16 lpCrc, LPUINT16 lpCrcTable, void *lpBuffer, INT32 nByteCnt);
// **********************************************************************************
// *** progress.c
LPVOID __stdcall ProgressClose(LPPROGRESSINFO lpPI);
LPPROGRESSINFO __stdcall ProgressOpen(HWND hWndOwner, INT32 nFontSize, LPSTR lpFontName, LPSTR lpTitle,
										LPSTR lpCancel, LPBOOL lpbCancel, INT32 nFlags, INT32 nRound0, INT32 nProgressWidth);
BOOL __stdcall ProgressSetText(LPPROGRESSINFO lpPI, INT32 nIndex, INT32 nMode, LPSTR lpText);
BOOL __stdcall ProgressSetValue(LPPROGRESSINFO lpPI, INT32 nIndex, float fValue);
BOOL __stdcall ProgressSetColor(LPPROGRESSINFO lpPI, COLORREF crBack, COLORREF crText, COLORREF crSelBack, COLORREF crSelText);
INT32 __stdcall ProgressSetTickDelta(LPPROGRESSINFO lpPI, INT32 nDelta);
// **********************************************************************************
// *** rstutils.c
BOOL __stdcall ReStartExists(LPSTR lpReStart);
BOOL __stdcall DoReStart(LPSTR lpCmdLine);
BOOL __stdcall TestReStart(LPSTR lpCmdLine);
// **********************************************************************************
// *** strings.c
char __stdcall ChrLwr(char c);
char __stdcall ChrUpr(char c);
INT32 __stdcall StrLwr(LPSTR lpStr);
INT32 __stdcall StrUpr(LPSTR lpStr);
INT32 __stdcall StrCat(LPSTR lpDst, LPSTR lpSrc);
INT32 __stdcall StrCatN(LPSTR lpDst, LPSTR lpSrc, INT32 nMax);
INT32 __stdcall StrFill(LPSTR lpDst, char c, INT32 nCount);
INT32 __stdcall ChrCpyN(LPSTR lpDst, LPSTR lpSrc, INT32 nMax);
INT32 __stdcall TrimCpy(LPSTR lpDst, LPSTR lpSrc, INT32 nMode);
INT32 __stdcall TrimCpyN(LPSTR lpDst, LPSTR lpSrc, INT32 nMax, INT32 nMode);
INT32 __stdcall TrimStr(LPSTR lpStr, INT32 nMode);
INT32 __stdcall StrXCpy(LPSTR lpDst, LPSTR lpCpy, LPSTR lpCat);
INT32 __cdecl MultiCat(LPSTR lpDst, LPSTR lpCpy, LPSTR lpCat, ...);
INT32 __cdecl MultiCatN(INT32 nMax, LPSTR lpDst, LPSTR lpCpy, LPSTR lpCat, ...);
INT32 __cdecl StrCmp(LPSTR lpStr1, LPSTR lpStr2);
INT32 __stdcall StrICmp(LPSTR lpStr1, LPSTR lpStr2);
INT32 __stdcall StrInStr(LPSTR lpStr, LPSTR lpSrch, INT32 nPos, BOOL bText);
INT32 __stdcall StrInStrRev(LPSTR lpStr, LPSTR lpSrch, INT32 nPos, BOOL bText);
INT32 __stdcall ChrInStr(LPSTR lpStr, char cSrch, INT32 nPos, INT32 nMax, BOOL bText);
INT32 __stdcall ChrInStrRev(LPSTR lpStr, char cSrch, INT32 nPos, BOOL bText);
INT32 __stdcall StrLines(LPSTR lpStr, LPINT32 lpLen);
INT32 __stdcall FormatInt(LPSTR lpIntStr, INT32 nGrp, char cSep);
INT32 __stdcall WStrSwap(LPWSTR lpwStr, INT32 nMax);
INT32 __stdcall StrLenX(LPSTR lpStr, INT32 nMax);
INT32 __stdcall WStrLenX(LPWSTR lpwStr, INT32 nMax);
INT32 __stdcall WStrCpy(LPWSTR lpwDst, LPWSTR lpwSrc);
INT32 __stdcall WStrCpyN(LPWSTR lpwDst, LPWSTR lpwSrc, INT32 nMax);
INT32 __stdcall WStrCmp(LPWSTR lpwStr1, LPWSTR lpwStr2);
INT32 __stdcall AnsiToUtf8(LPSTR lpDst, INT32 nMaxDst, LPSTR lpSrc, INT32 nMaxSrc, LPINT32 lpSrcSize);
INT32 __stdcall Utf8ToAnsi(LPSTR lpDst, INT32 nMaxDst, LPSTR lpSrc, INT32 nMaxSrc, LPINT32 lpSrcSize);
INT32 __stdcall AnsiToWideChar(LPWSTR lpDst, LPSTR lpSrc, INT32 nMaxLen, INT32 nMode);
INT32 __stdcall WideCharToAnsi(LPSTR lpDst, INT32 nMaxDst, LPWSTR lpwSrc, INT32 nMaxSrc, INT32 nMode, LPINT32 lpSrcSize);

INT32 __stdcall StrFromRes(LPSTR lpDst, LPSTR lpSrc, INT32 nDstSize);
LPSTR __stdcall GetParamStrA(LPSTR lpDst, LPSTR lpCmdLine, INT32 nDstSize, LPINT32 lpLen);
LPWSTR __stdcall GetParamStrW(LPWSTR lpDst, LPWSTR lpCmdLine, INT32 nDstSize, LPINT32 lpLen);
#ifdef UNICODE
#define GetParamStr	GetParamStrW
#else
#define GetParamStr	GetParamStrA
#endif

void __stdcall GetSysTime(LPSYSTEMTIME lpSysTime);
void __stdcall CpySysTime(LPSYSTEMTIME lpSysTime);
BOOL __stdcall GetTime(LPSYSTEMTIME lpSysTime);
void __stdcall LocalTimeToGMT(LPSYSTEMTIME lpLocal, LPSYSTEMTIME lpGMT);
void __stdcall GMTToLocalTime(LPSYSTEMTIME lpGMT, LPSYSTEMTIME lpLocal);
BOOL __stdcall DayLightSec(INT32 nStartYear, UINT32 nSec);
void __stdcall GMTSecToLocalTime(UINT32 nGMTSec, INT32 nStartYear, INT32 nDeltaHour, BOOL bDayLight, LPSYSTEMTIME lpLocal);
UINT32 __stdcall LocalTimeToGMTSec(INT32 nStartYear, INT32 nDeltaHour, BOOL bDayLight, LPSYSTEMTIME lpLocal);
INT32 __stdcall GetTimeStr(BOOL bGetTime, BOOL bFull, INT32 nMSec, LPSYSTEMTIME lpSysTime, INT32 nHT, LPSTR lpBuf);
INT32 __stdcall GetTimeStrWidth(HWND hStatus, BOOL bFull, INT32 nMSec, INT32 nXChar);
INT32 __stdcall FSplit(BOOL bBackslash, LPSTR lpFolder, LPSTR lpName, LPSTR lpPath);
INT32 __stdcall FNameSplit(LPSTR lpName, LPSTR lpExt, LPSTR lpFileName);
INT32 __stdcall ReplaceExt(LPSTR lpPath, LPSTR lpExt);
// **********************************************************************************
// *** utils.c
void __stdcall DeleteObjectEx(LPVOID *lpHandle);
void __stdcall CloseHandleEx(LPVOID *lpHandle);
void __stdcall GetWorkArea(LPRECT lpRect, BOOL bSize);
void __stdcall FillRectEx(HDC hDC, LPRECT lpRect, COLORREF crColor);
HBITMAP __stdcall DuplicateBitmap(HDC hDC, HBITMAP hSrcBmp, COLORREF crBkGr,
									INT32 nWidth, INT32 nHeight, INT32 nSrcX, INT32 nSrcY, BOOL bStretch);
INT32 __stdcall GetWindowSize(HWND hWnd, LPRECT rRect);
INT32 __stdcall GetWindowHeight(HWND hWnd, INT32 nChildID);
INT32 __stdcall GetWindowWidth(HWND hWnd, INT32 nChildID);
BOOL __stdcall GetClientSize(HWND hWnd, LPRECT lpRect);
void __stdcall GetBorderSize(HWND hWnd, LPINT32 lpToolHeight, LPINT32 lpStatusHeight, LPINT32 lpWidth, LPINT32 lpHeight);
BOOL __stdcall GetViewRect(HWND hWnd, LPINT32 lpToolHeight, LPINT32 lpStatusHeight, LPRECT lpView);
float __stdcall GetPercent(float fAct, float fMin, float fMax);
void __stdcall UpdateDlgWindow(HWND hWnd, INT32 nItem, BOOL bErase);
void __stdcall EnableDlgItem(HWND hDlg, INT32 nItem, BOOL bEnable);
void __stdcall ShowDlgItem(HWND hDlg, INT32 nItem, INT32 nShow);
BOOL __stdcall CreateSimpleProcess(LPSTR lpProgram, LPSTR lpParam);
BOOL __stdcall RegisterWndClass(WNDPROC lpWndProc, LPSTR lpClass, INT32 nIcon, INT32 nMenu, INT32 nBkGr, INT32 nExtraBytes);

extern BOOL						g_bComCtl_V6;
BOOL __stdcall CommCtrl_Init(INT32 nMode);

void __stdcall FillComboFromStr(HWND hDlg, INT32 nCombo, LPSTR lpBuf[], INT32 nItemCnt, INT32 nSelected, BOOL bClr);
void __stdcall FillComboFromRes(HWND hDlg, INT32 nCombo, INT32 nIDFirst, INT32 nIDLast, INT32 nSelected, BOOL bClr);
void __stdcall FillComboFromResList(HWND hDlg, INT32 nCombo, INT32 nCount, INT32 nIDList[], INT32 nSelected, BOOL bClr);
BOOL __stdcall PrevInstanceExists(BOOL bShow, BOOL bClassOnly, INT32 nIDClass, INT32 nClassSize, LPSTR lpClass, INT32 nIDTitle, INT32 nTitleSize, LPSTR lpTitle);
void __stdcall SetMinMaxInfo(HWND hMain, UINT32 nMinW, UINT32 nMinH, UINT32 nMaxW, UINT32 nMaxH,
								LPINT32 lpToolHeight, LPINT32 lpStatusHeight, LPMINMAXINFO lpMinMax);
UINT32 __stdcall FindProcess(UINT32 nOwnID, LPSTR lpProcessName, LPHANDLE lpHandle);
BOOL __stdcall KillProcess_Start(UINT32 nTimeOut);
void __cdecl KillProcess_Break();
// **********************************************************************************
INT32 __stdcall StrToDate(LPSTR lpBuf, LPSYSTEMTIME lpDate);
INT32 __stdcall StrToTime(LPSTR lpBuf, LPSYSTEMTIME lpTime);
// **********************************************************************************
void __stdcall GetUserInfo(LPUSERINFO lpUserInfo);
// **********************************************************************************
// *** strsort.c
BOOL __stdcall Sort_Init(LPSORTINFO lpSort, INT32 nBufSize, INT32 nMaxCnt, INT32 nXInfoSize, SORTCMPPROC CmpProc);
void __stdcall Sort_Done(LPSORTINFO lpSort);
void __stdcall Sort_Copy(LPSORTINFO lpDst, LPSORTINFO lpSrc, BOOL bDone, BOOL bRearrange);
INT32 __stdcall Sort_Add(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, BOOL bText, INT32 nDouble);
INT32 __stdcall Sort_Find(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, BOOL bText, LPINT32 lpLast);
INT32 __stdcall Sort_FindPos(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, BOOL bText);
LPSTR __stdcall Sort_Item(LPSORTINFO lpSort, INT32 nIndex);
void __stdcall Sort_Clear(LPSORTINFO lpSort);
void __stdcall Sort_Del(LPSORTINFO lpSort, INT32 nIndex);
void __stdcall Sort_Finish(LPSORTINFO lpSort);
INT32 __stdcall List_Append(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo);
INT32 __stdcall List_Add(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, INT32 nPos);
// *** filesort.c
BOOL __stdcall FSort_Init(LPSORTINFO lpSort);
INT32 __stdcall FSort_Fill(LPSORTINFO lpSort, LPSTR lpFolder, LPSTR lpMask, BOOL bFolder, BOOL bParent);
// **********************************************************************************
// *** dllversion.c
BOOL __stdcall GetDllVersion(LPSTR lpDllName, LPINT32 lpMajor, LPINT32 lpMinor);
// **********************************************************************************
// *** lvhdrsortimg.c
void __stdcall LV_SetHdrSortImage(HINSTANCE hInst, HWND hWnd, BOOL bComCtl6, INT32 nColIdx, INT32 nMode, INT32 nUpArrowID);
// **********************************************************************************
// *** lvcolwidth.c
INT32 __stdcall LV_GetHdrWidth(HWND hWnd, INT32 nColIdx, INT32 nXWidth);
void __stdcall LV_GetHdrsWidth(HWND hWnd, INT32 nXWidth, INT32 nColCnt, LPINT32 lpMinWidth);
void __stdcall LV_SetColWidth(HWND hWnd, INT32 nColIdx, INT32 nHdrWidth);
void __stdcall LV_SetColsWidth(HWND hWnd, INT32 nColCnt, LPINT32 lpMinWidth, LPINT32 lpColWidth);
void __stdcall LV_AddItem(BOOL bInsert, HWND hWnd, LPLVITEM lpLvi, LPINT32 lpStrWidth);
BOOL __stdcall LV_UpdateItem(HWND hWnd, LPLVITEM lpLvi, LPINT32 lpStrWidth, LPINT32 lpColWidth);
// **********************************************************************************
// *** lvparam.c
INT32 __stdcall LV_GetParam(HWND hWnd, INT32 nIndex);
INT32 __stdcall LV_FindParam(HWND hWnd, INT32 nParam);
// **********************************************************************************
// *** lvsubclass.c
BOOL __stdcall LV_SubClass(HWND hWnd, BOOL bClick, CUSTOMDRAWPROC lpDrawProc);
BOOL __stdcall LV_UnSubClass(HWND hWnd);
// **********************************************************************************
HCURSOR __stdcall SetCursorFromHandle(HWND hWnd, HCURSOR hCursor);
HCURSOR __stdcall SetCursorFromResource(HWND hWnd, HINSTANCE hInst, LPCSTR lpCursorName);
// **********************************************************************************
HFONT __stdcall CreateLogFont(HWND hWnd, INT32 nHeight, INT32 nWeight, INT32 nChrSet, LPSTR lpFontName);
// **********************************************************************************
INT32 __stdcall GetTableIndex(LPVOID lpTable, INT32 nSize, INT32 nCount, INT32 nValue);
INT32 __stdcall AboutBox(HWND hOwner, INT32 nDlgID);
BOOL __stdcall ShutdownWindows(BOOL bReboot, BOOL bForce);
// **********************************************************************************
LPEDITWIN __stdcall EditWin_Init(HWND hParent, HWND hEdit, INT32 nMaxLen, INT32 nMaxLine);
void __stdcall EditWin_Clear(LPEDITWIN lpEdit);
void __stdcall EditWin_Write(LPEDITWIN lpEdit, LPSTR lpStr, INT32 nStrLen, BOOL bLocal);
void __stdcall EditWin_Update(LPEDITWIN lpEdit, LPSTR lpStr, BOOL bFreeStr);
void __stdcall EditWin_Done(LPEDITWIN lpEdit);
// **********************************************************************************
BOOL __stdcall DisplayTime(HWND hStatus, BOOL bOwnerdraw, LPINT32 lpPrevSec, LPSYSTEMTIME lpSysTime, LPSTR lpStr);
void __stdcall SimpleTimerProc(HWND hWnd, UINT32 uMsg, UINT32 idEvent, ULONG dwTime);
// **********************************************************************************
BOOL __cdecl COM_Init();
void __stdcall COM_Done(BOOL bInitialized);
// **********************************************************************************
INT32 __stdcall MsgBox(HWND hWndOwner, LPSTR lpTitle, LPSTR lpMsg1, LPSTR lpMsg2, INT32 nMode);
INT32 __stdcall MsgBoxWithTimeOut(HWND hWndOwner, LPSTR lpTitle, LPSTR lpMsg1, LPSTR lpMsg2, INT32 nMode, UINT32 nMilliSec);
extern INT32		g_nPopupWidth;
extern INT32		g_nPopupHeight;
extern INT32		g_nPopupLeft;
extern INT32		g_nPopupTop;
extern BOOL			g_bPopupChecked;
void __stdcall ShowPopupMenu(HWND hWndOwner, INT32 x, INT32 y, LPTPMPARAMS lpTPM, INT32 nCount, INT32 nStrBase, UINT32 nMenuID[]);
void __stdcall PopupMenu_Measure(HWND hDlg, UINT32 lParam);
void __stdcall PopupMenu_Draw(HWND hDlg, UINT32 lParam);
void __stdcall DrawColoredFrameControl(HDC hInDC, INT32 nLeft, INT32 nTop, INT32 nWidth, INT32 nHeight, COLORREF crFG, COLORREF crBG, INT32 nType, INT32 nState);
BOOL __stdcall LB_UnSelect_Init(HWND hDlg, INT32 nListBoxID);
BOOL __stdcall LB_UnSelect_Done(HWND hDlg, INT32 nListBoxID);
// **********************************************************************************
#define RBU_BYTE1		0
#define RBU_BYTE2		1
#define RBU_BYTE4		2
#define RBU_BYTE8		3

BOOL __stdcall RingBuffer_Init(LPRINGBUFFER lpRB, INT32 nCount, INT32 nUnit);
void __stdcall RingBuffer_Done(LPRINGBUFFER lpRB);
void __stdcall RingBuffer_Clear(LPRINGBUFFER lpRB, INT32 nLock);
INT32 __stdcall RingBuffer_Count(LPRINGBUFFER lpRB, INT32 nLock);
INT32 __stdcall RingBuffer_Read(LPRINGBUFFER lpRB, LPVOID lpDst, INT32 nCount, INT32 nLock);
INT32 __stdcall RingBuffer_Write(LPRINGBUFFER lpRB, LPVOID lpSrc, INT32 nCount, INT32 nLock);

// **********************************************************************************
UINT32 __stdcall FastTimer_Init(LPUINT32 lpTimerValue, INT32 nEventBase, HANDLE hEvent, INT32 nProcBase, FASTTIMERPROC lpProc, LPVOID lpParam);
void __stdcall FastTimer_Done(UINT32 nTimer);

// **********************************************************************************
LPVOID __stdcall Chain_AddItem(LPVOID lpItem, LPVOID lpStart);
LPVOID __stdcall Chain_DelItem(UINT32 nID, LPVOID lpStart);
LPVOID __stdcall Chain_GetItem(UINT32 nID, LPVOID lpStart);
UINT32 __stdcall Chain_GetID(LPVOID lpChain);
LPVOID __stdcall Chain_GetNext(LPVOID lpStart);
// **********************************************************************************
extern BOOL						g_bDayLightStart;
extern BOOL						g_bDayLightEnd;
extern BOOL						g_bDayLightActive;

void __stdcall DayLightInit(LPSYSTEMTIME lpSt);
INT32 __stdcall GetSecOfDay(INT32 nCurSec, LPSYSTEMTIME lpSt);
// **********************************************************************************
#define GTS_ENDED		0
#define GTS_ACTIVE		1
#define GTS_BUSY		2
#define GTS_INVALID		3
INT32 __stdcall GetThreadState(HANDLE hThread, HANDLE hEvent, UINT32 nTimeOut);

#if defined(_DEF_SKCLIB_EXTERNC)
}
#undef _DEF_EXTERNC
#undef _DEF_SKCLIB_EXTERNC
#endif

#endif  // _INC_SKCLIB32
