#pragma once
#ifndef _INC_SKLIBCOM
#define _INC_SKLIBCOM

#if defined(__cplusplus) && !defined(_DEF_EXTERNC)
#define _DEF_EXTERNC
#define _DEF_SKLIBCOM_EXTERNC
extern "C" {
#endif

#define STR_COM						"Com"
#define STR_BAUD					"Baud"
#define STR_PARITY					"Parity"
#define STR_NONE					"None"
#define STR_EVEN					"Even"
#define STR_ODD						"Odd"

#define	DATABIT_MIN					5
#define	DATABIT_MAX					8
#define	COMPORT_MIN					1
#define	COMPORT_MAX					9

#pragma pack(push, 1)

#define COM_EVENTSTATE				0
#define COM_EVENTWRITE				1
#define COM_EVENTREAD				2
#define COM_EVENTTEST				3
#define COM_MAXEVENTS				4
#define COM_OUTSIZE					256

typedef struct tagCOMINFO	COMINFO, *LPCOMINFO;

typedef void (CALLBACK* COMEVENTPROC)(LPCOMINFO lpInfo);

typedef struct tagCOMPARS {
	UINT8					nPort;
	UINT8					nDataBits;
	UINT8					nStopBits;
	UINT8					nParity;
	UINT32					nBaudRate;
	union {
		UINT32				nFlags;
	struct {
		UINT32				XOnXOff : 1;
		UINT32				CtsFlow : 1;
		UINT32				DsrFlow : 1;
		UINT32				DsrSens : 1;
		UINT32				DtrCtrl : 2;
		UINT32				RtsCtrl : 2;
	};
	};
} COMPARS, *LPCOMPARS;

#define CSF_ERRBREAK			0x0001
#define CSF_ERRFRAME			0x0002
#define CSF_ERRPARITY			0x0004
#define CSF_ERROVRUN			0x0008
#define CSF_ERRRXOVER			0x0010
#define CSF_ERRLINE				0x0080
#define CSF_ERRMASK				(CSF_ERRBREAK |	CSF_ERRFRAME | CSF_ERRPARITY | CSF_ERROVRUN | CSF_ERRRXOVER)
#define CSF_CTS					0x0100
#define CSF_DSR					0x0200
#define CSF_RING				0x0400
#define CSF_RLSD				0x0800
#define CSF_MODEM				0x8000
#define CSF_MODEMMASK			(CSF_CTS |	CSF_DSR | CSF_RING | CSF_RLSD)

typedef struct tagCOMINFO {
	COMPARS					Params;
	union {
		UINT32				nState;
	struct {
		UINT32				bBreak		: 1;
		UINT32				bFrame		: 1;
		UINT32				bParity		: 1;
		UINT32				bOvRun		: 1;
		UINT32				bRxOver		: 1;
		UINT32				nReserv1	: 2;
		UINT32				bLineErr	: 1;
		UINT32				bCTS		: 1;
		UINT32				bDSR		: 1;
		UINT32				bRing		: 1;
		UINT32				bRLSD		: 1;
		UINT32				nReserv2	: 3;
		UINT32				bModem		: 1;
		UINT32 volatile		bConnected	: 1;
		UINT32 volatile		bSending	: 1;
		UINT32				bReadErr	: 1;
		UINT32				bWriteErr	: 1;
		UINT32				bReadRdy	: 1;
		UINT32				bWriteRdy	: 1;
	};
	};
	HANDLE					hDevice;
	HANDLE volatile			hThread;
	union {
		HANDLE				hEvents[COM_MAXEVENTS];
		struct {
			HANDLE			hEventState;
			HANDLE			hEventWrite;
			HANDLE			hEventRead;
			HANDLE			hEventTest;
		};
	};
	OVERLAPPED				olWrite;
	UINT32					nWritten;
	char					cOutBuf[COM_OUTSIZE];
	COMEVENTPROC			pComProc;
	HWND					hOwner;
	HANDLE					hUserEvent;
	INT32					nError;
	RINGBUFFER				rbRcv;
	RINGBUFFER				rbSnd;
} COMINFO, *LPCOMINFO;

#pragma pack(pop)

#ifndef NO_INC_WINDOWS
LPCOMINFO __stdcall Serial_Init(HWND hOwner, HANDLE hEvent, COMEVENTPROC lpComProc, LPCOMPARS lpComPars, INT32 nInpSize, INT32 nOutSize);
void __stdcall Serial_Done(LPCOMINFO *lpInfo, BOOL bSendBreak);
INT32 __stdcall Serial_Read(LPCOMINFO lpInfo, LPVOID lpBuffer, INT32 nSize);
INT32 __stdcall Serial_Write(LPCOMINFO lpInfo, LPVOID lpBuffer, INT32 nSize);
#endif	// NO_INC_WINDOWS

#if defined(_DEF_SKLIBCOM_EXTERNC)
}
#undef _DEF_EXTERNC
#undef _DEF_SKLIBUDP_EXTERNC
#endif

#endif  // _INC_SKLIBCOM
