#pragma once
#ifndef _INC_SKLIBOPC
#define _INC_SKLIBOPC

#if defined(__cplusplus) && !defined(_DEF_EXTERNC)
#define _DEF_EXTERNC
#define _DEF_SKLIBOPC_EXTERNC
extern "C" {
#endif

#define	OPCERR_NONE					0
#define	OPCERR_NOMEMORY				1
#define	OPCERR_INTERNAL				2
#define	OPCERR_SERVERNONE			3
#define	OPCERR_SERVERSTARTED		4
#define	OPCERR_SERVERSTOPPED		5
#define	OPCERR_GROUPEXISTS			6
#define	OPCERR_GROUPNOTEXISTS		7
#define	OPCERR_ITEMEXISTS			8
#define	OPCERR_ITEMNOTEXISTS		9
#define	OPCERR_UNSUPPORTEDTYPE		10
#define	OPCERR_NOGROUPDEFINED		11
#define	OPCERR_NOITEMDEFINED		12
#define	OPCERR_EMPTYGROUP			13
#define	OPCERR_ITEMUNREADABLE		14
#define	OPCERR_ITEMUNWRITEABLE		15
#define	OPCERR_COINITIALIZE			16
#define	OPCERR_GETCLSID				17
#define	OPCERR_CREATESERVER			18
#define	OPCERR_ADDGROUP				19
#define	OPCERR_ADDITEM				20
#define	OPCERR_GRPSTATEMGT			21
#define	OPCERR_GRPACTIVATE			22
#define	OPCERR_GETSYNCIO			23
#define	OPCERR_GETASYNCIO			24
#define	OPCERR_ADVISE				25
#define	OPCERR_ACTIVATE				26
#define	OPCERR_READFAILED			27
#define	OPCERR_WRITEFAILED			28

#if defined(__opcda_h__)
typedef IOPCServer					*LPIOPCSERVER;
typedef IOPCItemMgt					*LPIOPCITEMMGT;
typedef IOPCGroupStateMgt			*LPIOPCGROUPSSTATEMGT;
typedef IOPCSyncIO					*LPIOPCSYNCIO;
typedef IOPCAsyncIO2				*LPIOPCASYNCIO2;
typedef OPCITEMDEF					*LPOPCITEMDEF;
typedef OPCITEMRESULT				*LPOPCITEMRESULT;
typedef OPCITEMSTATE				*LPOPCITEMSTATE;
typedef OPCSERVERSTATUS				*LPOPCSERVERSTATUS;
typedef OPCHANDLE					*LPOPCHANDLE;
#else
typedef LPVOID						LPIOPCSERVER;
typedef LPVOID						LPIOPCITEMMGT;
typedef LPVOID						LPIOPCGROUPSSTATEMGT;
typedef LPVOID						LPIOPCSYNCIO;
typedef LPVOID						LPIOPCASYNCIO2;
typedef LPVOID						LPOPCITEMDEF;
typedef LPVOID						LPOPCITEMRESULT;
typedef LPVOID						LPOPCSERVERSTATUS;
typedef DWORD						OPCHANDLE, *LPOPCHANDLE;
#endif
#if !defined(__wtypes_h__)
typedef UINT16						VARTYPE;
#define VT_EMPTY					0
#define VT_NULL						1
#define VT_I2						2
#define VT_I4						3
#define VT_R4						4
#define VT_R8						5
#define VT_CY						6
#define VT_DATE						7
#define VT_BSTR						8
#define VT_BOOL						11
#define VT_VARIANT					12
#define VT_DECIMAL					14
#define VT_I1						16
#define VT_UI1						17
#define VT_UI2						18
#define VT_UI4						19
#define VT_I8						20
#define VT_UI8						21
#define VT_INT						22
#define VT_UINT						23
#define VT_VOID						24
#define VT_HRESULT					25
#define VT_PTR						26
#define VT_LPSTR					30
#define VT_LPWSTR					31
#endif

#define VTC_MIN						0
#define VTC_BOOL					0
#define VTC_INT32					1
#define VTC_UINT32					2
#define VTC_INT64					3
#define VTC_UINT64					4
#define VTC_DOUBLE					5
#define VTC_STR						6
#define VTC_WSTR					7
#define VTC_MAX						7

typedef HRESULT						*LPHRESULT;
typedef struct tagOPCSERVER			OPCSERVER, *LPOPCSERVER;
typedef struct tagOPCGROUP			OPCGROUP, *LPOPCGROUP;
typedef struct tagOPCITEM			OPCITEM, *LPOPCITEM;

#if defined(__cplusplus) && defined(__opcda_h__)
class COPCCallBack : public IOPCDataCallback {
public:
COPCCallBack();
~COPCCallBack();
// IUnknown Methods
HRESULT __stdcall QueryInterface (REFIID iid, LPVOID *ppv);
ULONG __stdcall AddRef();
ULONG __stdcall Release();
// IOPCDataCallback 
HRESULT __stdcall OnDataChange(DWORD dwTransid, OPCHANDLE hGroup, HRESULT hrMasterquality, HRESULT hrMastererror, DWORD dwCount,
								OPCHANDLE *phClientItems, VARIANT *pvValues, WORD *pwQualities,
								FILETIME *pftTimeStamps, HRESULT *pErrors);
HRESULT __stdcall OnReadComplete(DWORD dwTransid, OPCHANDLE hGroup, HRESULT hrMasterquality, HRESULT hrMastererror, DWORD dwCount,
									OPCHANDLE *phClientItems, VARIANT *pvValues, WORD *pwQualities,
									FILETIME *pftTimeStamps, HRESULT *pErrors);
HRESULT __stdcall OnWriteComplete(DWORD dwTransid, OPCHANDLE hGroup, HRESULT hrMastererr, DWORD dwCount,
									OPCHANDLE *pClienthandles, HRESULT *pErrors);
HRESULT __stdcall OnCancelComplete(DWORD dwTransid, OPCHANDLE hGroup);
void __stdcall Connect(LPOPCGROUP lpGrp);
void __stdcall SetReadData(LPOPCITEM lpItem, HRESULT hRes, WORD nQuality, LPFILETIME lpFt, LPVARIANT lpVar);
void __stdcall ClearWriteRequest(LPOPCITEM lpItem, HRESULT hRes);
private:
volatile LONG		m_nRef;
LPOPCGROUP			m_pGrp;
};
typedef COPCCallBack				*LPCOPCCALLBACK;
#else
typedef LPVOID						LPCOPCCALLBACK;
#endif

#if defined(__ocidl_h__)
typedef IConnectionPointContainer	*LPCONPOINTCONT;
typedef IConnectionPoint			*LPCONPOINT;
#else
typedef LPVOID						*LPCONPOINTCONT;
typedef LPVOID						*LPCONPOINT;
#endif
#pragma pack(push, 1)

typedef union tagOPCVALUE {
	BOOL					b;
	INT32					i32;
	UINT32					u32;
	INT64					i64;
	UINT64					u64;
	double					d;
	LPSTR					pStr;
	LPWSTR					pWStr;
} OPCVALUE, *LPOPCVALUE;

typedef struct tagOPCSERVER {
	LPIOPCSERVER					pIOPCServer;
	volatile LPOPCGROUP				pGroups;
	INT32							nGrpCnt;
	INT32							nItemCnt;
		struct	{
	UINT32							bComInit	: 1;
	UINT32							bActive		: 1;
		};
	LPSTR							pHost;
	LPSTR							pServer;
	char							cNames[2];				// for terminating 0. variable length
} OPCSERVER, *LPOPCSERVER;

typedef struct tagOPCGROUP {
	volatile LPOPCGROUP				pNext;
	OPCHANDLE						hClient;
	OPCHANDLE						hServer;
	LPIOPCITEMMGT					pIOPCItemMgt;
	LPIOPCGROUPSSTATEMGT			pIOPCGroupStateMgt;
	LPIOPCSYNCIO					pIOPCSyncIO;
	LPIOPCASYNCIO2					pIOPCAsyncIO2;
	LPCOPCCALLBACK					pCallBack;
	LPCONPOINT						pConPt;
	DWORD							nAdvise;
    DWORD							nUpdateRate;
		struct	{
	UINT32							bSyncRead		: 1;
	UINT32							bRateChanged	: 1;
	UINT32							bConnected		: 1;
	UINT32							bActive			: 1;
		};
	volatile LPOPCITEM				pItems;
	INT32							nItemCnt;
	char							cName[1];				// for terminating 0. variable length
} OPCGROUP, *LPOPCGROUP;

typedef struct tagOPCITEM {
	volatile LPOPCITEM				pNext;
	OPCHANDLE						hClient;
	OPCHANDLE						hServer;
    VARTYPE							vtClntType;
    VARTYPE							vtSrvrType;
		struct	{
	UINT16							bAllocated	: 1;
	UINT16							bReadable	: 1;
	UINT16							bWriteable	: 1;
	UINT16							bIsUpdated	: 1;
	UINT16							bWrRequest	: 1;
	UINT16							bReadError	: 1;
	UINT16							bUncertain	: 1;
	UINT16							bWriteError	: 1;
		};
    UINT16							nMaxStrLen;
	OPCVALUE						Value;
	FILETIME						ftStamp;
	char							cName[1];				// for terminating 0. variable length
} OPCITEM, *LPOPCITEM;

#pragma pack(pop)

LPOPCSERVER __stdcall OPC_Init(LPSTR lpHostName, LPSTR lpServerName);
INT32 __stdcall OPC_Done(LPOPCSERVER lpSrvr);
INT32 __stdcall OPC_AddGroup(LPOPCSERVER lpSrvr, LPSTR lpGroupName, UINT32 nGrpID, UINT32 nRefreshRate, BOOL bSyncIO);
INT32 __stdcall OPC_DelGroup(LPOPCSERVER lpSrvr, UINT32 nGrpID);
LPOPCGROUP __stdcall OPC_GetGroup(LPOPCSERVER lpSrvr, UINT32 nGrpID);
INT32 __stdcall OPC_AddItem(LPOPCSERVER lpSrvr, UINT32 nGrpID, LPSTR lpItemName, UINT32 nItemID, INT32 nVarType, INT32 nMaxLen);
INT32 __stdcall OPC_DelItem(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
LPOPCITEM __stdcall OPC_GetItem(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
INT32 __stdcall OPC_Start(LPOPCSERVER lpSrvr);
INT32 __stdcall OPC_Stop(LPOPCSERVER lpSrvr);
INT32 __stdcall OPC_Read(LPOPCSERVER lpSrvr, UINT32 nGrpID);
INT32 __stdcall OPC_Write(LPOPCSERVER lpSrvr, UINT32 nGrpID);
BOOL __stdcall OPC_ItemIsUpdated(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
BOOL __stdcall OPC_ReadBool(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
INT32 __stdcall OPC_ReadI32(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
UINT32 __stdcall OPC_ReadU32(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
INT64 __stdcall OPC_ReadI64(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
UINT64 __stdcall OPC_ReadU64(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
FLOAT __stdcall OPC_ReadFlt(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
DOUBLE __stdcall OPC_ReadDbl(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
LPSTR __stdcall OPC_ReadStr(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
LPWSTR __stdcall OPC_ReadWStr(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID);
void __stdcall OPC_WriteBool(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, BOOL bVal);
void __stdcall OPC_WriteI32(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, INT32 nVal);
void __stdcall OPC_WriteU32(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, UINT32 nVal);
void __stdcall OPC_WriteI64(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, INT64 nVal);
void __stdcall OPC_WriteU64(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, UINT64 nVal);
void __stdcall OPC_WriteFlt(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, FLOAT fVal);
void __stdcall OPC_WriteDbl(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, DOUBLE fVal);
void __stdcall OPC_WriteStr(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, LPSTR lpStr);
void __stdcall OPC_WriteWStr(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, LPWSTR lpWStr);
BOOL __stdcall OPC_ServerReady(LPOPCSERVER lpSrvr);

#if defined(_DEF_SKLIBOPC_EXTERNC)
}
#undef _DEF_EXTERNC
#undef _DEF_SKLIBOPC_EXTERNC
#endif

#endif  // _INC_SKLIBOPC
