#pragma once
#ifndef _INC_SKLIBUDP
#define _INC_SKLIBUDP

#include <sklibudpres.h>

#if defined(__cplusplus) && !defined(_DEF_EXTERNC)
#define _DEF_EXTERNC
#define _DEF_SKLIBUDP_EXTERNC
extern "C" {
#endif

//	Basic IP/UDP/SKDP structures
#pragma pack(push, 1)

typedef union tagIPADDRESS {
	UINT8							b[4];
	INT32							l;
} IPADDRESS, *LPIPADDRESS;

typedef struct tagETHERNETHDR {
	UINT8							Dst[6];
	UINT8							Src[6];
	UINT16							Typ;
} ETHERNETHDR, *LPETHERNETHDR;

typedef struct tagIPHDR {
	UINT8							HdrLen	:4;		// 4-bit header length (in 32-bit words) normally=5 (Means 20 Bytes may be 24 also)
	UINT8							Version	:4;		// 4-bit IPv4 version
	UINT8							TOS;			// IP type of service
	UINT16							Len;			// Total length
	UINT16							ID;				// Unique identifier
	UINT8							FrgOfs1	:5;		// Fragment offset field
	UINT8							FrgMore	:1;
	UINT8							FrgDont	:1;
	UINT8							FrgZero	:1;
	UINT8							FrgOffs2;		// fragment offset
	UINT8							TTL;			// Time to live
	UINT8							Protocol;		// Protocol(TCP,UDP etc)
	UINT16							ChkSum;			// IP checksum
	IPADDRESS						SrcIP;			// Source address
	IPADDRESS						DstIP;			// Source address
} IPHDR, *LPIPHDR;

typedef struct tagUDPHDR {
	UINT16							SrcPort;		// source port
	UINT16							DstPort;		// destination port
	UINT16							Len;			// window
	UINT16							ChkSum;			// checksum
} UDPHDR, *LPUDPHDR;

typedef struct tagSKDPHEADER {
		union {
	char							cID[2];							// should equal 'SK'
	UINT16							nID;
		};
	UINT8							nClntIdx;
	UINT8							nSrvrIdx;
	UINT8							nJobID;
	UINT8							nFlags;							// Flags
	UINT16							nReqID;
	UINT16							nFunction;						// Function Code
		struct {
	UINT32							nBlkOfs	:17;					// Data block offset
	UINT32							nBlkCnt	:7;						// Block count
	UINT32							nBlkID	:8;						// Block ID
		};
	UINT8							nError;							// error
	UINT8							nChk;							// checksum
} SKDPHEADER, *LPSKDPHEADER;

#pragma pack(pop)

#define ETH_MAXPACKETSIZE			(1518 - 4)						// 4 = sizeof(crc)
#define ETH_MAXDATASIZE				(ETH_MAXPACKETSIZE - sizeof(ETHERNETHDR))
#define IP_MAXDATASIZE				(ETH_MAXDATASIZE - sizeof(IPHDR))
#define UDP_MAXDATASIZE				(IP_MAXDATASIZE - sizeof(UDPHDR))
#define SKDP_MAXDATASIZE			(UDP_MAXDATASIZE - sizeof(SKDPHEADER))


#define SKDP_MAXPACKETCOUNT			64
#define SKDP_MAXTRANSFERSIZE		(SKDP_MAXPACKETCOUNT * SKDP_MAXDATASIZE)
#define SKDP_MAXJOBDATASIZE			(SKDP_MAXTRANSFERSIZE + SKDP_MAXDATASIZE)

typedef struct tagSKDPINFO	SKDPINFO, *LPSKDPINFO;
typedef struct tagSKDPJOB	SKDPJOB, *LPSKDPJOB;
typedef struct tagSKDPPACKET	SKDPPACKET, *LPSKDPPACKET;
typedef void (CALLBACK* SKDPCALLBACK)(INT32 nMode, INT32 nError, LPSKDPJOB lpJob, LPSKDPPACKET lpPkt);
typedef INT32 (CALLBACK* SKDPSNDCHKPROC)(LPSKDPJOB lpJob, INT32 nError);

#define SKDP_ABSMAXCONNECTION		16
#define	SKDP_MAXJOB					32
#define SKDP_MAXFILES				4
#define SKDP_MAXFOLDER				4
#define SKDP_MAXIOBLOCK				4
#define SKDP_MINSTRSIZE				2
#define SKDP_MAXSTRSIZE				256
#define SKDP_MAXNAMESIZE			24
#define SKDP_MAXPATH				128
#define SKDP_EVENTPACKET			0
#define SKDP_EVENTTIMEOUT			1
#define SKDP_EVENTTEST				2
#define SKDP_MAXEVENTS				3

#define	SYSLOGPRI_EMERG				0				// system is unusable
#define	SYSLOGPRI_ALERT				1				// action must be taken immediately
#define	SYSLOGPRI_CRITICAL			2				// critical conditions
#define	SYSLOGPRI_ERROR				3				// error conditions
#define	SYSLOGPRI_WARNING			4				// warning conditions
#define	SYSLOGPRI_NOTICE			5				// normal but significant condition
#define	SYSLOGPRI_INFO				6				// informational
#define	SYSLOGPRI_DEBUG				7				// debug-level messages

#define	SYSLOGFAC_KERN				0				// kernel messages
#define	SYSLOGFAC_USER				1				// random user-level messages
#define	SYSLOGFAC_MAIL				2				// mail system
#define	SYSLOGFAC_DAEMON			3				// system daemons
#define	SYSLOGFAC_AUTH				4				// security/authorization messages
#define	SYSLOGFAC_SYSLOG			5				// messages generated internally by syslogd
#define	SYSLOGFAC_LPR				6				// line printer subsystem
#define	SYSLOGFAC_NEWS				7				// network news subsystem
#define	SYSLOGFAC_UUCP				8				// UUCP subsystem
#define	SYSLOGFAC_CRON				9				// clock daemon
#define	SYSLOGFAC_AUTHPRIV			10				// security/authorization messages (private)
#define	SYSLOGFAC_FTP				11				// ftp daemon
#define	SYSLOGFAC_NTP				12				// NTP subsystem
#define	SYSLOGFAC_LOCAL0			16				// reserved for local use
#define	SYSLOGFAC_LOCAL1			17				// reserved for local use
#define	SYSLOGFAC_LOCAL2			18				// reserved for local use
#define	SYSLOGFAC_LOCAL3			19				// reserved for local use
#define	SYSLOGFAC_LOCAL4			20				// reserved for local use
#define	SYSLOGFAC_LOCAL5			21				// reserved for local use
#define	SYSLOGFAC_LOCAL6			22				// reserved for local use
#define	SYSLOGFAC_LOCAL7			23				// reserved for local use

#define SYSLOGMODE_NONE				0
#define SYSLOGMODE_PASSIVE			1
#define SYSLOGMODE_ACTIVE			2

#ifndef _WS2DEF_
#define SOCK_STREAM					1
#define SOCK_DGRAM					2

#define IPPROTO_IP					0
#define IPPROTO_ICMP				1
#define IPPROTO_TCP					6
#define IPPROTO_UDP					17
#endif

#pragma pack(push, 1)

typedef union tagSOCKETADDRESS {
#ifdef _WS2DEF_
	SOCKADDR						sa;
	SOCKADDR_IN						sin;
#endif
		struct {
	UINT32							nFamPort;    
	IPADDRESS						IP;
    UINT8							Zero[8];
		};
		struct {
	INT16							nFamily;    
	UINT16							nPort;
	UINT32							nIp;
		};
} SOCKETADDRESS, *LPSOCKETADDRESS;

typedef struct tagSKDPTIME {
	UINT16							nMilliSec	:10;
	UINT16							nSec		:6;
	UINT16							nMin		:6;
	UINT16							nHour		:5;
	UINT16							nDay		:5;
	UINT16							nMonth		:4;
	UINT16							nYear		:12;
} SKDPTIME, *LPSKDPTIME;

typedef struct tagSKDPFILEINFO {
	SKDPTIME						FileTime;
	UINT16							nAttr;
	UINT32							nSize;
} SKDPFILEINFO, *LPSKDPFILEINFO;

typedef struct tagSKDPBIGFILEINFO {
	SKDPTIME						FileTime;
	UINT16							nAttr;
		union {
			struct {
	UINT32							nSizeLo;
	UINT32							nSizeHi;
			};
	UINT64							nSize;
		};
} SKDPBIGFILEINFO, *LPSKDPBIGFILEINFO;

typedef struct tagSKDPTIMEINFO {
	UINT16							nMSec;
	UINT8							nDoW;
	UINT8							nSec;
	UINT8							nMin;
	UINT8							nHour;
	UINT8							nDay;
	UINT8							nMonth;
	UINT16							nYear;
	UINT16							nReserved;
} SKDPTIMEINFO, *LPSKDPTIMEINFO;

// SKDP version
typedef struct tagSKDPVERSION {
	UINT16							nVersionHi;
	UINT16							nVersionLo;
	UINT16							nUDPBlkSize;
	UINT8							nMaxUDPBlk;
	UINT8							nMaxFile;
	UINT8							nChrSetLocal;
	UINT8							nChrSetRemote;
	char							nReserved[14];
	char							cVendor[SKDP_MAXNAMESIZE];
	char							cComputer[SKDP_MAXNAMESIZE];
	char							cUser[SKDP_MAXNAMESIZE];
} SKDPVERSION, *LPSKDPVERSION;

typedef struct tagSKDPFINDHDR {
	UINT16							nBlk;
		union {
	UINT16							nCnt;
	UINT16							nPkt;
		};
} SKDPFINDHDR, *LPSKDPFINDHDR;

// SKDP FindFile
typedef struct tagSKDPFINDREQUEST {
	UINT16							nBlk;
	UINT16							nPkt;
	UINT8							bDirs;
	UINT8							nChrSet;
	char							cPath[SKDP_MAXPATH];
} SKDPFINDREQUEST, *LPSKDPFINDREQUEST;

// SKDP FindFile
typedef struct tagSKDPFINDREPLY {
	UINT16							nBlk;
	UINT16							nCnt;
	UINT8							bLast;
	UINT8							nChrSet;
	union {
	SKDPFILEINFO					FileInfo;
	SKDPBIGFILEINFO					BigFileInfo;
	char							cPath[SKDP_MAXPATH];
	};
} SKDPFINDREPLY, *LPSKDPFINDREPLY;

typedef struct tagSKDPFINDDATA {
	HANDLE							hFind;
	UINT16							nNextBlk;
	UINT8							nChrSet;
	UINT8							bReady;
	UINT8							bDirs;
	UINT8							bIsCurrent;
	UINT8							bIsParent;
	UINT8							bReserved;
	WIN32_FIND_DATA					wfd;
	char							cMask[SKDP_MAXPATH];
} SKDPFINDDATA, *LPSKDPFINDDATA;

typedef struct tagSKDPFILEIO {
	INT32							nHandle;
	INT32							nErr;
	INT32							nIpVal;
	union {
		LPVOID						pUser;
		UINT32						nUser;
	};
	union {
		struct {
			UINT32					nSizeLo;
			UINT32					nSizeHi;
		};
		UINT64						nSize;
	};
	union {
		struct {
			UINT32					nPosLo;
			UINT32					nPosHi;
		};
		UINT64						nPos;
	};
	INT32							nBlocks;
	struct {
		UINT32						nMode;
		union {
			struct {
		UINT32						nSize;
		INT64						nPos;
		LPVOID						pBuf;
			};
		SYSTEMTIME					st;
		};
	}								IO[SKDP_MAXIOBLOCK];
	char							cName[1];				// for terminating 0. variable length
} SKDPFILEIO, *LPSKDPFILEIO;

typedef struct tagSKDPFILEREQUEST {
	UINT8							nHandle;
	UINT8							nFlags;
	UINT8							nBlocks;
	UINT8							nReserved;
} SKDPFILEREQUEST, *LPSKDPFILEREQUEST;

typedef struct tagSKDPFILEREPLY {
	UINT8							nHandle;
	UINT8							nFlags;
	UINT8							nBlocks;
	UINT8							nReserved;
	union {
		struct {
			UINT32					nSizeLo;
			UINT32					nSizeHi;
		};
		UINT64						nSize;
	};
	union {
		struct {
			UINT32					nPosLo;
			UINT32					nPosHi;
		};
		UINT64						nPos;
	};
} SKDPFILEREPLY, *LPSKDPFILEREPLY;

typedef struct tagSKDPSFVREQUEST {
	UINT32							nSfv;
	INT32							nSize;
	INT32							nMaxSize;
	SKDPTIME						FTime;
	UINT8							bFirst;
	UINT8							nChrSet;
} SKDPSFVREQUEST, *LPSKDPSFVREQUEST;

typedef struct tagSKDPSFVREPLY {
	UINT32							nSfv;
	INT32							nSize;
	SKDPTIME						FTime;
	UINT8							bChanged;
	UINT8							bReserved;
} SKDPSFVREPLY, *LPSKDPSFVREPLY;

typedef struct tagSKDPSFVREADHDR {
	UINT32							nSfv;
	INT32							nSize;
	SYSTEMTIME						FTime;
	BOOL							bChanged;
} SKDPSFVREADHDR, *LPSKDPSFVREADHDR;

#define SKDP_MAXSFVREAD				(SKDP_MAXTRANSFERSIZE - sizeof(SKDPSFVREPLY))
typedef struct tagSKDPSFVREAD {
	SKDPSFVREADHDR					Hdr;
	char							cData[SKDP_MAXSFVREAD];
} SKDPSFVREAD, *LPSKDPSFVREAD;

typedef struct tagSKDPOPENMODE {
	UINT8							nMode;
	UINT8							nChrSet;
	char							cFile[SKDP_MAXPATH];
} SKDPOPENMODE, *LPSKDPOPENMODE;

typedef union tagSKDPIOMODE {
		struct {
	UINT32							nMode:8;
	UINT32							nSize:24;
	INT32							nSeek;
		};
		struct {
	UINT16							nReserved;
	SKDPTIME						st;
		};
} SKDPIOMODE, *LPSKDPIOMODE;

typedef struct tagSKDPBIGIOMODE {
		struct {
	UINT32							nMode:8;
	UINT32							nSize:24;
	INT64							nSeek;
		};
		struct {
	UINT16							nReserved;
	SKDPTIME						st;
		};
} SKDPBIGIOMODE, *LPSKDPBIGIOMODE;

typedef struct tagSKDPPACKET {
	SOCKETADDRESS					Adr;
	INT32							nLen;
	INT32							nError;
	INT32							nSysErr;
	union {
	char							cUdp[UDP_MAXDATASIZE];
		struct {
	SKDPHEADER						Hdr;
			union {
	SKDPVERSION						Version;
	SKDPTIMEINFO					TimeInfo;
	char							cData[SKDP_MAXDATASIZE];
	UINT16							wData[SKDP_MAXDATASIZE / 2];
	UINT32							dwData[SKDP_MAXDATASIZE / 4];
	UINT64							qwData[SKDP_MAXDATASIZE / 8];
			};
		};
	};
	INT32							nFill;
} SKDPPACKET, *LPSKDPPACKET;

typedef struct tagSKDPCONINFO {
	char							cName[SKDP_MAXNAMESIZE];
	UINT32							nIp;
	BOOL							bRstCheck;
	BOOL							bRstError;
	INT32							nRstTime;
	INT32							nRstActCnt;
	INT32							nRstMaxCnt;
	INT32							nRstLastDay;
	INT32							nRstLastSec;
	UINT32							nLastTick;
	INT16							nSysLog;
	INT8							nLogState;
	INT8							nState;
	UINT16							nFlags;
	INT8							nReserved;
	INT8							nDirCnt;
		union {
	UINT8							b[SKDP_MAXFOLDER];
	UINT32							d;
		}							nDirs;
} SKDPCONINFO, *LPSKDPCONINFO;

// Share Rights
#define	SKDP_SR_READ				1
#define	SKDP_SR_WRITE				2
#define	SKDP_SR_EXEC				4
// Connection Rights
#define	SKDP_CR_REBOOT				1
#define	SKDP_CR_QUIT				2
#define	SKDP_CR_RESTART				4
#define	SKDP_CR_UPDATE				8

#define SKDP_CS_UNKNOWN				0
#define SKDP_CS_DONTCARE			1
#define SKDP_CS_STOPPED				2
#define SKDP_CS_READY				3
#define SKDP_CS_TIMEOUT				4

typedef struct tagSKDPSHAREINFO {
	char							cName[SKDP_MAXNAMESIZE];
	UINT32							nID;
	UINT32							nFlags;
	UINT32							nConRead;
	UINT32							nConWrite;
	UINT32							nConExec;
} SKDPSHAREINFO, *LPSKDPSHAREINFO;

typedef struct tagSKDPJOB {
	UINT8							nClntIdx;							// own job index, initialized at allocation
	UINT8							nSrvrIdx;
	UINT8							nJobID;
	UINT8							nRcvBlkCnt;
	UINT8							nSndBlkCnt;
	UINT8							nRetry;
	UINT16							nFlags;
	UINT16							nReqID;
	UINT16							nFunction;
	UINT32							nTickStart;
	UINT32							nTimeOut;
	UINT32							nReqTOut;
	LPFILEIO						pActFile;
	LPFILEIO						pFiles[SKDP_MAXFILES];
	LARGEINT						nRcvBlkState;
	LARGEINT						nSndBlkState;
	UINT16							nLastID;
	UINT8							nSndRetry;
	UINT8							bQuit;
	HANDLE							hThread;
		union {
			struct {
	HANDLE							hEventUdp;
	HANDLE							hEventTest;
			};
	HANDLE							hEvents[2];
			};
	UINT16							nReserved;
	INT8							nConID;
	INT8							nDirCnt;
		union {
	UINT8							b[2 * SKDP_MAXFOLDER];
	UINT32							d[2];
		}							nDirs;
	UINT32							nRcvEnd;
	UINT32							nRcvLen;
	UINT32							nSndLen;
	LPSTR							pRcvData;
	LPSTR							pSndData;
	HWND							hUserWnd;
	HANDLE							hUserEvent;
	LPVOID							pResult;
		union {
	LPVOID							pUser;
	INT32							nUser;
		};
	LPSKDPFINDDATA					pFind;
	SKDPSNDCHKPROC					pSndChk;
	UINT8	volatile				bRcvRdy;
	UINT8	volatile				bTskRdy;
	INT8							nRcvErr;
	INT8							nSndErr;
	INT32							nSysErr;
	SKDPPACKET						sPkt;
	char							cData[SKDP_MAXJOBDATASIZE];
} SKDPJOB, *LPSKDPJOB;

typedef struct tagNETINFO {
	UINT32							nSkt;								// SOCKET = UINT_PTR
	UINT32							nIp;
	UINT32							nNetMask;
	UINT32							nBroadCast;
	UINT32							nLocBroadCast;
	UINT16							nPort;
	UINT16							bWSA;
} NETINFO, *LPNETINFO;

typedef struct tagSKDPINFO {
	USERINFO						UsrInf;
	NETINFO							NetInf;
	UINT16							nSysLog;
	UINT8							nDefDir;
	INT8							nDirCnt;
		union {
	UINT8							b[SKDP_MAXFOLDER];
	UINT32							d;
		}							nDirs;
	INT32							nConnections;
	LPSKDPCONINFO					pConInfo;
	LPSORTINFO						pShareList;
	LPSKDPPACKET					pRPkt;
	LPSKDPPACKET					pSPkt;
	UINT32							nTimerID;
	UINT32 volatile					nTickStart;
	UINT32 volatile					nTickCounter;
	INT32 volatile					nJobFree;
	INT32 volatile					nJobActive;
	INT32 volatile					nJobTimeOut;
	SKDPCALLBACK					pCallBack;
	LPSKDPJOB						pJobs[SKDP_MAXJOB];
	INT32							nMaxJob;
	UINT32							nTOut_Send;
	UINT32							nTOut_Std;
	UINT32							nTOut_Resend;
	UINT32							nTOut_IO;
	UINT32							nTOut_Find;
	UINT32							nTOut_Req;
	UINT32							nSndRetry;
	UINT32							nRcvRetry;
	UINT32							nDebug;
	INT32							nError;
	INT32							nSysErr;
	HWND							hMainWnd;
	HWND							hDlgWnd;
	BOOL							bActive;
	BOOL							bEnReStart;
	BOOL							bEnReBoot;
	HANDLE volatile					hThread;
	union {
		HANDLE						hEvents[SKDP_MAXEVENTS];
		struct {
			HANDLE					hEventPacket;
			HANDLE					hEventTimeOut;
			HANDLE					hEventTest;
		};
	};
} SKDPINFO, *LPSKDPINFO;

#pragma pack(pop)

#define	SKDP_MSGID					0x4B53			//	'SK'

//	SKDPPACKET Flags
#define	SKDPFL_REQUEST				0x00
#define	SKDPFL_REPLY				0x01
#define	SKDPFL_RETRY				0x02
#define	SKDPFL_RESEND				0x04
#define	SKDPFL_BROADCAST			0x80
#define	SKDPFL_WAITING				0x100
#define	SKDPFL_MULTIBLK				0x200
#define	SKDPFL_SENT					0x400
#define	SKDPFL_TYPEMASK				SKDPFL_REPLY

#define SKDPERRFL_REJECT			0x00010000

#define CHRSET_AUTO					0x100
#define CHRSET_NONE					0
#define CHRSET_ANY					0
#define CHRSET_WIN					1
#define CHRSET_CWI					2
#define CHRSET_852					3

#define	SKDPFC_SRVRINIT				0
#define	SKDPFC_SRVRDONE				1
#define	SKDPFC_SRVRFIND				2
#define	SKDPFC_MESSAGE				3
#define	SKDPFC_ENDREQUEST			4
#define	SKDPFC_VERSION				5
#define	SKDPFC_GETTIME				6
#define	SKDPFC_GETRIGHTS			7
#define	SKDPFC_RESTART				8
#define	SKDPFC_REBOOT				9
#define	SKDPFC_QUIT					10
#define	SKDPFC_UPDATE				11
#define	SKDPFC_EXEC					12
#define	SKDPFC_FINDFILE				13
#define	SKDPFC_DIRCREATE			14
#define	SKDPFC_DIRREMOVE			15
#define	SKDPFC_FILEINFO				16
#define	SKDPFC_SETFATTR				17
#define	SKDPFC_SETFDATE				18
#define	SKDPFC_FILERENAME			19
#define	SKDPFC_FILEDELETE			20
#define	SKDPFC_FILEIO				21
#define	SKDPFC_SFVREAD				22
#define	SKDPFC_CREATEDATA			23
#define	SKDPFC_READKEY				24
#define	SKDPFC_WRITEKEY				25
#define	SKDPFC_USER					512

#define	SKDP_DBGM_JOB				0x01
#define	SKDP_DBGM_RCV				0x02
#define	SKDP_DBGM_SND				0x04
#define	SKDP_DBGM_TOUT				0x08

#define	SKDP_CB_NONE				0
#define	SKDP_CB_DBGGETJOB			1
#define	SKDP_CB_DBGREPLYJOB			2
#define	SKDP_CB_DBGRESETJOB			3
#define	SKDP_CB_DBGFREEJOB			4
#define	SKDP_CB_DBGSEND				5
#define	SKDP_CB_DBGRECEIVE			6
#define	SKDP_CB_DBGTIMEOUT			7
#define	SKDP_CB_DBGLAST				7
#define	SKDP_CB_FINDSRVR			8
#define	SKDP_CB_MESSAGE				9
#define	SKDP_CB_JOB					10
#define	SKDP_CB_START				11
#define	SKDP_CB_STOP				12
#define	SKDP_CB_LIVE				13
#define	SKDP_CB_STARTCHECK			14

#define	SKDP_CPF_FIND				0x0001
#define	SKDP_CPF_FOLDER				0x0002
#define	SKDP_CPF_FILE				0x0004
#define	SKDP_CPF_EXISTS				0x0008

#define	SKDP_IOF_OPEN				0x01
#define	SKDP_IOF_READ				0x02
#define	SKDP_IOF_WRITE				0x04
#define	SKDP_IOF_CLOSE				0x08
#define	SKDP_IOF_BIGFILE			0x80

#define	SKDP_PORT					54321
#define	ISO_PORT					102
#define	NTP_PORT					123

extern SKDPINFO						g_SKDPInfo;

LPSKDPJOB __stdcall SKDP_GetJob(HWND hWnd, HANDLE hEvent, INT32 nIpVal, INT32 nPort, LPINT32 lpError);
INT32 __stdcall SKDP_ResetJob(LPSKDPJOB lpJob, HWND hWnd, HANDLE hEvent, INT32 nIpVal, INT32 nPort);
INT32 __stdcall SKDP_FreeJob(LPSKDPJOB lpJob);
INT32 __stdcall SKDP_JobValid(LPSKDPJOB lpJob, BOOL bForRequest);
LPSKDPJOB __stdcall SKDP_JobInUse(INT32 nJobIdx);

INT32 __stdcall IpCheckSum(LPVOID lpRawData);
INT32 __stdcall IcmpCheckSum(LPVOID lpRawData);
INT32 __stdcall UdpCheckSum(LPVOID lpRawData);
INT32 __stdcall SKDP_Init(HWND hWnd, INT32 nDbgMask, LPSTR lpIniFile, SKDPCALLBACK lpCallBack);
void __stdcall SKDP_Done();
void __stdcall SKDP_FillHeader(LPSKDPHEADER lpHeader, LPSKDPJOB lpJob, INT32 nFunc, INT32 nBlkOfs, INT32 nBlkCnt, INT32 nBlkID,
								INT32 nFlags, INT32 nError);
BOOL __stdcall SKDP_BroadCastIP(UINT32 nIpVal);
BOOL __stdcall SKDP_ValidIP(UINT32 nIpVal);
void __stdcall SysTimeToSKDPTime(LPSKDPTIME lpSKDPTime, LPSYSTEMTIME lpSysTime);
void __stdcall SKDPTimeToSysTime(LPSYSTEMTIME lpSysTime, LPSKDPTIME lpSKDPTime);
INT32 __stdcall SKDP_ShareRoot(LPSTR lpRoot);
INT32 __stdcall SKDP_DefaultFolder(LPSKDPJOB lpJob, LPSTR lpFolder);

INT32 SKDP_FindServer(LPSTR lpServer, UINT32 nIpVal, UINT32 nPort);
INT32 SKDP_Message(LPSKDPJOB lpJob, LPSTR lpMsg, UINT32 nIpVal, UINT32 nPort);
INT32 WINAPI SKDP_DefSndChkProc(LPSKDPJOB lpJob, INT32 nError);
INT32 __stdcall SKDP_SendPacket(LPSKDPJOB lpJob, LPSKDPPACKET lpPkt, BOOL bSKDP);
INT32 __stdcall SKDP_SendJob(LPSKDPJOB lpJob, INT32 nFn, INT32 nLen, INT32 nBlk, INT32 nTOut,
								SKDPSNDCHKPROC lpChk, INT32 nRetry, BOOL bRetry);
INT32 __stdcall SKDP_ResendJob(LPSKDPJOB lpJob, BOOL bResend);
INT32 __stdcall SKDP_CvtRcvStr(LPSTR lpStr, INT32 nCode, INT32 nSize, LPINT32 lpErr);
INT32 __stdcall SKDP_CpyRcvStr(LPSTR lpDst, LPSTR lpSrc, INT32 nSrcCode, INT32 nSize);
INT32 __stdcall SKDP_CpySndStr(LPSTR lpDst, LPSTR lpSrc, INT32 nSrcCode, INT32 nSize);
INT32 SKDP_GetVersion(LPSKDPJOB lpJob, INT32 nRetry, LPSKDPVERSION lpVersion);
INT32 SKDP_GetTime(LPSKDPJOB lpJob, INT32 nRetry, BOOL bSystem, LPSYSTEMTIME lpResult);
INT32 SKDP_ReBoot(LPSKDPJOB lpJob, INT32 nRetry);
INT32 SKDP_ReStart(LPSKDPJOB lpJob, INT32 nRetry);
INT32 SKDP_FindFile(LPSKDPJOB lpJob, LPSORTINFO lpSort, LPSTR lpPath, BOOL bDirs);
INT32 SKDP_FileInfo(LPSKDPJOB lpJob, INT32 nRetry, LPSTR lpFileName, LPFILEINFO lpFileInfo);
INT32 SKDP_CreateDir(LPSKDPJOB lpJob, INT32 nRetry, LPSTR lpDir);
INT32 SKDP_SfvRead(LPSKDPJOB lpJob, INT32 nRetry, BOOL bFirst, INT32 nMaxSize, LPSTR lpFileName, LPSKDPSFVREAD lpSfvRead);
INT32 __stdcall SKDP_CheckPath(LPSKDPJOB lpJob, LPSTR lpLoc, LPSTR lpRem, LPSTR lpPath, LPINT32 lpRights, INT32 nFlags);
// **********************************************************************************
LPSKDPFILEIO __stdcall SKDP_FInit(LPSTR lpFileName, INT32 nIpVal);
INT32 __stdcall SKDP_FDone(LPSKDPFILEIO lpFile);
INT32 __stdcall SKDP_WriteFile(LPSKDPJOB lpJob, INT32 nRetry, LPSKDPFILEIO lpFile, BOOL bRewrite, BOOL bBig, BOOL bClose);
INT32 __stdcall SKDP_ReadFile(LPSKDPJOB lpJob, INT32 nRetry, LPSKDPFILEIO lpFile, BOOL bBig, BOOL bClose);
INT32 SKDP_FRename(LPSKDPJOB lpJob, INT32 nRetry, LPSTR lpSrcName, LPSTR lpDstName);
INT32 SKDP_FDelete(LPSKDPJOB lpJob, INT32 nRetry, LPSTR lpFileName);
INT32 __stdcall SKDP_CreateData(LPSKDPJOB lpJob, INT32 nRetry, LPVOID lpHdr, INT32 nHdrSize, INT32 nClrSize, LPSKDPFILEIO lpFile, BOOL bCreate);
// **********************************************************************************
INT32 SysLog_Message(INT32 nFacility, UINT32 nPriority, LPSTR lpTag, INT32 nTagID, LPSTR lpContent);
// **********************************************************************************
INT32 __stdcall OpenSocket(LPSTR lpName, UINT32 nIP, INT32 nPort, INT32 nType, INT32 nProtocol, BOOL bBind, BOOL bBC, INT32 nRTOut, INT32 nSTOut, LPNETINFO lpNetInf, LPSOCKETADDRESS lpSA, LPINT32 lpSysErr);
void __stdcall CloseSocket(UINT32 nSkt, BOOL bWSA);
INT32 __stdcall TcpConnect(INT32 nSocket, INT32 nIp, INT32 nPort, INT32 nTimeOut, LPINT32 lpErr);
BOOL __stdcall NTP_GetTime(UINT32 nSkt, UINT32 nIP, INT32 nPort, INT32 nZone, BOOL bDayLight, LPSYSTEMTIME lpSt);

#if defined(_DEF_SKLIBUDP_EXTERNC)
}
#undef _DEF_EXTERNC
#undef _DEF_SKLIBUDP_EXTERNC
#endif

#endif  // _INC_SKLIBUDP
