/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * s7com32 - s7pdu.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <s7com32.h>
#include "private.h"
// **********************************************************************************
INT32 __stdcall pS7PDU_SndInit(LPS7CONNECTION lpCon, INT32 nType, INT32 nFunc, INT32 nMode, BOOL bConnected) {
#define CTRL_LEN	9
#define CTRL_STR	"P_PROGRAM"
LPS7ERRPDUHEADER	pHdr;
S7ANYPARPTR			pPar;
LPUINT8				pLen;
INT32				nHdrLen, nParLen, nReplyLen, nRes;

	nRes = pS7_TestConnection(lpCon, bConnected, TRUE);
	if (nRes) return nRes;
	MemClr(&lpCon->RdInfo, sizeof(lpCon->RdInfo));
	MemClr(&lpCon->nRWErrInfo, sizeof(lpCon->nRWErrInfo));
	lpCon->nRWErrCnt = 0;
	pHdr = (LPS7ERRPDUHEADER) lpCon->SndPdu.pData;
	MemClr(pHdr, sizeof(S7ERRPDUHEADER));
	nHdrLen = (nType == PDUT_ACK) || (nType == PDUT_RESPONSE) ? sizeof(S7ERRPDUHEADER) : sizeof(S7PDUHEADER);
	pPar.pStr = lpCon->SndPdu.pData + nHdrLen;
	pHdr->nID = S7PDU_ID;
	pHdr->nType = nType;
	pHdr->nSequence = lpCon->nSequence++;
	switch (nType) {
	case PDUT_REQUEST:
		nReplyLen = sizeof(S7ERRPDUHEADER);
		switch (nFunc) {
		case PDUFN_READ:
		case PDUFN_WRITE:
			lpCon->bAddEnabled = TRUE;
			nReplyLen += sizeof(RW_PAR_HDR);
			MemClr(pPar.pVoid, sizeof(RW_PAR_HDR));
			nParLen = sizeof(RW_PAR_HDR);
			pPar.pReqRW->Hdr.nFunc = nFunc;
			break;
		case PDUFN_CPUSTART:
		case PDUFN_CPUSTOP:
			nReplyLen += sizeof(RESCTRL_PARS);
			if (nFunc == PDUFN_CPUSTOP) {
				nParLen = sizeof(STOP_PARS);
				pLen = &pPar.pStop->nLength;
			}
			else {
				if (nMode) {
					nParLen = sizeof(COLDSTART_PARS);
					pLen = &pPar.pCStart->nLength2;
				}
				else {
					nParLen = sizeof(HOTSTART_PARS);
					pLen = &pPar.pHStart->nLength2;
				}
			}
			MemClr(pPar.pVoid, nParLen);
			pPar.pReqCtrl->nFunc = nFunc;
			if (nFunc == PDUFN_CPUSTART) {
				pPar.pCStart->nReserved[1] = 0xFD;
				if (nMode) {
					pPar.pCStart->nLength1 = ByteSwap16(2);
					pPar.pCStart->nSubFn = ByteSwap16(PDUSFN_COLDSTART);
				}
			}
			*pLen = CTRL_LEN;
			MemCpy(pLen + 1, CTRL_STR, CTRL_LEN);
			break;
		case PDUFN_NEGOTIATE:
			nReplyLen += sizeof(NEGOTIATE_PARS);
			MemClr(pPar.pVoid, sizeof(NEGOTIATE_PARS));
			nParLen = sizeof(NEGOTIATE_PARS);
			pPar.pNeg->nFunc = PDUFN_NEGOTIATE;
			pPar.pNeg->nParallelJobs1 = pPar.pNeg->nParallelJobs2 = ByteSwap16(1);
			pPar.pNeg->nPDUSize = ByteSwap16(MAX_S7PDUSIZE);
			break;
		}
		break;
	case PDUT_USERDATA:
		nReplyLen = sizeof(S7PDUHEADER) + sizeof(RESUSERPARS);
		MemClr(pPar.pVoid, sizeof(REQUSERPARS));
		nParLen = sizeof(REQUSERPARS);
//		pPar.pReqUser->nHead[0] = 0x00;
		pPar.pReqUser->nHead[1] = 0x01;
		pPar.pReqUser->nHead[2] = 0x12;
		pPar.pReqUser->nParLen = 0x04;
		pPar.pReqUser->nReserved = 0x11;
		pPar.pReqUser->nTG = nMode;
		pPar.pReqUser->nSubFn = nFunc;
//		pPar.pReqUser->nSequence = 0x00;
		nReplyLen += (nMode == TG_SZL) ? sizeof(CPUSTATEDATA) : ((nMode == TG_CLOCK) && (nFunc == PDUSFN_GETCLOCK) ? sizeof(CLOCKDATA) : sizeof(DATAHEADER));
		break;
	default:
		nParLen = 0;
	}
	pHdr->nParLen = ByteSwap16(nParLen);
	lpCon->SndPdu.nHdrLen = nHdrLen;
	lpCon->SndPdu.nParLen = nParLen;
	lpCon->SndPdu.nDatLen = 0;
	lpCon->SndPdu.nTotLen = nHdrLen + nParLen;
	lpCon->nReplyLen = nReplyLen;
	return S7ERR_NONE;
}
// **********************************************************************************
INT32 __stdcall pS7PDU_RcvInit(LPS7CONNECTION lpCon, LPINT32 lpSysErr) {
LPS7ERRPDUHEADER	pHdr;
S7ANYPARPTR			pPar;
INT32				nRes;

	pHdr = (LPS7ERRPDUHEADER) lpCon->RcvPdu.pData;
	*lpSysErr = lpCon->RcvPdu.nHdrLen = lpCon->RcvPdu.nParLen = lpCon->RcvPdu.nDatLen = 0;
	switch (pHdr->nType) {
	case PDUT_ACK:
	case PDUT_RESPONSE:
		lpCon->RcvPdu.nHdrLen = sizeof(S7ERRPDUHEADER);
		*lpSysErr = ByteSwap16(pHdr->nError);
		nRes = *lpSysErr ? S7ERR_PDUERROR : 0;
		break;
	case PDUT_REQUEST:
	case PDUT_USERDATA:
		lpCon->RcvPdu.nHdrLen = sizeof(S7PDUHEADER);
		nRes = 0;
		break;
	default:
		nRes = S7ERR_UNKNOWNPDU;
	}
	if (!nRes) {
		lpCon->RcvPdu.nParLen = ByteSwap16(pHdr->nParLen);
		lpCon->RcvPdu.nDatLen = ByteSwap16(pHdr->nDatLen);
		if (pHdr->nType == PDUT_USERDATA) {
			if (lpCon->RcvPdu.nParLen != sizeof(RESUSERPARS)) {
				nRes = S7ERR_INVALIDRESPONSE;
			}
			else {
				pPar.pStr = lpCon->RcvPdu.pData + lpCon->RcvPdu.nHdrLen;
				*lpSysErr = ByteSwap16(pPar.pResUser->nError);
				if (*lpSysErr) nRes = S7ERR_PARERROR;
			}
		}
	}
	lpCon->RcvPdu.nTotLen = lpCon->RcvPdu.nHdrLen + lpCon->RcvPdu.nParLen + lpCon->RcvPdu.nDatLen;
	if (!nRes && (lpCon->RcvPdu.nTotLen != lpCon->nReplyLen)) nRes = S7ERR_BADREPLYSIZE;
	return nRes;
}	
// **********************************************************************************
INT32 __stdcall pS7PDU_SetPDUSize(LPS7CONNECTION lpCon) {
LPS7ERRPDUHEADER	pHdr;
LPNEGOTIATE_PARS	pPar;
INT32				nRes, nLen;

	pHdr = (LPS7ERRPDUHEADER) lpCon->RcvPdu.pData;
	pPar = (LPNEGOTIATE_PARS) (lpCon->RcvPdu.pData + lpCon->RcvPdu.nHdrLen);
	nLen = (pHdr->nType == PDUT_RESPONSE) && (pPar->nFunc == PDUFN_NEGOTIATE) ? ByteSwap16(pPar->nPDUSize) : 0;
	if (nLen < MIN_S7PDUSIZE) {
		nLen = 0;
	}
	else if (nLen > MAX_S7PDUSIZE) {
		nLen = MAX_S7PDUSIZE;
	}
	nRes = nLen < MIN_S7PDUSIZE ? S7ERR_INVALIDPDUSIZE : 0;
	if (nLen) lpCon->nPDUSize = nLen;
	return nRes;
}	
// **********************************************************************************
void __stdcall pS7PDU_AddData(LPS7CONNECTION lpCon, LPVOID lpData, INT32 nSize) {
LPS7PDUHEADER	pHdr;
LPSTR			pDat;

	pHdr = (LPS7PDUHEADER) lpCon->SndPdu.pData;
	pDat = lpCon->SndPdu.pData + lpCon->SndPdu.nTotLen;
	MemCpy(pDat, lpData, nSize);
	lpCon->SndPdu.nDatLen = nSize;
	lpCon->SndPdu.nTotLen += nSize;
	pHdr->nDatLen = ByteSwap16(nSize);
}
