/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * s7com32 - utils.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <s7com32.h>
#include "private.h"

// **********************************************************************************
BOOL __stdcall S7_GetBit(LPVOID lpBuf) {

	return *((LPINT8) lpBuf) ? 1 : 0;
}
// **********************************************************************************
void __stdcall S7_SetBit(LPVOID lpBuf, BOOL bValue) {

	*((LPINT8) lpBuf) = bValue ? 1 : 0;
}
// **********************************************************************************
char __stdcall S7_GetChar(LPVOID lpBuf) {

	return *((LPSTR) lpBuf);
}
// **********************************************************************************
void __stdcall S7_SetChar(LPVOID lpBuf, char cValue) {

	*((LPSTR) lpBuf) = cValue;
}
// **********************************************************************************
INT32 __stdcall S7_GetShort(LPVOID lpBuf) {

	return *((LPINT8) lpBuf);
}
// **********************************************************************************
void __stdcall S7_SetShort(LPVOID lpBuf, INT8 nValue) {

	*((LPINT8) lpBuf) = nValue;
}
// **********************************************************************************
UINT32 __stdcall S7_GetByte(LPVOID lpBuf) {

	return *((LPUINT8) lpBuf);
}
// **********************************************************************************
void __stdcall S7_SetByte(LPVOID lpBuf, UINT8 nValue) {

	*((LPUINT8) lpBuf) = nValue;
}
// **********************************************************************************
INT32 __stdcall S7_GetInt(LPVOID lpBuf) {

	return SByteSwap16(*((LPINT16) lpBuf));
}
// **********************************************************************************
void __stdcall S7_SetInt(LPVOID lpBuf, INT16 nValue) {

	*((LPINT16) lpBuf) = ByteSwap16(nValue);
}
// **********************************************************************************
UINT32 __stdcall S7_GetWord(LPVOID lpBuf) {

	return ByteSwap16(*((LPUINT16) lpBuf));
}
// **********************************************************************************
void __stdcall S7_SetWord(LPVOID lpBuf, UINT16 nValue) {

	*((LPUINT16) lpBuf) = ByteSwap16(nValue);
}
// **********************************************************************************
UINT32 __stdcall S7_GetCounter(LPVOID lpBuf) {
ANYVALUE	any;
UINT32		nValue;

	GetErrorFlags(); 
	any.u16 = ByteSwap16(*((LPUINT16) lpBuf));
	nValue =  BCDToByte(any.aU8[1] & 0x0F) * 100 + BCDToByte(any.aU8[0]);
	if (GetErrorFlags() & ERRF_BCD) nValue = 0;
	return nValue;
}
// **********************************************************************************
BOOL __stdcall S7_SetCounter(LPVOID lpBuf, UINT32 nValue) {
ANYVALUE	any;
BOOL		bErr;

	bErr = nValue >= 1000 ? TRUE : FALSE;
	if (bErr) {
		any.u16 = 0;
	}
	else {
		any.aU8[1] = ByteToBCD(nValue % 100);
		any.aU8[0] = ByteToBCD(nValue / 100);
	}
	*((LPUINT32) lpBuf) = any.u16;
	return bErr;
}
// **********************************************************************************
//	S5TIME --> TIME
UINT32 __stdcall S7_GetS5Time(LPVOID lpBuf) {
ANYVALUE	any;
UINT32		nValue, nMul;

	GetErrorFlags(); 
	any.u16 = ByteSwap16(*((LPUINT16) lpBuf));
	nValue =  BCDToByte(any.aU8[1] & 0x0F) * 100 + BCDToByte(any.aU8[0]);
	nMul = 0;
	if ((GetErrorFlags() & ERRF_BCD) == 0) {
		switch (any.aU8[1] >> 4) {
		case 0:
			nMul = 10;
			break;
		case 1:
			nMul = 100;
			break;
		case 2:
			nMul = 1000;
			break;
		case 3:
			nMul = 10000;
			break;
		} 
	} 
	return nValue * nMul;
}
// **********************************************************************************
//	TIME --> S5TIME
BOOL __stdcall S7_SetS5Time(LPVOID lpBuf, UINT32 nTime) {
ANYVALUE	any;
UINT32		nValue, nDiv, nRes;
BOOL		bErr;

	bErr = FALSE;
	if (nTime < 10000) {
		nRes = 0;
		nDiv = 10;
	}
	else if (nTime < 100000) {
		nRes = 1;
		nDiv = 100;
	}
	else if (nTime < 1000000) {
		nRes = 2;
		nDiv = 1000;
	}
	else if (nTime < 10000000) {
		nRes = 3;
		nDiv = 10000;
	}
	else {
		bErr = TRUE;
		any.u16 = 0;
	}
	if (!bErr) {
		nValue = nTime / nDiv;
		any.aU8[1] = ByteToBCD(nValue % 100);
		any.aU8[0] = ByteToBCD(nValue / 100) | (nRes << 4);
	}
	*((LPUINT32) lpBuf) = any.u16;
	return bErr;
}
// **********************************************************************************
INT32 __stdcall S7_GetDInt(LPVOID lpBuf) {

	return ByteSwap32(*((LPUINT32) lpBuf));
}
// **********************************************************************************
void __stdcall S7_SetDInt(LPVOID lpBuf, INT32 nValue) {

	*((LPINT32) lpBuf) = ByteSwap32(nValue);
}
// **********************************************************************************
UINT32 __stdcall S7_GetDWord(LPVOID lpBuf) {

	return ByteSwap32(*((LPUINT32) lpBuf));
}
// **********************************************************************************
void __stdcall S7_SetDWord(LPVOID lpBuf, UINT32 nValue) {

	*((LPUINT32) lpBuf) = ByteSwap32(nValue);
}
// **********************************************************************************
UINT32 __stdcall S7_GetTime(LPVOID lpBuf) {

	return ByteSwap32(*((LPUINT32) lpBuf));
}
// **********************************************************************************
void __stdcall S7_SetTime(LPVOID lpBuf, UINT32 nValue) {

	*((LPUINT32) lpBuf) = ByteSwap32(nValue);
}
// **********************************************************************************
double __stdcall S7_GetReal(LPVOID lpBuf) {
ANYVALUE	any;

	any.u32 = ByteSwap32(*((LPUINT32) lpBuf));
	return any.f;
}
// **********************************************************************************
void __stdcall S7_SetReal(LPVOID lpBuf, double fValue) {
ANYVALUE	any;

	any.f = (float) fValue;
	*((LPUINT32) lpBuf) = ByteSwap32(any.u32);
}
// **********************************************************************************
BOOL __stdcall S7_GetDT(LPSYSTEMTIME lpSt, LPVOID lpBuf) {
LPS7DATETIME	pTime;
INT32			nYear;
BOOL			bErr;

	GetErrorFlags();
	pTime = lpBuf;
	nYear = BCDToByte(pTime->bcdYear);
	lpSt->wYear = (nYear >= 90 ? 1900 : 2000) + nYear;
	lpSt->wMonth =  BCDToByte(pTime->bcdMonth);
	lpSt->wDay =  BCDToByte(pTime->bcdDay);
	lpSt->wHour =  BCDToByte(pTime->bcdHour);
	lpSt->wMinute =  BCDToByte(pTime->bcdMin);
	lpSt->wSecond =  BCDToByte(pTime->bcdSec);
	lpSt->wMilliseconds =  10 * BCDToByte(pTime->bcdMsec) + (pTime->bcdDoW >> 4);
	lpSt->wDayOfWeek =  (pTime->bcdDoW &0x0F) - 1;
	bErr = (GetErrorFlags() & ERRF_BCD ? TRUE :FALSE) || !DateValid(lpSt);
	return bErr;
}
// **********************************************************************************
BOOL __stdcall S7_SetDT(LPVOID lpBuf, LPSYSTEMTIME lpSt) {
LPS7DATETIME	pTime;
BOOL			bErr;

	GetErrorFlags();
	if (DateValid(lpSt)) {
		pTime = lpBuf;
		pTime->bcdYear = ByteToBCD(lpSt->wYear % 100);
		pTime->bcdMonth = ByteToBCD(lpSt->wMonth);
		pTime->bcdDay = ByteToBCD(lpSt->wDay);
		pTime->bcdHour = ByteToBCD(lpSt->wHour);
		pTime->bcdMin = ByteToBCD(lpSt->wMinute);
		pTime->bcdSec = ByteToBCD(lpSt->wSecond);
		pTime->bcdMsec = ByteToBCD(lpSt->wMilliseconds / 10);
		pTime->bcdDoW = (lpSt->wMilliseconds % 10) * 10 + lpSt->wDayOfWeek + 1;
		bErr = GetErrorFlags() & ERRF_BCD ? TRUE :FALSE;
	}
	else {
		bErr = TRUE;
	}
	return bErr;
}
// **********************************************************************************
void __stdcall S7_GetDate(LPSYSTEMTIME lpSt, LPVOID lpBuf) {
UINT32		nDay;

	nDay = ByteSwap16(*((LPUINT16) lpBuf));
	DayToDate(nDay, 1990, lpSt);
}
// **********************************************************************************
void __stdcall S7_SetDate(LPVOID lpBuf, LPSYSTEMTIME lpSt) {
UINT32		nDay;

	nDay = DateToDay(1990, lpSt);
	*((LPUINT16) lpBuf) = ByteSwap16(nDay);
}
// **********************************************************************************
void __stdcall S7_GetTOD(LPSYSTEMTIME lpSt, LPVOID lpBuf) {
UINT32		nMSec;

	nMSec = ByteSwap32(*((LPUINT32) lpBuf));
	MilliSecToTime(nMSec, lpSt);
}
// **********************************************************************************
void __stdcall S7_SetTOD(LPVOID lpBuf, LPSYSTEMTIME lpSt) {
UINT32		nMSec;

	nMSec = TimeToMilliSec(0, lpSt);
	*((LPUINT32) lpBuf) = ByteSwap32(nMSec);
}
