/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_ifdlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
static BOOL			m_bFromPC		= FALSE;
static SYSTEMTIME	m_ST			= {0};
// **********************************************************************************
static void __stdcall DlgTimerProc(HWND hDlg, UINT32 uMsg, UINT32 idEvent, ULONG dwTime) {
SYSTEMTIME		st;
INT32			nErr;

	nErr = S7_GetCpuClock(g_VAT.hCon, &st);
	if (nErr == S7ERR_NONE) {
		SendDlgItemMessage(hDlg, IDC_CLK_PLCDATE, DTM_SETSYSTEMTIME, GDT_VALID, (LPARAM) &st);
		SendDlgItemMessage(hDlg, IDC_CLK_PLCTIME, DTM_SETSYSTEMTIME, GDT_VALID, (LPARAM) &st);
		if (m_bFromPC) {
			GetLocalTime(&m_ST);
			SendDlgItemMessage(hDlg, IDC_CLK_PCDATE, DTM_SETSYSTEMTIME, GDT_VALID, (LPARAM) &m_ST);
			SendDlgItemMessage(hDlg, IDC_CLK_PCTIME, DTM_SETSYSTEMTIME, GDT_VALID, (LPARAM) &m_ST);
		}
	}
}
// **********************************************************************************
static void __stdcall EnablePickers(HWND hDlg) {

	EnableWindow(GetDlgItem(hDlg, IDC_CLK_PCDATE), !m_bFromPC);
	EnableWindow(GetDlgItem(hDlg, IDC_CLK_PCTIME), !m_bFromPC);
}
// **********************************************************************************
static INT32 CALLBACK pSetClkDlg(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
LPNMDATETIMECHANGE	pChange;
SYSTEMTIME			st[2];
INT32				i, nID, nCmd, nValue;

	switch (uMsg) {
	case WM_INITDIALOG:
		MemClr(&st[0], sizeof(SYSTEMTIME));
		MemClr(&st[1], sizeof(SYSTEMTIME));
		st[0].wYear = 1990;
		st[0].wMonth = 1;
		st[0].wDay = 1;
		st[1].wYear = 2089;
		st[1].wMonth = 12;
		st[1].wDay = 31;
		SecToTime(SECONDSOFDAY - 1, &st[1]);
		for (i = IDC_CLK_DTFIRST; i < IDC_CLK_DTLAST; i++) {
			SendDlgItemMessage(hDlg, i, DTM_SETRANGE, GDTR_MIN | GDTR_MAX, (LPARAM) &st);
		}
		m_bFromPC = TRUE;
		EnablePickers(hDlg);
		CheckDlgButton(hDlg, IDC_CLK_PCLOCAL, BST_CHECKED);
		CenterWindow(hDlg, g_hWndMain);
		EnableWindow(GetDlgItem(hDlg, IDC_CLK_PLCDATE), FALSE);
		EnableWindow(GetDlgItem(hDlg, IDC_CLK_PLCTIME), FALSE);
		SetTimer(hDlg, IDC_TIMER, 300, DlgTimerProc);
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		return TRUE;
	case WM_COMMAND:
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDOK:
			EndDialog (hDlg, IDOK);
			return TRUE ;
		case IDCANCEL:
			EndDialog (hDlg, 0);
			return TRUE ;
		case IDC_CLK_PCLOCAL:
			switch (nCmd) {
			case BN_CLICKED:
				m_bFromPC = !m_bFromPC;
				EnablePickers(hDlg);
				break;
			}
			return TRUE;
		} // end switch
		return TRUE ;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if (wParam == IDC_SEPARATOR) {
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_NOTIFY:
		pChange = (LPNMDATETIMECHANGE) lParam;
		switch (pChange->nmhdr.idFrom) {
		case IDC_CLK_PCDATE:
		case IDC_CLK_PCTIME:
			if (pChange->nmhdr.code == DTN_DATETIMECHANGE) {
				if (pChange->nmhdr.idFrom == IDC_CLK_PCTIME) {
					nValue = TimeToSec(&pChange->st);
					SecToTime(nValue, &m_ST);
				}
				else {
					nValue = DateToDay(1990, &pChange->st);
					DayToDate(nValue, 1990, &m_ST);
				}
			}
		}
		break;
	case WM_DESTROY:
		KillTimer(hDlg, IDC_TIMER);
		return TRUE;
	} // end switch
	return FALSE ;
}
// **********************************************************************************
BOOL __cdecl DoSetClock() {
INT32			nDlg, nRes;
BOOL			bRet;

	bRet = FALSE;
	nDlg = DialogBox(g_hInstance, RESSTR(IDD_SETCLOCK), g_hWndMain, pSetClkDlg);
	if (nDlg == IDOK) {
		if (m_bFromPC) GetLocalTime(&m_ST);
		nRes = S7_SetCpuClock(g_VAT.hCon, &m_ST);
		WriteMsg(IDS_SETCLOCK, 0, NULL);
		bRet = TRUE;
	}
	return bRet;
}
