/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_ifdlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
static INT32	m_nLastMode		= 0;
// **********************************************************************************
static INT32 CALLBACK pIF_Open(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
INT32				nID, nCmd;

	switch (uMsg) {
	case WM_INITDIALOG:
		CheckDlgButton(hDlg, IDC_IF_TCP + m_nLastMode, BST_CHECKED);
		CenterWindow(hDlg, g_hWndMain);
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		return TRUE;
	case WM_COMMAND:
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDOK:
			EndDialog (hDlg, IDOK);
			return TRUE ;
		case IDCANCEL:
			EndDialog (hDlg, 0);
			return TRUE ;
		case IDC_IF_TCP:
		case IDC_IF_ONLINE:
		case IDC_IF_CP_L2_1:
		case IDC_IF_CP_L2_2:
			switch (nCmd) {
			case BN_CLICKED:
				m_nLastMode = nID - IDC_IF_TCP;
				break;
			}
			return TRUE;
		} // end switch
		return TRUE ;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if (wParam == IDC_SEPARATOR) {
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		return TRUE ;
	} // end switch
	return FALSE ;
}
// **********************************************************************************
BOOL __cdecl OpenInterface() {
INT32	nDlg;
BOOL	bRet;

	bRet = FALSE;
	m_nLastMode = g_VAT.nIFMode;
	nDlg = DialogBox(g_hInstance, RESSTR(IDD_OPENIF), g_hWndMain, pIF_Open);
	if (nDlg == IDOK) {
		if (g_VAT.nIFMode != m_nLastMode) {
			if (g_VAT.nIFMode == IFM_TCP) g_VAT.nAddr = DEFAULT_MPI;
			if (m_nLastMode == IFM_TCP) g_VAT.nAddr = DEFAULT_IP;
		}
		g_VAT.nIFMode = m_nLastMode;
		g_VAT.hIF = S7_Interface_Init(g_VAT.nIFMode);
		WriteMsg(IDS_IF_INIT, 0, NULL);
		bRet = TRUE;
	}
	return bRet;
}
