/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_inpdlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
static BOOL			m_bInit				= FALSE;
static BOOL			m_bWrite			= FALSE;
static BOOL			m_bUpDn				= FALSE;
static INT32		m_nIndex			= 0;
static INT32		m_nView				= 0;
static INT32		m_nSelIdx			= 0;
static LPVARINFO	m_pInfo				= NULL;
static LPSTR		m_pName				= NULL;
static BOOL			m_bEditErr			= FALSE;
static ANYVALUE		m_nEditMin;
static ANYVALUE		m_nEditMax;
static ANYVALUE		m_EditVal;
// **********************************************************************************
static void __stdcall SetEditStr(HWND hDlg, BOOL bSel) {
char	cBuf[256];
INT32	nLen;
BOOL	bInit, bErr;

	bInit = m_bInit;
	m_bInit = TRUE;
	bErr = m_bEditErr;
	nLen = GetValueStr(FALSE, TRUE, m_nIndex, m_pInfo, cBuf, &m_bEditErr);
	SendDlgItemMessage(hDlg, IDC_INP_VAL, WM_SETTEXT, 0, (LPARAM) cBuf);
	if (bSel) SendDlgItemMessage(hDlg, IDC_INP_VAL, EM_SETSEL, 0, nLen);
	if (bErr != m_bEditErr) UpdateDlgWindow(hDlg, IDC_INP_VAL, TRUE);
	m_bInit = bInit;
}
// **********************************************************************************
static void __stdcall EnableOK(HWND hDlg) {
BOOL	bEn;

	bEn = !m_bEditErr;
	EnableWindow(GetDlgItem(hDlg, IDOK), bEn);
}
// **********************************************************************************
static void __stdcall InitControls(HWND hDlg, BOOL bFirst) {
SYSTEMTIME	rst[2], st;
HANDLE		hEdit;
BOOL		bDate, bTime, bEdit, bChg;
INT32		nUpDn, nUpDnMin, nUpDnMax, nSel, nAccel, nViewModeCnt;
INT32		nViewModeList[VM_MAX];
UDACCEL		Accel[3];

	bChg = FALSE;
	nSel = FillViewModeList(TRUE, FALSE, m_nIndex, m_pInfo, &nViewModeCnt, nViewModeList);
	if (bFirst) {
		m_nSelIdx = nSel;
		FillComboFromResList(hDlg, IDC_INP_TYPE, nViewModeCnt, nViewModeList, m_nSelIdx, TRUE);
		bChg = TRUE;
	}
	else {
		nSel = SendDlgItemMessage(hDlg, IDC_INP_TYPE, CB_GETCURSEL, 0, 0);
		if (nSel != m_nSelIdx) {
			m_nSelIdx = nSel;
			bChg = TRUE;
		}
	}
	m_nView = nViewModeList[m_nSelIdx] - IDM_VM_FIRST;
	m_pInfo->pView[m_nIndex] = m_nView;
	if (m_nView == VM_DEFAULT) m_nView = GetDefViewMode(m_pInfo);
	if (bChg && m_bWrite) {
		bDate = bTime = m_bUpDn = FALSE;
		bEdit = TRUE;
		m_nEditMin.u64 = 0;
		GetViewValue(m_nIndex, m_pInfo, &m_EditVal, &st);
		switch (m_nView) {
		case VM_BIN:
		case VM_HEX:
		case VM_DEC:
		case VM_UDEC:
		case VM_CHAR:
			nAccel = 0;
			if (m_pInfo->nPlcVarSize == 8) {
				m_nEditMax.u64 = MAX_UNSIGNED64;
			}
			else {
				m_bUpDn = TRUE;
				if (m_pInfo->nVT == S7VT_BIT) {
					m_nEditMax.u64 = 1;
				}
				else {
					Accel[0].nSec = 0;
					Accel[0].nInc = 1;
					Accel[1].nSec = 2;
					Accel[1].nInc = 10;
					Accel[2].nSec = 10;
					Accel[2].nInc = 1000000;
					if ((m_pInfo->nPlcVarSize == 4) ||  (m_pInfo->nVT == S7VT_TIMER)) {
						Accel[1].nInc = 1000;
						nAccel = 3;
						if (m_nView == VM_DEC) {
							m_nEditMin.i64 = MIN_SIGNED32;
							m_nEditMax.i64 = MAX_SIGNED32;
						}
						else {
							if (m_pInfo->nVT == S7VT_TIMER) {
								m_nEditMax.i64 = 9990000;
								Accel[2].nInc = 100000;
							}
							else {
								m_nEditMax.u64 = MAX_UNSIGNED32;
							}
						}
					}
					else if (m_pInfo->nPlcVarSize == 2) {
						nAccel = 2;
						Accel[1].nInc = 100;
						if (m_nView == VM_DEC) {
							m_nEditMin.i64 = MIN_SIGNED16;
							m_nEditMax.i64 = MAX_SIGNED16;
						}
						else {
							m_nEditMax.u64 = (m_pInfo->nVT == S7VT_COUNTER) ? 999 : MAX_UNSIGNED16;
						}
					}
					else {
						nAccel = 1;
						if (m_nView == VM_DEC) {
							m_nEditMin.i64 = MIN_SIGNED8;
							m_nEditMax.i64 = MAX_SIGNED8;
						}
						else {
							m_nEditMax.u64 = MAX_UNSIGNED8;
						}
					}
				}
			}
			break;
		case VM_REAL:
			break;
		case VM_TIME:
			break;
		case VM_DT:
			MemClr(&rst[0], sizeof(SYSTEMTIME));
			MemClr(&rst[1], sizeof(SYSTEMTIME));
			rst[0].wYear = 1990;
			rst[0].wMonth = 1;
			rst[0].wDay = 1;
			rst[1].wYear = m_pInfo->nVT == S7VT_DT ? 2089 : 2168;
			rst[1].wMonth = 12;
			rst[1].wDay = 31;
			SecToTime(SECONDSOFDAY - 1, &rst[1]);
			SendDlgItemMessage(hDlg, IDC_INP_DATE, DTM_SETRANGE, GDTR_MIN | GDTR_MAX, (LPARAM) &rst);
			SendDlgItemMessage(hDlg, IDC_INP_TIME, DTM_SETRANGE, GDTR_MIN | GDTR_MAX, (LPARAM) &rst);
			SendDlgItemMessage(hDlg, IDC_INP_DATE, DTM_SETSYSTEMTIME, GDT_VALID, (LPARAM) &st);
			SendDlgItemMessage(hDlg, IDC_INP_TIME, DTM_SETSYSTEMTIME, GDT_VALID, (LPARAM) &st);
			bEdit = FALSE;
			bDate = m_pInfo->nPlcVarSize != 4;
			bTime = m_pInfo->nPlcVarSize != 2;
			break;
		}
		hEdit = GetDlgItem(hDlg, IDC_INP_VAL);
		ShowDlgItem(hDlg, IDC_INP_UD, m_bUpDn ? SW_SHOW : SW_HIDE);
		EnableWindow(hEdit, bEdit);
		EnableWindow(GetDlgItem(hDlg, IDC_INP_DATE), bDate);
		EnableWindow(GetDlgItem(hDlg, IDC_INP_TIME), bTime);
		if (bFirst)	{
			SendDlgItemMessage(hDlg, IDC_INP_UD, UDM_SETBUDDY, (WPARAM) hEdit, 0);
		}
		if (m_bUpDn) {
			if (m_nEditMax.u64 == MAX_UNSIGNED32) {
				nUpDnMin = MIN_SIGNED32;
				nUpDnMax = MAX_SIGNED32;
				nUpDn = (INT32) (m_EditVal.i64 + MIN_SIGNED32);
			}
			else {
				nUpDnMin = m_nEditMin.i32;
				nUpDnMax = m_nEditMax.i32;
				nUpDn = m_EditVal.i32;
			}
			SendDlgItemMessage(hDlg, IDC_INP_UD, UDM_SETRANGE32, nUpDnMin, nUpDnMax);
			SendDlgItemMessage(hDlg, IDC_INP_UD, UDM_SETPOS32, 0, nUpDn);
			if (nAccel) SendDlgItemMessage(hDlg, IDC_INP_UD, UDM_SETACCEL, nAccel, (LPARAM) &Accel);
		}
	}
	if (bFirst)	{
		SendDlgItemMessage(hDlg, IDC_INP_NAME_VAL, EM_SETLIMITTEXT, S7MAX_NAMELEN, 0);
		SendDlgItemMessage(hDlg, IDC_INP_NAME_VAL, WM_SETTEXT, 0, (LPARAM) m_pName);
	}
	SetEditStr(hDlg, FALSE);
}
// **********************************************************************************
static void __stdcall GetInpVal(HWND hDlg) {
#define MODE_STRT	0
#define MODE_DAY	1
#define MODE_HOUR	2
#define MODE_MIN	3
#define MODE_SEC	4
#define MODE_MSEC	5
static INT32	m_nFactor[6]	= {0, 86400000, 3600000, 60000, 1000, 1};
INT32		nLen, nScan, nMode, nLast, nValMode;
ANYVALUE	nPrev, nAct;
char		c, cBuf[256];
LPSTR		pStr;
BOOL		bState, bOK, bSigned;

	nLen = SendDlgItemMessage(hDlg, IDC_INP_VAL, WM_GETTEXT, sizeof(cBuf), (LPARAM) cBuf);
	if (m_nView != VM_CHAR) {
		nLen = TrimStr(cBuf, TSM_BOTH);
		CharLower(cBuf);
	}
	pStr = cBuf;
	bOK = nLen > 0;
	if (bOK) {
		switch (m_nView) {
		case VM_TIME:
			nPrev.i64 = 0;
			nMode = MODE_STRT;
			nValMode = NF_DEC | NF_INT16;
			while (nLen && bOK && (nMode < MODE_MSEC)) {
				nAct.i64 = IntVal(pStr, nValMode, 0, &nScan);
				if ((nScan == nLen) || (nScan <= 0)) {
					bOK = FALSE;
				}
				else {
					pStr += nScan;
					nLen -= nScan;
					nLast = nMode;
					if (*pStr == 'd') {
						nMode = MODE_DAY;
					}
					else if (*pStr == 'h') {
						nMode = MODE_HOUR;
					}
					else if (*pStr == 's') {
						nMode = MODE_SEC;
					}
					else if (*pStr == 'm') {
						pStr++;
						if (*pStr == 's') {
							nMode = MODE_MSEC;
							nLen--;
						}
						else {
							pStr--;
							nMode = MODE_MIN;
						}
					}
					else {
						bOK = FALSE;
					}
					pStr++;
					nLen--;
				}
				if (nMode <= nLast) bOK = FALSE;
				if (bOK) {
					if (nPrev.i64 < 0) nAct.i64 = -nAct.i64;
					nPrev.i64 += nAct.i64 * m_nFactor[nMode];
				}
				nValMode = NF_UDEC | NF_INT16 | NF_UNSIGNED;
			}
			if (nLen || (((m_pInfo->nVT == S7VT_S5TIME) || (m_pInfo->nVT == S7VT_TIMER)) && ((nPrev.i64 < 0) || (nPrev.i64 > 9990000)))) bOK = FALSE;
			if (bOK) m_EditVal.i64 = nPrev.i64;
			break;
		case VM_REAL:
			nAct.d = FltVal(cBuf, NF_DEFAULT | NF_SEP, &nScan);
			bOK = (nLen > 0) && (nScan == nLen);
			if (bOK) {
				m_EditVal.u64 = 0;
				m_EditVal.f = (float) nAct.d;
			}
			break;
		case VM_CHAR:
			if (nLen > 1) {
				nLen--;
				if (cBuf[0] == '#') {
					nAct.u64 = IntVal(&cBuf[1], NF_UDEC, 0, &nScan);
					bOK = nLen == nScan;
				}
				else {
					bOK = FALSE;
				}
			}
			else {
				nAct.u64 = (UINT8) cBuf[0];
			}
		default:
			if (m_nView != VM_CHAR) {
				bSigned = FALSE;
				c = 0;
				switch (m_nView) {
				case VM_BIN:
					nMode = NF_BIN | NF_SEP | NF_NOSEPERR;
					if (m_pInfo->nVT != S7VT_BIT) c = 'b';
					break;
				case VM_HEX:
					nMode = NF_HEX | NF_SEP | NF_NOSEPERR;
					c = 'x';
					break;
				case VM_DEC:
					bSigned = TRUE;
					nMode = NF_DEC | NF_SEP | NF_NOSEPERR;
					break;
				case VM_UDEC:
					nMode = NF_UDEC | NF_SEP | NF_NOSEPERR;
					break;
				}
				if (c) {
					bOK = (nLen > 2) && (cBuf[0] == '0') && (cBuf[1] == c) && (cBuf[2] >= '0');
					pStr += 2;
					nLen -= 2;
				}
				if (bOK) {
					nAct.i64 = IntVal(pStr, nMode, 0, &nScan);
					bOK = (nScan == nLen) && ((bSigned && (nAct.i64 >= m_nEditMin.i64) && (nAct.i64 <= m_nEditMax.i64)) || (!bSigned && (nAct.u64 >= m_nEditMin.u64) && (nAct.u64 <= m_nEditMax.u64)));
				}
			}
			if (bOK) {
				nPrev.u64 = m_EditVal.u64;
				m_EditVal.u64 = nAct.u64;
				if (m_bUpDn) {
					if (m_nEditMax.u64 == MAX_UNSIGNED32) nAct.i64 += MIN_SIGNED32;
					if (nPrev.u64 != m_EditVal.u64) SendDlgItemMessage(hDlg, IDC_INP_UD, UDM_SETPOS32, 0, nAct.i32);
				}
			}
		}
		if (bOK) SetViewValue(m_nIndex, m_pInfo, &m_EditVal, NULL);
	}
	bState = !m_bEditErr;
	m_bEditErr = !bOK;
	EnableOK(hDlg);
	if (bOK != bState) UpdateDlgWindow(hDlg, IDC_INP_VAL, TRUE);
}
// **********************************************************************************
static INT32 CALLBACK pVarInput(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPNMDATETIMECHANGE	pChange;
LPDRAWITEMSTRUCT	pDIS;
LPNMUPDOWN			pUD;
LPNMHDR				pHdr;
INT32				nCmd, nID, nRet;
ANYVALUE			nAct;

	switch (uMsg) {
	case WM_INITDIALOG:
		m_bInit = TRUE;
		InitControls(hDlg, TRUE);
		EnableOK(hDlg);
		CenterWindow(hDlg, GetParent(hDlg));
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		m_bInit = FALSE;
		return TRUE;
	case WM_CTLCOLOREDIT:
		nID = GetDlgCtrlID((HWND) lParam);
		if (nID == IDC_INP_VAL) {
			if (m_bEditErr) {
				SetTextColor((HDC) wParam, RGB_BLACK);
				SetBkColor((HDC) wParam, RGB_LIGHTRED);
				return (LRESULT) g_hRedBrush;
			}
			else {
				SetTextColor((HDC) wParam, GetSysColor(COLOR_WINDOWTEXT));
				SetBkColor((HDC) wParam, GetSysColor(COLOR_WINDOW));
				return (LRESULT) GetSysColorBrush(COLOR_WINDOW);
			}
		}
		break;
	case WM_COMMAND:
		nRet = 0;
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDC_INP_VAL:
		case IDC_INP_NAME_VAL:
			switch (nCmd) {
			case EN_SETFOCUS:
				SendDlgItemMessage(hDlg, nID, EM_SETSEL, 0, 255);
				break;
			case EN_CHANGE:
				if (!m_bInit) {
					if (nID == IDC_INP_VAL) {
						GetInpVal(hDlg);
					}
					else {
						SendDlgItemMessage(hDlg, IDC_INP_NAME_VAL, WM_GETTEXT, S7MAX_NAMESIZE, (LPARAM) m_pName);
						TrimStr(m_pName, TSM_BOTH);
					}
				}
				break;
			}
			break;
		case IDC_INP_TYPE:
			if (nCmd == CBN_SELCHANGE) {
				InitControls(hDlg, FALSE);
				EnableOK(hDlg);
			}
			break;
		case IDOK:
			nRet = IDOK;
		case IDCANCEL:
			EndDialog (hDlg, nRet);
		}
		return TRUE;
		break;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if ((wParam >= IDC_SEPARATOR) && (wParam <= IDC_SEPARATOR9)){
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_NOTIFY:
		pHdr = (LPNMHDR) lParam;
		nID = pHdr->idFrom;
		switch (nID) {
		case IDC_INP_DATE:
		case IDC_INP_TIME:
			if ((pHdr->code == DTN_DATETIMECHANGE) && !m_bInit) {
				pChange = (LPNMDATETIMECHANGE) lParam;
				pChange->st.wMilliseconds = 0;
				SetViewValue(m_nIndex, m_pInfo, &m_EditVal, &pChange->st);
				SetEditStr(hDlg, FALSE);
			}
			break;
		case IDC_INP_UD:
			if ((pHdr->code == UDN_DELTAPOS) && !m_bInit && m_bUpDn) {
				pUD = (LPNMUPDOWN) lParam;
				nAct.i64 = pUD->iDelta + pUD->iPos;
				if (m_nEditMax.u64 == MAX_UNSIGNED32) nAct.i64 -= MIN_SIGNED32;
				if (nAct.i64 < m_nEditMin.i64) nAct.i64 = m_nEditMin.i64;
				if (nAct.i64 > m_nEditMax.i64) nAct.i64 = m_nEditMax.i64;
				if (nAct.i64 != m_EditVal.i64) {
					m_EditVal.i64 = nAct.i64;
					SetViewValue(m_nIndex, m_pInfo, &m_EditVal, NULL);
					SetEditStr(hDlg, TRUE);
				}
				return TRUE;
			}
		}
		break;
	}
	return FALSE;
}
// **********************************************************************************
BOOL __stdcall DoVarInput(BOOL bWrite, INT32 nIndex, HWND hWnd, LPVARINFO lpInfo) {
INT32		nDlg, nID, nView;
ANYPOINTER	pAny;
LPSTR		pSave;
char		cName[S7MAX_NAMESIZE];
BOOL		bRet;

	bRet = FALSE;
	m_bWrite = bWrite;
	m_pInfo = lpInfo;
	m_nIndex = nIndex;
	pAny.pVoid = lpInfo->pData;
	pAny.pStr += nIndex * lpInfo->nPCVarSize;
	pSave = pAny.pStr + lpInfo->nAllocSize;
	MemCpy(pSave, pAny.pStr, lpInfo->nPCVarSize);
	m_pName = m_pInfo->pName + m_nIndex * S7MAX_NAMESIZE;
	StrCpy(cName, m_pName);
	nView = m_nView = m_pInfo->pView[m_nIndex];
	nID = bWrite ? IDD_WINPDLG : IDD_RINPDLG;
	nDlg = DialogBox(g_hInstance, RESSTR(nID), hWnd, pVarInput);
	if (nDlg == IDOK) {
		bRet = MemCmp(pSave, pAny.pStr, lpInfo->nPCVarSize) || StrICmp(m_pName, cName) || (nView != m_nView);
	}
	else {
		MemCpy(pAny.pStr, pSave, lpInfo->nPCVarSize);
		StrCpy(m_pName, cName);
		m_pInfo->pView[m_nIndex] = nView;
	}
	return bRet;
}
