/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_logindlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
#define MAX_PWDLEN						8
static BOOL		m_bInit					= FALSE;
static INT32	m_bError				= FALSE;
static char		m_cPwd[MAX_PWDLEN + 1]	= {0};
// **********************************************************************************
static void __stdcall EnableOK(HWND hDlg) {

	EnableWindow(GetDlgItem(hDlg, IDOK), !m_bError);
}
// **********************************************************************************
static INT32 CALLBACK pLoginDlg(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
INT32				nCmd, nID, nLen, nRet;
char				cBuf[256];
BOOL				bState;

	switch (uMsg) {
	case WM_INITDIALOG:
		m_bInit = TRUE;
		m_bError = FALSE;
		SendDlgItemMessage(hDlg, IDC_LOGIN_PWD, WM_SETTEXT, 0, (LPARAM) m_cPwd);
		CenterWindow(hDlg, GetParent(hDlg));
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		m_bInit = FALSE;
		return TRUE;
	case WM_CTLCOLOREDIT:
		if (m_bError) {
			SetTextColor((HDC) wParam, RGB_BLACK);
			SetBkColor((HDC) wParam, RGB_LIGHTRED);
			return (LRESULT) g_hRedBrush;
		}
		else {
			SetTextColor((HDC) wParam, GetSysColor(COLOR_WINDOWTEXT));
			SetBkColor((HDC) wParam, GetSysColor(COLOR_WINDOW));
			return (LRESULT) GetSysColorBrush(COLOR_WINDOW);
		}
		break;
	case WM_COMMAND:
		nRet = 0;
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDC_LOGIN_PWD:
			switch (nCmd) {
			case EN_SETFOCUS:
				SendDlgItemMessage(hDlg, nID, EM_SETSEL, 0, 31);
				break;
			case EN_KILLFOCUS:
//				SetEditStr(nPage, nIdx, nPrev, FALSE);
				break;
			case EN_CHANGE:
				if (!m_bInit) {
					nLen = SendDlgItemMessage(hDlg, nID, WM_GETTEXT, sizeof(cBuf), (LPARAM) cBuf);
					bState = m_bError;
					m_bError = nLen > MAX_PWDLEN;
					if (!m_bError) {
						StrCpy(m_cPwd, cBuf);;
					}
					EnableOK(hDlg);
					if (m_bError != bState) UpdateDlgWindow(hDlg, nID, TRUE);
				}
				break;
			}
			break;
		case IDOK:
			nRet = IDOK;
		case IDCANCEL:
			EndDialog (hDlg, nRet);
		}
		return TRUE;
		break;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if ((wParam >= IDC_SEPARATOR) && (wParam <= IDC_SEPARATOR9)){
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	}
	return FALSE;
}
// **********************************************************************************
BOOL __cdecl DoSessionLogin() {
INT32	nDlg, nRes;
BOOL	bRet;

	bRet = FALSE;
	nDlg = DialogBox(g_hInstance, RESSTR(IDD_LOGIN), g_hWndMain, pLoginDlg);
	if (nDlg == IDOK) {
		nRes = S7_SessionLogin(g_VAT.hCon, m_cPwd);
		WriteMsg(IDS_LOGIN, 0, NULL);
		bRet = TRUE;
	}
	return bRet;
}
