/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_rwdlg.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
static BOOL		m_bWrite				= FALSE;
static INT32	m_nSelelectedVar		= -1;
static INT32	m_nSelelectedValue		= -1;
static INT32	m_nLastSelelected		= -1;
// **********************************************************************************
static void __stdcall InsertVar(HWND hDlg, BOOL bAppend) {
char	cBuf[256];

	if (bAppend) {
		m_nSelelectedVar = g_VAT.nVarCnt;
	}
	else {
		MemCpy(&g_VAT.VarInfo[m_nSelelectedVar + 1], &g_VAT.VarInfo[m_nSelelectedVar], (g_VAT.nVarCnt - m_nSelelectedVar) * sizeof(VARINFO));
	}
	MemCpy(&g_VAT.VarInfo[m_nSelelectedVar], &g_ActVar, sizeof(VARINFO));
	g_VAT.nVarCnt++;
	GetVarName(TRUE, TRUE, TRUE, 0, &g_VAT.VarInfo[m_nSelelectedVar], cBuf, NULL);
	if (bAppend) {
		SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_ADDSTRING, 0, (LPARAM) cBuf);
	}
	else {
		SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_INSERTSTRING, m_nSelelectedVar, (LPARAM) cBuf);
	}
	SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_SETCURSEL, m_nSelelectedVar, 0);
}
// **********************************************************************************
static void __stdcall DeleteVar(HWND hDlg) {

	SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_DELETESTRING, m_nSelelectedVar, 0);
	MemCpy(&g_ActVar, &g_VAT.VarInfo[m_nSelelectedVar], sizeof(VARINFO));
	g_VAT.nVarCnt--;
	if (m_nSelelectedVar < g_VAT.nVarCnt) {
		MemCpy(&g_VAT.VarInfo[m_nSelelectedVar], &g_VAT.VarInfo[m_nSelelectedVar + 1], (g_VAT.nVarCnt - m_nSelelectedVar) * sizeof(VARINFO));
	}
	else {
		m_nSelelectedVar--;
	}
	MemClr(&g_VAT.VarInfo[g_VAT.nVarCnt], sizeof(VARINFO));
	SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_SETCURSEL, m_nSelelectedVar, 0);
	if (g_ActVar.pData) {
		FreeMem(g_ActVar.pData);
		g_ActVar.pData = NULL;
	}
}
// **********************************************************************************
static BOOL __stdcall ModifyVar(HWND hDlg) {
char	cBuf[256];
BOOL	bOK, bAppend;

	MemCpy(&g_ActVar, &g_VAT.VarInfo[m_nSelelectedVar], sizeof(VARINFO));
	g_VAT.nVarCnt--;
	if (m_nSelelectedVar < g_VAT.nVarCnt) {
		MemCpy(&g_VAT.VarInfo[m_nSelelectedVar], &g_VAT.VarInfo[m_nSelelectedVar + 1], (g_VAT.nVarCnt - m_nSelelectedVar) * sizeof(VARINFO));
	}
	MemClr(&g_VAT.VarInfo[g_VAT.nVarCnt], sizeof(VARINFO));
	bOK = DoVarSelect(FALSE, m_bWrite, hDlg, &g_ActVar);
	if (m_nSelelectedVar < g_VAT.nVarCnt) {
		MemCpy(&g_VAT.VarInfo[m_nSelelectedVar + 1], &g_VAT.VarInfo[m_nSelelectedVar], (g_VAT.nVarCnt - m_nSelelectedVar) * sizeof(VARINFO));
		bAppend = FALSE;
	}
	else {
		bAppend = TRUE;
	}
	MemCpy(&g_VAT.VarInfo[m_nSelelectedVar], &g_ActVar, sizeof(VARINFO));
	g_VAT.nVarCnt++;
	if (bOK) {
		GetVarName(TRUE, TRUE, TRUE, 0, &g_VAT.VarInfo[m_nSelelectedVar], cBuf, NULL);
		SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_DELETESTRING, m_nSelelectedVar, 0);
		if (bAppend) {
			SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_ADDSTRING, 0, (LPARAM) cBuf);
		}
		else {
			SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_INSERTSTRING, m_nSelelectedVar, (LPARAM) cBuf);
		}
		SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_SETCURSEL, m_nSelelectedVar, 0);
	}
	return bOK;
}
// **********************************************************************************
static void __stdcall FillVarList(HWND hDlg) {
char	cBuf[256];
INT32	i;

	for (i = 0; i < g_VAT.nVarCnt; i++) {
		GetVarName(TRUE, TRUE, TRUE, 0, &g_VAT.VarInfo[i], cBuf, NULL);
		SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_ADDSTRING, 0, (LPARAM) cBuf);
	}
	m_nSelelectedVar = -1;
	SendDlgItemMessage(hDlg, IDC_RW_VARLIST, LB_SETCURSEL, -1, 0);
}
// **********************************************************************************
static void __stdcall FillValueList(HWND hDlg, BOOL bFirst) {
char	cBuf[256];
INT32	i, nAct, nLen, nVarLen, nNameLen, nCnt, nWidth, nView, nRequest, nReply;
LPSTR	pSrc, pName;

	MultiReadWriteInit(m_bWrite);
	i = SendDlgItemMessage(hDlg, IDC_RW_VALLIST, LB_GETCOUNT, 0, 0);
	if (bFirst) {
		while (i--) {
			SendDlgItemMessage(hDlg, IDC_RW_VALLIST, LB_DELETESTRING, 0, 0);
		}
		m_nSelelectedValue = m_nLastSelelected = -1;
	}
	if (m_nSelelectedVar >= 0) {
		nWidth = nVarLen = nNameLen = 0;
		nCnt = g_VAT.VarInfo[m_nSelelectedVar].nCount;
		GetVarName(TRUE, FALSE, FALSE, nCnt - 1, &g_VAT.VarInfo[m_nSelelectedVar], cBuf, &nVarLen);
		pName = g_VAT.VarInfo[m_nSelelectedVar].pName;
		for (i = 0; i < nCnt; i++) {
			nLen = StrLen(pName);
			if (nLen > nNameLen) nNameLen = nLen;
			pName += S7MAX_NAMESIZE;
		}
		pSrc = g_VAT.VarInfo[m_nSelelectedVar].pData;
		pName = g_VAT.VarInfo[m_nSelelectedVar].pName;
		for (i = 0; i < nCnt; i++) {
			nAct = GetVarName(TRUE, FALSE, FALSE, i, &g_VAT.VarInfo[m_nSelelectedVar], cBuf, NULL);
			nAct += StrPrint(&cBuf[nAct], "%*c= ", nVarLen - nAct + 1, ' ');
			if (nNameLen) {
				nLen = StrLen(pName);
				nAct -= 2;
				nAct += StrPrint(&cBuf[nAct], ": %s%*c= ", pName, nNameLen - nLen + 1, ' ');
			}
			if (m_bWrite) {
				GetValueStr(TRUE, FALSE, i, &g_VAT.VarInfo[m_nSelelectedVar], &cBuf[nAct], NULL);
			}
			else {
				nView = g_VAT.VarInfo[m_nSelelectedVar].pView[i];
				StrPrint(&cBuf[nAct], "%s ", IDM_VM_FIRST + nView);
			}
			SendDlgItemMessage(hDlg, IDC_RW_VALLIST, LB_INSERTSTRING, i, (LPARAM) cBuf);
			nAct = MeasureText(NULL, hDlg, g_hListFont, cBuf, NULL, FALSE);
			if (nAct > nWidth) nWidth = nAct;
			if (!bFirst) SendDlgItemMessage(hDlg, IDC_RW_VALLIST, LB_DELETESTRING, i + 1, 0);
			pSrc += g_VAT.VarInfo[i].nPCVarSize;
			pName += S7MAX_NAMESIZE;
		}
		nAct = SendDlgItemMessage(hDlg, IDC_RW_VALLIST, LB_GETHORIZONTALEXTENT, 0, 0);
		if (nAct != nWidth) SendDlgItemMessage(hDlg, IDC_RW_VALLIST, LB_SETHORIZONTALEXTENT, nWidth, 0);
	}
	SendDlgItemMessage(hDlg, IDC_RW_VALLIST, LB_SETCURSEL, m_nSelelectedValue, 0);
	nRequest =S7_GetRequestPduSize(g_VAT.hCon);
	nReply = S7_GetReplyPduSize(g_VAT.hCon);
#ifdef LANGUAGE_ENGLISH
	StrPrint(cBuf, "\tRequest size : %d", nRequest);
#endif
#ifdef LANGUAGE_HUNGARIAN
	StrPrint(cBuf, "\tKrs mrete : %d", nRequest);
#endif
	SendDlgItemMessage(hDlg, IDC_STATUSBAR, SB_SETTEXT, 0, (LPARAM) cBuf);
#ifdef LANGUAGE_ENGLISH
	StrPrint(cBuf, "\tReply size : %d", nReply);
#endif
#ifdef LANGUAGE_HUNGARIAN
	StrPrint(cBuf, "\tVlasz mrete : %d", nReply);
#endif
	SendDlgItemMessage(hDlg, IDC_STATUSBAR, SB_SETTEXT, 1, (LPARAM) cBuf);
}
// **********************************************************************************
static void __stdcall EnableButtons(HWND hDlg) {
BOOL	bOK, bAppend, bInsert, bModify, bDelete;

	bOK = g_VAT.nVarCnt > 0;
	bAppend = TRUE;
	bInsert = bModify = bDelete = (m_nSelelectedVar >= 0) && bOK;
	if (g_VAT.nVarCnt >= MAX_S7VARS) bAppend = bInsert = FALSE;
	EnableWindow(GetDlgItem(hDlg, IDC_RW_APPEND), bAppend);
	EnableWindow(GetDlgItem(hDlg, IDC_RW_INSERT), bInsert);
	EnableWindow(GetDlgItem(hDlg, IDC_RW_MODIFY), bModify);
	EnableWindow(GetDlgItem(hDlg, IDC_RW_DELETE), bDelete);
	EnableWindow(GetDlgItem(hDlg, IDC_RW_EDIT), m_nSelelectedValue >= 0);
	EnableWindow(GetDlgItem(hDlg, IDOK), bOK);
}
// **********************************************************************************
static INT32 CALLBACK pRdWrDlg(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
INT32				nCmd, nID, nRet, paParts[2];
RECT				rc;
char				cBuf[256];
BOOL				bOK;

	switch (uMsg) {
	case WM_INITDIALOG:
		LoadString(g_hResource, m_bWrite ? IDS_WRITETITLE : IDS_READTITLE, cBuf, sizeof(cBuf));
		SetWindowText(hDlg, cBuf);
		SendDlgItemMessage(hDlg, IDC_STATUSBAR, SB_GETRECT, 0, (LPARAM) &rc);
		paParts[0] = (rc.right - rc.left) >> 1;
		paParts[1] = -1;
		SendDlgItemMessage(hDlg, IDC_STATUSBAR, SB_SETPARTS, (WPARAM) 2, (LPARAM) paParts);
		SendDlgItemMessage(hDlg, IDC_RW_VARLIST, WM_SETFONT, (WPARAM) g_hListFont, TRUE);
		FillVarList(hDlg);
		EnableButtons(hDlg);
		LB_UnSelect_Init(hDlg, IDC_RW_VARLIST);
		SendDlgItemMessage(hDlg, IDC_RW_VALLIST, WM_SETFONT, (WPARAM) g_hListFont, TRUE);
		FillValueList(hDlg, TRUE);
		LB_UnSelect_Init(hDlg, IDC_RW_VALLIST);
		CenterWindow(hDlg, GetParent(hDlg));
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		return TRUE;
	case WM_COMMAND:
		nRet = 0;
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDC_RW_APPEND:
		case IDC_RW_INSERT:
			bOK = DoVarSelect(TRUE, m_bWrite, hDlg, &g_ActVar);
			if (bOK) {
				InsertVar(hDlg, nID == IDC_RW_APPEND);
				FillValueList(hDlg, TRUE);
				EnableButtons(hDlg);
			}
			break;
		case IDC_RW_MODIFY:
			bOK = ModifyVar(hDlg);
			if (bOK) {
				FillValueList(hDlg, TRUE);
			}
			EnableButtons(hDlg);
			break;
		case IDC_RW_DELETE:
			DeleteVar(hDlg);
			FillValueList(hDlg, TRUE);
			EnableButtons(hDlg);
			break;
		case IDC_RW_EDIT:
			bOK = DoVarInput(m_bWrite, m_nSelelectedValue, hDlg, &g_VAT.VarInfo[m_nSelelectedVar]);
			if (bOK) FillValueList(hDlg, FALSE);
			break;
		case IDC_RW_VARLIST:
			break;
		case IDC_RW_VALLIST:
			if (nCmd == LBN_DBLCLK) {
				if ((m_nSelelectedValue < 0) && (m_nLastSelelected >= 0)) {
					m_nSelelectedValue = m_nLastSelelected;
					SendDlgItemMessage(hDlg, IDC_RW_VALLIST, LB_SETCURSEL, m_nSelelectedValue, 0);
				}
				if (m_nSelelectedValue >= 0) {
					EnableButtons(hDlg);
					bOK = DoVarInput(m_bWrite, m_nSelelectedValue, hDlg, &g_VAT.VarInfo[m_nSelelectedVar]);
					if (bOK) FillValueList(hDlg, FALSE);
				}
			}
			break;
		case IDOK:
			nRet = IDOK;
		case IDCANCEL:
			EndDialog (hDlg, nRet);
		}
		return TRUE;
	case WM_SK_LISTSEL:
		if (wParam == IDC_RW_VARLIST) {
			m_nSelelectedVar = lParam;
			FillValueList(hDlg, TRUE);
		}
		else {
			m_nSelelectedValue = lParam;
			if (m_nSelelectedValue >= 0) m_nLastSelelected = m_nSelelectedValue;
		}
		EnableButtons(hDlg);
		return TRUE;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if ((wParam >= IDC_SEPARATOR) && (wParam <= IDC_SEPARATOR9)){
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		LB_UnSelect_Done(hDlg, IDC_RW_VARLIST);
		if (m_bWrite) {
			LB_UnSelect_Done(hDlg, IDC_RW_VALLIST);
		}
		return TRUE;
	}
	return FALSE;
}
// **********************************************************************************
BOOL __cdecl DoRead() {
INT32	nDlg, nRes;
BOOL	bRet;

	bRet = FALSE;
	m_bWrite = FALSE;
	nDlg = DialogBox(g_hInstance, RESSTR(IDD_RW_DLG), g_hWndMain, pRdWrDlg);
	if (nDlg == IDOK) {
		if (g_VAT.nVarCnt == 1) {
			nRes = S7_SimpleRead(g_VAT.hCon, g_VAT.VarInfo[0].nVT, g_VAT.VarInfo[0].nArea, g_VAT.VarInfo[0].nDB, g_VAT.VarInfo[0].nAddr, g_VAT.VarInfo[0].nBit, g_VAT.VarInfo[0].nCount, TRUE, g_VAT.VarInfo[0].pData);
			WriteMsg(IDS_SIMPLEREAD, 0, NULL);
		}
		else {
			MultiReadWriteInit(m_bWrite);
			nRes = S7_MultiRead_Done(g_VAT.hCon);
			WriteMsg(IDS_MULTIREAD, 0, NULL);
		}
		bRet = TRUE;
		if (!nRes) DoView(FALSE, FALSE);
	}
	return bRet;
}
// **********************************************************************************
BOOL __cdecl DoWrite() {
INT32	nDlg, nRes;
BOOL	bRet;

	bRet = FALSE;
	m_bWrite = TRUE;
	nDlg = DialogBox(g_hInstance, RESSTR(IDD_RW_DLG), g_hWndMain, pRdWrDlg);
	if (nDlg == IDOK) {
		if (g_VAT.nVarCnt == 1) {
			nRes = S7_SimpleWrite(g_VAT.hCon, g_VAT.VarInfo[0].nVT, g_VAT.VarInfo[0].nArea, g_VAT.VarInfo[0].nDB, g_VAT.VarInfo[0].nAddr, g_VAT.VarInfo[0].nBit, g_VAT.VarInfo[0].nCount, TRUE, g_VAT.VarInfo[0].pData);
			WriteMsg(IDS_SIMPLEWRITE, 0, NULL);
		}
		else {
			MultiReadWriteInit(m_bWrite);
			nRes = S7_MultiWrite_Done(g_VAT.hCon);
			WriteMsg(IDS_MULTIWRITE, 0, NULL);
		}
		bRet = TRUE;
		if (!nRes) DoView(TRUE, FALSE);
	}
	return bRet;
}
