/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_utils.c										*
********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
#include <math.h>

static LPSTR		m_BaudTable[BAUD_LAST + 1]		= {"9.6K", "19.2K", "93.75K", "187.5K", "500K", "375K", "750K", "3M", "6M", "12M", "???", "45.45K"};
static LPSTR		m_StateTable[S7_CPULAST + 1]	= {"???", "Stop", "Run"};
#pragma pack(push, 1)

typedef struct tagERRINFO {
	INT32						nCode;
	LPSTR						pName;
} ERRINFO, *LPERRINFO;

#pragma pack(pop)

#define MAX_ITEMERROR			8
#ifdef LANGUAGE_ENGLISH
#define UNKNOWN_ITEMERROR		"Unknown error"
static ERRINFO		ItemErrors[MAX_ITEMERROR]		= {
	{0x00,	"Reserved"},
	{0x01,	"Hardware fault"},
	{0x03,	"Accessing the object not allowed"},
	{0x05,	"Address out of range"},
	{0x06,	"Data type not supported"},
	{0x07,	"Data type inconsistent"},
	{0x0a,	"Object does not exist"},
	{0xff,	"Success"}
};
#endif
#ifdef LANGUAGE_HUNGARIAN
#define UNKNOWN_ITEMERROR		"Ismeretlen hiba"
static ERRINFO		ItemErrors[MAX_ITEMERROR]		= {
	{0x00,	"Tartalk"},
	{0x01,	"Hardver hiba"},
	{0x03,	"A hozzfrs nem engedlyezett"},
	{0x05,	"A cm tartomnyon kvl"},
	{0x06,	"Az adattpus nem tmogatott"},
	{0x07,	"Az adattpus nem konzisztens"},
	{0x0a,	"Az objektum nem ltezik"},
	{0xff,	"Sikeres"}
};
#endif


// **********************************************************************************
void __stdcall SetListFont(INT32 nFont) {
HMENU		hMenu;
INT32		i;
UINT32		dwFlags;

	g_nFont = nFont;
	DeleteObjectEx(&g_hFont);
	g_hFont = CreateLogFont(g_pMainEdit->hEdit, -g_nFontSize[g_nFont], FW_NORMAL, DEFAULT_CHARSET, STR_COURIERNEW);
	hMenu = GetMenu(g_hWndMain);
	for (i = SMALL_FONT; i < MAX_FONT; i++) {
		dwFlags = (g_nFont == i) ? MF_CHECKED : MF_UNCHECKED;
		CheckMenuItem(hMenu, IDM_FONTSMALL + i, MF_BYCOMMAND | dwFlags);
	}
	SendMessage(g_pMainEdit->hEdit, WM_SETFONT, (WPARAM) g_hFont, TRUE);
}
// **********************************************************************************
void __stdcall WriteMsg(INT32 nFunc, INT32 nData, LPVOID lpData) {
LPSYSTEMTIME	pSt;
LPBUSPARBLK		pBus;
LPSTR			pStation, pStr;
SYSTEMTIME		stPC, stPLC;
char			cBuf[2048], cInfo[512], cName[S7MAX_NAMESIZE];
BOOL			bName, bWait, bCheck;
UINT32			nStrt, nAct;
INT32			i, j,  k, nBaud, nLen, nRes, nErr, nState, nExtRes, nCount;

	nRes = S7_GetLastError(&nErr);
	bName = TRUE;
	nLen = 0;
	cInfo[0] = cName[0] = 0;
	bCheck = FALSE;
	switch (nFunc) {
	case IDS_IF_INIT:
	case IDS_IF_DONE:
		bName = FALSE;
		break;
	case IDS_CON_INIT:
	case IDS_CONNECT:
#ifdef LANGUAGE_ENGLISH
		if (!nRes) StrPrint(cInfo, "\tPDU size : %d\r\n", S7_GetMaxPduSize(g_VAT.hCon));
#endif
#ifdef LANGUAGE_HUNGARIAN
		if (!nRes) StrPrint(cInfo, "\tPDU mret : %d\r\n", S7_GetMaxPduSize(g_VAT.hCon));
#endif
		break;
	case IDS_LOGIN:
	case IDS_LOGOUT:
	case IDS_SIMPLEREAD:
	case IDS_MULTIREAD:
	case IDS_SIMPLEWRITE:
	case IDS_MULTIWRITE:
		bCheck = TRUE;
	case IDS_CON_DONE:
	case IDS_DISCONNECT:
		break;
	case IDS_PARTNERS:
		bName = FALSE;
		if (nRes) break;
		pStation = lpData;
		for (i = 0; i < nData; i++) {
			switch (pStation[i]) {
			case STATION_PASSIVE:
				pStr = "passive";
				break;
			case STATION_ACTIVE_READY:
				pStr = "active ready";
				break;
			case STATION_ACTIVE:
				pStr = "active";
				break;
			default:
				pStr = NULL;
			}
			if (pStr) {
				nLen += StrPrint(&cInfo[nLen], "\t%3d : %s\r\n", i, pStr);
			}
		}
		break;
	case IDS_BUSPARS:
		bName = FALSE;
		if (nRes) break;
		pBus = lpData;
		nBaud = pBus->nBaud > BAUD_LAST ? BAUD_UNKNOWN : pBus->nBaud;
		pStr = m_BaudTable[nBaud];
		nLen = StrPrint(cInfo, "\tHSA\t\t: %d\r\n\tTS\t\t: %d\r\n\tType\t\t: %d\r\n\tBaud\t\t: %s\r\n\tRedundant\t: %d\r\n", pBus->nHSA, pBus->nTS, pBus->nType, pStr, pBus->nRedundant);
		nLen += StrPrint(&cInfo[nLen], "\tRetryCtr\t: %d\r\n\tDefault SAP\t: %d\r\n\tTotal SAP\t: %d\r\n\tTsl\t\t: %d\r\n", pBus->nRetryCtr, pBus->nDefaultSap, pBus->nTotalSap, pBus->nTsl);
		nLen += StrPrint(&cInfo[nLen], "\tTqui\t\t: %d\r\n\tTSet\t\t: %d\r\n\tMin Tsdr\t: %d\r\n\tMax Tsdr\t: %d\r\n", pBus->nTqui, pBus->nTSet, pBus->nMinTsdr, pBus->nMaxTsdr);
		nLen += StrPrint(&cInfo[nLen], "\tTtr\t\t: %d\r\n\tGap\t\t: %d\r\n\tIn ring\t\t: %d\r\n\tLayer\t\t: %d\r\n\tIdent\t\t: %s\r\n", pBus->nTtr, pBus->nGap, pBus->nInRing, pBus->nLayer, &pBus->nIdent[4]);
		break;
	case IDS_GETCLOCK:
		if (nRes) break;
		pSt = lpData;
		StrPrint(cInfo, "\tCPU : %D %T\r\n", pSt, pSt);
		bCheck = TRUE;
		break;
	case IDS_SETCLOCK:
		if (nRes) break;
		nExtRes = S7_GetCpuClock(g_VAT.hCon, &stPLC);
		GetLocalTime(&stPC);
		if (!nExtRes) StrPrint(cInfo, "\tCPU : %D %T PC : %D %T\r\n", &stPLC, &stPLC, &stPC, &stPC);
		bCheck = TRUE;
		break;
	case IDS_CPUSTATE:
		if (!nRes) StrPrint(cInfo, "\tCPU : %s\r\n", m_StateTable[nData]);
		bCheck = TRUE;
		break;
	case IDS_CPUSTART:
		if (nRes) break;
		nStrt = GetTickCount();
		bWait = TRUE;
		do {
			nExtRes = S7_GetCpuState(g_VAT.hCon, &nState);
			if (nState == S7_CPURUN) {
				bWait = FALSE;
			}
			else {
				Sleep(0);
				nAct = GetTickCount();
				if ((nAct - nStrt) >= 2000) {
					bWait = FALSE;
				}
			}
		} while (bWait);
		if (!nExtRes) StrPrint(cInfo, "\tCPU : %s\r\n", m_StateTable[nState]);
		bCheck = TRUE;
		break;
	case IDS_CPUSTOP:
		if (nRes) break;
		nExtRes = S7_GetCpuState(g_VAT.hCon, &nState);
		if (!nExtRes) StrPrint(cInfo, "\tCPU : %s\r\n", m_StateTable[nState]);
		bCheck = TRUE;
		break;
	default:
		return;
	}
	if (bName) {
		S7_GetConName(g_VAT.hCon, cName);
		bName = cName[0] > 0;
	}
#ifdef LANGUAGE_ENGLISH
	nLen = StrPrint(cBuf, "%[%s - %]%s : %s.%[ Additional errorcode : %d(0x%04x).%]\r\n%s", cName, bName, nFunc, IDS_S7ERR_BASE + nRes, nErr, nErr, nErr, cInfo);
#endif
#ifdef LANGUAGE_HUNGARIAN
	nLen = StrPrint(cBuf, "%[%s - %]%s : %s.%[ Kiegszt hibakd : %d(0x%04x).%]\r\n%s", cName, bName, nFunc, IDS_S7ERR_BASE + nRes, nErr, nErr, nErr, cInfo);
#endif
	nCount = S7_IsReadWriteError(g_VAT.hCon);
	if (nRes && nCount) {
		for (i = 0; i < nCount; i++) {
			S7_GetReadWriteError(g_VAT.hCon, i, &nErr);
			k = -1;
			for (j = 0; j < MAX_ITEMERROR; j++) {
				if (nErr == ItemErrors[j].nCode) {
					k = j;
					pStr = ItemErrors[j].pName;
					break;
				}
			}
			if (k < 0) pStr = UNKNOWN_ITEMERROR;
			GetVarName(FALSE, TRUE, TRUE, 0, &g_VAT.VarInfo[i], cInfo, NULL);
			nLen += StrPrint(&cBuf[nLen], "\t%s : %s\r\n", cInfo, pStr);
		}
	}
	EditWin_Write(g_pMainEdit, cBuf, nLen, TRUE);
	if (bCheck && (nRes == S7ERR_TIMEOUT)) {
		nRes = S7_Disconnect(g_VAT.hCon);
		WriteMsg(IDS_DISCONNECT, 0, NULL);
		if (!nRes) EnableMenus(MENU_UNCHANGED, MENU_SETON, FALSE);
	}
}
// **********************************************************************************
void __stdcall PresetVarInfo(BOOL bClr, INT32 nVT, INT32 nArea, INT32 nCount, LPVARINFO lpInfo) {

	if (bClr) MemClr(lpInfo, sizeof(VARINFO));
	if (nVT >= 0) lpInfo->nVT = nVT;
	if (nArea >= 0) lpInfo->nArea = nArea;
	if (nCount > 0) lpInfo->nCount = nCount;
	if (lpInfo->nArea == S7AT_DB) {
		if (lpInfo->nDB == 0) lpInfo->nDB = 1;
	}
	else {
		if (lpInfo->nDB) lpInfo->nDB = 0;
	}
	lpInfo->nPCVarSize = lpInfo->nVT == S7VT_CHAR ? 1 : (lpInfo->nVT == S7VT_DT ? 8 : 4);
	lpInfo->nAllocSize = lpInfo->nCount * lpInfo->nPCVarSize;
	switch (lpInfo->nVT) {
	case S7VT_CHAR:
		lpInfo->nAllocSize++;
	case S7VT_BIT:
	case S7VT_BYTE:
	case S7VT_SHORT:
		lpInfo->nPlcVarSize = 1;
		break;
	case S7VT_WORD:
	case S7VT_INT:
	case S7VT_S5TIME:
	case S7VT_DATE:
	case S7VT_TIMER:
	case S7VT_COUNTER:
		lpInfo->nPlcVarSize = 2;
		break;
	case S7VT_DWORD:
	case S7VT_DINT:
	case S7VT_TIME:
	case S7VT_TOD:
	case S7VT_REAL:
		lpInfo->nPlcVarSize = 4;
		break;
	case S7VT_DT:
		lpInfo->nPlcVarSize = 8;
		break;
	}
}
// **********************************************************************************
INT32 __stdcall GetVarName(BOOL bAddSpc, BOOL bCount, BOOL bType, INT32 nIndex, LPVARINFO lpInfo, LPSTR lpBuf, LPINT32 lpSize) {
INT32			nAddr, nLen, nIdx, nBit;
BOOL			bBit;
char			cSize;

	nAddr = lpInfo->nAddr;
	nBit = lpInfo->nBit;
	if (lpInfo->nVT == S7VT_BIT) {
		nBit += nIndex;
		nAddr += nBit >> 3;
		nBit &= 7;
		nIdx = 0;
		bBit = TRUE;
	}
	else {
		nAddr += ((lpInfo->nVT == S7VT_TIMER) || (lpInfo->nVT == S7VT_COUNTER) ? 1 : lpInfo->nPlcVarSize) * nIndex;
		nIdx = lpInfo->nPlcVarSize;
		if (nIdx > 2) {
			nIdx = nIdx == 4 ? 3 : 4;
		}
		bBit = FALSE;
	}
	if (bAddSpc) {
		nLen = 1;
		lpBuf[0] = ' ';
	}
	else {
		nLen = 0;
	}
	cSize = g_cSizeName[nIdx];
	if (lpInfo->nArea == S7AT_DB) {
		nLen += StrPrint(&lpBuf[nLen], "DB%d.DB", lpInfo->nDB);
	}
	else {
		lpBuf[nLen] = g_cAreaName[lpInfo->nArea];
		nLen += 1;
		if (bBit || (lpInfo->nArea == S7AT_TIMER) || (lpInfo->nArea == S7AT_COUNTER)) cSize = 0;
	}
	nLen += StrPrint(&lpBuf[nLen], "%[%c%]%d%[.%d%]", cSize, cSize, nAddr, nBit, bBit);
	if (lpSize) {
		if (nLen > *lpSize) *lpSize = nLen;
	}
	if (bCount) nLen += StrPrint(&lpBuf[nLen], ":%d", lpInfo->nCount);
	if (bType) nLen += StrPrint(&lpBuf[nLen], " (%s)", g_VarTypes[lpInfo->nVT]);
	return nLen;
}
// **********************************************************************************
INT32 __stdcall GetDefViewMode(LPVARINFO lpInfo) {
INT32	nView;

	nView = VM_HEX;
	switch (lpInfo->nVT) {
	case S7VT_BIT:
	case S7VT_SHORT:
	case S7VT_INT:
	case S7VT_DINT:
	case S7VT_COUNTER:
		nView = VM_DEC;
		break;
	case S7VT_BYTE:
	case S7VT_WORD:
	case S7VT_DWORD:
		nView = VM_HEX;
		break;
	case S7VT_CHAR:
		nView = VM_CHAR;
		break;
	case S7VT_TIME:
	case S7VT_S5TIME:
	case S7VT_TIMER:
		nView = VM_TIME;
		break;
	case S7VT_TOD:
	case S7VT_DT:
	case S7VT_DATE:
		nView = VM_DT;
		break;
	case S7VT_REAL:
		nView = VM_REAL;
		break;
	}
	return nView;
}
// **********************************************************************************
void __stdcall GetViewValue(INT32 nIdx, LPVARINFO lpInfo, LPANYVALUE lpDst, LPSYSTEMTIME lpSt) {
INT32		nView;
ANYPOINTER	pAny;

	pAny.pVoid = lpInfo->pData;
	pAny.pStr += lpInfo->nPCVarSize * nIdx;
	nView = lpInfo->pView[nIdx];
	if (nView == VM_DEFAULT) nView = GetDefViewMode(lpInfo);
	lpDst->u64 = 0;
	switch (nView) {
	case VM_DEC:
	case VM_TIME:
		switch (lpInfo->nPlcVarSize) {
		case 1:
			lpDst->i64 = *pAny.pI8;
			break;
		case 2:
			lpDst->i64 = (lpInfo->nVT == S7VT_S5TIME) || (lpInfo->nVT == S7VT_TIMER) ? *pAny.pI32 : *pAny.pI16;
			break;
		default:
			lpDst->i64 = *pAny.pI32;
		}
		break;
	default:
		switch (lpInfo->nPlcVarSize) {
		case 1:
			lpDst->u64 = *pAny.pU8;
			break;
		case 2:
			lpDst->u64 = (lpInfo->nVT == S7VT_S5TIME) || (lpInfo->nVT == S7VT_TIMER) ? *pAny.pU32 : *pAny.pU16;
			break;
		case 4:
			lpDst->u64 = *pAny.pU32;
			break;
		default:
			lpDst->u64 = *pAny.pU64;
		}
		break;
	}
	if (lpSt) {
		switch (lpInfo->nPlcVarSize) {
		case 2:
			MemClr(lpSt, sizeof(SYSTEMTIME));
			DayToDate(*pAny.pU32, 1990, lpSt);
			break;
		case 4:
			GetLocalTime(lpSt);
			MilliSecToTime(*pAny.pU32, lpSt);
			break;
		case 8:
			S7_GetDT(lpSt, pAny.pVoid);
		}
	}
}
// **********************************************************************************
void __stdcall SetViewValue(INT32 nIdx, LPVARINFO lpInfo, LPANYVALUE lpSrc, LPSYSTEMTIME lpSt) {
INT32		nView;
ANYPOINTER	pAny;

	pAny.pVoid = lpInfo->pData;
	pAny.pStr += lpInfo->nPCVarSize * nIdx;
	nView = lpInfo->pView[nIdx];
	if (nView == VM_DEFAULT) nView = GetDefViewMode(lpInfo);
	if (lpSt) {
		switch (lpInfo->nPlcVarSize) {
		case 2:
			lpSrc->u64 = DateToDay(1990, lpSt);
			break;
		case 4:
			lpSrc->u64 = TimeToMilliSec(0, lpSt);
			break;
		case 8:
			S7_SetDT(lpSrc, lpSt);
		}
	}
	if (lpInfo->nPCVarSize == 4) *pAny.pU32 = 0;
	switch (lpInfo->nPlcVarSize) {
	case 1:
		*pAny.pU8 = lpSrc->u8;
		break;
	case 2:
		if ((lpInfo->nVT == S7VT_S5TIME) || (lpInfo->nVT == S7VT_TIMER)) {
			*pAny.pU32 = lpSrc->u32;
		}
		else {
			*pAny.pU16 = lpSrc->u16;
		}
		break;
	case 4:
		*pAny.pU32 = lpSrc->u32;
		break;
	case 8:
		*pAny.pU64 = lpSrc->u64;
		break;
	}
}
// **********************************************************************************
INT32 __stdcall GetValueStr(BOOL bAddSpc, BOOL bEdit, INT32 nIdx, LPVARINFO lpInfo, LPSTR lpBuf, LPBOOL lpErr) {
SYSTEMTIME	st;
INT32		nLen, nDay, nHour, nMin, nSec, nMSec, nMode, nDec, nView, nTest;
ANYVALUE	Val;
double		d, ad;
BOOL		bErr;
char		cBuf[128];

	bErr = FALSE;
	GetViewValue(nIdx, lpInfo, &Val, &st);
	nLen = 0;
	nView = lpInfo->pView[nIdx];
	if (nView == VM_DEFAULT) nView = GetDefViewMode(lpInfo);
	switch (nView) {
	case VM_BIN:
	case VM_HEX:
	case VM_DEC:
	case VM_UDEC:
		if (lpInfo->nVT == S7VT_BIT) nView = VM_DEC;
		if (nView == VM_BIN) {
			nDec = lpInfo->nPlcVarSize << 3;
			nMode = NF_ZBIN | NF_SEP;
			lpBuf[0] = '0';
			lpBuf[1] = 'b';
			nLen = 2;
		}
		else if (nView == VM_HEX) {
			nDec = lpInfo->nPlcVarSize << 1;
			nMode = NF_ZHEX | NF_SEP;
			lpBuf[0] = '0';
			lpBuf[1] = 'x';
			nLen = 2;
		}
		else {
			nLen = nDec = 0;
			nMode = NF_DEC | NF_SEP;
			if (nView == VM_UDEC) nMode |= NF_UNSIGNED;
		}
		nLen += IntStr(&lpBuf[nLen], Val.u64, nMode, nDec, 0);
		break;
	case VM_CHAR:
		if (Val.u8 >= 32) {
			nLen = bEdit ? StrPrint(lpBuf, "%c", Val.u8) : StrPrint(lpBuf, "'%c' (#%d)", Val.u8, Val.u8);
		}
		else {
			nLen = StrPrint(lpBuf, "#%d", Val.u8);
		}
		break;
	case VM_REAL:
		d = Val.f;
		nTest = FltXam(d, FALSE);
		if ((nTest == FXAM_INF) || (nTest == -FXAM_INF)) {
			nLen = StrPrint(lpBuf, "%cINF", nTest == FXAM_INF ? '+' : '-');
			bErr = TRUE;
		}
		else if ((nTest == FXAM_NAN) || (nTest == -FXAM_NAN)) {
			Val.u32 &= 0x007FFFFF;
			nLen = StrPrint(lpBuf, "NaN(%c%d)", nTest == FXAM_NAN ? '+' : '-', Val.u32);
			bErr = TRUE;
		}
		else {
			ad = fabs(d);
			if ((ad >= 10000000.0) || ((ad < 0.000001) && (ad != 0.0))) {
				nMode = NF_FLOATING | NF_SEP;
				nDec = 6;
			}
			else {
				nLen = FltStr(cBuf, ad, NF_DEFAULT, 0, 0);
				nDec = 8 - nLen;
				if (nDec > 6) nDec = 6;
				nMode = NF_DEFAULT | NF_CLRZDEC | NF_ONEZDEC | NF_SEP;
			}
			nLen = FltStr(lpBuf, d, nMode, nDec, 0);
		}
		break;
	case VM_TIME:
		nDay = Val.i32 / MILLISECONDSOFDAY;
		if (nDay) {
			nLen = StrPrint(lpBuf, "%dd", nDay);
		}
		nHour = AbsInt32(Val.i32) % MILLISECONDSOFDAY;
		nMSec = nHour % 1000;
		nHour = nHour / 1000;
		nSec = nHour % 60;
		nHour = nHour / 60;
		nMin = nHour % 60;
		nHour /= 60;
		if (nHour) {
			nLen += StrPrint(&lpBuf[nLen], "%dh", nHour);
		}
		if (nMin) {
			nLen += StrPrint(&lpBuf[nLen], "%dm", nMin);
		}
		if (nSec) {
			nLen += StrPrint(&lpBuf[nLen], "%ds", nSec);
		}
		if (nMSec || !nLen) {
			nLen += StrPrint(&lpBuf[nLen], "%dms", nMSec);
		}
		break;
	case VM_DT:
		switch (lpInfo->nPlcVarSize) {
		case 2:
			nLen = StrPrint(lpBuf, "%D", &st);
			break;
		case 4:
			nLen = StrPrint(lpBuf, "%.3T", &st);
			break;
		case 8:
			nLen = StrPrint(lpBuf, "%D.%.3T", &st, &st);
		}
	}
	if (bAddSpc) {
		lpBuf[nLen++] = ' ';
		lpBuf[nLen] = 0;
	}
	if (lpErr) *lpErr = bErr;
	return nLen;
}
// **********************************************************************************
void __stdcall MultiReadWriteInit(BOOL bWrite) {
char	cBuf[256], cName[128];
INT32	i, nLen, nRes;

	if (bWrite) {
		nRes = S7_MultiWrite_Init(g_VAT.hCon);
	}
	else {
		nRes = S7_MultiRead_Init(g_VAT.hCon);
	}
	if (!nRes) {
		for (i = 0; i < g_VAT.nVarCnt; i++) {
			nRes = S7_AddItem(g_VAT.hCon, g_VAT.VarInfo[i].nVT, g_VAT.VarInfo[i].nArea, g_VAT.VarInfo[i].nDB, g_VAT.VarInfo[i].nAddr, g_VAT.VarInfo[i].nBit, g_VAT.VarInfo[i].nCount, TRUE, g_VAT.VarInfo[i].pData);
			if (nRes) {
				GetVarName(FALSE, TRUE, TRUE, 0, &g_VAT.VarInfo[i], cName, NULL);
				nLen = StrPrint(cBuf, "%s : %s. Deleted\r\n", cName, IDS_S7ERR_BASE + nRes);
				EditWin_Write(g_pMainEdit, cBuf, nLen, TRUE);
				FreeMem(g_VAT.VarInfo[i].pData);
				g_VAT.nVarCnt--;
				if (i < g_VAT.nVarCnt) {
					MemCpy(&g_VAT.VarInfo[i], &g_VAT.VarInfo[i + 1], (g_VAT.nVarCnt - i) * sizeof(VARINFO));
				}
				MemClr(&g_VAT.VarInfo[g_VAT.nVarCnt], sizeof(VARINFO));
			}
		}
	}
}
// **********************************************************************************
INT32 __stdcall FillViewModeList(BOOL bAddDefault, BOOL bMenu, INT32 nIdx, LPVARINFO lpInfo, LPINT32 lpViewCnt, LPINT32 lpViewList) {
INT32	i, nView, nSelect, nViewCnt;
BOOL	bAdd;

	MemClr(lpViewList, sizeof(INT32) * VM_MAX);
	nViewCnt = nSelect = 0;
	nView = IDM_VM_FIRST + lpInfo->pView[nIdx];
	for (i = IDM_VM_FIRST; i <= IDM_VM_LAST; i++) {
		bAdd = FALSE;
		switch (i) {
		case IDM_VM_DEF:
			if (bAddDefault) bAdd = TRUE;
			break;
		case IDM_VM_DEC:
			if ((lpInfo->nVT == S7VT_TIMER) || (lpInfo->nVT == S7VT_COUNTER)) break;
		case IDM_VM_BIN:
		case IDM_VM_HEX:
		case IDM_VM_UDEC:
			switch (lpInfo->nVT) {
			case S7VT_BIT:
				if (i != IDM_VM_BIN) break;
			case S7VT_SHORT:
			case S7VT_INT:
			case S7VT_DINT:
			case S7VT_COUNTER:
			case S7VT_BYTE:
			case S7VT_WORD:
			case S7VT_DWORD:
			case S7VT_CHAR:
			case S7VT_TIME:
			case S7VT_S5TIME:
			case S7VT_TIMER:
			case S7VT_TOD:
			case S7VT_DATE:
			case S7VT_REAL:
				bAdd = TRUE;
				break;
			case S7VT_DT:
				if (i == IDM_VM_HEX) bAdd = TRUE;
				break;
			}
		case IDM_VM_CHAR:
			switch (lpInfo->nVT) {
			case S7VT_SHORT:
			case S7VT_BYTE:
			case S7VT_CHAR:
				bAdd = TRUE;
				break;
			}
			break;
		case IDM_VM_REAL:
			if (lpInfo->nVT == S7VT_REAL) bAdd = TRUE;
			break;
		case IDM_VM_TIME:
			switch (lpInfo->nVT) {
			case S7VT_DINT:
			case S7VT_DWORD:
			case S7VT_TIME:
			case S7VT_S5TIME:
			case S7VT_TIMER:
			case S7VT_TOD:
				bAdd = TRUE;
				break;
			}
			break;
		case IDM_VM_DT:
			switch (lpInfo->nPlcVarSize) {
			case 2:
			case 4:
			case 8:
				bAdd = (lpInfo->nVT != S7VT_TIMER) && (lpInfo->nVT != S7VT_COUNTER);
				break;
			}
			break;
		}
		if (bAdd) {
			if (i == nView) nSelect = nViewCnt;
			lpViewList[nViewCnt] = i;
			nViewCnt++;
			if (bMenu && (i == IDM_VM_DEF)) nViewCnt++;
		}
	}
	*lpViewCnt = nViewCnt;
	return nSelect;
}
// **********************************************************************************
void __stdcall SetWinTitle(HWND hWnd, INT32 nIDS) {
char	cBuf[256];
char	cFile[MAX_PATH];

	LoadString(g_hResource, nIDS, cBuf, sizeof(cBuf));
	if (g_bLoaded) {
		FSplit(FALSE, NULL, cFile, g_cVatName);
		MultiCatN(sizeof(cBuf), cBuf, NULL, " - ", cFile, NULL);
	}
	SetWindowText(hWnd, cBuf);
}
// **********************************************************************************
static void __stdcall EnableSubMenu(HMENU hMenu, INT32 nPos1, INT32 nPos2, BOOL bEnable) {
HMENU	hSub;

	hSub = GetSubMenu(hMenu, nPos1);
	EnableMenuItem(hSub, nPos2, MF_BYPOSITION | (bEnable ? MF_ENABLED : MF_GRAYED));
}
// **********************************************************************************
void __stdcall EnableMenus(INT32 nIF, INT32 nCon, BOOL bSave) {
HMENU	hMenu;
BOOL	bEnable, bConnected, bClosed;
INT32	i, nStateAll, nStateOpen, nStateMix, nState;

	hMenu = GetMenu(g_hWndMain);
	if (nIF != MENU_UNCHANGED) {
		if (nIF == MENU_SETON) {
			bEnable = TRUE;
			nStateOpen = MF_BYCOMMAND | MF_GRAYED;
			nState = MF_BYCOMMAND | MF_ENABLED;
			nStateMix = S7_GetInterfaceMode(g_VAT.hIF) == IFM_TCP ? MF_BYCOMMAND | MF_GRAYED : MF_BYCOMMAND | MF_ENABLED;
		}
		else {
			bEnable = FALSE;
			nStateOpen = MF_BYCOMMAND | MF_ENABLED;
			nState = nStateMix = MF_BYCOMMAND | MF_GRAYED;
		}
		EnableSubMenu(hMenu, 1, 1, bEnable);
		EnableMenuItem(hMenu, IDM_IF_OPEN, nStateOpen);
		EnableMenuItem(hMenu, IDM_IF_CLOSE, nState);
		EnableMenuItem(hMenu, IDM_CON_OPEN, nState);
		EnableMenuItem(hMenu, IDM_PARTNERS, nStateMix);
		EnableMenuItem(hMenu, IDM_BUSPARS, nStateMix);
	}
	if (nCon != MENU_UNCHANGED) {
		nStateAll = MF_BYCOMMAND | MF_GRAYED;
		if (nCon == MENU_SETON) {
			bClosed = FALSE;
			if (bConnected = S7_IsConnected(g_VAT.hCon)) nStateAll = MF_BYCOMMAND | MF_ENABLED;
			nStateOpen = MF_BYCOMMAND | MF_GRAYED;
			nState = MF_BYCOMMAND | MF_ENABLED;
		}
		else {
			bClosed = TRUE;
			bConnected = FALSE;
			nStateOpen = MF_BYCOMMAND | MF_ENABLED;
			nState = MF_BYCOMMAND | MF_GRAYED;
		}
		EnableMenuItem(hMenu, IDM_CON_OPEN, nStateOpen);
		EnableMenuItem(hMenu, IDM_CON_CLOSE, nState);
		EnableMenuItem(hMenu, IDM_CON_MODIFY, nState);
		EnableMenuItem(hMenu, IDM_CONNECT, bConnected || bClosed ? MF_BYCOMMAND | MF_GRAYED : MF_BYCOMMAND | MF_ENABLED);
		EnableMenuItem(hMenu, IDM_DISCONNECT, bConnected ? MF_BYCOMMAND | MF_ENABLED : MF_BYCOMMAND | MF_GRAYED);
		for (i = IDM_ENDISFIRST; i <= IDM_ENDISLAST; i++) {
			EnableMenuItem(hMenu, i, nStateAll);
		}
	}
	if (bSave) {
		EnableMenuItem(hMenu, IDM_SAVE, g_VAT.nVarCnt ? MF_BYCOMMAND | MF_ENABLED : MF_BYCOMMAND | MF_GRAYED);
	}
}
